/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import org.slf4j.Logger;

public class TagDataPack<T> {
    private static final Logger a = LogUtils.getLogger();
    final Function<MinecraftKey, Optional<? extends T>> b;
    private final String c;

    public TagDataPack(Function<MinecraftKey, Optional<? extends T>> registryGetter, String dataType) {
        this.b = registryGetter;
        this.c = dataType;
    }

    public Map<MinecraftKey, List<a>> a(IResourceManager resourceManager) {
        HashMap map = Maps.newHashMap();
        FileToIdConverter fileToIdConverter = FileToIdConverter.a(this.c);
        for (Map.Entry<MinecraftKey, List<IResource>> entry2 : fileToIdConverter.b(resourceManager).entrySet()) {
            MinecraftKey resourceLocation = entry2.getKey();
            MinecraftKey resourceLocation2 = fileToIdConverter.b(resourceLocation);
            for (IResource resource : entry2.getValue()) {
                try {
                    BufferedReader reader = resource.e();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        List list = map.computeIfAbsent(resourceLocation2, id -> new ArrayList());
                        TagFile tagFile = (TagFile)TagFile.a.parse(new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, jsonElement)).getOrThrow(false, arg_0 -> ((Logger)a).error(arg_0));
                        if (tagFile.b()) {
                            list.clear();
                        }
                        String string = resource.b();
                        tagFile.a().forEach(entry -> list.add(new a((TagEntry)entry, string)));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception exception) {
                    a.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{resourceLocation2, resourceLocation, resource.b(), exception});
                }
            }
        }
        return map;
    }

    private static void a(Map<MinecraftKey, List<a>> tags, Multimap<MinecraftKey, MinecraftKey> referencedTagIdsByTagId, Set<MinecraftKey> alreadyResolved, MinecraftKey tagId, BiConsumer<MinecraftKey, List<a>> resolver) {
        if (!alreadyResolved.add(tagId)) {
            return;
        }
        referencedTagIdsByTagId.get((Object)tagId).forEach(resolvedTagId -> TagDataPack.a(tags, referencedTagIdsByTagId, alreadyResolved, resolvedTagId, resolver));
        List<a> list = tags.get(tagId);
        if (list != null) {
            resolver.accept(tagId, list);
        }
    }

    private static boolean a(Multimap<MinecraftKey, MinecraftKey> referencedTagIdsByTagId, MinecraftKey tagId, MinecraftKey referencedTagId) {
        Collection collection = referencedTagIdsByTagId.get((Object)referencedTagId);
        if (collection.contains(tagId)) {
            return true;
        }
        return collection.stream().anyMatch(id -> TagDataPack.a(referencedTagIdsByTagId, tagId, id));
    }

    private static void b(Multimap<MinecraftKey, MinecraftKey> referencedTagIdsByTagId, MinecraftKey tagId, MinecraftKey referencedTagId) {
        if (!TagDataPack.a(referencedTagIdsByTagId, tagId, referencedTagId)) {
            referencedTagIdsByTagId.put((Object)tagId, (Object)referencedTagId);
        }
    }

    private Either<Collection<a>, Collection<T>> a(TagEntry.a<T> valueGetter, List<a> entries) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayList<a> list = new ArrayList<a>();
        for (a entryWithSource : entries) {
            if (entryWithSource.a().a(valueGetter, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0))) continue;
            list.add(entryWithSource);
        }
        return list.isEmpty() ? Either.right(builder.build()) : Either.left(list);
    }

    public Map<MinecraftKey, Collection<T>> a(Map<MinecraftKey, List<a>> tags) {
        final HashMap map = Maps.newHashMap();
        TagEntry.a lookup = new TagEntry.a<T>(){

            @Override
            @Nullable
            @Override
            public T a(MinecraftKey id) {
                return TagDataPack.this.b.apply(id).orElse(null);
            }

            @Override
            @Nullable
            @Override
            public Collection<T> b(MinecraftKey id) {
                return (Collection)map.get(id);
            }
        };
        HashMultimap multimap = HashMultimap.create();
        tags.forEach((arg_0, arg_1) -> TagDataPack.b((Multimap)multimap, arg_0, arg_1));
        tags.forEach((arg_0, arg_1) -> TagDataPack.a((Multimap)multimap, arg_0, arg_1));
        HashSet set = Sets.newHashSet();
        tags.keySet().forEach(arg_0 -> this.a(tags, (Multimap)multimap, set, lookup, map, arg_0));
        return map;
    }

    public Map<MinecraftKey, Collection<T>> b(IResourceManager manager) {
        return this.a(this.a(manager));
    }

    private /* synthetic */ void a(Map map, Multimap multimap, Set set, TagEntry.a lookup, Map map2, MinecraftKey tagId) {
        TagDataPack.a((Map<MinecraftKey, List<a>>)map, (Multimap<MinecraftKey, MinecraftKey>)multimap, (Set<MinecraftKey>)set, tagId, (MinecraftKey tagId2, List<a> entries) -> this.a(lookup, (List<a>)entries).ifLeft(missingReferences -> a.error("Couldn't load tag {} as it is missing following references: {}", tagId2, (Object)missingReferences.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(resolvedEntries -> map2.put(tagId2, resolvedEntries)));
    }

    private static /* synthetic */ void a(Multimap multimap, MinecraftKey tagId, List entries) {
        entries.forEach(entry -> entry.a.b((MinecraftKey referencedTagId) -> TagDataPack.b((Multimap<MinecraftKey, MinecraftKey>)multimap, tagId, referencedTagId)));
    }

    private static /* synthetic */ void b(Multimap multimap, MinecraftKey tagId, List entries) {
        entries.forEach(entry -> entry.a.a((MinecraftKey referencedTagId) -> TagDataPack.b((Multimap<MinecraftKey, MinecraftKey>)multimap, tagId, referencedTagId)));
    }

    public record a(TagEntry a, String b) {
        @Override
        @Override
        public String toString() {
            return this.a + " (from " + this.b + ")";
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "entry;source", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "entry;source", "a", "b"}, this, object);
        }
    }
}

