/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ExtraCodecs {
    public static final Codec<JsonElement> a = Codec.PASSTHROUGH.xmap(dynamic -> (JsonElement)dynamic.convert(JsonOps.INSTANCE).getValue(), element -> new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, (JsonElement)element));
    public static final Codec<IChatBaseComponent> b = a.flatXmap(element -> {
        try {
            return DataResult.success((Object)IChatBaseComponent.ChatSerializer.a(element));
        }
        catch (JsonParseException jsonParseException) {
            return DataResult.error(jsonParseException::getMessage);
        }
    }, text -> {
        try {
            return DataResult.success((Object)IChatBaseComponent.ChatSerializer.c(text));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(illegalArgumentException::getMessage);
        }
    });
    public static final Codec<Vector3f> c = Codec.FLOAT.listOf().comapFlatMap(list2 -> SystemUtils.a(list2, 3).map(list -> new Vector3f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue())), vec3f -> List.of(Float.valueOf(vec3f.x()), Float.valueOf(vec3f.y()), Float.valueOf(vec3f.z())));
    public static final Codec<Quaternionf> d = Codec.FLOAT.listOf().comapFlatMap(list2 -> SystemUtils.a(list2, 4).map(list -> new Quaternionf(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue(), ((Float)list.get(3)).floatValue())), quaternion -> List.of(Float.valueOf(quaternion.x), Float.valueOf(quaternion.y), Float.valueOf(quaternion.z), Float.valueOf(quaternion.w)));
    public static final Codec<AxisAngle4f> e = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("angle").forGetter(axisAngle -> Float.valueOf(axisAngle.angle)), (App)c.fieldOf("axis").forGetter(axisAngle -> new Vector3f(axisAngle.x, axisAngle.y, axisAngle.z))).apply((Applicative)instance, AxisAngle4f::new));
    public static final Codec<Quaternionf> f = Codec.either(d, (Codec)e.xmap(Quaternionf::new, AxisAngle4f::new)).xmap(either -> either.map(quaternion -> quaternion, quaternion -> quaternion), Either::left);
    public static Codec<Matrix4f> g = Codec.FLOAT.listOf().comapFlatMap(list2 -> SystemUtils.a(list2, 16).map(list -> {
        Matrix4f matrix4f = new Matrix4f();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            matrix4f.setRowColumn(i2 >> 2, i2 & 3, ((Float)list.get(i2)).floatValue());
        }
        return matrix4f.determineProperties();
    }), matrix4f -> {
        FloatArrayList floatList = new FloatArrayList(16);
        for (int i2 = 0; i2 < 16; ++i2) {
            floatList.add(matrix4f.getRowColumn(i2 >> 2, i2 & 3));
        }
        return floatList;
    });
    public static final Codec<Integer> h = ExtraCodecs.a(0, Integer.MAX_VALUE, (Integer v2) -> "Value must be non-negative: " + v2);
    public static final Codec<Integer> i = ExtraCodecs.a(1, Integer.MAX_VALUE, (Integer v2) -> "Value must be positive: " + v2);
    public static final Codec<Float> j = ExtraCodecs.a(0.0f, Float.MAX_VALUE, (Float v2) -> "Value must be positive: " + v2);
    public static final Codec<Pattern> k = Codec.STRING.comapFlatMap(pattern -> {
        try {
            return DataResult.success((Object)Pattern.compile(pattern));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return DataResult.error(() -> "Invalid regex pattern '" + pattern + "': " + patternSyntaxException.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> l = ExtraCodecs.a(DateTimeFormatter.ISO_INSTANT);
    public static final Codec<byte[]> m = Codec.STRING.comapFlatMap(encoded -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)encoded));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, data -> Base64.getEncoder().encodeToString((byte[])data));
    public static final Codec<d> n = Codec.STRING.comapFlatMap(tagEntry -> tagEntry.startsWith("#") ? MinecraftKey.b(tagEntry.substring(1)).map(id -> new d((MinecraftKey)id, true)) : MinecraftKey.b(tagEntry).map(id -> new d((MinecraftKey)id, false)), d::c);
    public static final Function<Optional<Long>, OptionalLong> o = optional -> optional.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> p = optionalLong -> optionalLong.isPresent() ? Optional.of(optionalLong.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> q = Codec.LONG_STREAM.xmap(stream -> BitSet.valueOf(stream.toArray()), set -> Arrays.stream(set.toLongArray()));
    private static final Codec<Property> u = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Property::getName), (App)Codec.STRING.fieldOf("value").forGetter(Property::getValue), (App)Codec.STRING.optionalFieldOf("signature").forGetter(property -> Optional.ofNullable(property.getSignature()))).apply((Applicative)instance, (key, value, signature) -> new Property(key, value, (String)signature.orElse(null))));
    @VisibleForTesting
    public static final Codec<PropertyMap> r = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()), (Codec)u.listOf()).xmap(either -> {
        PropertyMap propertyMap = new PropertyMap();
        either.ifLeft(map -> map.forEach((key, values) -> {
            for (String string : values) {
                propertyMap.put(key, (Object)new Property(key, string));
            }
        })).ifRight(properties -> {
            for (Property property : properties) {
                propertyMap.put((Object)property.getName(), (Object)property);
            }
        });
        return propertyMap;
    }, properties -> Either.right(properties.values().stream().toList()));
    public static final Codec<GameProfile> s = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)UUIDUtil.c.xmap(Optional::of, optional -> optional.orElse(null)).optionalFieldOf("id", Optional.empty()), (MapCodec)Codec.STRING.xmap(Optional::of, optional -> optional.orElse(null)).optionalFieldOf("name", Optional.empty())).flatXmap(ExtraCodecs::a, ExtraCodecs::a).forGetter(Function.identity()), (App)r.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(GameProfile::getProperties)).apply((Applicative)instance, (profile, properties) -> {
        properties.forEach((key, property) -> profile.getProperties().put(key, property));
        return profile;
    }));
    public static final Codec<String> t = ExtraCodecs.a(Codec.STRING, (T string) -> string.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)string));

    public static <F, S> Codec<Either<F, S>> a(Codec<F> first, Codec<S> second) {
        return new e<F, S>(first, second);
    }

    public static <P, I> Codec<I> a(Codec<P> codec, String leftFieldName, String rightFieldName, BiFunction<P, P, DataResult<I>> combineFunction, Function<I, P> leftFunction, Function<I, P> rightFunction) {
        Codec codec2 = Codec.list(codec).comapFlatMap(list2 -> SystemUtils.a(list2, 2).flatMap(list -> {
            Object object = list.get(0);
            Object object2 = list.get(1);
            return (DataResult)combineFunction.apply(object, object2);
        }), pair -> ImmutableList.of(leftFunction.apply(pair), rightFunction.apply(pair)));
        Codec codec3 = RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf(leftFieldName).forGetter(Pair::getFirst), (App)codec.fieldOf(rightFieldName).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).comapFlatMap(pair -> (DataResult)combineFunction.apply(pair.getFirst(), pair.getSecond()), pair -> Pair.of(leftFunction.apply(pair), rightFunction.apply(pair)));
        Codec codec4 = new b(codec2, codec3).xmap(either -> either.map(object -> object, object -> object), Either::left);
        return Codec.either(codec, (Codec)codec4).comapFlatMap(either -> either.map(object -> (DataResult)combineFunction.apply(object, object), DataResult::success), pair -> {
            Object object2;
            Object object = leftFunction.apply(pair);
            if (Objects.equals(object, object2 = rightFunction.apply(pair))) {
                return Either.left(object);
            }
            return Either.right(pair);
        });
    }

    public static <A> Codec.ResultFunction<A> a(final A object) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> dynamicOps, T object2, DataResult<Pair<A, T>> dataResult) {
                MutableObject mutableObject = new MutableObject();
                Optional optional = dataResult.resultOrPartial(arg_0 -> ((MutableObject)mutableObject).setValue(arg_0));
                if (optional.isPresent()) {
                    return dataResult;
                }
                return DataResult.error(() -> "(" + (String)mutableObject.getValue() + " -> using default)", (Object)Pair.of((Object)object, object2));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, A object2, DataResult<T> dataResult) {
                return dataResult;
            }

            @Override
            public String toString() {
                return "OrElsePartial[" + object + "]";
            }
        };
    }

    public static <E> Codec<E> a(ToIntFunction<E> elementToRawId, IntFunction<E> rawIdToElement, int errorRawId) {
        return Codec.INT.flatXmap(rawId -> Optional.ofNullable(rawIdToElement.apply((int)rawId)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + rawId)), element -> {
            int j2 = elementToRawId.applyAsInt(element);
            return j2 == errorRawId ? DataResult.error(() -> "Element with unknown id: " + element) : DataResult.success((Object)j2);
        });
    }

    public static <E> Codec<E> a(Function<E, String> elementToId, Function<String, E> idToElement) {
        return Codec.STRING.flatXmap(id -> Optional.ofNullable(idToElement.apply((String)id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + id)), element -> Optional.ofNullable((String)elementToId.apply(element)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + element)));
    }

    public static <E> Codec<E> b(final Codec<E> uncompressedCodec, final Codec<E> compressedCodec) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E object, DynamicOps<T> dynamicOps, T object2) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.encode(object, dynamicOps, object2);
                }
                return uncompressedCodec.encode(object, dynamicOps, object2);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> dynamicOps, T object) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.decode(dynamicOps, object);
                }
                return uncompressedCodec.decode(dynamicOps, object);
            }

            @Override
            public String toString() {
                return uncompressedCodec + " orCompressed " + compressedCodec;
            }
        };
    }

    public static <E> Codec<E> a(Codec<E> originalCodec, final Function<E, Lifecycle> entryLifecycleGetter, final Function<E, Lifecycle> lifecycleGetter) {
        return originalCodec.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> dynamicOps, T object, DataResult<Pair<E, T>> dataResult) {
                return dataResult.result().map(pair -> dataResult.setLifecycle((Lifecycle)entryLifecycleGetter.apply(pair.getFirst()))).orElse(dataResult);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, E object, DataResult<T> dataResult) {
                return dataResult.setLifecycle((Lifecycle)lifecycleGetter.apply(object));
            }

            @Override
            public String toString() {
                return "WithLifecycle[" + entryLifecycleGetter + " " + lifecycleGetter + "]";
            }
        });
    }

    public static <T> Codec<T> a(Codec<T> codec, Function<T, DataResult<T>> validator) {
        return codec.flatXmap(validator, validator);
    }

    private static Codec<Integer> a(int min, int max, Function<Integer, String> messageFactory) {
        return ExtraCodecs.a(Codec.INT, (T value) -> {
            if (value.compareTo(min) >= 0 && value.compareTo(max) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)messageFactory.apply((Integer)value));
        });
    }

    public static Codec<Integer> a(int min, int max) {
        return ExtraCodecs.a(min, max, (Integer value) -> "Value must be within range [" + min + ";" + max + "]: " + value);
    }

    private static Codec<Float> a(float min, float max, Function<Float, String> messageFactory) {
        return ExtraCodecs.a(Codec.FLOAT, (T value) -> {
            if (value.compareTo(Float.valueOf(min)) > 0 && value.compareTo(Float.valueOf(max)) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)messageFactory.apply((Float)value));
        });
    }

    public static <T> Codec<List<T>> a(Codec<List<T>> originalCodec) {
        return ExtraCodecs.a(originalCodec, (T list) -> list.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)list));
    }

    public static <T> Codec<HolderSet<T>> b(Codec<HolderSet<T>> originalCodec) {
        return ExtraCodecs.a(originalCodec, (T entryList) -> {
            if (entryList.c().right().filter(List::isEmpty).isPresent()) {
                return DataResult.error(() -> "List must have contents");
            }
            return DataResult.success((Object)entryList);
        });
    }

    public static <A> Codec<A> a(Supplier<Codec<A>> supplier) {
        return new c<A>(supplier);
    }

    public static <E> MapCodec<E> a(Function<DynamicOps<?>, DataResult<E>> retriever) {
        class A
        extends MapCodec<E> {
            final /* synthetic */ Function a;

            A(Function retriever) {
                this.a = retriever;
            }

            public <T> RecordBuilder<T> encode(E object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                return recordBuilder;
            }

            public <T> DataResult<E> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return (DataResult)this.a.apply(dynamicOps);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + this.a + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return Stream.empty();
            }
        }
        return new A(retriever);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> b(Function<E, T> typeGetter) {
        return collection -> {
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                Object object = typeGetter.apply(iterator.next());
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    Object object3 = typeGetter.apply(object2);
                    if (object3 == object) continue;
                    return DataResult.error(() -> "Mixed type list: element " + object2 + " had type " + object3 + ", but list is of type " + object);
                }
            }
            return DataResult.success((Object)collection, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> c(final Codec<A> codec) {
        return Codec.of(codec, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> dynamicOps, T object) {
                try {
                    return codec.decode(dynamicOps, object);
                }
                catch (Exception exception) {
                    return DataResult.error(() -> "Caught exception decoding " + object + ": " + exception.getMessage());
                }
            }
        });
    }

    public static Codec<Instant> a(DateTimeFormatter formatter) {
        return Codec.STRING.comapFlatMap(dateTimeString -> {
            try {
                return DataResult.success((Object)Instant.from(formatter.parse((CharSequence)dateTimeString)));
            }
            catch (Exception exception) {
                return DataResult.error(exception::getMessage);
            }
        }, formatter::format);
    }

    public static MapCodec<OptionalLong> a(MapCodec<Optional<Long>> codec) {
        return codec.xmap(o, p);
    }

    private static DataResult<GameProfile> a(Pair<Optional<UUID>, Optional<String>> pair) {
        try {
            return DataResult.success((Object)new GameProfile((UUID)((Optional)pair.getFirst()).orElse(null), (String)((Optional)pair.getSecond()).orElse(null)));
        }
        catch (Throwable throwable) {
            return DataResult.error(throwable::getMessage);
        }
    }

    private static DataResult<Pair<Optional<UUID>, Optional<String>>> a(GameProfile profile) {
        return DataResult.success((Object)Pair.of(Optional.ofNullable(profile.getId()), Optional.ofNullable(profile.getName())));
    }

    public static Codec<String> b(int minLength, int maxLength) {
        return ExtraCodecs.a(Codec.STRING, (T string) -> {
            int k2 = string.length();
            if (k2 < minLength) {
                return DataResult.error(() -> "String \"" + string + "\" is too short: " + k2 + ", expected range [" + minLength + "-" + maxLength + "]");
            }
            if (k2 > maxLength) {
                return DataResult.error(() -> "String \"" + string + "\" is too long: " + k2 + ", expected range [" + minLength + "-" + maxLength + "]");
            }
            return DataResult.success((Object)string);
        });
    }

    static final class e<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> a;
        private final Codec<S> b;

        public e(Codec<F> first, Codec<S> second) {
            this.a = first;
            this.b = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            DataResult dataResult = this.a.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::left));
            DataResult dataResult2 = this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::right));
            Optional optional = dataResult.result();
            Optional optional2 = dataResult2.result();
            if (optional.isPresent() && optional2.isPresent()) {
                return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + optional.get() + " second: " + optional2.get(), (Object)((Pair)optional.get()));
            }
            return optional.isPresent() ? dataResult : dataResult2;
        }

        public <T> DataResult<T> a(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return either.map(left -> this.a.encode(left, dynamicOps, object), right -> this.b.encode(right, dynamicOps, object));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            e xorCodec = (e)object;
            return Objects.equals(this.a, xorCodec.a) && Objects.equals(this.b, xorCodec.b);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        @Override
        public String toString() {
            return "XorCodec[" + this.a + ", " + this.b + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Either)object, dynamicOps, object2);
        }
    }

    static final class b<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> a;
        private final Codec<S> b;

        public b(Codec<F> first, Codec<S> second) {
            this.a = first;
            this.b = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            DataResult dataResult = this.a.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::left));
            if (!dataResult.error().isPresent()) {
                return dataResult;
            }
            DataResult dataResult2 = this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Either::right));
            if (!dataResult2.error().isPresent()) {
                return dataResult2;
            }
            return dataResult.apply2((pair, pair2) -> pair2, dataResult2);
        }

        public <T> DataResult<T> a(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return either.map(left -> this.a.encode(left, dynamicOps, object), right -> this.b.encode(right, dynamicOps, object));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            b eitherCodec = (b)object;
            return Objects.equals(this.a, eitherCodec.a) && Objects.equals(this.b, eitherCodec.b);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        @Override
        public String toString() {
            return "EitherCodec[" + this.a + ", " + this.b + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Either)object, dynamicOps, object2);
        }
    }

    record c<A>(Supplier<Codec<A>> a) implements Codec<A>
    {
        c(Supplier<Codec<A>> supplier) {
            this.a = supplier = Suppliers.memoize(() -> supplier.get());
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> dynamicOps, T object) {
            return this.a.get().decode(dynamicOps, object);
        }

        public <T> DataResult<T> encode(A object, DynamicOps<T> dynamicOps, T object2) {
            return this.a.get().encode(object, dynamicOps, object2);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "delegate", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "delegate", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "delegate", "a"}, this, object);
        }
    }

    public record d(MinecraftKey a, boolean b) {
        @Override
        @Override
        public String toString() {
            return this.c();
        }

        private String c() {
            return this.b ? "#" + this.a : this.a.toString();
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "id;tag", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "id;tag", "a", "b"}, this, object);
        }
    }
}

