/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.BlendingDataFix;
import net.minecraft.util.datafix.fixes.BlendingDataRemoveFromNetherEndFix;
import net.minecraft.util.datafix.fixes.BlockRenameFixWithJigsaw;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChunkConverterPalette;
import net.minecraft.util.datafix.fixes.ChunkDeleteIgnoredLightDataFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.CriteriaRenameFix;
import net.minecraft.util.datafix.fixes.DataConverterAddChoices;
import net.minecraft.util.datafix.fixes.DataConverterAdvancement;
import net.minecraft.util.datafix.fixes.DataConverterAdvancementBase;
import net.minecraft.util.datafix.fixes.DataConverterArmorStand;
import net.minecraft.util.datafix.fixes.DataConverterAttributes;
import net.minecraft.util.datafix.fixes.DataConverterBanner;
import net.minecraft.util.datafix.fixes.DataConverterBannerColour;
import net.minecraft.util.datafix.fixes.DataConverterBedBlock;
import net.minecraft.util.datafix.fixes.DataConverterBedItem;
import net.minecraft.util.datafix.fixes.DataConverterBiome;
import net.minecraft.util.datafix.fixes.DataConverterBiomeBase;
import net.minecraft.util.datafix.fixes.DataConverterBitStorageAlign;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterBlockName;
import net.minecraft.util.datafix.fixes.DataConverterBlockRename;
import net.minecraft.util.datafix.fixes.DataConverterBook;
import net.minecraft.util.datafix.fixes.DataConverterCatType;
import net.minecraft.util.datafix.fixes.DataConverterChunkLightRemove;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus2;
import net.minecraft.util.datafix.fixes.DataConverterChunkStructuresTemplateRename;
import net.minecraft.util.datafix.fixes.DataConverterColorlessShulkerEntity;
import net.minecraft.util.datafix.fixes.DataConverterCoral;
import net.minecraft.util.datafix.fixes.DataConverterCoralFan;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameEntity;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameItem;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameTile;
import net.minecraft.util.datafix.fixes.DataConverterDropChances;
import net.minecraft.util.datafix.fixes.DataConverterDye;
import net.minecraft.util.datafix.fixes.DataConverterEntity;
import net.minecraft.util.datafix.fixes.DataConverterEntityBlockState;
import net.minecraft.util.datafix.fixes.DataConverterEntityCatSplit;
import net.minecraft.util.datafix.fixes.DataConverterEntityCodSalmon;
import net.minecraft.util.datafix.fixes.DataConverterEntityProjectileOwner;
import net.minecraft.util.datafix.fixes.DataConverterEntityPufferfish;
import net.minecraft.util.datafix.fixes.DataConverterEntityRavagerRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityShulkerRotation;
import net.minecraft.util.datafix.fixes.DataConverterEntityTippedArrow;
import net.minecraft.util.datafix.fixes.DataConverterEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterEntityZombifiedPiglinRename;
import net.minecraft.util.datafix.fixes.DataConverterEquipment;
import net.minecraft.util.datafix.fixes.DataConverterFlatten;
import net.minecraft.util.datafix.fixes.DataConverterFlattenSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterFlattenState;
import net.minecraft.util.datafix.fixes.DataConverterFurnaceRecipesUsed;
import net.minecraft.util.datafix.fixes.DataConverterGossip;
import net.minecraft.util.datafix.fixes.DataConverterGuardian;
import net.minecraft.util.datafix.fixes.DataConverterHanging;
import net.minecraft.util.datafix.fixes.DataConverterHealth;
import net.minecraft.util.datafix.fixes.DataConverterHeightmapRenaming;
import net.minecraft.util.datafix.fixes.DataConverterHorse;
import net.minecraft.util.datafix.fixes.DataConverterIglooMetadataRemoval;
import net.minecraft.util.datafix.fixes.DataConverterItemFrame;
import net.minecraft.util.datafix.fixes.DataConverterItemLoreComponentize;
import net.minecraft.util.datafix.fixes.DataConverterItemName;
import net.minecraft.util.datafix.fixes.DataConverterItemStackEnchantment;
import net.minecraft.util.datafix.fixes.DataConverterItemStackUUID;
import net.minecraft.util.datafix.fixes.DataConverterJigsawProperties;
import net.minecraft.util.datafix.fixes.DataConverterJigsawRotation;
import net.minecraft.util.datafix.fixes.DataConverterJukeBox;
import net.minecraft.util.datafix.fixes.DataConverterKeybind;
import net.minecraft.util.datafix.fixes.DataConverterKeybind2;
import net.minecraft.util.datafix.fixes.DataConverterLang;
import net.minecraft.util.datafix.fixes.DataConverterLeaves;
import net.minecraft.util.datafix.fixes.DataConverterLeavesBiome;
import net.minecraft.util.datafix.fixes.DataConverterLevelDataGeneratorOptions;
import net.minecraft.util.datafix.fixes.DataConverterMap;
import net.minecraft.util.datafix.fixes.DataConverterMapId;
import net.minecraft.util.datafix.fixes.DataConverterMaterialId;
import net.minecraft.util.datafix.fixes.DataConverterMemoryExpiry;
import net.minecraft.util.datafix.fixes.DataConverterMinecart;
import net.minecraft.util.datafix.fixes.DataConverterMiscUUID;
import net.minecraft.util.datafix.fixes.DataConverterMissingDimension;
import net.minecraft.util.datafix.fixes.DataConverterMobSpawner;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterNewVillage;
import net.minecraft.util.datafix.fixes.DataConverterObjectiveDisplayName;
import net.minecraft.util.datafix.fixes.DataConverterObjectiveRenderType;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerBlockEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerRename;
import net.minecraft.util.datafix.fixes.DataConverterOptionsAddTextBackground;
import net.minecraft.util.datafix.fixes.DataConverterPOI;
import net.minecraft.util.datafix.fixes.DataConverterPOIRebuild;
import net.minecraft.util.datafix.fixes.DataConverterPainting;
import net.minecraft.util.datafix.fixes.DataConverterPiston;
import net.minecraft.util.datafix.fixes.DataConverterPlayerUUID;
import net.minecraft.util.datafix.fixes.DataConverterPotionId;
import net.minecraft.util.datafix.fixes.DataConverterPotionWater;
import net.minecraft.util.datafix.fixes.DataConverterProtoChunk;
import net.minecraft.util.datafix.fixes.DataConverterRecipeBase;
import net.minecraft.util.datafix.fixes.DataConverterRecipeRename;
import net.minecraft.util.datafix.fixes.DataConverterRecipes;
import net.minecraft.util.datafix.fixes.DataConverterRedstoneConnections;
import net.minecraft.util.datafix.fixes.DataConverterRemoveGolemGossip;
import net.minecraft.util.datafix.fixes.DataConverterRiding;
import net.minecraft.util.datafix.fixes.DataConverterSaddle;
import net.minecraft.util.datafix.fixes.DataConverterSavedDataUUID;
import net.minecraft.util.datafix.fixes.DataConverterSettingRename;
import net.minecraft.util.datafix.fixes.DataConverterShoulderEntity;
import net.minecraft.util.datafix.fixes.DataConverterShulker;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxBlock;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxItem;
import net.minecraft.util.datafix.fixes.DataConverterSignText;
import net.minecraft.util.datafix.fixes.DataConverterSkeleton;
import net.minecraft.util.datafix.fixes.DataConverterSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterStatistic;
import net.minecraft.util.datafix.fixes.DataConverterStriderGravity;
import net.minecraft.util.datafix.fixes.DataConverterStructureReference;
import net.minecraft.util.datafix.fixes.DataConverterTeamDisplayName;
import net.minecraft.util.datafix.fixes.DataConverterTileEntity;
import net.minecraft.util.datafix.fixes.DataConverterTrappedChest;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterUUID;
import net.minecraft.util.datafix.fixes.DataConverterVBO;
import net.minecraft.util.datafix.fixes.DataConverterVillagerFollowRange;
import net.minecraft.util.datafix.fixes.DataConverterVillagerLevelXp;
import net.minecraft.util.datafix.fixes.DataConverterVillagerProfession;
import net.minecraft.util.datafix.fixes.DataConverterVillagerTrade;
import net.minecraft.util.datafix.fixes.DataConverterWallProperty;
import net.minecraft.util.datafix.fixes.DataConverterWolf;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettings;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettingsBuilding;
import net.minecraft.util.datafix.fixes.DataConverterZombie;
import net.minecraft.util.datafix.fixes.DataConverterZombieType;
import net.minecraft.util.datafix.fixes.DataConverterZombieVillagerLevelXp;
import net.minecraft.util.datafix.fixes.EffectDurationFix;
import net.minecraft.util.datafix.fixes.EntityGoatMissingStateFix;
import net.minecraft.util.datafix.fixes.EntityPaintingFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityVariantFix;
import net.minecraft.util.datafix.fixes.FilteredBooksFix;
import net.minecraft.util.datafix.fixes.FilteredSignsFix;
import net.minecraft.util.datafix.fixes.GoatHornIdFix;
import net.minecraft.util.datafix.fixes.ItemRemoveBlockEntityTagFix;
import net.minecraft.util.datafix.fixes.OptionsAccessibilityOnboardFix;
import net.minecraft.util.datafix.fixes.OptionsAmbientOcclusionFix;
import net.minecraft.util.datafix.fixes.OptionsProgrammerArtFix;
import net.minecraft.util.datafix.fixes.OverreachingTickFix;
import net.minecraft.util.datafix.fixes.PoiTypeRemoveFix;
import net.minecraft.util.datafix.fixes.PoiTypeRenameFix;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.SimpleRenameFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StructureSettingsFlattenFix;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.util.datafix.fixes.VariantRenameFix;
import net.minecraft.util.datafix.fixes.WeaponSmithChestLootTableFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV102;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1022;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV106;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV107;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1125;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV135;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV143;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_1;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_2;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_3;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_4;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_5;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_6;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1460;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1466;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1470;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1481;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1483;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1486;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1510;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1800;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1801;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1904;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1906;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1909;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1920;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1928;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1929;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1931;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2502;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2505;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2509;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2519;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2522;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2551;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2568;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV700;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV701;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV702;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV703;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV704;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV705;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV808;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV99;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V3076;
import net.minecraft.util.datafix.schemas.V3078;
import net.minecraft.util.datafix.schemas.V3081;
import net.minecraft.util.datafix.schemas.V3082;
import net.minecraft.util.datafix.schemas.V3083;
import net.minecraft.util.datafix.schemas.V3202;
import net.minecraft.util.datafix.schemas.V3203;
import net.minecraft.util.datafix.schemas.V3204;
import net.minecraft.util.datafix.schemas.V3325;
import net.minecraft.util.datafix.schemas.V3326;
import net.minecraft.util.datafix.schemas.V3327;
import net.minecraft.util.datafix.schemas.V3328;

public class DataConverterRegistry {
    private static final BiFunction<Integer, Schema, Schema> b = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> c = DataConverterSchemaNamed::new;
    private static final DataFixer d = DataConverterRegistry.a(SharedConstants.aP);
    public static final int a = 3088;

    private DataConverterRegistry() {
    }

    public static DataFixer a() {
        return d;
    }

    private static synchronized DataFixer a(Set<DSL.TypeReference> requiredTypes) {
        DataFixerBuilder datafixerbuilder = new DataFixerBuilder(SharedConstants.b().d().c());
        DataConverterRegistry.a(datafixerbuilder);
        if (requiredTypes.isEmpty()) {
            return datafixerbuilder.buildUnoptimized();
        }
        ExecutorService executorservice = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        return datafixerbuilder.buildOptimized(requiredTypes, executorservice);
    }

    private static void a(DataFixerBuilder builder) {
        builder.addSchema(99, DataConverterSchemaV99::new);
        Schema schema = builder.addSchema(100, DataConverterSchemaV100::new);
        builder.addFixer(new DataConverterEquipment(schema, true));
        Schema schema1 = builder.addSchema(101, b);
        builder.addFixer(new DataConverterSignText(schema1, false));
        Schema schema2 = builder.addSchema(102, DataConverterSchemaV102::new);
        builder.addFixer(new DataConverterMaterialId(schema2, true));
        builder.addFixer(new DataConverterPotionId(schema2, false));
        Schema schema3 = builder.addSchema(105, b);
        builder.addFixer(new DataConverterSpawnEgg(schema3, true));
        Schema schema4 = builder.addSchema(106, DataConverterSchemaV106::new);
        builder.addFixer(new DataConverterMobSpawner(schema4, true));
        Schema schema5 = builder.addSchema(107, DataConverterSchemaV107::new);
        builder.addFixer(new DataConverterMinecart(schema5, true));
        Schema schema6 = builder.addSchema(108, b);
        builder.addFixer(new DataConverterUUID(schema6, true));
        Schema schema7 = builder.addSchema(109, b);
        builder.addFixer(new DataConverterHealth(schema7, true));
        Schema schema8 = builder.addSchema(110, b);
        builder.addFixer(new DataConverterSaddle(schema8, true));
        Schema schema9 = builder.addSchema(111, b);
        builder.addFixer(new DataConverterHanging(schema9, true));
        Schema schema10 = builder.addSchema(113, b);
        builder.addFixer(new DataConverterDropChances(schema10, true));
        Schema schema11 = builder.addSchema(135, DataConverterSchemaV135::new);
        builder.addFixer(new DataConverterRiding(schema11, true));
        Schema schema12 = builder.addSchema(143, DataConverterSchemaV143::new);
        builder.addFixer(new DataConverterEntityTippedArrow(schema12, true));
        Schema schema13 = builder.addSchema(147, b);
        builder.addFixer(new DataConverterArmorStand(schema13, true));
        Schema schema14 = builder.addSchema(165, b);
        builder.addFixer(new DataConverterBook(schema14, true));
        Schema schema15 = builder.addSchema(501, DataConverterSchemaV501::new);
        builder.addFixer(new DataConverterAddChoices(schema15, "Add 1.10 entities fix", DataConverterTypes.q));
        Schema schema16 = builder.addSchema(502, b);
        builder.addFixer(DataConverterItemName.a(schema16, "cooked_fished item renamer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : s2));
        builder.addFixer(new DataConverterZombie(schema16, false));
        Schema schema17 = builder.addSchema(505, b);
        builder.addFixer(new DataConverterVBO(schema17, false));
        Schema schema18 = builder.addSchema(700, DataConverterSchemaV700::new);
        builder.addFixer(new DataConverterGuardian(schema18, true));
        Schema schema19 = builder.addSchema(701, DataConverterSchemaV701::new);
        builder.addFixer(new DataConverterSkeleton(schema19, true));
        Schema schema20 = builder.addSchema(702, DataConverterSchemaV702::new);
        builder.addFixer(new DataConverterZombieType(schema20, true));
        Schema schema21 = builder.addSchema(703, DataConverterSchemaV703::new);
        builder.addFixer(new DataConverterHorse(schema21, true));
        Schema schema22 = builder.addSchema(704, DataConverterSchemaV704::new);
        builder.addFixer(new DataConverterTileEntity(schema22, true));
        Schema schema23 = builder.addSchema(705, DataConverterSchemaV705::new);
        builder.addFixer(new DataConverterEntity(schema23, true));
        Schema schema24 = builder.addSchema(804, c);
        builder.addFixer(new DataConverterBanner(schema24, true));
        Schema schema25 = builder.addSchema(806, c);
        builder.addFixer(new DataConverterPotionWater(schema25, false));
        Schema schema26 = builder.addSchema(808, DataConverterSchemaV808::new);
        builder.addFixer(new DataConverterAddChoices(schema26, "added shulker box", DataConverterTypes.l));
        Schema schema27 = builder.addSchema(808, 1, c);
        builder.addFixer(new DataConverterShulker(schema27, false));
        Schema schema28 = builder.addSchema(813, c);
        builder.addFixer(new DataConverterShulkerBoxItem(schema28, false));
        builder.addFixer(new DataConverterShulkerBoxBlock(schema28, false));
        Schema schema29 = builder.addSchema(816, c);
        builder.addFixer(new DataConverterLang(schema29, false));
        Schema schema30 = builder.addSchema(820, c);
        builder.addFixer(DataConverterItemName.a(schema30, "totem item renamer", DataConverterRegistry.a("minecraft:totem", "minecraft:totem_of_undying")));
        Schema schema31 = builder.addSchema(1022, DataConverterSchemaV1022::new);
        builder.addFixer(new DataConverterShoulderEntity(schema31, "added shoulder entities to players", DataConverterTypes.b));
        Schema schema32 = builder.addSchema(1125, DataConverterSchemaV1125::new);
        builder.addFixer(new DataConverterBedBlock(schema32, true));
        builder.addFixer(new DataConverterBedItem(schema32, false));
        Schema schema33 = builder.addSchema(1344, c);
        builder.addFixer(new DataConverterKeybind(schema33, false));
        Schema schema34 = builder.addSchema(1446, c);
        builder.addFixer(new DataConverterKeybind2(schema34, false));
        Schema schema35 = builder.addSchema(1450, c);
        builder.addFixer(new DataConverterFlattenState(schema35, false));
        Schema schema36 = builder.addSchema(1451, DataConverterSchemaV1451::new);
        builder.addFixer(new DataConverterAddChoices(schema36, "AddTrappedChestFix", DataConverterTypes.l));
        Schema schema37 = builder.addSchema(1451, 1, DataConverterSchemaV1451_1::new);
        builder.addFixer(new ChunkConverterPalette(schema37, true));
        Schema schema38 = builder.addSchema(1451, 2, DataConverterSchemaV1451_2::new);
        builder.addFixer(new DataConverterPiston(schema38, true));
        Schema schema39 = builder.addSchema(1451, 3, DataConverterSchemaV1451_3::new);
        builder.addFixer(new DataConverterEntityBlockState(schema39, true));
        builder.addFixer(new DataConverterMap(schema39, false));
        Schema schema40 = builder.addSchema(1451, 4, DataConverterSchemaV1451_4::new);
        builder.addFixer(new DataConverterBlockName(schema40, true));
        builder.addFixer(new DataConverterFlatten(schema40, false));
        Schema schema41 = builder.addSchema(1451, 5, DataConverterSchemaV1451_5::new);
        builder.addFixer(new ItemRemoveBlockEntityTagFix(schema41, false, Set.of("minecraft:note_block", "minecraft:flower_pot", "minecraft:dandelion", "minecraft:poppy", "minecraft:blue_orchid", "minecraft:allium", "minecraft:azure_bluet", "minecraft:red_tulip", "minecraft:orange_tulip", "minecraft:white_tulip", "minecraft:pink_tulip", "minecraft:oxeye_daisy", "minecraft:cactus", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:oak_sapling", "minecraft:spruce_sapling", "minecraft:birch_sapling", "minecraft:jungle_sapling", "minecraft:acacia_sapling", "minecraft:dark_oak_sapling", "minecraft:dead_bush", "minecraft:fern")));
        builder.addFixer(new DataConverterAddChoices(schema41, "RemoveNoteBlockFlowerPotFix", DataConverterTypes.l));
        builder.addFixer(new DataConverterFlattenSpawnEgg(schema41, false, "minecraft:spawn_egg"));
        builder.addFixer(new DataConverterWolf(schema41, false));
        builder.addFixer(new DataConverterBannerColour(schema41, false));
        builder.addFixer(new DataConverterWorldGenSettings(schema41, false));
        Schema schema42 = builder.addSchema(1451, 6, DataConverterSchemaV1451_6::new);
        builder.addFixer(new DataConverterStatistic(schema42, true));
        builder.addFixer(new DataConverterShoulderEntity(schema42, "Rewrite objectives", DataConverterTypes.w));
        builder.addFixer(new DataConverterJukeBox(schema42, false));
        Schema schema43 = builder.addSchema(1451, 7, c);
        builder.addFixer(new DataConverterVillagerTrade(schema43, false));
        Schema schema44 = builder.addSchema(1456, c);
        builder.addFixer(new DataConverterItemFrame(schema44, false));
        Schema schema45 = builder.addSchema(1458, c);
        builder.addFixer(new DataFix(schema45, false){

            protected TypeRewriteRule makeRule() {
                return this.fixTypeEverywhereTyped("Player CustomName", this.getInputSchema().getType(DataConverterTypes.b), typed -> typed.update(DSL.remainderFinder(), dynamic -> DataConverterCustomNameEntity.a(dynamic)));
            }
        });
        builder.addFixer(new DataConverterCustomNameEntity(schema45, false));
        builder.addFixer(new DataConverterCustomNameItem(schema45, false));
        builder.addFixer(new DataConverterCustomNameTile(schema45, false));
        Schema schema46 = builder.addSchema(1460, DataConverterSchemaV1460::new);
        builder.addFixer(new DataConverterPainting(schema46, false));
        Schema schema47 = builder.addSchema(1466, DataConverterSchemaV1466::new);
        builder.addFixer(new DataConverterProtoChunk(schema47, true));
        Schema schema48 = builder.addSchema(1470, DataConverterSchemaV1470::new);
        builder.addFixer(new DataConverterAddChoices(schema48, "Add 1.13 entities fix", DataConverterTypes.q));
        Schema schema49 = builder.addSchema(1474, c);
        builder.addFixer(new DataConverterColorlessShulkerEntity(schema49, false));
        builder.addFixer(DataConverterBlockRename.a(schema49, "Colorless shulker block fixer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : s2));
        builder.addFixer(DataConverterItemName.a(schema49, "Colorless shulker item fixer", s2 -> Objects.equals(DataConverterSchemaNamed.a(s2), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : s2));
        Schema schema50 = builder.addSchema(1475, c);
        builder.addFixer(DataConverterBlockRename.a(schema50, "Flowing fixer", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema schema51 = builder.addSchema(1480, c);
        builder.addFixer(DataConverterBlockRename.a(schema51, "Rename coral blocks", DataConverterRegistry.a(DataConverterCoral.a)));
        builder.addFixer(DataConverterItemName.a(schema51, "Rename coral items", DataConverterRegistry.a(DataConverterCoral.a)));
        Schema schema52 = builder.addSchema(1481, DataConverterSchemaV1481::new);
        builder.addFixer(new DataConverterAddChoices(schema52, "Add conduit", DataConverterTypes.l));
        Schema schema53 = builder.addSchema(1483, DataConverterSchemaV1483::new);
        builder.addFixer(new DataConverterEntityPufferfish(schema53, true));
        builder.addFixer(DataConverterItemName.a(schema53, "Rename pufferfish egg item", DataConverterRegistry.a(DataConverterEntityPufferfish.a)));
        Schema schema54 = builder.addSchema(1484, c);
        builder.addFixer(DataConverterItemName.a(schema54, "Rename seagrass items", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        builder.addFixer(DataConverterBlockRename.a(schema54, "Rename seagrass blocks", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        builder.addFixer(new DataConverterHeightmapRenaming(schema54, false));
        Schema schema55 = builder.addSchema(1486, DataConverterSchemaV1486::new);
        builder.addFixer(new DataConverterEntityCodSalmon(schema55, true));
        builder.addFixer(DataConverterItemName.a(schema55, "Rename cod/salmon egg items", DataConverterRegistry.a(DataConverterEntityCodSalmon.b)));
        Schema schema56 = builder.addSchema(1487, c);
        builder.addFixer(DataConverterItemName.a(schema56, "Rename prismarine_brick(s)_* blocks", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        builder.addFixer(DataConverterBlockRename.a(schema56, "Rename prismarine_brick(s)_* items", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema schema57 = builder.addSchema(1488, c);
        builder.addFixer(DataConverterBlockRename.a(schema57, "Rename kelp/kelptop", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        builder.addFixer(DataConverterItemName.a(schema57, "Rename kelptop", DataConverterRegistry.a("minecraft:kelp_top", "minecraft:kelp")));
        builder.addFixer(new DataConverterNamedEntity(schema57, false, "Command block block entity custom name fix", DataConverterTypes.l, "minecraft:command_block"){

            @Override
            protected Typed<?> a(Typed<?> inputType) {
                return inputType.update(DSL.remainderFinder(), DataConverterCustomNameEntity::a);
            }
        });
        builder.addFixer(new DataConverterNamedEntity(schema57, false, "Command block minecart custom name fix", DataConverterTypes.q, "minecraft:commandblock_minecart"){

            @Override
            protected Typed<?> a(Typed<?> inputType) {
                return inputType.update(DSL.remainderFinder(), DataConverterCustomNameEntity::a);
            }
        });
        builder.addFixer(new DataConverterIglooMetadataRemoval(schema57, false));
        Schema schema58 = builder.addSchema(1490, c);
        builder.addFixer(DataConverterBlockRename.a(schema58, "Rename melon_block", DataConverterRegistry.a("minecraft:melon_block", "minecraft:melon")));
        builder.addFixer(DataConverterItemName.a(schema58, "Rename melon_block/melon/speckled_melon", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema schema59 = builder.addSchema(1492, c);
        builder.addFixer(new DataConverterChunkStructuresTemplateRename(schema59, false));
        Schema schema60 = builder.addSchema(1494, c);
        builder.addFixer(new DataConverterItemStackEnchantment(schema60, false));
        Schema schema61 = builder.addSchema(1496, c);
        builder.addFixer(new DataConverterLeaves(schema61, false));
        Schema schema62 = builder.addSchema(1500, c);
        builder.addFixer(new DataConverterBlockEntityKeepPacked(schema62, false));
        Schema schema63 = builder.addSchema(1501, c);
        builder.addFixer(new DataConverterAdvancement(schema63, false));
        Schema schema64 = builder.addSchema(1502, c);
        builder.addFixer(new DataConverterRecipes(schema64, false));
        Schema schema65 = builder.addSchema(1506, c);
        builder.addFixer(new DataConverterLevelDataGeneratorOptions(schema65, false));
        Schema schema66 = builder.addSchema(1510, DataConverterSchemaV1510::new);
        builder.addFixer(DataConverterBlockRename.a(schema66, "Block renamening fix", DataConverterRegistry.a(DataConverterEntityRename.b)));
        builder.addFixer(DataConverterItemName.a(schema66, "Item renamening fix", DataConverterRegistry.a(DataConverterEntityRename.c)));
        builder.addFixer(new DataConverterRecipeRename(schema66, false));
        builder.addFixer(new DataConverterEntityRename(schema66, true));
        builder.addFixer(new StatsRenameFix(schema66, "SwimStatsRenameFix", (Map<String, String>)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema schema67 = builder.addSchema(1514, c);
        builder.addFixer(new DataConverterObjectiveDisplayName(schema67, false));
        builder.addFixer(new DataConverterTeamDisplayName(schema67, false));
        builder.addFixer(new DataConverterObjectiveRenderType(schema67, false));
        Schema schema68 = builder.addSchema(1515, c);
        builder.addFixer(DataConverterBlockRename.a(schema68, "Rename coral fan blocks", DataConverterRegistry.a(DataConverterCoralFan.a)));
        Schema schema69 = builder.addSchema(1624, c);
        builder.addFixer(new DataConverterTrappedChest(schema69, false));
        Schema schema70 = builder.addSchema(1800, DataConverterSchemaV1800::new);
        builder.addFixer(new DataConverterAddChoices(schema70, "Added 1.14 mobs fix", DataConverterTypes.q));
        builder.addFixer(DataConverterItemName.a(schema70, "Rename dye items", DataConverterRegistry.a(DataConverterDye.a)));
        Schema schema71 = builder.addSchema(1801, DataConverterSchemaV1801::new);
        builder.addFixer(new DataConverterAddChoices(schema71, "Added Illager Beast", DataConverterTypes.q));
        Schema schema72 = builder.addSchema(1802, c);
        builder.addFixer(DataConverterBlockRename.a(schema72, "Rename sign blocks & stone slabs", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        builder.addFixer(DataConverterItemName.a(schema72, "Rename sign item & stone slabs", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema schema73 = builder.addSchema(1803, c);
        builder.addFixer(new DataConverterItemLoreComponentize(schema73, false));
        Schema schema74 = builder.addSchema(1904, DataConverterSchemaV1904::new);
        builder.addFixer(new DataConverterAddChoices(schema74, "Added Cats", DataConverterTypes.q));
        builder.addFixer(new DataConverterEntityCatSplit(schema74, false));
        Schema schema75 = builder.addSchema(1905, c);
        builder.addFixer(new DataConverterChunkStatus(schema75, false));
        Schema schema76 = builder.addSchema(1906, DataConverterSchemaV1906::new);
        builder.addFixer(new DataConverterAddChoices(schema76, "Add POI Blocks", DataConverterTypes.l));
        Schema schema77 = builder.addSchema(1909, DataConverterSchemaV1909::new);
        builder.addFixer(new DataConverterAddChoices(schema77, "Add jigsaw", DataConverterTypes.l));
        Schema schema78 = builder.addSchema(1911, c);
        builder.addFixer(new DataConverterChunkStatus2(schema78, false));
        Schema schema79 = builder.addSchema(1914, c);
        builder.addFixer(new WeaponSmithChestLootTableFix(schema79, false));
        Schema schema80 = builder.addSchema(1917, c);
        builder.addFixer(new DataConverterCatType(schema80, false));
        Schema schema81 = builder.addSchema(1918, c);
        builder.addFixer(new DataConverterVillagerProfession(schema81, "minecraft:villager"));
        builder.addFixer(new DataConverterVillagerProfession(schema81, "minecraft:zombie_villager"));
        Schema schema82 = builder.addSchema(1920, DataConverterSchemaV1920::new);
        builder.addFixer(new DataConverterNewVillage(schema82, false));
        builder.addFixer(new DataConverterAddChoices(schema82, "Add campfire", DataConverterTypes.l));
        Schema schema83 = builder.addSchema(1925, c);
        builder.addFixer(new DataConverterMapId(schema83, false));
        Schema schema84 = builder.addSchema(1928, DataConverterSchemaV1928::new);
        builder.addFixer(new DataConverterEntityRavagerRename(schema84, true));
        builder.addFixer(DataConverterItemName.a(schema84, "Rename ravager egg item", DataConverterRegistry.a(DataConverterEntityRavagerRename.a)));
        Schema schema85 = builder.addSchema(1929, DataConverterSchemaV1929::new);
        builder.addFixer(new DataConverterAddChoices(schema85, "Add Wandering Trader and Trader Llama", DataConverterTypes.q));
        Schema schema86 = builder.addSchema(1931, DataConverterSchemaV1931::new);
        builder.addFixer(new DataConverterAddChoices(schema86, "Added Fox", DataConverterTypes.q));
        Schema schema87 = builder.addSchema(1936, c);
        builder.addFixer(new DataConverterOptionsAddTextBackground(schema87, false));
        Schema schema88 = builder.addSchema(1946, c);
        builder.addFixer(new DataConverterPOI(schema88, false));
        Schema schema89 = builder.addSchema(1948, c);
        builder.addFixer(new DataConverterOminousBannerRename(schema89));
        Schema schema90 = builder.addSchema(1953, c);
        builder.addFixer(new DataConverterOminousBannerBlockEntityRename(schema90, false));
        Schema schema91 = builder.addSchema(1955, c);
        builder.addFixer(new DataConverterVillagerLevelXp(schema91, false));
        builder.addFixer(new DataConverterZombieVillagerLevelXp(schema91, false));
        Schema schema92 = builder.addSchema(1961, c);
        builder.addFixer(new DataConverterChunkLightRemove(schema92, false));
        Schema schema93 = builder.addSchema(1963, c);
        builder.addFixer(new DataConverterRemoveGolemGossip(schema93, false));
        Schema schema94 = builder.addSchema(2100, DataConverterSchemaV2100::new);
        builder.addFixer(new DataConverterAddChoices(schema94, "Added Bee and Bee Stinger", DataConverterTypes.q));
        builder.addFixer(new DataConverterAddChoices(schema94, "Add beehive", DataConverterTypes.l));
        builder.addFixer(new DataConverterRecipeBase(schema94, false, "Rename sugar recipe", DataConverterRegistry.a("minecraft:sugar", "sugar_from_sugar_cane")));
        builder.addFixer(new DataConverterAdvancementBase(schema94, false, "Rename sugar recipe advancement", DataConverterRegistry.a("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema schema95 = builder.addSchema(2202, c);
        builder.addFixer(new DataConverterLeavesBiome(schema95, false));
        Schema schema96 = builder.addSchema(2209, c);
        UnaryOperator<String> unaryoperator = DataConverterRegistry.a("minecraft:bee_hive", "minecraft:beehive");
        builder.addFixer(DataConverterItemName.a(schema96, "Rename bee_hive item to beehive", unaryoperator));
        builder.addFixer(new PoiTypeRenameFix(schema96, "Rename bee_hive poi to beehive", unaryoperator));
        builder.addFixer(DataConverterBlockRename.a(schema96, "Rename bee_hive block to beehive", unaryoperator));
        Schema schema97 = builder.addSchema(2211, c);
        builder.addFixer(new DataConverterStructureReference(schema97, false));
        Schema schema98 = builder.addSchema(2218, c);
        builder.addFixer(new DataConverterPOIRebuild(schema98, false));
        Schema schema99 = builder.addSchema(2501, DataConverterSchemaV2501::new);
        builder.addFixer(new DataConverterFurnaceRecipesUsed(schema99, true));
        Schema schema100 = builder.addSchema(2502, DataConverterSchemaV2502::new);
        builder.addFixer(new DataConverterAddChoices(schema100, "Added Hoglin", DataConverterTypes.q));
        Schema schema101 = builder.addSchema(2503, c);
        builder.addFixer(new DataConverterWallProperty(schema101, false));
        builder.addFixer(new DataConverterAdvancementBase(schema101, false, "Composter category change", DataConverterRegistry.a("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema schema102 = builder.addSchema(2505, DataConverterSchemaV2505::new);
        builder.addFixer(new DataConverterAddChoices(schema102, "Added Piglin", DataConverterTypes.q));
        builder.addFixer(new DataConverterMemoryExpiry(schema102, "minecraft:villager"));
        Schema schema103 = builder.addSchema(2508, c);
        builder.addFixer(DataConverterItemName.a(schema103, "Renamed fungi items to fungus", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        builder.addFixer(DataConverterBlockRename.a(schema103, "Renamed fungi blocks to fungus", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema schema104 = builder.addSchema(2509, DataConverterSchemaV2509::new);
        builder.addFixer(new DataConverterEntityZombifiedPiglinRename(schema104));
        builder.addFixer(DataConverterItemName.a(schema104, "Rename zombie pigman egg item", DataConverterRegistry.a(DataConverterEntityZombifiedPiglinRename.a)));
        Schema schema105 = builder.addSchema(2511, c);
        builder.addFixer(new DataConverterEntityProjectileOwner(schema105));
        Schema schema106 = builder.addSchema(2514, c);
        builder.addFixer(new DataConverterEntityUUID(schema106));
        builder.addFixer(new DataConverterBlockEntityUUID(schema106));
        builder.addFixer(new DataConverterPlayerUUID(schema106));
        builder.addFixer(new DataConverterMiscUUID(schema106));
        builder.addFixer(new DataConverterSavedDataUUID(schema106));
        builder.addFixer(new DataConverterItemStackUUID(schema106));
        Schema schema107 = builder.addSchema(2516, c);
        builder.addFixer(new DataConverterGossip(schema107, "minecraft:villager"));
        builder.addFixer(new DataConverterGossip(schema107, "minecraft:zombie_villager"));
        Schema schema108 = builder.addSchema(2518, c);
        builder.addFixer(new DataConverterJigsawProperties(schema108, false));
        builder.addFixer(new DataConverterJigsawRotation(schema108, false));
        Schema schema109 = builder.addSchema(2519, DataConverterSchemaV2519::new);
        builder.addFixer(new DataConverterAddChoices(schema109, "Added Strider", DataConverterTypes.q));
        Schema schema110 = builder.addSchema(2522, DataConverterSchemaV2522::new);
        builder.addFixer(new DataConverterAddChoices(schema110, "Added Zoglin", DataConverterTypes.q));
        Schema schema111 = builder.addSchema(2523, c);
        builder.addFixer(new DataConverterAttributes(schema111));
        Schema schema112 = builder.addSchema(2527, c);
        builder.addFixer(new DataConverterBitStorageAlign(schema112));
        Schema schema113 = builder.addSchema(2528, c);
        builder.addFixer(DataConverterItemName.a(schema113, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        builder.addFixer(DataConverterBlockRename.a(schema113, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema schema114 = builder.addSchema(2529, c);
        builder.addFixer(new DataConverterStriderGravity(schema114, false));
        Schema schema115 = builder.addSchema(2531, c);
        builder.addFixer(new DataConverterRedstoneConnections(schema115));
        Schema schema116 = builder.addSchema(2533, c);
        builder.addFixer(new DataConverterVillagerFollowRange(schema116));
        Schema schema117 = builder.addSchema(2535, c);
        builder.addFixer(new DataConverterEntityShulkerRotation(schema117));
        Schema schema118 = builder.addSchema(2550, c);
        builder.addFixer(new DataConverterWorldGenSettingsBuilding(schema118));
        Schema schema119 = builder.addSchema(2551, DataConverterSchemaV2551::new);
        builder.addFixer(new DataConverterShoulderEntity(schema119, "add types to WorldGenData", DataConverterTypes.A));
        Schema schema120 = builder.addSchema(2552, c);
        builder.addFixer(new DataConverterBiomeBase(schema120, false, "Nether biome rename", (Map<String, String>)ImmutableMap.of((Object)"minecraft:nether", (Object)"minecraft:nether_wastes")));
        Schema schema121 = builder.addSchema(2553, c);
        builder.addFixer(new DataConverterBiome(schema121, false));
        Schema schema122 = builder.addSchema(2558, c);
        builder.addFixer(new DataConverterMissingDimension(schema122, false));
        builder.addFixer(new DataConverterSettingRename(schema122, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema schema123 = builder.addSchema(2568, DataConverterSchemaV2568::new);
        builder.addFixer(new DataConverterAddChoices(schema123, "Added Piglin Brute", DataConverterTypes.q));
        Schema schema124 = builder.addSchema(2571, V2571::new);
        builder.addFixer(new DataConverterAddChoices(schema124, "Added Goat", DataConverterTypes.q));
        Schema schema125 = builder.addSchema(2679, c);
        builder.addFixer(new CauldronRenameFix(schema125, false));
        Schema schema126 = builder.addSchema(2680, c);
        builder.addFixer(DataConverterItemName.a(schema126, "Renamed grass path item to dirt path", DataConverterRegistry.a("minecraft:grass_path", "minecraft:dirt_path")));
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema126, "Renamed grass path block to dirt path", DataConverterRegistry.a("minecraft:grass_path", "minecraft:dirt_path")));
        Schema schema127 = builder.addSchema(2684, V2684::new);
        builder.addFixer(new DataConverterAddChoices(schema127, "Added Sculk Sensor", DataConverterTypes.l));
        Schema schema128 = builder.addSchema(2686, V2686::new);
        builder.addFixer(new DataConverterAddChoices(schema128, "Added Axolotl", DataConverterTypes.q));
        Schema schema129 = builder.addSchema(2688, V2688::new);
        builder.addFixer(new DataConverterAddChoices(schema129, "Added Glow Squid", DataConverterTypes.q));
        builder.addFixer(new DataConverterAddChoices(schema129, "Added Glow Item Frame", DataConverterTypes.q));
        Schema schema130 = builder.addSchema(2690, c);
        ImmutableMap immutablemap = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        builder.addFixer(DataConverterItemName.a(schema130, "Renamed copper block items to new oxidized terms", DataConverterRegistry.a((Map<String, String>)immutablemap)));
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema130, "Renamed copper blocks to new oxidized terms", DataConverterRegistry.a((Map<String, String>)immutablemap)));
        Schema schema131 = builder.addSchema(2691, c);
        ImmutableMap immutablemap1 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        builder.addFixer(DataConverterItemName.a(schema131, "Rename copper item suffixes", DataConverterRegistry.a((Map<String, String>)immutablemap1)));
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema131, "Rename copper blocks suffixes", DataConverterRegistry.a((Map<String, String>)immutablemap1)));
        Schema schema132 = builder.addSchema(2693, c);
        builder.addFixer(new AddFlagIfNotPresentFix(schema132, DataConverterTypes.A, "has_increased_height_already", false));
        Schema schema133 = builder.addSchema(2696, c);
        ImmutableMap immutablemap2 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        builder.addFixer(DataConverterItemName.a(schema133, "Renamed grimstone block items to deepslate", DataConverterRegistry.a((Map<String, String>)immutablemap2)));
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema133, "Renamed grimstone blocks to deepslate", DataConverterRegistry.a((Map<String, String>)immutablemap2)));
        Schema schema134 = builder.addSchema(2700, c);
        builder.addFixer(BlockRenameFixWithJigsaw.b(schema134, "Renamed cave vines blocks", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema schema135 = builder.addSchema(2701, c);
        builder.addFixer(new SavedDataFeaturePoolElementFix(schema135));
        Schema schema136 = builder.addSchema(2702, c);
        builder.addFixer(new AbstractArrowPickupFix(schema136));
        Schema schema137 = builder.addSchema(2704, V2704::new);
        builder.addFixer(new DataConverterAddChoices(schema137, "Added Goat", DataConverterTypes.q));
        Schema schema138 = builder.addSchema(2707, V2707::new);
        builder.addFixer(new DataConverterAddChoices(schema138, "Added Marker", DataConverterTypes.q));
        builder.addFixer(new AddFlagIfNotPresentFix(schema138, DataConverterTypes.A, "has_increased_height_already", true));
        Schema schema139 = builder.addSchema(2710, c);
        builder.addFixer(new StatsRenameFix(schema139, "Renamed play_one_minute stat to play_time", (Map<String, String>)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema schema140 = builder.addSchema(2717, c);
        builder.addFixer(DataConverterItemName.a(schema140, "Rename azalea_leaves_flowers", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        builder.addFixer(DataConverterBlockRename.a(schema140, "Rename azalea_leaves_flowers items", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema schema141 = builder.addSchema(2825, c);
        builder.addFixer(new AddFlagIfNotPresentFix(schema141, DataConverterTypes.A, "has_increased_height_already", false));
        Schema schema142 = builder.addSchema(2831, V2831::new);
        builder.addFixer(new SpawnerDataFix(schema142));
        Schema schema143 = builder.addSchema(2832, V2832::new);
        builder.addFixer(new WorldGenSettingsHeightAndBiomeFix(schema143));
        builder.addFixer(new ChunkHeightAndBiomeFix(schema143));
        Schema schema144 = builder.addSchema(2833, c);
        builder.addFixer(new WorldGenSettingsDisallowOldCustomWorldsFix(schema144));
        Schema schema145 = builder.addSchema(2838, c);
        builder.addFixer(new DataConverterBiomeBase(schema145, false, "Caves and Cliffs biome renames", (Map<String, String>)CavesAndCliffsRenames.a));
        Schema schema146 = builder.addSchema(2841, c);
        builder.addFixer(new ChunkProtoTickListFix(schema146));
        Schema schema147 = builder.addSchema(2842, V2842::new);
        builder.addFixer(new ChunkRenamesFix(schema147));
        Schema schema148 = builder.addSchema(2843, c);
        builder.addFixer(new OverreachingTickFix(schema148));
        builder.addFixer(new DataConverterBiomeBase(schema148, false, "Remove Deep Warm Ocean", Map.of("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema schema149 = builder.addSchema(2846, c);
        builder.addFixer(new DataConverterAdvancementBase(schema149, false, "Rename some C&C part 2 advancements", DataConverterRegistry.a((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema schema150 = builder.addSchema(2852, c);
        builder.addFixer(new WorldGenSettingsDisallowOldCustomWorldsFix(schema150));
        Schema schema151 = builder.addSchema(2967, c);
        builder.addFixer(new StructureSettingsFlattenFix(schema151));
        Schema schema152 = builder.addSchema(2970, c);
        builder.addFixer(new StructuresBecomeConfiguredFix(schema152));
        Schema schema153 = builder.addSchema(3076, V3076::new);
        builder.addFixer(new DataConverterAddChoices(schema153, "Added Sculk Catalyst", DataConverterTypes.l));
        Schema schema154 = builder.addSchema(3077, c);
        builder.addFixer(new ChunkDeleteIgnoredLightDataFix(schema154));
        Schema schema155 = builder.addSchema(3078, V3078::new);
        builder.addFixer(new DataConverterAddChoices(schema155, "Added Frog", DataConverterTypes.q));
        builder.addFixer(new DataConverterAddChoices(schema155, "Added Tadpole", DataConverterTypes.q));
        builder.addFixer(new DataConverterAddChoices(schema155, "Added Sculk Shrieker", DataConverterTypes.l));
        Schema schema156 = builder.addSchema(3081, V3081::new);
        builder.addFixer(new DataConverterAddChoices(schema156, "Added Warden", DataConverterTypes.q));
        Schema schema157 = builder.addSchema(3082, V3082::new);
        builder.addFixer(new DataConverterAddChoices(schema157, "Added Chest Boat", DataConverterTypes.q));
        Schema schema158 = builder.addSchema(3083, V3083::new);
        builder.addFixer(new DataConverterAddChoices(schema158, "Added Allay", DataConverterTypes.q));
        Schema schema159 = builder.addSchema(3084, c);
        builder.addFixer(new SimpleRenameFix(schema159, DataConverterTypes.t, (Map<String, String>)ImmutableMap.builder().put((Object)"minecraft:block_press", (Object)"minecraft:block_activate").put((Object)"minecraft:block_switch", (Object)"minecraft:block_activate").put((Object)"minecraft:block_unpress", (Object)"minecraft:block_deactivate").put((Object)"minecraft:block_unswitch", (Object)"minecraft:block_deactivate").put((Object)"minecraft:drinking_finish", (Object)"minecraft:drink").put((Object)"minecraft:elytra_free_fall", (Object)"minecraft:elytra_glide").put((Object)"minecraft:entity_damaged", (Object)"minecraft:entity_damage").put((Object)"minecraft:entity_dying", (Object)"minecraft:entity_die").put((Object)"minecraft:entity_killed", (Object)"minecraft:entity_die").put((Object)"minecraft:mob_interact", (Object)"minecraft:entity_interact").put((Object)"minecraft:ravager_roar", (Object)"minecraft:entity_roar").put((Object)"minecraft:ring_bell", (Object)"minecraft:block_change").put((Object)"minecraft:shulker_close", (Object)"minecraft:container_close").put((Object)"minecraft:shulker_open", (Object)"minecraft:container_open").put((Object)"minecraft:wolf_shaking", (Object)"minecraft:entity_shake").build()));
        Schema schema160 = builder.addSchema(3086, c);
        DSL.TypeReference typereference = DataConverterTypes.q;
        Int2ObjectOpenHashMap int2objectopenhashmap = SystemUtils.a(new Int2ObjectOpenHashMap(), (T int2objectopenhashmap1) -> {
            int2objectopenhashmap1.defaultReturnValue((Object)"minecraft:tabby");
            int2objectopenhashmap1.put(0, (Object)"minecraft:tabby");
            int2objectopenhashmap1.put(1, (Object)"minecraft:black");
            int2objectopenhashmap1.put(2, (Object)"minecraft:red");
            int2objectopenhashmap1.put(3, (Object)"minecraft:siamese");
            int2objectopenhashmap1.put(4, (Object)"minecraft:british");
            int2objectopenhashmap1.put(5, (Object)"minecraft:calico");
            int2objectopenhashmap1.put(6, (Object)"minecraft:persian");
            int2objectopenhashmap1.put(7, (Object)"minecraft:ragdoll");
            int2objectopenhashmap1.put(8, (Object)"minecraft:white");
            int2objectopenhashmap1.put(9, (Object)"minecraft:jellie");
            int2objectopenhashmap1.put(10, (Object)"minecraft:all_black");
        });
        Objects.requireNonNull(int2objectopenhashmap);
        builder.addFixer(new EntityVariantFix(schema160, "Change cat variant type", typereference, "minecraft:cat", "CatType", arg_0 -> ((Int2ObjectOpenHashMap)int2objectopenhashmap).get(arg_0)));
        ImmutableMap immutablemap3 = ImmutableMap.builder().put((Object)"textures/entity/cat/tabby.png", (Object)"minecraft:tabby").put((Object)"textures/entity/cat/black.png", (Object)"minecraft:black").put((Object)"textures/entity/cat/red.png", (Object)"minecraft:red").put((Object)"textures/entity/cat/siamese.png", (Object)"minecraft:siamese").put((Object)"textures/entity/cat/british_shorthair.png", (Object)"minecraft:british").put((Object)"textures/entity/cat/calico.png", (Object)"minecraft:calico").put((Object)"textures/entity/cat/persian.png", (Object)"minecraft:persian").put((Object)"textures/entity/cat/ragdoll.png", (Object)"minecraft:ragdoll").put((Object)"textures/entity/cat/white.png", (Object)"minecraft:white").put((Object)"textures/entity/cat/jellie.png", (Object)"minecraft:jellie").put((Object)"textures/entity/cat/all_black.png", (Object)"minecraft:all_black").build();
        builder.addFixer(new CriteriaRenameFix(schema160, "Migrate cat variant advancement", "minecraft:husbandry/complete_catalogue", s2 -> (String)immutablemap3.getOrDefault(s2, s2)));
        Schema schema161 = builder.addSchema(3087, c);
        typereference = DataConverterTypes.q;
        int2objectopenhashmap = SystemUtils.a(new Int2ObjectOpenHashMap(), (T int2objectopenhashmap1) -> {
            int2objectopenhashmap1.put(0, (Object)"minecraft:temperate");
            int2objectopenhashmap1.put(1, (Object)"minecraft:warm");
            int2objectopenhashmap1.put(2, (Object)"minecraft:cold");
        });
        Objects.requireNonNull(int2objectopenhashmap);
        builder.addFixer(new EntityVariantFix(schema161, "Change frog variant type", typereference, "minecraft:frog", "Variant", arg_0 -> ((Int2ObjectOpenHashMap)int2objectopenhashmap).get(arg_0)));
        Schema schema162 = builder.addSchema(3088, c);
        builder.addFixer(new BlendingDataFix(schema162));
        Schema schema163 = builder.addSchema(3090, c);
        builder.addFixer(new EntityPaintingFieldsRenameFix(schema163));
        Schema schema164 = builder.addSchema(3093, c);
        builder.addFixer(new EntityGoatMissingStateFix(schema164));
        Schema schema165 = builder.addSchema(3094, c);
        builder.addFixer(new GoatHornIdFix(schema165));
        Schema schema166 = builder.addSchema(3097, c);
        builder.addFixer(new FilteredBooksFix(schema166));
        builder.addFixer(new FilteredSignsFix(schema166));
        Map<String, String> map = Map.of("minecraft:british", "minecraft:british_shorthair");
        builder.addFixer(new VariantRenameFix(schema166, "Rename british shorthair", DataConverterTypes.q, "minecraft:cat", map));
        builder.addFixer(new CriteriaRenameFix(schema166, "Migrate cat variant advancement for british shorthair", "minecraft:husbandry/complete_catalogue", s2 -> map.getOrDefault(s2, (String)s2)));
        Set<String> set = Set.of("minecraft:unemployed", "minecraft:nitwit");
        Objects.requireNonNull(set);
        builder.addFixer(new PoiTypeRemoveFix(schema166, "Remove unpopulated villager PoI types", set::contains));
        Schema schema167 = builder.addSchema(3108, c);
        builder.addFixer(new BlendingDataRemoveFromNetherEndFix(schema167));
        Schema schema168 = builder.addSchema(3201, c);
        builder.addFixer(new OptionsProgrammerArtFix(schema168));
        Schema schema169 = builder.addSchema(3202, V3202::new);
        builder.addFixer(new DataConverterAddChoices(schema169, "Added Hanging Sign", DataConverterTypes.l));
        Schema schema170 = builder.addSchema(3203, V3203::new);
        builder.addFixer(new DataConverterAddChoices(schema170, "Added Camel", DataConverterTypes.q));
        Schema schema171 = builder.addSchema(3204, V3204::new);
        builder.addFixer(new DataConverterAddChoices(schema171, "Added Chiseled Bookshelf", DataConverterTypes.l));
        Schema schema172 = builder.addSchema(3209, c);
        builder.addFixer(new DataConverterFlattenSpawnEgg(schema172, false, "minecraft:pig_spawn_egg"));
        Schema schema173 = builder.addSchema(3214, c);
        builder.addFixer(new OptionsAmbientOcclusionFix(schema173));
        Schema schema174 = builder.addSchema(3319, c);
        builder.addFixer(new OptionsAccessibilityOnboardFix(schema174));
        Schema schema175 = builder.addSchema(3322, c);
        builder.addFixer(new EffectDurationFix(schema175));
        Schema schema176 = builder.addSchema(3325, V3325::new);
        builder.addFixer(new DataConverterAddChoices(schema176, "Added displays", DataConverterTypes.q));
        Schema schema177 = builder.addSchema(3326, V3326::new);
        builder.addFixer(new DataConverterAddChoices(schema177, "Added Sniffer", DataConverterTypes.q));
        Schema schema178 = builder.addSchema(3327, V3327::new);
        builder.addFixer(new DataConverterAddChoices(schema178, "Archaeology", DataConverterTypes.l));
        Schema schema179 = builder.addSchema(3328, V3328::new);
        builder.addFixer(new DataConverterAddChoices(schema179, "Added interaction", DataConverterTypes.q));
    }

    private static UnaryOperator<String> a(Map<String, String> replacements) {
        return s2 -> replacements.getOrDefault(s2, (String)s2);
    }

    private static UnaryOperator<String> a(String old, String current) {
        return s2 -> Objects.equals(s2, old) ? current : s2;
    }
}

