/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterLeavesBiome
extends DataFix {
    public DataConverterLeavesBiome(Schema schema, boolean bl) {
        super(schema, bl);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        return this.fixTypeEverywhereTyped("Leaves fix", type, typed2 -> typed2.updateTyped(opticFinder, typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("Biomes").asIntStreamOpt().result();
            if (optional.isEmpty()) {
                return dynamic;
            }
            int[] is = ((IntStream)optional.get()).toArray();
            if (is.length != 256) {
                return dynamic;
            }
            int[] js = new int[1024];
            for (int i2 = 0; i2 < 4; ++i2) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    int k2 = (j2 << 2) + 2;
                    int l2 = (i2 << 2) + 2;
                    int m2 = l2 << 4 | k2;
                    js[i2 << 2 | j2] = is[m2];
                }
            }
            for (int n2 = 1; n2 < 64; ++n2) {
                System.arraycopy(js, 0, js, n2 * 16, 16);
            }
            return dynamic.set("Biomes", dynamic.createIntList(Arrays.stream(js)));
        })));
    }
}

