/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class SimpleRenameFix
extends DataFix {
    private final String a;
    private final Map<String, String> b;
    private final DSL.TypeReference c;

    public SimpleRenameFix(Schema schema, DSL.TypeReference typeReference, Map<String, String> renames) {
        this(schema, typeReference, typeReference.typeName() + "-renames at version: " + schema.getVersionKey(), renames);
    }

    public SimpleRenameFix(Schema schema, DSL.TypeReference typeReference, String name, Map<String, String> renames) {
        super(schema, false);
        this.b = renames;
        this.a = name;
        this.c = typeReference;
    }

    protected TypeRewriteRule makeRule() {
        Type type = DSL.named((String)this.c.typeName(), DataConverterSchemaNamed.a());
        if (!Objects.equals(type, this.getInputSchema().getType(this.c))) {
            throw new IllegalStateException("\"" + this.c.typeName() + "\" type is not what was expected.");
        }
        return this.fixTypeEverywhere(this.a, type, dynamicOps -> pair -> pair.mapSecond(string -> this.b.getOrDefault(string, (String)string)));
    }
}

