/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import java.util.Map;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class StatsRenameFix
extends DataFix {
    private final String a;
    private final Map<String, String> b;

    public StatsRenameFix(Schema outputSchema, String name, Map<String, String> replacements) {
        super(outputSchema, false);
        this.a = name;
        this.b = replacements;
    }

    protected TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.b(), (TypeRewriteRule)this.a());
    }

    private TypeRewriteRule a() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.w);
        Type type2 = this.getInputSchema().getType(DataConverterTypes.w);
        OpticFinder opticFinder = type2.findField("CriteriaType");
        TaggedChoice.TaggedChoiceType taggedChoiceType = (TaggedChoice.TaggedChoiceType)opticFinder.type().findChoiceType("type", -1).orElseThrow(() -> new IllegalStateException("Can't find choice type for criteria"));
        Type type3 = (Type)taggedChoiceType.types().get("minecraft:custom");
        if (type3 == null) {
            throw new IllegalStateException("Failed to find custom criterion type variant");
        }
        OpticFinder opticFinder2 = DSL.namedChoice((String)"minecraft:custom", (Type)type3);
        OpticFinder opticFinder3 = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.a());
        return this.fixTypeEverywhereTyped(this.a, type2, type, typed -> typed.updateTyped(opticFinder, typed2 -> typed2.updateTyped(opticFinder2, typed -> typed.update(opticFinder3, old -> this.b.getOrDefault(old, (String)old)))));
    }

    private TypeRewriteRule b() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.g);
        Type type2 = this.getInputSchema().getType(DataConverterTypes.g);
        OpticFinder opticFinder = type2.findField("stats");
        OpticFinder opticFinder2 = opticFinder.type().findField("minecraft:custom");
        OpticFinder opticFinder3 = DataConverterSchemaNamed.a().finder();
        return this.fixTypeEverywhereTyped(this.a, type2, type, typed -> typed.updateTyped(opticFinder, typed2 -> typed2.updateTyped(opticFinder2, typed -> typed.update(opticFinder3, old -> this.b.getOrDefault(old, (String)old)))));
    }
}

