/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.NetworkPacketSummary;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import net.minecraft.util.profiling.jfr.stats.TimedStatSummary;
import net.minecraft.world.level.chunk.ChunkStatus;

public class JfrResultJsonSerializer {
    private static final String b = "bytesPerSecond";
    private static final String c = "count";
    private static final String d = "durationNanosTotal";
    private static final String e = "totalBytes";
    private static final String f = "countPerSecond";
    final Gson a = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).create();

    public String a(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("startedEpoch", (Number)profile.c().toEpochMilli());
        jsonObject.addProperty("endedEpoch", (Number)profile.d().toEpochMilli());
        jsonObject.addProperty("durationMs", (Number)profile.e().toMillis());
        Duration duration = profile.f();
        if (duration != null) {
            jsonObject.addProperty("worldGenDurationMs", (Number)duration.toMillis());
        }
        jsonObject.add("heap", this.a(profile.i()));
        jsonObject.add("cpuPercent", this.c(profile.h()));
        jsonObject.add("network", this.c(profile));
        jsonObject.add("fileIO", this.b(profile));
        jsonObject.add("serverTick", this.b(profile.g()));
        jsonObject.add("threadAllocation", this.a(profile.j()));
        jsonObject.add("chunkGen", this.a(profile.a()));
        return this.a.toJson((JsonElement)jsonObject);
    }

    private JsonElement a(GcHeapStat.a statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("allocationRateBytesPerSecond", (Number)statistics.e());
        jsonObject.addProperty("gcCount", (Number)statistics.d());
        jsonObject.addProperty("gcOverHeadPercent", (Number)Float.valueOf(statistics.a()));
        jsonObject.addProperty("gcTotalDurationMs", (Number)statistics.c().toMillis());
        return jsonObject;
    }

    private JsonElement a(List<Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>>> statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(d, (Number)statistics.stream().mapToDouble(pair -> ((TimedStatSummary)pair.getSecond()).f().toNanos()).sum());
        JsonArray jsonArray = SystemUtils.a(new JsonArray(), (T json) -> jsonObject.add("status", (JsonElement)json));
        for (Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>> pair2 : statistics) {
            TimedStatSummary timedStatSummary = (TimedStatSummary)pair2.getSecond();
            JsonObject jsonObject2 = SystemUtils.a(new JsonObject(), arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            jsonObject2.addProperty("state", ((ChunkStatus)pair2.getFirst()).d());
            jsonObject2.addProperty(c, (Number)timedStatSummary.d());
            jsonObject2.addProperty(d, (Number)timedStatSummary.f().toNanos());
            jsonObject2.addProperty("durationNanosAvg", (Number)(timedStatSummary.f().toNanos() / (long)timedStatSummary.d()));
            JsonObject jsonObject3 = SystemUtils.a(new JsonObject(), (T json) -> jsonObject2.add("durationNanosPercentiles", (JsonElement)json));
            timedStatSummary.e().forEach((quantile, value) -> jsonObject3.addProperty("p" + quantile, (Number)value));
            Function<ChunkGenStat, JsonElement> function = sample -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("durationNanos", (Number)sample.a().toNanos());
                jsonObject.addProperty("level", sample.e());
                jsonObject.addProperty("chunkPosX", (Number)sample.b().e);
                jsonObject.addProperty("chunkPosZ", (Number)sample.b().f);
                jsonObject.addProperty("worldPosX", (Number)sample.c().c());
                jsonObject.addProperty("worldPosZ", (Number)sample.c().d());
                return jsonObject;
            };
            jsonObject2.add("fastest", function.apply((ChunkGenStat)timedStatSummary.a()));
            jsonObject2.add("slowest", function.apply((ChunkGenStat)timedStatSummary.b()));
            jsonObject2.add("secondSlowest", (JsonElement)(timedStatSummary.c() != null ? function.apply((ChunkGenStat)timedStatSummary.c()) : JsonNull.INSTANCE));
        }
        return jsonObject;
    }

    private JsonElement a(ThreadAllocationStat.a statistics) {
        JsonArray jsonArray = new JsonArray();
        statistics.a().forEach((threadName, allocation) -> jsonArray.add((JsonElement)SystemUtils.a(new JsonObject(), (T json) -> {
            json.addProperty("thread", threadName);
            json.addProperty(b, (Number)allocation);
        })));
        return jsonArray;
    }

    private JsonElement b(List<TickTimeStat> samples) {
        if (samples.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        double[] ds = samples.stream().mapToDouble(sample -> (double)sample.b().toNanos() / 1000000.0).toArray();
        DoubleSummaryStatistics doubleSummaryStatistics = DoubleStream.of(ds).summaryStatistics();
        jsonObject.addProperty("minMs", (Number)doubleSummaryStatistics.getMin());
        jsonObject.addProperty("averageMs", (Number)doubleSummaryStatistics.getAverage());
        jsonObject.addProperty("maxMs", (Number)doubleSummaryStatistics.getMax());
        Map<Integer, Double> map = Percentiles.a(ds);
        map.forEach((quantile, value) -> jsonObject.addProperty("p" + quantile, (Number)value));
        return jsonObject;
    }

    private JsonElement b(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("write", this.a(profile.m()));
        jsonObject.add("read", this.a(profile.n()));
        return jsonObject;
    }

    private JsonElement a(FileIOStat.a statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(e, (Number)statistics.a());
        jsonObject.addProperty(c, (Number)statistics.c());
        jsonObject.addProperty(b, (Number)statistics.b());
        jsonObject.addProperty(f, (Number)statistics.d());
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("topContributors", (JsonElement)jsonArray);
        statistics.f().forEach(pair -> {
            JsonObject jsonObject = new JsonObject();
            jsonArray.add((JsonElement)jsonObject);
            jsonObject.addProperty("path", (String)pair.getFirst());
            jsonObject.addProperty(e, (Number)pair.getSecond());
        });
        return jsonObject;
    }

    private JsonElement c(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("sent", this.a(profile.l()));
        jsonObject.add("received", this.a(profile.k()));
        return jsonObject;
    }

    private JsonElement a(NetworkPacketSummary statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(e, (Number)statistics.d());
        jsonObject.addProperty(c, (Number)statistics.c());
        jsonObject.addProperty(b, (Number)statistics.b());
        jsonObject.addProperty(f, (Number)statistics.a());
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("topContributors", (JsonElement)jsonArray);
        statistics.e().forEach(pair -> {
            JsonObject jsonObject = new JsonObject();
            jsonArray.add((JsonElement)jsonObject);
            NetworkPacketSummary.b packetIdentification = (NetworkPacketSummary.b)pair.getFirst();
            NetworkPacketSummary.a packetCountAndSize = (NetworkPacketSummary.a)pair.getSecond();
            jsonObject.addProperty("protocolId", (Number)packetIdentification.c());
            jsonObject.addProperty("packetId", (Number)packetIdentification.d());
            jsonObject.addProperty("packetName", packetIdentification.a());
            jsonObject.addProperty(e, (Number)packetCountAndSize.b());
            jsonObject.addProperty(c, (Number)packetCountAndSize.a());
        });
        return jsonObject;
    }

    private JsonElement c(List<CpuLoadStat> samples2) {
        JsonObject jsonObject = new JsonObject();
        BiFunction<List, ToDoubleFunction, JsonObject> biFunction = (samples, valueGetter) -> {
            JsonObject jsonObject = new JsonObject();
            DoubleSummaryStatistics doubleSummaryStatistics = samples.stream().mapToDouble(valueGetter).summaryStatistics();
            jsonObject.addProperty("min", (Number)doubleSummaryStatistics.getMin());
            jsonObject.addProperty("average", (Number)doubleSummaryStatistics.getAverage());
            jsonObject.addProperty("max", (Number)doubleSummaryStatistics.getMax());
            return jsonObject;
        };
        jsonObject.add("jvm", (JsonElement)biFunction.apply(samples2, CpuLoadStat::a));
        jsonObject.add("userJvm", (JsonElement)biFunction.apply(samples2, CpuLoadStat::b));
        jsonObject.add("system", (JsonElement)biFunction.apply(samples2, CpuLoadStat::c));
        return jsonObject;
    }
}

