/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.Mailbox;
import org.slf4j.Logger;

public abstract class IAsyncTaskHandler<R extends Runnable>
implements ProfilerMeasured,
Mailbox<R>,
Executor {
    private final String b;
    private static final Logger c = LogUtils.getLogger();
    private final Queue<R> d = Queues.newConcurrentLinkedQueue();
    private int e;

    protected IAsyncTaskHandler(String name) {
        this.b = name;
        MetricsRegistry.a.a(this);
    }

    protected abstract R f(Runnable var1);

    protected abstract boolean e(R var1);

    public boolean bn() {
        return Thread.currentThread() == this.au();
    }

    protected abstract Thread au();

    protected boolean at() {
        return !this.bn();
    }

    public int bo() {
        return this.d.size();
    }

    @Override
    public String bp() {
        return this.b;
    }

    public <V> CompletableFuture<V> a(Supplier<V> task) {
        return this.at() ? CompletableFuture.supplyAsync(task, this) : CompletableFuture.completedFuture(task.get());
    }

    private CompletableFuture<Void> a(Runnable runnable) {
        return CompletableFuture.supplyAsync(() -> {
            runnable.run();
            return null;
        }, this);
    }

    public CompletableFuture<Void> g(Runnable task) {
        if (this.at()) {
            return this.a(task);
        }
        task.run();
        return CompletableFuture.completedFuture(null);
    }

    public void h(Runnable runnable) {
        if (!this.bn()) {
            this.a(runnable).join();
        } else {
            runnable.run();
        }
    }

    public void scheduleOnMain(Runnable r0) {
        this.i(this.f(r0));
    }

    public void i(R runnable) {
        this.d.add(runnable);
        LockSupport.unpark(this.au());
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.at()) {
            this.i(this.f(runnable));
        } else {
            runnable.run();
        }
    }

    public void c(Runnable runnable) {
        this.execute(runnable);
    }

    protected void bq() {
        this.d.clear();
    }

    protected void br() {
        while (this.x()) {
        }
    }

    public boolean x() {
        Runnable runnable = (Runnable)this.d.peek();
        if (runnable == null) {
            return false;
        }
        if (this.e == 0 && !this.e(runnable)) {
            return false;
        }
        this.d((Runnable)this.d.remove());
        return true;
    }

    public void c(BooleanSupplier stopCondition) {
        ++this.e;
        try {
            while (!stopCondition.getAsBoolean()) {
                if (this.x()) continue;
                this.bs();
            }
        }
        finally {
            --this.e;
        }
    }

    protected void bs() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void d(R task) {
        try {
            task.run();
        }
        catch (Exception var3) {
            if (var3.getCause() instanceof ThreadDeath) {
                throw var3;
            }
            c.error(LogUtils.FATAL_MARKER, "Error executing task on {}", (Object)this.bp(), (Object)var3);
        }
    }

    @Override
    public List<MetricSampler> bm() {
        return ImmutableList.of((Object)MetricSampler.a(this.b + "-pending-tasks", MetricCategory.b, this::bo));
    }
}

