/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import org.slf4j.Logger;

public class MobEffect
implements Comparable<MobEffect> {
    private static final Logger b = LogUtils.getLogger();
    public static final int a = -1;
    private final MobEffectList c;
    private int d;
    private int e;
    private boolean f;
    private boolean g;
    private boolean h;
    @Nullable
    private MobEffect i;
    private final Optional<a> j;

    public MobEffect(MobEffectList type) {
        this(type, 0, 0);
    }

    public MobEffect(MobEffectList type, int duration) {
        this(type, duration, 0);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier) {
        this(type, duration, amplifier, false, true);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean visible) {
        this(type, duration, amplifier, ambient, visible, visible);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon) {
        this(type, duration, amplifier, ambient, showParticles, showIcon, null, type.b());
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon, @Nullable MobEffect hiddenEffect, Optional<a> factorCalculationData) {
        this.c = type;
        this.d = duration;
        this.e = amplifier;
        this.f = ambient;
        this.g = showParticles;
        this.h = showIcon;
        this.i = hiddenEffect;
        this.j = factorCalculationData;
    }

    public MobEffect(MobEffect instance) {
        this.c = instance.c;
        this.j = this.c.b();
        this.a(instance);
    }

    public Optional<a> a() {
        return this.j;
    }

    void a(MobEffect that) {
        this.d = that.d;
        this.e = that.e;
        this.f = that.f;
        this.g = that.g;
        this.h = that.h;
    }

    public boolean b(MobEffect that) {
        if (this.c != that.c) {
            b.warn("This method should only be called for matching effects!");
        }
        int i2 = this.d;
        boolean bl = false;
        if (that.e > this.e) {
            if (that.d(this)) {
                MobEffect mobEffectInstance = this.i;
                this.i = new MobEffect(this);
                this.i.i = mobEffectInstance;
            }
            this.e = that.e;
            this.d = that.d;
            bl = true;
        } else if (this.d(that)) {
            if (that.e == this.e) {
                this.d = that.d;
                bl = true;
            } else if (this.i == null) {
                this.i = new MobEffect(that);
            } else {
                this.i.b(that);
            }
        }
        if (!that.f && this.f || bl) {
            this.f = that.f;
            bl = true;
        }
        if (that.g != this.g) {
            this.g = that.g;
            bl = true;
        }
        if (that.h != this.h) {
            this.h = that.h;
            bl = true;
        }
        return bl;
    }

    private boolean d(MobEffect effect) {
        return !this.b() && (this.d < effect.d || effect.b());
    }

    public boolean b() {
        return this.d == -1;
    }

    public boolean a(int duration) {
        return !this.b() && this.d <= duration;
    }

    public int a(Int2IntFunction mapper) {
        return !this.b() && this.d != 0 ? mapper.applyAsInt(this.d) : this.d;
    }

    public MobEffectList c() {
        return this.c;
    }

    public int d() {
        return this.d;
    }

    public int e() {
        return this.e;
    }

    public boolean f() {
        return this.f;
    }

    public boolean g() {
        return this.g;
    }

    public boolean h() {
        return this.h;
    }

    public boolean a(EntityLiving entity, Runnable overwriteCallback) {
        if (this.j()) {
            int i2;
            int n2 = i2 = this.b() ? entity.ag : this.d;
            if (this.c.a(i2, this.e)) {
                this.a(entity);
            }
            this.k();
            if (this.d == 0 && this.i != null) {
                this.a(this.i);
                this.i = this.i.i;
                overwriteCallback.run();
            }
        }
        this.j.ifPresent(factorCalculationData -> factorCalculationData.a(this));
        return this.j();
    }

    private boolean j() {
        return this.b() || this.d > 0;
    }

    private int k() {
        if (this.i != null) {
            this.i.k();
        }
        this.d = this.a(duration -> duration - 1);
        return this.d;
    }

    public void a(EntityLiving entity) {
        if (this.j()) {
            this.c.a(entity, this.e);
        }
    }

    public String i() {
        return this.c.d();
    }

    public String toString() {
        String string = this.e > 0 ? this.i() + " x " + (this.e + 1) + ", Duration: " + this.l() : this.i() + ", Duration: " + this.l();
        if (!this.g) {
            string = string + ", Particles: false";
        }
        if (!this.h) {
            string = string + ", Show Icon: false";
        }
        return string;
    }

    private String l() {
        return this.b() ? "infinite" : Integer.toString(this.d);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MobEffect)) {
            return false;
        }
        MobEffect mobEffectInstance = (MobEffect)object;
        return this.d == mobEffectInstance.d && this.e == mobEffectInstance.e && this.f == mobEffectInstance.f && this.c.equals(mobEffectInstance.c);
    }

    public int hashCode() {
        int i2 = this.c.hashCode();
        i2 = 31 * i2 + this.d;
        i2 = 31 * i2 + this.e;
        return 31 * i2 + (this.f ? 1 : 0);
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        nbt.a("Id", MobEffectList.a(this.c()));
        this.c(nbt);
        return nbt;
    }

    private void c(NBTTagCompound nbt) {
        nbt.a("Amplifier", (byte)this.e());
        nbt.a("Duration", this.d());
        nbt.a("Ambient", this.f());
        nbt.a("ShowParticles", this.g());
        nbt.a("ShowIcon", this.h());
        if (this.i != null) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            this.i.a(compoundTag);
            nbt.a("HiddenEffect", compoundTag);
        }
        this.j.ifPresent(factorCalculationData -> net.minecraft.world.effect.MobEffect$a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, factorCalculationData).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)).ifPresent(factorCalculationDataNbt -> nbt.a("FactorCalculationData", (NBTBase)factorCalculationDataNbt)));
    }

    @Nullable
    public static MobEffect b(NBTTagCompound nbt) {
        int i2 = nbt.h("Id");
        MobEffectList mobEffect = MobEffectList.a(i2);
        return mobEffect == null ? null : MobEffect.a(mobEffect, nbt);
    }

    private static MobEffect a(MobEffectList type, NBTTagCompound nbt) {
        int i2 = Byte.toUnsignedInt(nbt.f("Amplifier"));
        int j2 = nbt.h("Duration");
        boolean bl = nbt.q("Ambient");
        boolean bl2 = true;
        if (nbt.b("ShowParticles", 1)) {
            bl2 = nbt.q("ShowParticles");
        }
        boolean bl3 = bl2;
        if (nbt.b("ShowIcon", 1)) {
            bl3 = nbt.q("ShowIcon");
        }
        MobEffect mobEffectInstance = null;
        if (nbt.b("HiddenEffect", 10)) {
            mobEffectInstance = MobEffect.a(type, nbt.p("HiddenEffect"));
        }
        Optional optional = nbt.b("FactorCalculationData", 10) ? net.minecraft.world.effect.MobEffect$a.a.parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p("FactorCalculationData"))).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)) : Optional.empty();
        return new MobEffect(type, j2, Math.max(i2, 0), bl, bl2, bl3, mobEffectInstance, optional);
    }

    public int c(MobEffect mobEffectInstance) {
        int i2 = 32147;
        return !(this.d() > 32147 && mobEffectInstance.d() > 32147 || this.f() && mobEffectInstance.f()) ? ComparisonChain.start().compareFalseFirst(this.f(), mobEffectInstance.f()).compareFalseFirst(this.b(), mobEffectInstance.b()).compare(this.d(), mobEffectInstance.d()).compare(this.c().g(), mobEffectInstance.c().g()).result() : ComparisonChain.start().compare(Boolean.valueOf(this.f()), Boolean.valueOf(mobEffectInstance.f())).compare(this.c().g(), mobEffectInstance.c().g()).result();
    }

    public static class a {
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.h.fieldOf("padding_duration").forGetter(data -> data.b), (App)Codec.FLOAT.fieldOf("factor_start").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.c)), (App)Codec.FLOAT.fieldOf("factor_target").orElse((Object)Float.valueOf(1.0f)).forGetter(data -> Float.valueOf(data.d)), (App)Codec.FLOAT.fieldOf("factor_current").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.e)), (App)ExtraCodecs.h.fieldOf("ticks_active").orElse((Object)0).forGetter(data -> data.f), (App)Codec.FLOAT.fieldOf("factor_previous_frame").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.g)), (App)Codec.BOOL.fieldOf("had_effect_last_tick").orElse((Object)false).forGetter(data -> data.h)).apply((Applicative)instance, a::new));
        private final int b;
        private float c;
        private float d;
        private float e;
        private int f;
        private float g;
        private boolean h;

        public a(int paddingDuration, float factorStart, float factorTarget, float factorCurrent, int effectChangedTimestamp, float factorPreviousFrame, boolean hadEffectLastTick) {
            this.b = paddingDuration;
            this.c = factorStart;
            this.d = factorTarget;
            this.e = factorCurrent;
            this.f = effectChangedTimestamp;
            this.g = factorPreviousFrame;
            this.h = hadEffectLastTick;
        }

        public a(int paddingDuration) {
            this(paddingDuration, 0.0f, 1.0f, 0.0f, 0, 0.0f, false);
        }

        public void a(MobEffect effect) {
            this.g = this.e;
            boolean bl = !effect.a(this.b);
            ++this.f;
            if (this.h != bl) {
                this.h = bl;
                this.f = 0;
                this.c = this.e;
                this.d = bl ? 1.0f : 0.0f;
            }
            float f2 = MathHelper.a((float)this.f / (float)this.b, 0.0f, 1.0f);
            this.e = MathHelper.i(f2, this.c, this.d);
        }

        public float a(EntityLiving entity, float tickDelta) {
            if (entity.dB()) {
                this.g = this.e;
            }
            return MathHelper.i(tickDelta, this.g, this.e);
        }
    }
}

