/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.FormattedString;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger o = LogUtils.getLogger();
    private static final float p = Float.POSITIVE_INFINITY;
    public static final int b = -1;
    private static final DataWatcherObject<Integer> q = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> r = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Vector3f> s = DataWatcher.a(Display.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Vector3f> t = DataWatcher.a(Display.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Quaternionf> u = DataWatcher.a(Display.class, DataWatcherRegistry.B);
    private static final DataWatcherObject<Quaternionf> aC = DataWatcher.a(Display.class, DataWatcherRegistry.B);
    private static final DataWatcherObject<Byte> aD = DataWatcher.a(Display.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> aE = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> aF = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aG = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aH = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aI = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aJ = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> aK = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final float aL = 0.0f;
    private static final float aM = 1.0f;
    private static final int aN = -1;
    public static final String c = "interpolation_duration";
    public static final String d = "start_interpolation";
    public static final String e = "transformation";
    public static final String f = "billboard";
    public static final String g = "brightness";
    public static final String h = "view_range";
    public static final String i = "shadow_radius";
    public static final String j = "shadow_strength";
    public static final String k = "width";
    public static final String l = "height";
    public static final String m = "glow_color_override";
    private final GenericInterpolator<Transformation> aO = new GenericInterpolator<Transformation>(Transformation.a()){

        @Override
        protected Transformation a(float delta, Transformation start, Transformation end) {
            return start.a(end, delta);
        }
    };
    private final FloatInterpolator aP = new FloatInterpolator(0.0f);
    private final FloatInterpolator aQ = new FloatInterpolator(1.0f);
    private final Quaternionf aR = new Quaternionf();
    protected final InterpolatorSet n = new InterpolatorSet();
    private long aS;
    private float aT;
    private AxisAlignedBB aU;
    private boolean aV;
    private boolean aW;

    public Display(EntityTypes<?> type, World world) {
        super(type, world);
        this.ae = true;
        this.as = true;
        this.aU = this.cD();
        this.n.a(Set.of(s, u, t, aC), (float value, DataWatcher dataTracker) -> this.aO.a(value, Display.a(dataTracker)));
        this.n.a(aH, this.aQ);
        this.n.a(aG, this.aP);
    }

    @Override
    public void a(List<DataWatcher.b<?>> dataEntries) {
        super.a(dataEntries);
        boolean bl = false;
        for (DataWatcher.b<?> dataValue : dataEntries) {
            bl |= this.n.a(dataValue.a());
        }
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = this.ag <= 0;
            if (bl2) {
                this.n.a(Float.POSITIVE_INFINITY, this.am);
            } else {
                this.aV = true;
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (aJ.equals(data) || aI.equals(data)) {
            this.y();
        }
        if (q.equals(data)) {
            this.aW = true;
        }
    }

    public static Transformation a(DataWatcher dataTracker) {
        Vector3f vector3f = dataTracker.a(s);
        Quaternionf quaternionf = dataTracker.a(u);
        Vector3f vector3f2 = dataTracker.a(t);
        Quaternionf quaternionf2 = dataTracker.a(aC);
        return new Transformation(vector3f, quaternionf, vector3f2, quaternionf2);
    }

    @Override
    public void l() {
        Entity entity = this.cV();
        if (entity != null && entity.dB()) {
            this.bz();
        }
        if (this.H.B) {
            if (this.aW) {
                this.aW = false;
                int i2 = this.getInterpolationDelay_();
                this.aS = this.ag + i2;
            }
            if (this.aV) {
                this.aV = false;
                this.n.a(this.aT, this.am);
            }
        }
    }

    @Override
    protected void a_() {
        this.am.a(q, 0);
        this.am.a(r, 0);
        this.am.a(s, new Vector3f());
        this.am.a(t, new Vector3f(1.0f, 1.0f, 1.0f));
        this.am.a(aC, new Quaternionf());
        this.am.a(u, new Quaternionf());
        this.am.a(aD, BillboardConstraints.a.a());
        this.am.a(aE, -1);
        this.am.a(aF, Float.valueOf(1.0f));
        this.am.a(aG, Float.valueOf(0.0f));
        this.am.a(aH, Float.valueOf(1.0f));
        this.am.a(aI, Float.valueOf(0.0f));
        this.am.a(aJ, Float.valueOf(0.0f));
        this.am.a(aK, -1);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.e(e)) {
            Transformation.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(e)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((Transformation)pair.getFirst()));
        }
        if (nbt.b(c, 99)) {
            int i2 = nbt.h(c);
            this.setInterpolationDuration_(i2);
        }
        if (nbt.b(d, 99)) {
            int j2 = nbt.h(d);
            this.setInterpolationDelay_(j2);
        }
        if (nbt.b(f, 8)) {
            BillboardConstraints.e.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(f)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((BillboardConstraints)pair.getFirst()));
        }
        if (nbt.b(h, 99)) {
            this.g(nbt.j(h));
        }
        if (nbt.b(i, 99)) {
            this.h(nbt.j(i));
        }
        if (nbt.b(j, 99)) {
            this.w(nbt.j(j));
        }
        if (nbt.b(k, 99)) {
            this.x(nbt.j(k));
        }
        if (nbt.b(l, 99)) {
            this.y(nbt.j(l));
        }
        if (nbt.b(m, 99)) {
            this.d(nbt.h(m));
        }
        if (nbt.b(g, 10)) {
            Brightness.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(g)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((Brightness)pair.getFirst()));
        } else {
            this.a((Brightness)null);
        }
    }

    public void a(Transformation transformation) {
        this.am.b(s, transformation.d());
        this.am.b(u, transformation.e());
        this.am.b(t, transformation.f());
        this.am.b(aC, transformation.g());
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        Transformation.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)Display.a(this.am)).result().ifPresent(transformations -> nbt.a(e, (NBTBase)transformations));
        BillboardConstraints.e.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.j()).result().ifPresent(billboard -> nbt.a(f, (NBTBase)billboard));
        nbt.a(c, this.o());
        nbt.a(h, this.r());
        nbt.a(i, this.s());
        nbt.a(j, this.t());
        nbt.a(k, this.v());
        nbt.a(l, this.x());
        nbt.a(m, this.w());
        Brightness brightness = this.q();
        if (brightness != null) {
            Brightness.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)brightness).result().ifPresent(brightnessx -> nbt.a(g, (NBTBase)brightnessx));
        }
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    @Override
    public AxisAlignedBB A_() {
        return this.aU;
    }

    @Override
    public EnumPistonReaction C_() {
        return EnumPistonReaction.d;
    }

    public Quaternionf i() {
        return this.aR;
    }

    public Transformation a(float delta) {
        return this.aO.a(delta);
    }

    public void setInterpolationDuration_(int interpolationDuration) {
        this.am.b(r, interpolationDuration);
    }

    public int o() {
        return this.am.a(r);
    }

    public void setInterpolationDelay_(int startInterpolation) {
        this.am.a(q, startInterpolation, true);
    }

    public int getInterpolationDelay_() {
        return this.am.a(q);
    }

    public void a(BillboardConstraints billboardMode) {
        this.am.b(aD, billboardMode.a());
    }

    public BillboardConstraints j() {
        return BillboardConstraints.f.apply(this.am.a(aD).byteValue());
    }

    public void a(@Nullable Brightness brightness) {
        this.am.b(aE, brightness != null ? brightness.a() : -1);
    }

    @Nullable
    public Brightness q() {
        int i2 = this.am.a(aE);
        return i2 != -1 ? Brightness.a(i2) : null;
    }

    public int k() {
        return this.am.a(aE);
    }

    public void g(float viewRange) {
        this.am.b(aF, Float.valueOf(viewRange));
    }

    public float r() {
        return this.am.a(aF).floatValue();
    }

    public void h(float shadowRadius) {
        this.am.b(aG, Float.valueOf(shadowRadius));
    }

    public float s() {
        return this.am.a(aG).floatValue();
    }

    public float b(float delta) {
        return this.aP.a(delta);
    }

    public void w(float shadowStrength) {
        this.am.b(aH, Float.valueOf(shadowStrength));
    }

    public float t() {
        return this.am.a(aH).floatValue();
    }

    public float c(float delta) {
        return this.aQ.a(delta);
    }

    public void x(float width) {
        this.am.b(aI, Float.valueOf(width));
    }

    public float v() {
        return this.am.a(aI).floatValue();
    }

    public void y(float height) {
        this.am.b(aJ, Float.valueOf(height));
    }

    public int w() {
        return this.am.a(aK);
    }

    public void d(int glowColorOverride) {
        this.am.b(aK, glowColorOverride);
    }

    public float d(float delta) {
        float h2;
        int i2 = this.o();
        if (i2 <= 0) {
            return 1.0f;
        }
        float f2 = (long)this.ag - this.aS;
        float g2 = f2 + delta;
        this.aT = h2 = MathHelper.a(MathHelper.g(g2, 0.0f, i2), 0.0f, 1.0f);
        return h2;
    }

    public float x() {
        return this.am.a(aJ).floatValue();
    }

    @Override
    public void e(double x2, double y2, double z2) {
        super.e(x2, y2, z2);
        this.y();
    }

    private void y() {
        float f2 = this.v();
        float g2 = this.x();
        if (f2 != 0.0f && g2 != 0.0f) {
            this.as = false;
            float h2 = f2 / 2.0f;
            double d2 = this.dl();
            double e2 = this.dn();
            double i2 = this.dr();
            this.aU = new AxisAlignedBB(d2 - (double)h2, e2, i2 - (double)h2, d2 + (double)h2, e2 + (double)g2, i2 + (double)h2);
        } else {
            this.as = true;
        }
    }

    @Override
    public void e(float pitch) {
        super.e(pitch);
        this.z();
    }

    @Override
    public void f(float yaw) {
        super.f(yaw);
        this.z();
    }

    private void z() {
        this.aR.rotationYXZ((float)(-Math.PI) / 180 * this.dw(), (float)Math.PI / 180 * this.dy(), 0.0f);
    }

    @Override
    public boolean a(double distance) {
        return distance < MathHelper.k((double)this.r() * 64.0 * Display.cw());
    }

    @Override
    public int B_() {
        int i2 = this.w();
        return i2 != -1 ? i2 : super.B_();
    }

    static abstract class GenericInterpolator<T>
    extends Interpolator<T> {
        protected GenericInterpolator(T value) {
            super(value);
        }

        protected abstract T a(float var1, T var2, T var3);

        public T a(float delta) {
            return !((double)delta >= 1.0) && this.b != null ? this.a(delta, this.b, this.c) : this.c;
        }

        @Override
        protected T c(float value) {
            return this.a(value);
        }
    }

    static class FloatInterpolator
    extends Interpolator<Float> {
        protected FloatInterpolator(float value) {
            super(Float.valueOf(value));
        }

        protected float a(float delta, float start, float end) {
            return MathHelper.i(delta, start, end);
        }

        public float a(float delta) {
            return !((double)delta >= 1.0) && this.b != null ? this.a(delta, ((Float)this.b).floatValue(), ((Float)this.c).floatValue()) : ((Float)this.c).floatValue();
        }

        protected Float b(float f2) {
            return Float.valueOf(this.a(f2));
        }
    }

    static class InterpolatorSet {
        private final IntSet a = new IntOpenHashSet();
        private final List<IntepolatorUpdater> b = new ArrayList<IntepolatorUpdater>();

        InterpolatorSet() {
        }

        protected <T> void a(DataWatcherObject<T> data, Interpolator<T> interpolator) {
            this.a.add(data.a());
            this.b.add((value, dataTracker) -> interpolator.a(value, dataTracker.a(data)));
        }

        protected void a(Set<DataWatcherObject<?>> dataSet, IntepolatorUpdater updater) {
            for (DataWatcherObject<?> entityDataAccessor : dataSet) {
                this.a.add(entityDataAccessor.a());
            }
            this.b.add(updater);
        }

        public boolean a(int id) {
            return this.a.contains(id);
        }

        public void a(float value, DataWatcher dataTracker) {
            for (IntepolatorUpdater intepolatorUpdater : this.b) {
                intepolatorUpdater.update(value, dataTracker);
            }
        }
    }

    @FunctionalInterface
    static interface IntepolatorUpdater {
        public void update(float var1, DataWatcher var2);
    }

    static abstract class Interpolator<T> {
        @Nullable
        protected T b;
        protected T c;

        protected Interpolator(T value) {
            this.c = value;
        }

        protected abstract T c(float var1);

        public void a(float prevValue, T value) {
            if (prevValue != Float.POSITIVE_INFINITY) {
                this.b = this.c(prevValue);
            }
            this.c = value;
        }
    }

    public static final class BillboardConstraints
    extends Enum<BillboardConstraints>
    implements INamable {
        public static final /* enum */ BillboardConstraints a = new BillboardConstraints(0, "fixed");
        public static final /* enum */ BillboardConstraints b = new BillboardConstraints(1, "vertical");
        public static final /* enum */ BillboardConstraints c = new BillboardConstraints(2, "horizontal");
        public static final /* enum */ BillboardConstraints d = new BillboardConstraints(3, "center");
        public static final Codec<BillboardConstraints> e;
        public static final IntFunction<BillboardConstraints> f;
        private final byte g;
        private final String h;
        private static final /* synthetic */ BillboardConstraints[] i;

        public static BillboardConstraints[] values() {
            return (BillboardConstraints[])i.clone();
        }

        public static BillboardConstraints valueOf(String name) {
            return Enum.valueOf(BillboardConstraints.class, name);
        }

        private BillboardConstraints(byte index, String name) {
            this.h = name;
            this.g = index;
        }

        @Override
        public String c() {
            return this.h;
        }

        byte a() {
            return this.g;
        }

        private static /* synthetic */ BillboardConstraints[] b() {
            return new BillboardConstraints[]{a, b, c, d};
        }

        static {
            i = BillboardConstraints.b();
            e = INamable.a(BillboardConstraints::values);
            f = ByIdMap.a(BillboardConstraints::a, BillboardConstraints.values(), ByIdMap.a.a);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String o = "text";
        private static final String aC = "line_width";
        private static final String aD = "text_opacity";
        private static final String aE = "background";
        private static final String aF = "shadow";
        private static final String aG = "see_through";
        private static final String aH = "default_background";
        private static final String aI = "alignment";
        public static final byte p = 1;
        public static final byte q = 2;
        public static final byte r = 4;
        public static final byte s = 8;
        public static final byte t = 16;
        private static final byte aJ = -1;
        public static final int u = 0x40000000;
        private static final DataWatcherObject<IChatBaseComponent> aK = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.f);
        private static final DataWatcherObject<Integer> aL = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        private static final DataWatcherObject<Integer> aM = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        private static final DataWatcherObject<Byte> aN = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final DataWatcherObject<Byte> aO = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private final IntInterpolator aP = new IntInterpolator(-1);
        private final IntInterpolator aQ = new ColorInterpolator(0x40000000);
        @Nullable
        private CachedInfo aR;

        public TextDisplay(EntityTypes<?> type, World world) {
            super(type, world);
            this.n.a(aM, this.aQ);
            this.n.a(Set.of(aN), (float value, DataWatcher dataTracker) -> this.aP.a(value, dataTracker.a(aN) & 0xFF));
        }

        @Override
        protected void a_() {
            super.a_();
            this.am.a(aK, IChatBaseComponent.h());
            this.am.a(aL, 200);
            this.am.a(aM, 0x40000000);
            this.am.a(aN, (byte)-1);
            this.am.a(aO, (byte)0);
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            this.aR = null;
        }

        public IChatBaseComponent o() {
            return this.am.a(aK);
        }

        public void c(IChatBaseComponent text) {
            this.am.b(aK, text);
        }

        public int p() {
            return this.am.a(aL);
        }

        public void b(int lineWidth) {
            this.am.b(aL, lineWidth);
        }

        public byte g(float delta) {
            return (byte)this.aP.a(delta);
        }

        public byte r() {
            return this.am.a(aN);
        }

        public void c(byte textOpacity) {
            this.am.b(aN, textOpacity);
        }

        public int h(float delta) {
            return this.aQ.a(delta);
        }

        public int s() {
            return this.am.a(aM);
        }

        public void c(int background) {
            this.am.b(aM, background);
        }

        public byte q() {
            return this.am.a(aO);
        }

        public void d(byte flags) {
            this.am.b(aO, flags);
        }

        private static byte a(byte flags, NBTTagCompound nbt, String nbtKey, byte flag) {
            return nbt.q(nbtKey) ? (byte)(flags | flag) : flags;
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            if (nbt.b(aC, 99)) {
                this.b(nbt.h(aC));
            }
            if (nbt.b(aD, 99)) {
                this.c(nbt.f(aD));
            }
            if (nbt.b(aE, 99)) {
                this.c(nbt.h(aE));
            }
            byte b2 = TextDisplay.a((byte)0, nbt, aF, (byte)1);
            b2 = TextDisplay.a(b2, nbt, aG, (byte)2);
            b2 = TextDisplay.a(b2, nbt, aH, (byte)4);
            Optional<Align> optional = Align.d.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(aI)).result().map(Pair::getFirst);
            if (optional.isPresent()) {
                b2 = switch (optional.get()) {
                    case Align.a -> b2;
                    case Align.b -> (byte)(b2 | 8);
                    case Align.c -> (byte)(b2 | 0x10);
                    default -> throw new IncompatibleClassChangeError();
                };
            }
            this.d(b2);
            if (nbt.b(o, 8)) {
                String string = nbt.l(o);
                try {
                    IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(string);
                    if (component != null) {
                        CommandListenerWrapper commandSourceStack = this.cZ().a(2);
                        IChatMutableComponent component2 = ChatComponentUtils.a(commandSourceStack, component, (Entity)this, 0);
                        this.c(component2);
                    } else {
                        this.c(IChatBaseComponent.h());
                    }
                }
                catch (Exception var8) {
                    o.warn("Failed to parse display entity text {}", (Object)string, (Object)var8);
                }
            }
        }

        private static void b(byte flags, NBTTagCompound nbt, String nbtKey, byte flag) {
            nbt.a(nbtKey, (flags & flag) != 0);
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(o, IChatBaseComponent.ChatSerializer.a(this.o()));
            nbt.a(aC, this.p());
            nbt.a(aE, this.s());
            nbt.a(aD, this.r());
            byte b2 = this.q();
            TextDisplay.b(b2, nbt, aF, (byte)1);
            TextDisplay.b(b2, nbt, aG, (byte)2);
            TextDisplay.b(b2, nbt, aH, (byte)4);
            Align.d.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)TextDisplay.a(b2)).result().ifPresent(tag -> nbt.a(aI, (NBTBase)tag));
        }

        public CachedInfo a(LineSplitter splitter) {
            if (this.aR == null) {
                int i2 = this.p();
                this.aR = splitter.split(this.o(), i2);
            }
            return this.aR;
        }

        public static Align a(byte flags) {
            if ((flags & 8) != 0) {
                return Align.b;
            }
            return (flags & 0x10) != 0 ? Align.c : Align.a;
        }

        public record CachedInfo(List<CachedLine> a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this, o2);
            }
        }

        public static final class Align
        extends Enum<Align>
        implements INamable {
            public static final /* enum */ Align a = new Align("center");
            public static final /* enum */ Align b = new Align("left");
            public static final /* enum */ Align c = new Align("right");
            public static final Codec<Align> d;
            private final String e;
            private static final /* synthetic */ Align[] f;

            public static Align[] values() {
                return (Align[])f.clone();
            }

            public static Align valueOf(String name) {
                return Enum.valueOf(Align.class, name);
            }

            private Align(String name) {
                this.e = name;
            }

            @Override
            public String c() {
                return this.e;
            }

            private static /* synthetic */ Align[] a() {
                return new Align[]{a, b, c};
            }

            static {
                f = Align.a();
                d = INamable.a(Align::values);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(IChatBaseComponent var1, int var2);
        }

        public record CachedLine(FormattedString a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this, o2);
            }
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String o = "item";
        private static final String p = "item_display";
        private static final DataWatcherObject<ItemStack> q = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.h);
        private static final DataWatcherObject<Byte> r = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.a);
        private final SlotAccess s = new SlotAccess(){

            @Override
            public ItemStack a() {
                return this.o();
            }

            @Override
            public boolean a(ItemStack stack) {
                this.a(stack);
                return true;
            }
        };

        public ItemDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a_() {
            super.a_();
            this.am.a(q, ItemStack.b);
            this.am.a(r, ItemDisplayContext.a.a());
        }

        public ItemStack o() {
            return this.am.a(q);
        }

        public void a(ItemStack stack) {
            this.am.b(q, stack);
        }

        public void a(ItemDisplayContext transformationMode) {
            this.am.b(r, transformationMode.a());
        }

        public ItemDisplayContext p() {
            return ItemDisplayContext.k.apply(this.am.a(r).byteValue());
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            this.a(ItemStack.a(nbt.p(o)));
            if (nbt.b(p, 8)) {
                ItemDisplayContext.j.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(p)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(mode -> this.a((ItemDisplayContext)mode.getFirst()));
            }
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(o, this.o().b(new NBTTagCompound()));
            ItemDisplayContext.j.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.p()).result().ifPresent(nbtx -> nbt.a(p, (NBTBase)nbtx));
        }

        @Override
        public SlotAccess a_(int mappedIndex) {
            return mappedIndex == 0 ? this.s : SlotAccess.b;
        }
    }

    static class IntInterpolator
    extends Interpolator<Integer> {
        protected IntInterpolator(int value) {
            super(value);
        }

        protected int a(float delta, int start, int end) {
            return MathHelper.a(delta, start, end);
        }

        public int a(float value) {
            return !((double)value >= 1.0) && this.b != null ? this.a(value, (Integer)this.b, (Integer)this.c) : ((Integer)this.c).intValue();
        }

        protected Integer b(float f2) {
            return this.a(f2);
        }
    }

    static class ColorInterpolator
    extends IntInterpolator {
        protected ColorInterpolator(int value) {
            super(value);
        }

        @Override
        protected int a(float delta, int start, int end) {
            return ColorUtil.b.a(delta, start, end);
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String o = "block_state";
        private static final DataWatcherObject<IBlockData> p = DataWatcher.a(BlockDisplay.class, DataWatcherRegistry.i);

        public BlockDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a_() {
            super.a_();
            this.am.a(p, Blocks.a.o());
        }

        public IBlockData o() {
            return this.am.a(p);
        }

        public void b(IBlockData state) {
            this.am.b(p, state);
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            this.b(GameProfileSerializer.a(this.H.a(Registries.e), nbt.p(o)));
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(o, GameProfileSerializer.a(this.o()));
        }
    }
}

