/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftVector;
import org.bukkit.craftbukkit.v1_19_R3.util.UnsafeList;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.TrackingRange;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;
import top.leavesmc.leaves.LeavesConfig;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements INamableTileEntity,
EntityAccess,
ICommandListener {
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public PaperLootableInventoryData lootableData;
    public boolean collisionLoadChunks = false;
    private CraftEntity bukkitEntity;
    @Nullable
    public PlayerChunkMap.EntityTracker tracker;
    @javax.annotation.Nullable
    public Throwable addedToWorldStack;
    private static final Logger c = LogUtils.getLogger();
    public static final String v = "id";
    public static final String w = "Passengers";
    private static final AtomicInteger d = new AtomicInteger();
    private static final List<ItemStack> e = Collections.emptyList();
    public static final int x = 60;
    public static final int y = 300;
    public static final int z = 1024;
    public static final double A = 0.5000001;
    public static final float B = 0.11111111f;
    public static final int C = 140;
    public static final int D = 40;
    private static final AxisAlignedBB k = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double l = 0.014;
    private static final double m = 0.007;
    private static final double n = 0.0023333333333333335;
    public static final String E = "UUID";
    private static double o = 1.0;
    private final EntityTypes<?> p;
    private int q;
    public boolean F;
    public ImmutableList<Entity> r;
    protected int G;
    @javax.annotation.Nullable
    private Entity s;
    public net.minecraft.world.level.World H;
    public double I;
    public double J;
    public double K;
    private Vec3D t;
    public BlockPosition u;
    private ChunkCoordIntPair aC;
    private Vec3D aD;
    private float aE;
    private float aF;
    public float L;
    public float M;
    private AxisAlignedBB aG;
    public boolean N;
    public boolean O;
    public boolean P;
    public boolean Q;
    public boolean R;
    public boolean S;
    protected Vec3D T;
    @javax.annotation.Nullable
    private RemovalReason aH;
    public static final float U = 0.6f;
    public static final float V = 1.8f;
    public float W;
    public float X;
    public float Y;
    public float Z;
    public float aa;
    private float aI = 1.0f;
    public double ab;
    public double ac;
    public double ad;
    private float aJ;
    public boolean ae;
    protected final RandomSource af;
    public int ag;
    public int aK;
    public boolean ah;
    protected Object2DoubleMap<TagKey<FluidType>> ai;
    protected boolean aj;
    private final Set<TagKey<FluidType>> aL;
    public int ak;
    protected boolean al = true;
    protected final DataWatcher am;
    protected static final DataWatcherObject<Byte> an = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int ao = 0;
    private static final int aM = 1;
    private static final int aN = 3;
    private static final int aO = 4;
    private static final int aP = 5;
    protected static final int ap = 6;
    protected static final int aq = 7;
    private static final DataWatcherObject<Integer> aQ = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aR = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aS = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aT = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aU = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> ar = DataWatcher.a(Entity.class, DataWatcherRegistry.v);
    private static final DataWatcherObject<Integer> aV = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aW;
    private final VecDeltaCodec aX;
    public boolean as;
    public boolean at;
    public int aY;
    public boolean au;
    protected int av;
    protected BlockPosition aw;
    private boolean aZ;
    protected UUID ax;
    protected String ay;
    private boolean ba;
    private final Set<String> bb;
    private final double[] bc;
    private long bd;
    private EntitySize be;
    private float bf;
    public boolean az;
    public boolean aA;
    public boolean aB;
    private float bg;
    private int bh;
    public boolean bi;
    @javax.annotation.Nullable
    private IBlockData bj = null;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive = false;
    public boolean fromNetherPortal;
    protected int numCollisions = 0;
    public boolean spawnedViaMobSpawner;
    @javax.annotation.Nullable
    private Vector origin;
    @javax.annotation.Nullable
    private UUID originWorld;
    public boolean freezeLocked = false;
    public boolean collidingWithWorldBorder;
    private NBTTagCompound leavesData = new NBTTagCompound();
    private final boolean hardCollides = this instanceof EntityBoat || this instanceof EntityShulker || this instanceof EntityMinecartAbstract || this.shouldHardCollide();
    private static final Map<Class<? extends Entity>, Boolean> cachedOverrides = Collections.synchronizedMap(new WeakHashMap());
    public PlayerChunk.State chunkStatus;
    public int sectionX = Integer.MIN_VALUE;
    public int sectionY = Integer.MIN_VALUE;
    public int sectionZ = Integer.MIN_VALUE;
    public boolean updatingSectionStatus = false;
    final TrackingRange.TrackingRangeType trackingRangeType = TrackingRange.getTrackingRangeType(this);
    public boolean isLegacyTrackingEntity = false;
    public final Object posLock = new Object();
    private Vec3D moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.e("Bukkit.updateLevel") && tag.h("Bukkit.updateLevel") >= level;
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity(this.H.getCraftServer(), this);
        }
        return this.bukkitEntity;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.getBukkitEntity();
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public void setOrigin(@Nonnull Location location) {
        this.origin = location.toVector();
        this.originWorld = location.getWorld().getUID();
    }

    @javax.annotation.Nullable
    public Vector getOriginVector() {
        return this.origin != null ? this.origin.clone() : null;
    }

    @javax.annotation.Nullable
    public UUID getOriginWorld() {
        return this.originWorld;
    }

    public float getBukkitYaw() {
        return this.aE;
    }

    public boolean isChunkLoaded() {
        return this.H.b((int)Math.floor(this.dl()) >> 4, (int)Math.floor(this.dr()) >> 4);
    }

    public final AxisAlignedBB getBoundingBoxAt(double x2, double y2, double z2) {
        return this.be.a(x2, y2, z2);
    }

    protected boolean shouldHardCollide() {
        return false;
    }

    public final boolean hardCollides() {
        return this.hardCollides;
    }

    public final void setLegacyTrackingEntity(boolean isLegacyTrackingEntity) {
        this.isLegacyTrackingEntity = isLegacyTrackingEntity;
    }

    private TrackingRange.TrackingRangeType getFurthestEntity(Entity entity, PlayerChunkMap chunkMap, TrackingRange.TrackingRangeType type, int range) {
        List<Entity> passengers = entity.cM();
        int size = passengers.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Entity passenger = passengers.get(i2);
            TrackingRange.TrackingRangeType passengerType = passenger.trackingRangeType;
            int passengerRange = chunkMap.getEntityTrackerRange(passengerType.ordinal());
            if (passengerRange > range) {
                type = passengerType;
                range = passengerRange;
            }
            type = this.getFurthestEntity(passenger, chunkMap, type, range);
        }
        return type;
    }

    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> getPlayersInTrackRange() {
        if (this.r.isEmpty()) {
            return ((WorldServer)this.H).k().a.playerEntityTrackerTrackMaps[this.trackingRangeType.ordinal()].getObjectsInRange(MCUtil.getCoordinateKey(this));
        }
        PlayerChunkMap chunkMap = ((WorldServer)this.H).k().a;
        TrackingRange.TrackingRangeType type = this.trackingRangeType;
        int range = chunkMap.getEntityTrackerRange(type.ordinal());
        if (LeavesConfig.removeGetNearPlayerStreams) {
            type = this.getFurthestEntity(this, chunkMap, type, range);
        } else {
            Iterable<Entity> passengers = this.cQ();
            for (Entity passenger : passengers) {
                TrackingRange.TrackingRangeType passengerType = passenger.trackingRangeType;
                int passengerRange = chunkMap.getEntityTrackerRange(passengerType.ordinal());
                if (passengerRange <= range) continue;
                type = passengerType;
                range = passengerRange;
            }
        }
        return chunkMap.playerEntityTrackerTrackMaps[type.ordinal()].getObjectsInRange(MCUtil.getCoordinateKey(this));
    }

    public Entity(EntityTypes<?> type, net.minecraft.world.level.World world) {
        this.q = d.incrementAndGet();
        this.r = ImmutableList.of();
        this.aD = Vec3D.b;
        this.aG = k;
        this.T = Vec3D.b;
        this.af = LeavesConfig.useVanillaRandom ? RandomSource.a() : SHARED_RANDOM;
        this.aK = -this.cY();
        this.ai = new Object2DoubleArrayMap(2);
        this.aL = new HashSet<TagKey<FluidType>>();
        this.aW = EntityInLevelCallback.a;
        this.aX = new VecDeltaCodec();
        this.ax = MathHelper.a(this.af);
        this.ay = this.ax.toString();
        this.bb = Sets.newHashSet();
        this.bc = new double[]{0.0, 0.0, 0.0};
        this.p = type;
        this.H = world;
        this.be = type.n();
        this.t = Vec3D.b;
        this.u = BlockPosition.b;
        this.aC = ChunkCoordIntPair.b;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        this.am = new DataWatcher(this);
        this.am.a(an, (byte)0);
        this.am.a(aQ, this.cc());
        this.am.a(aS, false);
        this.am.a(aR, Optional.empty());
        this.am.a(aT, false);
        this.am.a(aU, false);
        this.am.a(ar, EntityPose.a);
        this.am.a(aV, 0);
        this.a_();
        this.aj().registrationLocked = true;
        this.e(0.0, 0.0, 0.0);
        this.bf = this.a(EntityPose.a, this.be);
    }

    public boolean a(BlockPosition pos, IBlockData state) {
        VoxelShape voxelshape = state.b((IBlockAccess)this.H, pos, VoxelShapeCollision.a(this));
        VoxelShape voxelshape1 = voxelshape.a((double)pos.u(), (double)pos.v(), (double)pos.w());
        return VoxelShapes.c(voxelshape1, VoxelShapes.a(this.cD()), OperatorBoolean.i);
    }

    public int B_() {
        ScoreboardTeamBase scoreboardteambase = this.cb();
        return scoreboardteambase != null && scoreboardteambase.n().f() != null ? scoreboardteambase.n().f() : 0xFFFFFF;
    }

    public boolean F_() {
        return false;
    }

    public final void ac() {
        if (this.bM()) {
            this.bx();
        }
        if (this.bL()) {
            this.bz();
        }
    }

    public void f(double x2, double y2, double z2) {
        this.aX.e(new Vec3D(x2, y2, z2));
    }

    public VecDeltaCodec ad() {
        return this.aX;
    }

    public EntityTypes<?> ae() {
        return this.p;
    }

    @Override
    public int af() {
        return this.q;
    }

    public void e(int id) {
        this.q = id;
    }

    public Set<String> ag() {
        return this.bb;
    }

    public boolean a(String tag) {
        return this.bb.size() >= 1024 ? false : this.bb.add(tag);
    }

    public boolean b(String tag) {
        return this.bb.remove(tag);
    }

    public void ah() {
        this.a(RemovalReason.a);
        this.a(GameEvent.q);
    }

    public final void ai() {
        this.a(RemovalReason.b);
    }

    protected abstract void a_();

    public DataWatcher aj() {
        return this.am;
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).q == this.q : false;
    }

    public int hashCode() {
        return this.q;
    }

    public void a(RemovalReason reason) {
        this.b(reason);
    }

    public void ak() {
    }

    public void b(EntityPose pose) {
        if (pose == this.al()) {
            return;
        }
        this.H.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[pose.ordinal()]));
        this.am.b(ar, pose);
    }

    public EntityPose al() {
        return this.am.a(ar);
    }

    public boolean c(EntityPose pose) {
        return this.al() == pose;
    }

    public boolean a(Entity entity, double radius) {
        return this.de().a((IPosition)entity.de(), radius);
    }

    public boolean a(Entity entity, double horizontalRadius, double verticalRadius) {
        double d2 = entity.dl() - this.dl();
        double d3 = entity.dn() - this.dn();
        double d4 = entity.dr() - this.dr();
        return MathHelper.e(d2, d4) < MathHelper.k(horizontalRadius) && MathHelper.k(d3) < MathHelper.k(verticalRadius);
    }

    public void a(float yaw, float pitch) {
        if (Float.isNaN(yaw)) {
            yaw = 0.0f;
        }
        if (yaw == Float.POSITIVE_INFINITY || yaw == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.H.getCraftServer().getLogger().warning(this.cu() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yaw = 0.0f;
        }
        if (Float.isNaN(pitch)) {
            pitch = 0.0f;
        }
        if (pitch == Float.POSITIVE_INFINITY || pitch == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.H.getCraftServer().getLogger().warning(this.cu() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            pitch = 0.0f;
        }
        this.f(yaw % 360.0f);
        this.e(pitch % 360.0f);
    }

    public final void a(Vec3D pos) {
        this.e(pos.a(), pos.b(), pos.c());
    }

    public void e(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, true);
    }

    protected AxisAlignedBB am() {
        return this.be.a(this.t);
    }

    protected void an() {
        this.e(this.t.c, this.t.d, this.t.e);
    }

    public void b(double cursorDeltaX, double cursorDeltaY) {
        float f2 = (float)cursorDeltaY * 0.15f;
        float f1 = (float)cursorDeltaX * 0.15f;
        this.e(this.dy() + f2);
        this.f(this.dw() + f1);
        this.e(MathHelper.a(this.dy(), -90.0f, 90.0f));
        this.M += f2;
        this.L += f1;
        this.M = MathHelper.a(this.M, -90.0f, 90.0f);
        if (this.s != null) {
            this.s.j(this);
        }
    }

    public void l() {
        this.ao();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer) && this.bq()) {
            this.bF();
        }
    }

    public void ao() {
        Entity entity;
        this.H.ac().a("entityBaseTick");
        if (this.al && (entity = this) instanceof IEntityAngerable) {
            IEntityAngerable neutralMob = (IEntityAngerable)((Object)entity);
            neutralMob.tickInitialPersistentAnger(this.H);
        }
        this.bj = null;
        if (this.bL() && this.cV().dB()) {
            this.bz();
        }
        if (this.G > 0) {
            --this.G;
        }
        this.W = this.X;
        this.M = this.dy();
        this.L = this.dw();
        if (this instanceof EntityPlayer) {
            this.bF();
        }
        if (this.be()) {
            this.bf();
        }
        this.aA = this.az;
        this.az = false;
        this.aZ();
        this.o();
        this.aY();
        if (this.H.B) {
            this.av();
        } else if (this.aK > 0) {
            if (this.aS()) {
                this.g(this.aK - 4);
                if (this.aK < 0) {
                    this.av();
                }
            } else {
                if (this.aK % 20 == 0 && !this.bg()) {
                    this.a(this.dG().c(), 1.0f);
                }
                this.g(this.aK - 1);
            }
            if (this.ce() > 0 && !this.freezeLocked) {
                this.j(0);
                this.H.a((EntityHuman)null, 1009, this.u, 1);
            }
        }
        if (this.bg()) {
            this.at();
            this.aa *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.ap();
        if (!this.H.B) {
            this.a_(this.aK > 0);
        }
        this.al = false;
        this.H.ac().c();
    }

    public void a_(boolean onFire) {
        this.b(0, onFire || this.bi);
    }

    public void ap() {
        block3: {
            block2: {
                if (this.dn() < (double)(this.H.v_() - 64)) break block2;
                if (this.H.getWorld().getEnvironment() != World.Environment.NETHER || !this.H.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> this.dn() >= (double)v2)) break block3;
                Entity entity = this;
                if (!(entity instanceof EntityHuman)) break block2;
                EntityHuman player = (EntityHuman)entity;
                if (player.fK().a) break block3;
            }
            this.aw();
        }
    }

    public void aq() {
        this.aY = this.bG();
    }

    public boolean ar() {
        return this.aY > 0;
    }

    protected void H() {
        if (this.ar()) {
            --this.aY;
        }
    }

    public int as() {
        return 0;
    }

    public void at() {
        if (!this.aS()) {
            if (this instanceof EntityLiving && this.aK <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.H, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.H.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.setSecondsOnFire(combustEvent.getDuration(), false);
                }
            } else {
                this.setSecondsOnFire(15, false);
            }
            CraftBlock craftBlock = CraftEventFactory.blockDamage = this.lastLavaContact == null ? null : CraftBlock.at(this.H, this.lastLavaContact);
            if (this.a(this.dG().d(), 4.0f)) {
                this.a(SoundEffects.iK, 0.4f, 2.0f + this.af.i() * 0.4f);
            }
            CraftEventFactory.blockDamage = null;
        }
    }

    public void f(int seconds) {
        this.setSecondsOnFire(seconds, true);
    }

    public void setSecondsOnFire(int i2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
            this.H.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            i2 = event.getDuration();
        }
        int j2 = i2 * 20;
        if (this instanceof EntityLiving) {
            j2 = EnchantmentProtection.a((EntityLiving)this, j2);
        }
        if (this.aK < j2) {
            this.g(j2);
        }
    }

    public void g(int fireTicks) {
        this.aK = fireTicks;
    }

    public int au() {
        return this.aK;
    }

    public void av() {
        this.g(0);
    }

    protected void aw() {
        this.ai();
    }

    public boolean g(double offsetX, double offsetY, double offsetZ) {
        return this.b(this.cD().d(offsetX, offsetY, offsetZ));
    }

    private boolean b(AxisAlignedBB box) {
        return this.H.a(this, box) && !this.H.d(box);
    }

    public void c(boolean onGround) {
        this.N = onGround;
    }

    public boolean ax() {
        return this.N;
    }

    public final Vec3D getMoveVector() {
        return this.moveVector;
    }

    public final double getMoveStartX() {
        return this.moveStartX;
    }

    public final double getMoveStartY() {
        return this.moveStartY;
    }

    public final double getMoveStartZ() {
        return this.moveStartZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumMoveType movementType, Vec3D movement) {
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.dl();
            this.moveStartY = this.dn();
            this.moveStartZ = this.dr();
            this.moveVector = movement;
        }
        try {
            if (this.ae) {
                this.e(this.dl() + movement.c, this.dn() + movement.d, this.dr() + movement.e);
            } else {
                this.aB = this.bK();
                if (movementType == EnumMoveType.c) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.c(movement)).equals(Vec3D.b)) {
                        return;
                    }
                }
                this.H.ac().a("move");
                if (this.T.g() > 1.0E-7) {
                    movement = movement.h(this.T);
                    this.T = Vec3D.b;
                    this.f(Vec3D.b);
                }
                if (this.isTemporarilyActive && !(this instanceof EntityItem) && !(this instanceof EntityMinecartAbstract) && movement == this.dj() && movementType == EnumMoveType.a) {
                    this.f(Vec3D.b);
                    this.H.ac().c();
                    return;
                }
                Vec3D vec3d1 = this.h(movement = this.a(movement, movementType));
                double d0 = vec3d1.g();
                if (d0 > 1.0E-7) {
                    MovingObjectPositionBlock movingobjectpositionblock;
                    if (this.aa != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.H.a(new RayTrace(this.de(), this.de().e(vec3d1), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                        this.n();
                    }
                    this.e(this.dl() + vec3d1.c, this.dn() + vec3d1.d, this.dr() + vec3d1.e);
                }
                this.H.ac().c();
                this.H.ac().a("rest");
                boolean flag = !MathHelper.b(movement.c, vec3d1.c);
                boolean flag1 = !MathHelper.b(movement.e, vec3d1.e);
                this.O = flag || flag1;
                this.P = movement.d != vec3d1.d;
                this.Q = this.P && movement.d < 0.0;
                this.R = this.O ? this.b(vec3d1) : false;
                this.N = this.P && movement.d < 0.0;
                BlockPosition blockposition = this.aC();
                IBlockData iblockdata = this.H.a_(blockposition);
                this.a(vec3d1.d, this.N, iblockdata, blockposition);
                if (this.dB()) {
                    this.H.ac().c();
                } else {
                    MovementEmission entity_movementemission;
                    if (this.O) {
                        Vec3D vec3d2 = this.dj();
                        this.o(flag ? 0.0 : vec3d2.c, vec3d2.d, flag1 ? 0.0 : vec3d2.e);
                    }
                    Block block = iblockdata.b();
                    if (movement.d != vec3d1.d) {
                        block.a(this.H, this);
                    }
                    if (this.O && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block bl = this.H.getWorld().getBlockAt(MathHelper.a(this.dl()), MathHelper.a(this.dn()), MathHelper.a(this.dr()));
                        if (movement.c > vec3d1.c) {
                            bl = bl.getRelative(BlockFace.EAST);
                        } else if (movement.c < vec3d1.c) {
                            bl = bl.getRelative(BlockFace.WEST);
                        } else if (movement.e > vec3d1.e) {
                            bl = bl.getRelative(BlockFace.SOUTH);
                        } else if (movement.e < vec3d1.e) {
                            bl = bl.getRelative(BlockFace.NORTH);
                        }
                        if (!bl.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl, CraftVector.toBukkit(this.moveVector));
                            this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                        }
                    }
                    if (this.N) {
                        block.a(this.H, blockposition, iblockdata, this);
                    }
                    if ((entity_movementemission = this.aQ()).a() && !this.bL()) {
                        boolean flag2;
                        double d1 = vec3d1.c;
                        double d2 = vec3d1.d;
                        double d3 = vec3d1.e;
                        this.Z += (float)(vec3d1.f() * 0.6);
                        boolean bl = flag2 = iblockdata.a(TagsBlock.aM) || iblockdata.a(Blocks.qy);
                        if (!flag2) {
                            d2 = 0.0;
                        }
                        this.X += (float)vec3d1.h() * 0.6f;
                        this.Y += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                        if (this.Y > this.aI && !iblockdata.h()) {
                            this.aI = this.aH();
                            if (this.aT()) {
                                if (entity_movementemission.c()) {
                                    Entity object2 = this.bM() && this.cK() != null ? this.cK() : this;
                                    float f2 = object2 == this ? 0.35f : 0.4f;
                                    Vec3D vec3d3 = object2.dj();
                                    float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d3.c * vec3d3.c * (double)0.2f + vec3d3.d * vec3d3.d + vec3d3.e * vec3d3.e * (double)0.2f) * f2);
                                    this.i(f1);
                                }
                                if (entity_movementemission.b()) {
                                    this.a(GameEvent.U);
                                }
                            } else {
                                if (entity_movementemission.c()) {
                                    this.b(iblockdata);
                                    this.b(blockposition, iblockdata);
                                }
                                if (entity_movementemission.b() && (this.N || movement.d == 0.0 || this.az || flag2)) {
                                    this.H.a(GameEvent.T, this.t, GameEvent.a.a(this, this.bd()));
                                }
                            }
                        } else if (iblockdata.h()) {
                            this.aB();
                        }
                    }
                    this.ay();
                    float f2 = this.aF();
                    this.f(this.dj().d(f2, 1.0, f2));
                    boolean noneMatch = true;
                    AxisAlignedBB fireSearchBox = this.cD().h(1.0E-6);
                    int minX = MathHelper.a(fireSearchBox.a);
                    int minY = MathHelper.a(fireSearchBox.b);
                    int minZ = MathHelper.a(fireSearchBox.c);
                    int maxX = MathHelper.a(fireSearchBox.d);
                    int maxY = MathHelper.a(fireSearchBox.e);
                    int maxZ = MathHelper.a(fireSearchBox.f);
                    block20: for (int fz = minZ; fz <= maxZ; ++fz) {
                        for (int fx = minX; fx <= maxX; ++fx) {
                            for (int fy = minY; fy <= maxY; ++fy) {
                                IBlockData type;
                                Chunk chunk = (Chunk)this.H.getChunkIfLoadedImmediately(fx >> 4, fz >> 4);
                                if (chunk == null) {
                                    noneMatch = true;
                                    break block20;
                                }
                                if (!noneMatch || !(type = chunk.getBlockStateFinal(fx, fy, fz)).a(TagsBlock.aH) && !type.a(Blocks.H)) continue;
                                noneMatch = false;
                            }
                        }
                    }
                    if (noneMatch) {
                        if (this.aK <= 0) {
                            this.g(-this.cY());
                        }
                        if (this.aB && (this.az || this.aV())) {
                            this.az();
                        }
                    }
                    if (this.bK() && (this.az || this.aV())) {
                        this.g(-this.cY());
                    }
                    this.H.ac().c();
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    protected boolean b(Vec3D adjustedMovement) {
        return false;
    }

    protected void ay() {
        try {
            this.aL();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Checking entity block collision");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being checked for collision");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected void az() {
        this.a(SoundEffects.iP, 0.7f, 1.6f + (this.af.i() - this.af.i()) * 0.4f);
    }

    public void aA() {
        if (!this.H.B && this.aB) {
            this.az();
        }
        this.av();
    }

    protected void aB() {
        if (this.aN()) {
            this.aM();
            if (this.aQ().b()) {
                this.a(GameEvent.z);
            }
        }
    }

    @Deprecated
    public BlockPosition aC() {
        return this.a(0.2f);
    }

    public BlockPosition aD() {
        return this.a(1.0E-5f);
    }

    private BlockPosition a(float offset) {
        BlockPosition blockposition1;
        IBlockData iblockdata;
        int k2;
        int j2;
        int i2 = MathHelper.a(this.t.c);
        BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.a(this.t.d - (double)offset), k2 = MathHelper.a(this.t.e));
        if (this.H.a_(blockposition).h() && ((iblockdata = this.H.a_(blockposition1 = blockposition.d())).a(TagsBlock.R) || iblockdata.a(TagsBlock.K) || iblockdata.b() instanceof BlockFenceGate)) {
            return blockposition1;
        }
        return blockposition;
    }

    protected float aE() {
        float f2 = this.H.a_(this.dg()).b().l();
        float f1 = this.H.a_(this.aG()).b().l();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float aF() {
        IBlockData iblockdata = this.H.a_(this.dg());
        float f2 = iblockdata.b().j();
        return !iblockdata.a(Blocks.G) && !iblockdata.a(Blocks.mZ) ? ((double)f2 == 1.0 ? this.H.a_(this.aG()).b().j() : f2) : f2;
    }

    protected BlockPosition aG() {
        return BlockPosition.a(this.t.c, this.cD().b - 0.5000001, this.t.e);
    }

    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        return movement;
    }

    protected Vec3D c(Vec3D movement) {
        if (movement.g() <= 1.0E-7) {
            return movement;
        }
        long i2 = this.H.U();
        if (i2 != this.bd) {
            Arrays.fill(this.bc, 0.0);
            this.bd = i2;
        }
        if (movement.c != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, movement.c);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(d0, 0.0, 0.0);
        }
        if (movement.d != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.b, movement.d);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, d0, 0.0);
        }
        if (movement.e != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.c, movement.e);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, 0.0, d0);
        }
        return Vec3D.b;
    }

    private double a(EnumDirection.EnumAxis axis, double offsetFactor) {
        int i2 = axis.ordinal();
        double d1 = MathHelper.a(offsetFactor + this.bc[i2], -0.51, 0.51);
        offsetFactor = d1 - this.bc[i2];
        this.bc[i2] = d1;
        return offsetFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vec3D h(Vec3D movement) {
        if (movement.c == 0.0 && movement.d == 0.0 && movement.e == 0.0) {
            return movement;
        }
        net.minecraft.world.level.World world = this.H;
        AxisAlignedBB currBoundingBox = this.cD();
        if (CollisionUtil.isEmpty(currBoundingBox)) {
            return movement;
        }
        UnsafeList<AxisAlignedBB> potentialCollisions = CachedLists.getTempCollisionList();
        try {
            double stepHeight = this.dA();
            AxisAlignedBB collisionBox = movement.c == 0.0 && movement.e == 0.0 && movement.d != 0.0 ? (movement.d > 0.0 ? CollisionUtil.cutUpwards(currBoundingBox, movement.d) : CollisionUtil.cutDownwards(currBoundingBox, movement.d)) : (stepHeight > 0.0 && (this.N || movement.d < 0.0) && (movement.c != 0.0 || movement.e != 0.0) ? (movement.d <= 0.0 ? CollisionUtil.expandUpwards(currBoundingBox.b(movement.c, movement.d, movement.e), stepHeight) : currBoundingBox.b(movement.c, Math.max(stepHeight, movement.d), movement.e)) : currBoundingBox.b(movement.c, movement.d, movement.e));
            CollisionUtil.getCollisions(world, this, collisionBox, potentialCollisions, false, this.H.paperConfig().chunks.preventMovingIntoUnloadedChunks, false, false, null, null);
            this.collidingWithWorldBorder = CollisionUtil.isCollidingWithBorderEdge(world.p_(), collisionBox);
            if (this.collidingWithWorldBorder) {
                CollisionUtil.addBoxesToIfIntersects(world.p_().c(), collisionBox, potentialCollisions);
            }
            Vec3D limitedMoveVector = CollisionUtil.performCollisions(movement, currBoundingBox, potentialCollisions);
            if (stepHeight > 0.0 && (this.N || limitedMoveVector.d != movement.d && movement.d < 0.0) && (limitedMoveVector.c != movement.c || limitedMoveVector.e != movement.e)) {
                Vec3D vec3D;
                Vec3D vec3d4;
                Vec3D vec3d2 = CollisionUtil.performCollisions(new Vec3D(movement.c, stepHeight, movement.e), currBoundingBox, potentialCollisions);
                Vec3D vec3d3 = CollisionUtil.performCollisions(new Vec3D(0.0, stepHeight, 0.0), currBoundingBox.b(movement.c, 0.0, movement.e), potentialCollisions);
                if (vec3d3.d < stepHeight && (vec3d4 = CollisionUtil.performCollisions(new Vec3D(movement.c, 0.0, movement.e), currBoundingBox.c(vec3d3), potentialCollisions).e(vec3d3)).i() > vec3d2.i()) {
                    vec3d2 = vec3d4;
                }
                if (vec3d2.i() > limitedMoveVector.i()) {
                    vec3D = vec3d2.e(CollisionUtil.performCollisions(new Vec3D(0.0, -vec3d2.d + movement.d, 0.0), currBoundingBox.c(vec3d2), potentialCollisions));
                    return vec3D;
                }
                vec3D = limitedMoveVector;
                return vec3D;
            }
            Vec3D vec3D = limitedMoveVector;
            return vec3D;
        }
        finally {
            CachedLists.returnTempCollisionList(potentialCollisions);
        }
    }

    public static Vec3D a(@javax.annotation.Nullable Entity entity, Vec3D movement, AxisAlignedBB entityBoundingBox, net.minecraft.world.level.World world, List<VoxelShape> collisions) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        WorldBorder worldborder = world.p_();
        boolean bl = flag = entity != null && worldborder.a(entity, entityBoundingBox.b(movement));
        if (flag) {
            builder.add((Object)worldborder.c());
        }
        builder.addAll(world.d(entity, entityBoundingBox.b(movement)));
        return Entity.a(movement, entityBoundingBox, (List<VoxelShape>)builder.build());
    }

    private static Vec3D a(Vec3D movement, AxisAlignedBB entityBoundingBox, List<VoxelShape> collisions) {
        boolean flag;
        if (collisions.isEmpty()) {
            return movement;
        }
        double d0 = movement.c;
        double d1 = movement.d;
        double d2 = movement.e;
        if (d1 != 0.0 && (d1 = VoxelShapes.a(EnumDirection.EnumAxis.b, entityBoundingBox, collisions, d1)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.a(EnumDirection.EnumAxis.a, entityBoundingBox, collisions, d0);
            if (!flag && d0 != 0.0) {
                entityBoundingBox = entityBoundingBox.d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2);
        }
        return new Vec3D(d0, d1, d2);
    }

    protected float aH() {
        return (int)this.Y + 1;
    }

    protected SoundEffect aI() {
        return SoundEffects.iT;
    }

    protected SoundEffect aJ() {
        return SoundEffects.iS;
    }

    protected SoundEffect aK() {
        return SoundEffects.iS;
    }

    public SoundEffect getSwimSound0() {
        return this.aI();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.aJ();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.aK();
    }

    protected void aL() {
        BlockPosition blockposition1;
        AxisAlignedBB axisalignedbb = this.cD();
        BlockPosition blockposition = BlockPosition.a(axisalignedbb.a + 1.0E-7, axisalignedbb.b + 1.0E-7, axisalignedbb.c + 1.0E-7);
        if (this.H.a(blockposition, blockposition1 = BlockPosition.a(axisalignedbb.d - 1.0E-7, axisalignedbb.e - 1.0E-7, axisalignedbb.f - 1.0E-7))) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int i2 = blockposition.u(); i2 <= blockposition1.u(); ++i2) {
                for (int j2 = blockposition.v(); j2 <= blockposition1.v(); ++j2) {
                    for (int k2 = blockposition.w(); k2 <= blockposition1.w(); ++k2) {
                        blockposition_mutableblockposition.d(i2, j2, k2);
                        IBlockData iblockdata = this.H.a_(blockposition_mutableblockposition);
                        try {
                            iblockdata.a(this.H, (BlockPosition)blockposition_mutableblockposition, this);
                            this.a(iblockdata);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                            CrashReportSystemDetails.a(crashreportsystemdetails, this.H, blockposition_mutableblockposition, iblockdata);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void a(IBlockData state) {
    }

    public void a(GameEvent event, @javax.annotation.Nullable Entity entity) {
        this.H.a(entity, event, this.t);
    }

    public void a(GameEvent event) {
        this.a(event, this);
    }

    protected void b(BlockPosition pos, IBlockData state) {
        IBlockData iblockdata1 = this.H.a_(pos.c());
        boolean flag = iblockdata1.a(TagsBlock.bk);
        if (flag || !state.d().a()) {
            SoundEffectType soundeffecttype = flag ? iblockdata1.t() : state.t();
            this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        }
    }

    private void b(IBlockData state) {
        if (state.a(TagsBlock.bj) && this.ag >= this.bh + 20) {
            this.bg *= (float)Math.pow(0.997, this.ag - this.bh);
            this.bg = Math.min(1.0f, this.bg + 0.07f);
            float f2 = 0.5f + this.bg * this.af.i() * 1.2f;
            float f1 = 0.1f + this.bg * 1.2f;
            this.a(SoundEffects.E, f1, f2);
            this.bh = this.ag;
        }
    }

    protected void i(float volume) {
        this.a(this.aI(), volume, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
    }

    protected void aM() {
    }

    protected boolean aN() {
        return false;
    }

    public void a(SoundEffect sound, float volume, float pitch) {
        if (!this.aO()) {
            this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), sound, this.cX(), volume, pitch);
        }
    }

    public void a(SoundEffect event) {
        if (!this.aO()) {
            this.a(event, 1.0f, 1.0f);
        }
    }

    public boolean aO() {
        return this.am.a(aT);
    }

    public void d(boolean silent) {
        this.am.b(aT, silent);
    }

    public boolean aP() {
        return this.am.a(aU);
    }

    public void e(boolean noGravity) {
        this.am.b(aU, noGravity);
    }

    protected MovementEmission aQ() {
        return MovementEmission.d;
    }

    public boolean aR() {
        return false;
    }

    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        if (onGround) {
            if (this.aa > 0.0f) {
                state.b().a(this.H, state, landedPosition, this, this.aa);
                this.H.a(GameEvent.C, this.t, GameEvent.a.a(this, this.bd()));
            }
            this.n();
        } else if (heightDifference < 0.0) {
            this.aa -= (float)heightDifference;
        }
    }

    public boolean aS() {
        return this.ae().d();
    }

    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.p.a(TagsEntity.l)) {
            return false;
        }
        if (this.bM()) {
            for (Entity entity : this.cM()) {
                entity.a(fallDistance, damageMultiplier, damageSource);
            }
        }
        return false;
    }

    public boolean aT() {
        return this.ah;
    }

    public boolean j() {
        BlockPosition blockposition = this.dg();
        return this.H.t(blockposition) || this.H.t(BlockPosition.a((double)blockposition.u(), this.cD().e, (double)blockposition.w()));
    }

    public boolean k() {
        return this.H.a_(this.dg()).a(Blocks.mZ);
    }

    public boolean aU() {
        return this.aT() || this.j();
    }

    public boolean aV() {
        return this.aT() || this.j() || this.k();
    }

    public boolean aW() {
        return this.aT() || this.k();
    }

    public boolean aX() {
        return this.aj && this.aT();
    }

    public void aY() {
        if (this.bV()) {
            this.h(this.bU() && this.aT() && !this.bL());
        } else {
            this.h(this.bU() && this.aX() && !this.bL() && this.H.b_(this.u).a(TagsFluid.a));
        }
    }

    protected boolean aZ() {
        this.ai.clear();
        this.ba();
        double d0 = this.H.q_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.aT() || flag;
    }

    void ba() {
        EntityBoat entityboat;
        Entity entity = this.cV();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).aX()) {
            this.ah = false;
            return;
        }
        if (this.a(TagsFluid.a, 0.014)) {
            if (!this.ah && !this.al) {
                this.bb();
            }
            this.n();
            this.ah = true;
            this.av();
        } else {
            this.ah = false;
        }
    }

    private void o() {
        EntityBoat entityboat;
        this.aj = this.a(TagsFluid.a);
        this.aL.clear();
        double d0 = this.dp() - 0.1111111119389534;
        Entity entity = this.cV();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).aX() && entityboat.cD().e >= d0 && entityboat.cD().b <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.a(this.dl(), d0, this.dr());
        Fluid fluid = this.H.b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a((IBlockAccess)this.H, blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.aL;
            Objects.requireNonNull(this.aL);
            stream.forEach(set::add);
        }
    }

    protected void bb() {
        double d1;
        double d0;
        Entity object = this.bM() && this.cK() != null ? this.cK() : this;
        float f2 = object == this ? 0.2f : 0.9f;
        Vec3D vec3d = object.dj();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.aJ(), f1, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
        } else {
            this.a(this.aK(), f1, 1.0f + (this.af.i() - this.af.i()) * 0.4f);
        }
        float f22 = MathHelper.a(this.dn());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.be.a * 20.0f) {
            d0 = (this.af.j() * 2.0 - 1.0) * (double)this.be.a;
            d1 = (this.af.j() * 2.0 - 1.0) * (double)this.be.a;
            this.H.a(Particles.e, this.dl() + d0, (double)(f22 + 1.0f), this.dr() + d1, vec3d.c, vec3d.d - this.af.j() * (double)0.2f, vec3d.e);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.be.a * 20.0f) {
            d0 = (this.af.j() * 2.0 - 1.0) * (double)this.be.a;
            d1 = (this.af.j() * 2.0 - 1.0) * (double)this.be.a;
            this.H.a(Particles.ai, this.dl() + d0, (double)(f22 + 1.0f), this.dr() + d1, vec3d.c, vec3d.d, vec3d.e);
            ++i2;
        }
        this.a(GameEvent.S);
    }

    @Deprecated
    protected IBlockData bc() {
        return this.H.a_(this.aC());
    }

    public IBlockData bd() {
        return this.H.a_(this.aD());
    }

    public boolean be() {
        return this.bU() && !this.aT() && !this.F_() && !this.bT() && !this.bg() && this.bq();
    }

    protected void bf() {
        int k2;
        int j2;
        int i2 = MathHelper.a(this.dl());
        BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.a(this.dn() - (double)0.2f), k2 = MathHelper.a(this.dr()));
        IBlockData iblockdata = this.H.a_(blockposition);
        if (iblockdata.i() != EnumRenderType.a) {
            Vec3D vec3d = this.dj();
            this.H.a(new ParticleParamBlock(Particles.c, iblockdata), this.dl() + (this.af.j() - 0.5) * (double)this.be.a, this.dn() + 0.1, this.dr() + (this.af.j() - 0.5) * (double)this.be.a, vec3d.c * -4.0, 1.5, vec3d.e * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> fluidTag) {
        return this.aL.contains(fluidTag);
    }

    public boolean bg() {
        return !this.al && this.ai.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float speed, Vec3D movementInput) {
        Vec3D vec3d1 = Entity.a(movementInput, speed, this.dw());
        this.f(this.dj().e(vec3d1));
    }

    private static Vec3D a(Vec3D movementInput, float speed, float yaw) {
        double d0 = movementInput.g();
        if (d0 < 1.0E-7) {
            return Vec3D.b;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? movementInput.d() : movementInput).a((double)speed);
        float f2 = MathHelper.a(yaw * ((float)Math.PI / 180));
        float f3 = MathHelper.b(yaw * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.c * (double)f3 - vec3d1.e * (double)f2, vec3d1.d, vec3d1.e * (double)f3 + vec3d1.c * (double)f2);
    }

    @Deprecated
    public float bh() {
        return this.H.f(this.dk(), this.dq()) ? this.H.z(BlockPosition.a(this.dl(), this.dp(), this.dr())) : 0.0f;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.h(x2, y2, z2);
        this.f(yaw % 360.0f);
        this.e(MathHelper.a(pitch, -90.0f, 90.0f) % 360.0f);
        this.L = this.dw();
        this.M = this.dy();
        this.r(yaw);
    }

    public void h(double x2, double y2, double z2) {
        double d3 = MathHelper.a(x2, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(z2, -3.0E7, 3.0E7);
        this.I = d3;
        this.J = y2;
        this.K = d4;
        this.e(d3, y2, d4);
        if (this.valid) {
            this.H.d((int)Math.floor(this.dl()) >> 4, (int)Math.floor(this.dr()) >> 4);
        }
    }

    public void d(Vec3D pos) {
        this.d(pos.c, pos.d, pos.e);
    }

    public void d(double x2, double y2, double z2) {
        this.b(x2, y2, z2, this.dw(), this.dy());
    }

    public void a(BlockPosition pos, float yaw, float pitch) {
        this.b((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, yaw, pitch);
    }

    public void b(double x2, double y2, double z2, float yaw, float pitch) {
        if (!this.preserveMotion) {
            this.aD = Vec3D.b;
        } else {
            this.preserveMotion = false;
        }
        this.p(x2, y2, z2);
        this.f(yaw);
        this.e(pitch);
        this.bi();
        this.an();
        this.r(yaw);
    }

    public final void bi() {
        double d0 = this.dl();
        double d1 = this.dn();
        double d2 = this.dr();
        this.I = d0;
        this.J = d1;
        this.K = d2;
        this.ab = d0;
        this.ac = d1;
        this.ad = d2;
        this.L = this.dw();
        this.M = this.dy();
    }

    public float e(Entity entity) {
        float f2 = (float)(this.dl() - entity.dl());
        float f1 = (float)(this.dn() - entity.dn());
        float f22 = (float)(this.dr() - entity.dr());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double i(double x2, double y2, double z2) {
        double d3 = this.dl() - x2;
        double d4 = this.dn() - y2;
        double d5 = this.dr() - z2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double f(Entity entity) {
        return this.e(entity.de());
    }

    public double e(Vec3D vector) {
        double d0 = this.dl() - vector.c;
        double d1 = this.dn() - vector.d;
        double d2 = this.dr() - vector.e;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void b_(EntityHuman player) {
    }

    public void g(Entity entity) {
        if (!(this.v(entity) || entity.ae || this.ae)) {
            double d1;
            if (this.H.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityPlayer) && !(this instanceof EntityPlayer)) {
                return;
            }
            double d0 = entity.dl() - this.dl();
            double d2 = MathHelper.a(d0, d1 = entity.dr() - this.dr());
            if (d2 >= (double)0.01f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.bM() && this.bn()) {
                    this.j(-d0, 0.0, -d1);
                }
                if (!entity.bM() && entity.bn()) {
                    entity.j(d0, 0.0, d1);
                }
            }
        }
    }

    public void j(double deltaX, double deltaY, double deltaZ) {
        this.push(deltaX, deltaY, deltaZ, null);
    }

    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(deltaX, deltaY, deltaZ);
        if (pushingEntity == null || new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta).callEvent()) {
            this.f(this.dj().b(delta.getX(), delta.getY(), delta.getZ()));
            this.at = true;
        }
    }

    protected void bj() {
        this.S = true;
    }

    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        this.bj();
        return false;
    }

    public final Vec3D j(float tickDelta) {
        return this.b(this.k(tickDelta), this.l(tickDelta));
    }

    public float k(float tickDelta) {
        return tickDelta == 1.0f ? this.dy() : MathHelper.i(tickDelta, this.M, this.dy());
    }

    public float l(float tickDelta) {
        return tickDelta == 1.0f ? this.dw() : MathHelper.i(tickDelta, this.L, this.dw());
    }

    protected final Vec3D b(float pitch, float yaw) {
        float f2 = pitch * ((float)Math.PI / 180);
        float f3 = -yaw * ((float)Math.PI / 180);
        float f4 = MathHelper.b(f3);
        float f5 = MathHelper.a(f3);
        float f6 = MathHelper.b(f2);
        float f7 = MathHelper.a(f2);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D m(float tickDelta) {
        return this.c(this.k(tickDelta), this.l(tickDelta));
    }

    protected final Vec3D c(float pitch, float yaw) {
        return this.b(pitch - 90.0f, yaw);
    }

    public final Vec3D bk() {
        return new Vec3D(this.dl(), this.dp(), this.dr());
    }

    public final Vec3D n(float tickDelta) {
        double d0 = MathHelper.d((double)tickDelta, this.I, this.dl());
        double d1 = MathHelper.d((double)tickDelta, this.J, this.dn()) + (double)this.cE();
        double d2 = MathHelper.d((double)tickDelta, this.K, this.dr());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D o(float tickDelta) {
        return this.n(tickDelta);
    }

    public final Vec3D p(float delta) {
        double d0 = MathHelper.d((double)delta, this.I, this.dl());
        double d1 = MathHelper.d((double)delta, this.J, this.dn());
        double d2 = MathHelper.d((double)delta, this.K, this.dr());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double maxDistance, float tickDelta, boolean includeFluids) {
        Vec3D vec3d = this.n(tickDelta);
        Vec3D vec3d1 = this.j(tickDelta);
        Vec3D vec3d2 = vec3d.b(vec3d1.c * maxDistance, vec3d1.d * maxDistance, vec3d1.e * maxDistance);
        return this.H.a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, includeFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bl() {
        return this.bq() && this.bm();
    }

    public boolean bm() {
        return false;
    }

    public boolean bn() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bn();
    }

    public void a(Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled instanceof EntityPlayer) {
            CriterionTriggers.c.a((EntityPlayer)entityKilled, this, damageSource);
        }
    }

    public boolean k(double cameraX, double cameraY, double cameraZ) {
        double d3 = this.dl() - cameraX;
        double d4 = this.dn() - cameraY;
        double d5 = this.dr() - cameraZ;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double distance) {
        double d1 = this.cD().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * o) * d1;
    }

    public boolean d(NBTTagCompound nbt) {
        if (this.aH != null && !this.aH.b()) {
            return false;
        }
        String s2 = this.bp();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbt.a(v, s2);
        this.f(nbt);
        return true;
    }

    public boolean serializeEntity(NBTTagCompound compound) {
        ArrayList<Entity> pass = new ArrayList<Entity>(this.cM());
        this.r = ImmutableList.of();
        boolean result = this.e(compound);
        this.r = ImmutableList.copyOf(pass);
        return result;
    }

    public boolean e(NBTTagCompound nbt) {
        return this.bL() ? false : this.d(nbt);
    }

    public NBTTagCompound f(NBTTagCompound nbt) {
        try {
            NBTTagList nbttaglist;
            int i2;
            if (this.s != null) {
                nbt.a("Pos", this.a(new double[]{this.s.dl(), this.dn(), this.s.dr()}));
            } else {
                nbt.a("Pos", this.a(new double[]{this.dl(), this.dn(), this.dr()}));
            }
            Vec3D vec3d = this.dj();
            nbt.a("Motion", this.a(new double[]{vec3d.c, vec3d.d, vec3d.e}));
            if (Float.isNaN(this.aE)) {
                this.aE = 0.0f;
            }
            if (Float.isNaN(this.aF)) {
                this.aF = 0.0f;
            }
            nbt.a("Rotation", this.a(new float[]{this.dw(), this.dy()}));
            nbt.a("FallDistance", this.aa);
            nbt.a("Fire", (short)this.aK);
            nbt.a("Air", (short)this.cd());
            nbt.a("OnGround", this.N);
            nbt.a("Invulnerable", this.aZ);
            nbt.a("PortalCooldown", this.aY);
            nbt.a(E, this.cs());
            nbt.a("WorldUUIDLeast", ((WorldServer)this.H).getWorld().getUID().getLeastSignificantBits());
            nbt.a("WorldUUIDMost", ((WorldServer)this.H).getWorld().getUID().getMostSignificantBits());
            nbt.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbt.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbt.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbt.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbt.a("Bukkit.MaxAirSupply", this.cc());
            }
            nbt.a("Spigot.ticksLived", this.ag);
            IChatBaseComponent ichatbasecomponent = this.ab();
            if (ichatbasecomponent != null) {
                nbt.a("CustomName", IChatBaseComponent.ChatSerializer.a(ichatbasecomponent));
            }
            if (this.cx()) {
                nbt.a("CustomNameVisible", this.cx());
            }
            if (this.aO()) {
                nbt.a("Silent", this.aO());
            }
            if (this.aP()) {
                nbt.a("NoGravity", this.aP());
            }
            if (this.ba) {
                nbt.a("Glowing", true);
            }
            if ((i2 = this.ce()) > 0) {
                nbt.a("TicksFrozen", this.ce());
            }
            if (this.bi) {
                nbt.a("HasVisualFire", this.bi);
            }
            if (!this.bb.isEmpty()) {
                nbttaglist = new NBTTagList();
                for (String s2 : this.bb) {
                    nbttaglist.add(NBTTagString.a(s2));
                }
                nbt.a("Tags", nbttaglist);
            }
            this.b(nbt);
            if (this.bM()) {
                nbttaglist = new NBTTagList();
                for (Entity entity : this.cM()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.d(nbttagcompound1 = new NBTTagCompound())) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbt.a(w, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbt);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.H != null ? this.H.getWorld().getUID() : null);
                if (originWorld != null) {
                    nbt.a("Paper.OriginWorld", originWorld);
                }
                nbt.a("Paper.Origin", this.a(new double[]{this.origin.getX(), this.origin.getY(), this.origin.getZ()}));
            }
            if (this.spawnReason != null) {
                nbt.a("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                nbt.a("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                nbt.a("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                nbt.a("Paper.FreezeLock", true);
            }
            nbt.a("Leaves.Data", this.leavesData);
            return nbt;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void g(NBTTagCompound nbt) {
        try {
            NBTTagList originTag;
            NBTTagList nbttaglist = nbt.c("Pos", 6);
            NBTTagList nbttaglist1 = nbt.c("Motion", 6);
            NBTTagList nbttaglist2 = nbt.c("Rotation", 5);
            double d0 = nbttaglist1.h(0);
            double d1 = nbttaglist1.h(1);
            double d2 = nbttaglist1.h(2);
            this.o(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            double d3 = 3.0000512E7;
            this.p(MathHelper.a(nbttaglist.h(0), -3.0000512E7, 3.0000512E7), MathHelper.a(nbttaglist.h(1), -2.0E7, 2.0E7), MathHelper.a(nbttaglist.h(2), -3.0000512E7, 3.0000512E7));
            this.f(nbttaglist2.i(0));
            this.e(nbttaglist2.i(1));
            this.bi();
            this.r(this.dw());
            this.s(this.dw());
            this.aa = nbt.j("FallDistance");
            this.aK = nbt.g("Fire");
            if (nbt.e("Air")) {
                this.i(nbt.g("Air"));
            }
            this.N = nbt.q("OnGround");
            this.aZ = nbt.q("Invulnerable");
            this.aY = nbt.h("PortalCooldown");
            if (nbt.b(E)) {
                this.ax = nbt.a(E);
                this.ay = this.ax.toString();
            }
            if (!Double.isFinite(this.dl()) || !Double.isFinite(this.dn()) || !Double.isFinite(this.dr())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.dw()) || !Double.isFinite(this.dy())) throw new IllegalStateException("Entity has invalid rotation");
            this.an();
            this.a(this.dw(), this.dy());
            if (nbt.b("CustomName", 8)) {
                String s2 = nbt.l("CustomName");
                try {
                    this.b(IChatBaseComponent.ChatSerializer.a(s2));
                }
                catch (Exception exception) {
                    c.warn("Failed to parse entity custom name {}", (Object)s2, (Object)exception);
                }
            }
            this.n(nbt.q("CustomNameVisible"));
            this.d(nbt.q("Silent"));
            this.e(nbt.q("NoGravity"));
            this.i(nbt.q("Glowing"));
            this.j(nbt.h("TicksFrozen"));
            this.bi = nbt.q("HasVisualFire");
            if (nbt.b("Tags", 9)) {
                this.bb.clear();
                NBTTagList nbttaglist3 = nbt.c("Tags", 8);
                int i2 = Math.min(nbttaglist3.size(), 1024);
                for (int j2 = 0; j2 < i2; ++j2) {
                    this.bb.add(nbttaglist3.j(j2));
                }
            }
            this.a(nbt);
            if (this.bo()) {
                this.an();
            }
            if (this instanceof EntityLiving) {
                this.ag = nbt.h("Spigot.ticksLived");
            }
            this.persist = !nbt.e("Bukkit.persist") || nbt.q("Bukkit.persist");
            boolean bl = this.visibleByDefault = !nbt.e("Bukkit.visibleByDefault") || nbt.q("Bukkit.visibleByDefault");
            if (nbt.e("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbt.h("Bukkit.MaxAirSupply");
            }
            if (this instanceof EntityPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = nbt.l("world");
                if (nbt.e("WorldUUIDMost") && nbt.e("WorldUUIDLeast")) {
                    UUID uid = new UUID(nbt.i("WorldUUIDMost"), nbt.i("WorldUUIDLeast"));
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                ((EntityPlayer)this).c(bworld == null ? null : ((CraftWorld)bworld).getHandle());
            }
            this.getBukkitEntity().readBukkitValues(nbt);
            if (nbt.e("Bukkit.invisible")) {
                boolean bukkitInvisible = nbt.q("Bukkit.invisible");
                this.j(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if (!(originTag = nbt.c("Paper.Origin", 6)).isEmpty()) {
                UUID originWorld = null;
                if (nbt.e("Paper.OriginWorld")) {
                    originWorld = nbt.a("Paper.OriginWorld");
                } else if (this.H != null) {
                    originWorld = this.H.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = new Vector(originTag.h(0), originTag.h(1), originTag.h(2));
            }
            this.spawnedViaMobSpawner = nbt.q("Paper.FromMobSpawner");
            this.fromNetherPortal = nbt.q("Paper.FromNetherPortal");
            if (nbt.e("Paper.SpawnReason")) {
                String spawnReasonName = nbt.l("Paper.SpawnReason");
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    c.error("Unknown SpawnReason " + spawnReasonName + " for " + this);
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof EntityInsentient && (this instanceof EntityAnimal || this instanceof EntityFish) && !((EntityInsentient)this).h(0.0) && !nbt.q("PersistenceRequired")) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (nbt.e("Paper.FreezeLock")) {
                this.freezeLocked = nbt.q("Paper.FreezeLock");
            }
            if (!nbt.e("Leaves.Data")) return;
            this.leavesData = nbt.p("Leaves.Data");
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bo() {
        return true;
    }

    @javax.annotation.Nullable
    public final String bp() {
        EntityTypes<?> entitytypes = this.ae();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return entitytypes.b() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.a(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList a(float ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            float f2 = afloat1[j2];
            nbttaglist.add(NBTTagFloat.a(f2));
        }
        return nbttaglist;
    }

    @javax.annotation.Nullable
    public EntityItem a(IMaterial item) {
        return this.a(item, 0);
    }

    @javax.annotation.Nullable
    public EntityItem a(IMaterial item, int yOffset) {
        return this.a(new ItemStack(item), (float)yOffset);
    }

    @javax.annotation.Nullable
    public EntityItem b(ItemStack stack) {
        return this.a(stack, 0.0f);
    }

    @javax.annotation.Nullable
    public EntityItem a(ItemStack stack, float yOffset) {
        if (stack.b()) {
            return null;
        }
        if (this.H.B) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(CraftItemStack.asCraftMirror(stack));
            return null;
        }
        EntityItem entityitem = new EntityItem(this.H, this.dl(), this.dn() + (double)yOffset, this.dr(), stack.o());
        stack.f(0);
        entityitem.k();
        return this.spawnAtLocation(entityitem);
    }

    @javax.annotation.Nullable
    public EntityItem spawnAtLocation(EntityItem entityitem) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.H.b(entityitem);
        return entityitem;
    }

    public boolean bq() {
        return !this.dB();
    }

    public boolean br() {
        if (this.ae) {
            return false;
        }
        float f2 = this.be.a * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.bk(), f2, 1.0E-6, f2);
        BlockPosition.MutableBlockPosition blockposition = new BlockPosition.MutableBlockPosition();
        int minX = MathHelper.a(axisalignedbb.a);
        int minY = MathHelper.a(axisalignedbb.b);
        int minZ = MathHelper.a(axisalignedbb.c);
        int maxX = MathHelper.a(axisalignedbb.d);
        int maxY = MathHelper.a(axisalignedbb.e);
        int maxZ = MathHelper.a(axisalignedbb.f);
        for (int fz = minZ; fz <= maxZ; ++fz) {
            for (int fx = minX; fx <= maxX; ++fx) {
                for (int fy = minY; fy <= maxY; ++fy) {
                    Chunk chunk = (Chunk)this.H.getChunkIfLoadedImmediately(fx >> 4, fz >> 4);
                    if (chunk == null) continue;
                    IBlockData iblockdata = chunk.getBlockStateFinal(fx, fy, fz);
                    blockposition.d(fx, fy, fz);
                    if (iblockdata.h() || !iblockdata.o(this.H, blockposition) || !VoxelShapes.c(iblockdata.k(this.H, blockposition).a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w()), VoxelShapes.a(axisalignedbb), OperatorBoolean.i)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean h(Entity other) {
        return other.bs() && !this.v(other);
    }

    public boolean bs() {
        return false;
    }

    public void bt() {
        this.f(Vec3D.b);
        this.l();
        if (this.bL()) {
            this.cV().i(this);
        }
    }

    public void i(Entity passenger) {
        this.a(passenger, Entity::e);
    }

    private void a(Entity passenger, MoveFunction positionUpdater) {
        if (this.u(passenger)) {
            double d0 = this.dn() + this.bv() + passenger.bu();
            positionUpdater.accept(passenger, this.dl(), d0, this.dr());
        }
    }

    public void j(Entity passenger) {
    }

    public double bu() {
        return 0.0;
    }

    public double bv() {
        return (double)this.be.b * 0.75;
    }

    public boolean k(Entity entity) {
        return this.a(entity, false);
    }

    public boolean bw() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean force) {
        if (entity == this.s) {
            return false;
        }
        if (!entity.bA()) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.s != null) {
            if (entity1.s == this) {
                return false;
            }
            entity1 = entity1.s;
        }
        if (!(force || this.l(entity) && entity.o(this))) {
            return false;
        }
        if (this.bL()) {
            this.bz();
        }
        this.b(EntityPose.a);
        this.s = entity;
        if (!this.s.addPassenger(this)) {
            this.s = null;
        }
        entity.p().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.R.a((EntityPlayer)entity2));
        return true;
    }

    protected boolean l(Entity entity) {
        return !this.bO() && this.G <= 0;
    }

    protected boolean d(EntityPose pose) {
        return this.H.a(this, this.e(pose).h(1.0E-7));
    }

    public void bx() {
        for (int i2 = this.r.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.r.get(i2)).bz();
        }
    }

    public void by() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        if (this.s != null) {
            Entity entity = this.s;
            this.s = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.s = entity;
            }
        }
    }

    public void bz() {
        this.by();
    }

    protected boolean addPassenger(Entity entity) {
        EntityMountEvent event;
        Entity orig;
        if (entity.H != this.H) {
            c.error("Entity passenger world must match, cannot add " + entity + " as passenger to " + this, new Throwable());
            return false;
        }
        if (entity == this) {
            throw new IllegalArgumentException("Entities cannot become a passenger of themselves");
        }
        if (entity.cV() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        Preconditions.checkState((!entity.r.contains((Object)this) ? 1 : 0) != 0, (String)"Circular entity riding! %s %s", (Object)this, (Object)entity);
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleEnterEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.r.isEmpty()) {
            this.r = ImmutableList.of((Object)entity);
        } else {
            ArrayList list = Lists.newArrayList(this.r);
            if (!this.H.B && entity instanceof EntityHuman && !(this.cN() instanceof EntityHuman)) {
                list.add(0, entity);
            } else {
                list.add(entity);
            }
            this.r = ImmutableList.copyOf((Collection)list);
        }
        this.a(GameEvent.t, entity);
        return true;
    }

    protected boolean removePassenger(Entity entity) {
        return this.removePassenger(entity, false);
    }

    protected boolean removePassenger(Entity entity, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.cV() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.r = this.r.size() == 1 && this.r.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.r.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.G = 60;
        this.a(GameEvent.r, entity);
        return true;
    }

    protected boolean o(Entity passenger) {
        return this.r.isEmpty();
    }

    protected boolean bA() {
        return true;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.e(x2, y2, z2);
        this.a(yaw, pitch);
    }

    public void a(float yaw, int interpolationSteps) {
        this.r(yaw);
    }

    public float bB() {
        return 0.0f;
    }

    public Vec3D bC() {
        return this.b(this.dy(), this.dw());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        if (!(this instanceof EntityHuman)) {
            return Vec3D.b;
        }
        EntityHuman entityhuman = (EntityHuman)this;
        boolean flag = entityhuman.eL().a(item) && !entityhuman.eK().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.fd().d() : entityhuman.fd();
        return this.b(0.0f, this.dw() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).a(0.5);
    }

    public Vec2F bD() {
        return new Vec2F(this.dy(), this.dw());
    }

    public Vec3D bE() {
        return Vec3D.a(this.bD());
    }

    public void d(BlockPosition pos) {
        if (this.ar()) {
            this.aq();
        } else {
            if (!this.H.B && !pos.equals(this.aw)) {
                this.aw = pos.i();
            }
            this.au = true;
        }
    }

    protected void bF() {
        if (this.H instanceof WorldServer) {
            int i2 = this.as();
            WorldServer worldserver = (WorldServer)this.H;
            if (this.au) {
                MinecraftServer minecraftserver = worldserver.n();
                ResourceKey<net.minecraft.world.level.World> resourcekey = this.H.getTypeKey() == WorldDimension.c ? net.minecraft.world.level.World.h : net.minecraft.world.level.World.i;
                WorldServer worldserver1 = minecraftserver.a(resourcekey);
                if (!this.bL() && this.av++ >= i2) {
                    this.H.ac().a("portal");
                    this.av = i2;
                    EntityPortalReadyEvent event = new EntityPortalReadyEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (World)(worldserver1 == null ? null : worldserver1.getWorld()), PortalType.NETHER);
                    if (!event.callEvent()) {
                        this.av = 0;
                    } else {
                        worldserver1 = event.getTargetWorld() == null ? null : ((CraftWorld)event.getTargetWorld()).getHandle();
                        this.aq();
                        if (this instanceof EntityPlayer) {
                            ((EntityPlayer)this).changeDimension(worldserver1, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
                        } else {
                            this.b(worldserver1);
                        }
                    }
                    this.H.ac().c();
                }
                this.au = false;
            } else {
                if (this.av > 0) {
                    this.av -= 4;
                }
                if (this.av < 0) {
                    this.av = 0;
                }
            }
            this.H();
        }
    }

    public int bG() {
        return 300;
    }

    public void l(double x2, double y2, double z2) {
        this.o(x2, y2, z2);
    }

    public void c(DamageSource damageSource) {
    }

    public void b(byte status) {
        switch (status) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void q(float yaw) {
    }

    public Iterable<ItemStack> bH() {
        return e;
    }

    public Iterable<ItemStack> bI() {
        return e;
    }

    public Iterable<ItemStack> bJ() {
        return Iterables.concat(this.bH(), this.bI());
    }

    public void a(EnumItemSlot slot, ItemStack stack) {
    }

    public boolean bK() {
        boolean flag = this.H != null && this.H.B;
        return !this.aS() && (this.aK > 0 || flag && this.h(0));
    }

    public boolean bL() {
        return this.cV() != null;
    }

    public boolean bM() {
        return !this.r.isEmpty();
    }

    public boolean bN() {
        return this.ae().a(TagsEntity.m);
    }

    public void f(boolean sneaking) {
        this.b(1, sneaking);
    }

    public boolean bO() {
        return this.h(1);
    }

    public boolean bP() {
        return this.bO();
    }

    public boolean bQ() {
        return this.bO();
    }

    public boolean bR() {
        return this.bO();
    }

    public boolean bS() {
        return this.bO();
    }

    public boolean bT() {
        return this.c(EntityPose.f);
    }

    public boolean bU() {
        return this.h(3);
    }

    public void g(boolean sprinting) {
        this.b(3, sprinting);
    }

    public boolean bV() {
        return this.h(4);
    }

    public boolean bW() {
        return this.c(EntityPose.d);
    }

    public boolean bX() {
        return this.bW() && !this.aT();
    }

    public void h(boolean swimming) {
        if (this.valid && this.bV() != swimming && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, swimming).isCancelled()) {
            return;
        }
        this.b(4, swimming);
    }

    public final boolean bY() {
        return this.ba;
    }

    public final void i(boolean glowing) {
        this.ba = glowing;
        this.b(6, this.bZ());
    }

    public boolean bZ() {
        return this.H.k_() ? this.h(6) : this.ba;
    }

    public boolean ca() {
        return this.h(5);
    }

    public boolean d(EntityHuman player) {
        if (player.F_()) {
            return false;
        }
        ScoreboardTeamBase scoreboardteambase = this.cb();
        return scoreboardteambase != null && player != null && player.cb() == scoreboardteambase && scoreboardteambase.i() ? false : this.ca();
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> callback) {
    }

    @javax.annotation.Nullable
    public ScoreboardTeamBase cb() {
        if (!this.H.paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
            return null;
        }
        return this.H.H().i(this.cu());
    }

    public boolean p(Entity other) {
        return this.a(other.cb());
    }

    public boolean a(ScoreboardTeamBase team) {
        return this.cb() != null ? this.cb().a(team) : false;
    }

    public void j(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.b(5, invisible);
        }
    }

    public boolean h(int index) {
        return (this.am.a(an) & 1 << index) != 0;
    }

    public void b(int index, boolean value) {
        byte b0 = this.am.a(an);
        if (value) {
            this.am.b(an, (byte)(b0 | 1 << index));
        } else {
            this.am.b(an, (byte)(b0 & ~(1 << index)));
        }
    }

    public int cc() {
        return this.maxAirTicks;
    }

    public int cd() {
        return this.am.a(aQ);
    }

    public void i(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.cd() != air) {
            this.am.markDirty(aQ);
            return;
        }
        this.am.b(aQ, event.getAmount());
    }

    public int ce() {
        return this.am.a(aV);
    }

    public void j(int frozenTicks) {
        this.am.b(aV, frozenTicks);
    }

    public float cf() {
        int i2 = this.ch();
        return (float)Math.min(this.ce(), i2) / (float)i2;
    }

    public boolean cg() {
        return this.ce() >= this.ch();
    }

    public int ch() {
        return 140;
    }

    public void a(WorldServer world, EntityLightning lightning) {
        this.g(this.aK + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aK == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.setSecondsOnFire(entityCombustEvent.getDuration(), false);
            } else {
                this.g(this.aK - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.aS()) {
            return;
        }
        CraftEventFactory.entityDamage = lightning;
        if (!this.a(this.dG().b(), 5.0f)) {
            CraftEventFactory.entityDamage = null;
            return;
        }
    }

    public void k(boolean drag) {
        Vec3D vec3d = this.dj();
        double d0 = drag ? Math.max(-0.9, vec3d.d - 0.03) : Math.min(1.8, vec3d.d + 0.1);
        this.o(vec3d.c, d0, vec3d.e);
    }

    public void l(boolean drag) {
        Vec3D vec3d = this.dj();
        double d0 = drag ? Math.max(-0.3, vec3d.d - 0.03) : Math.min(0.7, vec3d.d + 0.06);
        this.o(vec3d.c, d0, vec3d.e);
        this.n();
    }

    public boolean a(WorldServer world, EntityLiving other) {
        return true;
    }

    public void ci() {
        if (this.dj().b() > -0.5 && this.aa > 1.0f) {
            this.aa = 1.0f;
        }
    }

    public void n() {
        this.aa = 0.0f;
    }

    protected void m(double x2, double y2, double z2) {
        BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
        Vec3D vec3d = new Vec3D(x2 - (double)blockposition.u(), y2 - (double)blockposition.v(), z2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d5;
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (this.H.a_(blockposition_mutableblockposition).r(this.H, blockposition_mutableblockposition)) continue;
            double d4 = vec3d.a(enumdirection1.o());
            double d2 = d5 = enumdirection1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.af.i() * 0.2f + 0.1f;
        float f1 = enumdirection.f().a();
        Vec3D vec3d1 = this.dj().a(0.75);
        if (enumdirection.o() == EnumDirection.EnumAxis.a) {
            this.o(f1 * f2, vec3d1.d, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            this.o(vec3d1.c, f1 * f2, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.c) {
            this.o(vec3d1.c, vec3d1.d, f1 * f2);
        }
    }

    public void a(IBlockData state, Vec3D multiplier) {
        this.n();
        this.T = multiplier;
    }

    private static IChatBaseComponent c(IChatBaseComponent textComponent) {
        IChatMutableComponent ichatmutablecomponent = textComponent.d().b(textComponent.a().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : textComponent.c()) {
            ichatmutablecomponent.b(Entity.c(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent Z() {
        IChatBaseComponent ichatbasecomponent = this.ab();
        return ichatbasecomponent != null ? Entity.c(ichatbasecomponent) : this.cj();
    }

    protected IChatBaseComponent cj() {
        return this.p.h();
    }

    public boolean q(Entity entity) {
        return this == entity;
    }

    public float ck() {
        return 0.0f;
    }

    public void r(float headYaw) {
    }

    public void s(float bodyYaw) {
    }

    public boolean cl() {
        return true;
    }

    public boolean r(Entity attacker) {
        return false;
    }

    public String toString() {
        String s2 = this.H == null ? "~NULL~" : this.H.toString();
        return this.aH != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.Z().getString(), this.q, this.ax, s2, this.dl(), this.dn(), this.dr(), this.di(), this.ag, this.valid, this.aH}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.Z().getString(), this.q, this.ax, s2, this.dl(), this.dn(), this.dr(), this.di(), this.ag, this.valid);
    }

    public boolean b(DamageSource damageSource) {
        return this.dB() || this.aZ && !damageSource.a(DamageTypeTags.d) && !damageSource.g() || damageSource.a(DamageTypeTags.i) && this.aS() || damageSource.a(DamageTypeTags.m) && this.ae().a(TagsEntity.l);
    }

    public boolean cm() {
        return this.aZ;
    }

    public void m(boolean invulnerable) {
        this.aZ = invulnerable;
    }

    public void s(Entity entity) {
        this.b(entity.dl(), entity.dn(), entity.dr(), entity.dw(), entity.dy());
    }

    public void t(Entity original) {
        CraftEntity bukkitEntity = original.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        NBTTagCompound nbttagcompound = original.f(new NBTTagCompound());
        nbttagcompound.r("Dimension");
        this.g(nbttagcompound);
        this.aY = original.aY;
        this.aw = original.aw;
    }

    @javax.annotation.Nullable
    public Entity b(WorldServer destination) {
        return this.teleportTo(destination, null);
    }

    @javax.annotation.Nullable
    public Entity teleportTo(WorldServer worldserver, Position location) {
        if (!this.bq() || !this.valid) {
            c.warn("Illegal Entity Teleport " + this + " to " + worldserver + ":" + location, new Throwable());
            return null;
        }
        if (this.H instanceof WorldServer && !this.dB()) {
            Object entity;
            ShapeDetectorShape shapedetectorshape;
            this.H.ac().a("changeDimension");
            if (worldserver == null) {
                return null;
            }
            this.H.ac().a("reposition");
            ShapeDetectorShape shapeDetectorShape = shapedetectorshape = location == null ? this.a(worldserver) : new ShapeDetectorShape(new Vec3D(location.a(), location.b(), location.c()), Vec3D.b, this.aE, this.aF, worldserver, null);
            if (shapedetectorshape == null) {
                return null;
            }
            worldserver = shapedetectorshape.world;
            CraftEntity bukkitEntity = this.getBukkitEntity();
            Vec3D position = shapedetectorshape.a;
            float yaw = shapedetectorshape.c;
            float pitch = bukkitEntity.getLocation().getPitch();
            Vec3D velocity = shapedetectorshape.b;
            EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), new Location((World)worldserver.getWorld(), position.c, position.d, position.e, yaw, pitch), bukkitEntity.getVelocity(), CraftVector.toBukkit(shapedetectorshape.b));
            if (event.callEvent() && event.getTo() != null && this.bq()) {
                worldserver = ((CraftWorld)event.getTo().getWorld()).getHandle();
                position = new Vec3D(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
                yaw = event.getTo().getYaw();
                pitch = event.getTo().getPitch();
                velocity = CraftVector.toNMS(event.getAfter());
            }
            if (worldserver == this.H) {
                this.b(shapedetectorshape.a.c, shapedetectorshape.a.d, shapedetectorshape.a.e, shapedetectorshape.c, shapedetectorshape.d);
                this.f(shapedetectorshape.b);
                return this;
            }
            this.ac();
            this.H.ac().b("reloading");
            if (this instanceof EntityInsentient) {
                ((EntityInsentient)this).a(true, true);
            }
            if ((entity = this.ae().a(worldserver)) != null) {
                ((Entity)entity).t(this);
                ((Entity)entity).b(position.c, position.d, position.e, yaw, pitch);
                ((Entity)entity).f(velocity);
                worldserver.d((Entity)entity);
                if (worldserver.getTypeKey() == WorldDimension.d) {
                    WorldServer.makeObsidianPlatform(worldserver, this);
                }
            }
            this.cn();
            this.H.ac().c();
            ((WorldServer)this.H).g();
            worldserver.g();
            this.H.ac().c();
            return entity;
        }
        return null;
    }

    protected void cn() {
        this.b(RemovalReason.e);
    }

    @javax.annotation.Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        BlockPosition blockposition1;
        boolean flag1;
        if (destination == null) {
            return null;
        }
        boolean flag = this.H.getTypeKey() == WorldDimension.d && destination.getTypeKey() == WorldDimension.b;
        boolean bl = flag1 = destination.getTypeKey() == WorldDimension.d;
        if (!flag && !flag1) {
            CraftPortalEvent event;
            boolean flag2;
            boolean bl2 = flag2 = destination.getTypeKey() == WorldDimension.c;
            if (this.H.getTypeKey() != WorldDimension.c && !flag2) {
                return null;
            }
            WorldBorder worldborder = destination.p_();
            double d0 = DimensionManager.a(this.H.q_(), destination.q_());
            BlockPosition blockposition = worldborder.b(this.dl() * d0, this.dn(), this.dr() * d0);
            int portalSearchRadius = destination.paperConfig().environment.portalSearchRadius;
            if (this.H.paperConfig().environment.portalSearchVanillaDimensionScaling && flag2) {
                portalSearchRadius = (int)((double)portalSearchRadius / destination.q_().k());
            }
            if ((event = this.callPortalEvent(this, destination, new Position(blockposition.u(), blockposition.v(), blockposition.w()), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, portalSearchRadius, destination.paperConfig().environment.portalCreateRadius)) == null) {
                return null;
            }
            WorldServer worldserverFinal = destination = ((CraftWorld)event.getTo().getWorld()).getHandle();
            worldborder = worldserverFinal.p_();
            blockposition = worldborder.b(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
            return this.getExitPortal(destination, blockposition, flag2, worldborder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius()).map(blockutil_rectangle -> {
                Vec3D vec3d;
                EnumDirection.EnumAxis enumdirection_enumaxis;
                IBlockData iblockdata = this.H.a_(this.aw);
                if (iblockdata.b(BlockProperties.H)) {
                    enumdirection_enumaxis = iblockdata.c(BlockProperties.H);
                    BlockUtil.Rectangle blockutil_rectangle1 = BlockUtil.a(this.aw, enumdirection_enumaxis, 21, EnumDirection.EnumAxis.b, 21, blockposition1 -> this.H.a_((BlockPosition)blockposition1) == iblockdata);
                    vec3d = this.a(enumdirection_enumaxis, blockutil_rectangle1);
                } else {
                    enumdirection_enumaxis = EnumDirection.EnumAxis.a;
                    vec3d = new Vec3D(0.5, 0.0, 0.0);
                }
                return BlockPortalShape.createPortalInfo(worldserverFinal, blockutil_rectangle, enumdirection_enumaxis, vec3d, this, this.dj(), this.dw(), this.dy(), event);
            }).orElse(null);
        }
        if (flag1) {
            blockposition1 = WorldServer.a;
        } else {
            destination.l(destination.Q());
            blockposition1 = destination.a(HeightMap.Type.f, destination.Q());
        }
        CraftPortalEvent event = this.callPortalEvent(this, destination, new Position((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5), PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0);
        if (event == null) {
            return null;
        }
        return new ShapeDetectorShape(new Vec3D(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ()), this.dj(), this.dw(), this.dy(), ((CraftWorld)event.getTo().getWorld()).getHandle(), event);
    }

    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return BlockPortalShape.a(portalRect, portalAxis, this.de(), this.a(this.al()));
    }

    protected CraftPortalEvent callPortalEvent(Entity entity, WorldServer exitWorldServer, Position exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld());
        PortalType portalType = switch (cause) {
            case PlayerTeleportEvent.TeleportCause.END_PORTAL -> PortalType.ENDER;
            case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> PortalType.NETHER;
            default -> PortalType.CUSTOM;
        };
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, portalType);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bq()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        return worldserver.o().findPortalAround(blockposition, worldborder, searchRadius);
    }

    public boolean co() {
        return !this.bL() && !this.bM() && this.bq() && this.valid;
    }

    public float a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState, float max) {
        return max;
    }

    public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float explosionPower) {
        return true;
    }

    public int cp() {
        return 3;
    }

    public boolean cq() {
        return false;
    }

    public void a(CrashReportSystemDetails section) {
        section.a("Entity Type", () -> {
            MinecraftKey minecraftkey = EntityTypes.a(this.ae());
            return minecraftkey + " (" + this.getClass().getCanonicalName() + ")";
        });
        section.a("Entity ID", this.q);
        section.a("Entity Name", () -> this.Z().getString());
        section.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dl(), this.dn(), this.dr()));
        section.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.H, MathHelper.a(this.dl()), MathHelper.a(this.dn()), MathHelper.a(this.dr())));
        Vec3D vec3d = this.dj();
        section.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.c, vec3d.d, vec3d.e));
        section.a("Entity's Passengers", () -> this.cM().toString());
        section.a("Entity's Vehicle", () -> String.valueOf(this.cV()));
    }

    public boolean cr() {
        return this.bK() && !this.F_();
    }

    public void a_(UUID uuid) {
        this.ax = uuid;
        this.ay = this.ax.toString();
    }

    @Override
    public UUID cs() {
        return this.ax;
    }

    public String ct() {
        return this.ay;
    }

    public String cu() {
        return this.ay;
    }

    public boolean cv() {
        return true;
    }

    public static double cw() {
        return o;
    }

    public static void b(double value) {
        o = value;
    }

    @Override
    public IChatBaseComponent G_() {
        return ScoreboardTeam.a(this.cb(), this.Z()).a(chatmodifier -> chatmodifier.a(this.cC()).a(this.ct()));
    }

    public void b(@javax.annotation.Nullable IChatBaseComponent name) {
        this.am.b(aR, Optional.ofNullable(name));
    }

    @Override
    @javax.annotation.Nullable
    public IChatBaseComponent ab() {
        return this.am.a(aR).orElse(null);
    }

    @Override
    public boolean aa() {
        return this.am.a(aR).isPresent();
    }

    public void n(boolean visible) {
        this.am.b(aS, visible);
    }

    public boolean cx() {
        return this.am.a(aS);
    }

    public final void n(double destX, double destY, double destZ) {
        if (this.H instanceof WorldServer) {
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(destX, destY, destZ));
            ((WorldServer)this.H).k().a(TicketType.g, chunkcoordintpair, 0, this.af());
            this.H.d(chunkcoordintpair.e, chunkcoordintpair.f);
            this.b(destX, destY, destZ);
        }
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.a(worldserver, d0, d1, d2, set, f2, f1);
    }

    public boolean a(WorldServer world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        float f2 = MathHelper.a(pitch, -90.0f, 90.0f);
        if (world == this.H) {
            this.b(destX, destY, destZ, yaw, f2);
            this.r(yaw);
        } else {
            this.ac();
            Object entity = this.ae().a(world);
            if (entity == null) {
                return false;
            }
            ((Entity)entity).t(this);
            ((Entity)entity).b(destX, destY, destZ, yaw, f2);
            ((Entity)entity).r(yaw);
            this.b(RemovalReason.e);
            world.d((Entity)entity);
        }
        return true;
    }

    public void a(double destX, double destY, double destZ) {
        this.b(destX, destY, destZ);
    }

    public void b(double destX, double destY, double destZ) {
        if (this.H instanceof WorldServer) {
            this.b(destX, destY, destZ, this.dw(), this.dy());
            this.cO().forEach(entity -> {
                for (Entity entity1 : entity.r) {
                    entity.a(entity1, Entity::d);
                }
            });
        }
    }

    public void c(double offsetX, double offsetY, double offsetZ) {
        this.b(this.dl() + offsetX, this.dn() + offsetY, this.dr() + offsetZ);
    }

    public boolean cy() {
        return this.cx();
    }

    public void a(List<DataWatcher.b<?>> dataEntries) {
    }

    public void a(DataWatcherObject<?> data) {
        if (ar.equals(data)) {
            this.c_();
        }
    }

    @Deprecated
    protected void cz() {
        EntitySize entitysize;
        EntityPose entitypose = this.al();
        this.be = entitysize = this.a(entitypose);
        this.bf = this.a(entitypose, entitysize);
    }

    public void c_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.be;
        EntityPose entitypose = this.al();
        this.be = entitysize1 = this.a(entitypose);
        this.bf = this.a(entitypose, entitysize1);
        this.an();
        boolean bl = flag = (double)entitysize1.a <= 4.0 && (double)entitysize1.b <= 4.0;
        if (!(this.H.B || this.al || this.ae || !flag || !(entitysize1.a > entitysize.a) && !(entitysize1.b > entitysize.b) || this instanceof EntityHuman)) {
            Vec3D vec3d = this.de().b(0.0, (double)entitysize.b / 2.0, 0.0);
            double d0 = (double)Math.max(0.0f, entitysize1.a - entitysize.a) + 1.0E-6;
            double d1 = (double)Math.max(0.0f, entitysize1.b - entitysize.b) + 1.0E-6;
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, d1, d0));
            this.H.a(this, voxelshape, vec3d, (double)entitysize1.a, (double)entitysize1.b, (double)entitysize1.a).ifPresent(vec3d1 -> this.a(vec3d1.b(0.0, (double)(-entitysize1.b) / 2.0, 0.0)));
        }
    }

    public EnumDirection cA() {
        return EnumDirection.a(this.dw());
    }

    public EnumDirection cB() {
        return this.cA();
    }

    protected ChatHoverable cC() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.c, new ChatHoverable.b(this.ae(), this.cs(), this.Z()));
    }

    public boolean a(EntityPlayer spectator) {
        return true;
    }

    @Override
    public final AxisAlignedBB cD() {
        return this.aG;
    }

    public AxisAlignedBB A_() {
        return this.cD();
    }

    protected AxisAlignedBB e(EntityPose pos) {
        EntitySize entitysize = this.a(pos);
        float f2 = entitysize.a / 2.0f;
        Vec3D vec3d = new Vec3D(this.dl() - (double)f2, this.dn(), this.dr() - (double)f2);
        Vec3D vec3d1 = new Vec3D(this.dl() + (double)f2, this.dn() + (double)entitysize.b, this.dr() + (double)f2);
        return new AxisAlignedBB(vec3d, vec3d1);
    }

    public final void a(AxisAlignedBB boundingBox) {
        double minX = boundingBox.a;
        double minY = boundingBox.b;
        double minZ = boundingBox.c;
        double maxX = boundingBox.d;
        double maxY = boundingBox.e;
        double maxZ = boundingBox.f;
        double len = boundingBox.d - boundingBox.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = boundingBox.e - boundingBox.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = boundingBox.f - boundingBox.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aG = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float a(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.85f;
    }

    public float f(EntityPose pose) {
        return this.a(pose, this.a(pose));
    }

    public final float cE() {
        return this.bf;
    }

    public Vec3D t(float tickDelta) {
        return this.cF();
    }

    protected Vec3D cF() {
        return new Vec3D(0.0, this.cE(), this.dc() * 0.4f);
    }

    public SlotAccess a_(int mappedIndex) {
        return SlotAccess.b;
    }

    @Override
    public void a(IChatBaseComponent message) {
    }

    public net.minecraft.world.level.World cG() {
        return this.H;
    }

    @javax.annotation.Nullable
    public MinecraftServer cH() {
        return this.H.n();
    }

    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean cI() {
        return false;
    }

    public void a(EntityLiving attacker, Entity target) {
        if (target instanceof EntityLiving) {
            EnchantmentManager.a((EntityLiving)target, (Entity)attacker);
        }
        EnchantmentManager.b(attacker, target);
    }

    public void c(EntityPlayer player) {
        if (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public void d(EntityPlayer player) {
        if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerUntrackEntityEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public float a(EnumBlockRotation rotation) {
        float f2 = MathHelper.g(this.dw());
        switch (rotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror mirror) {
        float f2 = MathHelper.g(this.dw());
        switch (mirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public boolean cJ() {
        return false;
    }

    @javax.annotation.Nullable
    public EntityLiving cK() {
        return null;
    }

    public final boolean cL() {
        return this.cK() != null;
    }

    public final List<Entity> cM() {
        return this.r;
    }

    @javax.annotation.Nullable
    public Entity cN() {
        return this.r.isEmpty() ? null : (Entity)this.r.get(0);
    }

    public boolean u(Entity passenger) {
        return this.r.contains((Object)passenger);
    }

    public boolean a(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.r.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> p() {
        if (this.r.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.r.stream().flatMap(Entity::cO);
    }

    public Stream<Entity> cO() {
        if (this.r.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.p());
    }

    public Stream<Entity> cP() {
        if (this.r.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.r.stream().flatMap(Entity::cP), Stream.of(this));
    }

    public Iterable<Entity> cQ() {
        if (this.r.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder indirectPassengers = ImmutableList.builder();
        for (Entity passenger : this.r) {
            indirectPassengers.add((Object)passenger);
            indirectPassengers.addAll(passenger.cQ());
        }
        return indirectPassengers.build();
    }

    private Iterable<Entity> getIndirectPassengers_old() {
        return () -> this.p().iterator();
    }

    public boolean hasAnyPlayerPassengers() {
        if (this.r.isEmpty()) {
            return false;
        }
        return this.p().anyMatch(entity -> entity instanceof EntityHuman);
    }

    public boolean cR() {
        if (this.r.isEmpty()) {
            return false;
        }
        return this.p().filter(entity -> entity instanceof EntityHuman).count() == 1L;
    }

    public Entity cS() {
        Entity entity = this;
        while (entity.bL()) {
            entity = entity.cV();
        }
        return entity;
    }

    public boolean v(Entity entity) {
        return this.cS() == entity.cS();
    }

    public boolean w(Entity passenger) {
        if (!passenger.bL()) {
            return false;
        }
        Entity entity1 = passenger.cV();
        return entity1 == this ? true : this.w(entity1);
    }

    public boolean cT() {
        EntityLiving entityliving = this.cK();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            return entityhuman.g();
        }
        return this.cU();
    }

    public boolean cU() {
        return !this.H.B;
    }

    protected static Vec3D a(double vehicleWidth, double passengerWidth, float passengerYaw) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a(passengerYaw * ((float)Math.PI / 180));
        float f2 = MathHelper.b(passengerYaw * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f2));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f2 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dl(), this.cD().e, this.dr());
    }

    @javax.annotation.Nullable
    public Entity cV() {
        return this.s;
    }

    @javax.annotation.Nullable
    public Entity cW() {
        return this.s != null && this.s.cK() == this ? this.s : null;
    }

    public EnumPistonReaction C_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory cX() {
        return SoundCategory.g;
    }

    public int cY() {
        return 1;
    }

    public CommandListenerWrapper cZ() {
        return new CommandListenerWrapper(this, this.de(), this.bD(), this.H instanceof WorldServer ? (WorldServer)this.H : null, this.B(), this.Z().getString(), this.G_(), this.H.n(), this);
    }

    protected int B() {
        return 0;
    }

    public boolean k(int permissionLevel) {
        return this.B() >= permissionLevel;
    }

    @Override
    public boolean d_() {
        return this.H.W().b(GameRules.o);
    }

    @Override
    public boolean j_() {
        return true;
    }

    @Override
    public boolean M_() {
        return true;
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        Vec3D vec3d1 = anchorPoint.a(this);
        double d0 = target.c - vec3d1.c;
        double d1 = target.d - vec3d1.d;
        double d2 = target.e - vec3d1.e;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.e(MathHelper.g((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.f(MathHelper.g((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.r(this.dw());
        this.M = this.dy();
        this.L = this.dw();
    }

    public boolean a(TagKey<FluidType> tag, double speed) {
        if (!LeavesConfig.reduceEntityFluidLookup && this.da()) {
            return false;
        }
        AxisAlignedBB axisalignedbb = this.cD().h(0.001);
        int minBlockX = MathHelper.a(axisalignedbb.a);
        int maxBlockX = MathHelper.c(axisalignedbb.d);
        int minBlockY = MathHelper.a(axisalignedbb.b);
        int maxBlockY = MathHelper.c(axisalignedbb.e);
        int minBlockZ = MathHelper.a(axisalignedbb.c);
        int maxBlockZ = MathHelper.c(axisalignedbb.f);
        double d1 = 0.0;
        boolean flag = this.cv();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.b;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        if (LeavesConfig.reduceEntityFluidLookup) {
            int minSection = WorldUtil.getMinSection(this.H);
            int maxSection = WorldUtil.getMaxSection(this.H);
            int minBlock = minSection << 4;
            int maxBlock = maxSection << 4 | 0xF;
            if (minBlockY > maxBlock || maxBlockY < minBlock) {
                return false;
            }
            int minYIterate = Math.max(minBlock, minBlockY);
            int maxYIterate = Math.min(maxBlock, maxBlockY);
            int minChunkX = minBlockX >> 4;
            int maxChunkX = maxBlockX >> 4;
            int minChunkZ = minBlockZ >> 4;
            int maxChunkZ = maxBlockZ >> 4;
            for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
                int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 16;
                for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                    int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 16;
                    IChunkAccess chunk = this.H.getChunkIfLoadedImmediately(currChunkX, currChunkZ);
                    if (chunk == null) {
                        return false;
                    }
                    ChunkSection[] sections = chunk.d();
                    for (int currY = minYIterate; currY < maxYIterate; ++currY) {
                        ChunkSection section = sections[(currY >> 4) - minSection];
                        if (section == null || section.c() || section.fluidStateCount == 0) {
                            currY = (currY & 0xFFFFFFF0) + 15;
                            continue;
                        }
                        DataPaletteBlock<IBlockData> blocks = section.i;
                        for (int currZ = minZ; currZ < maxZ; ++currZ) {
                            for (int currX = minX; currX < maxX; ++currX) {
                                Fluid fluid = blocks.a(currX & 0xF, currY & 0xF, currZ & 0xF).r();
                                if (!fluid.a(tag)) continue;
                                blockposition_mutableblockposition.d((currChunkX << 4) + currX, currY, (currChunkZ << 4) + currZ);
                                double d2 = (float)currY + fluid.a((IBlockAccess)this.H, (BlockPosition)blockposition_mutableblockposition);
                                if (!(d2 >= axisalignedbb.b)) continue;
                                flag1 = true;
                                d1 = Math.max(d2 - axisalignedbb.b, d1);
                                if (flag) {
                                    Vec3D vec3d1 = fluid.c(this.H, blockposition_mutableblockposition);
                                    if (d1 < 0.4) {
                                        vec3d1 = vec3d1.a(d1);
                                    }
                                    vec3d = vec3d.e(vec3d1);
                                    ++k1;
                                }
                                if (tag != TagsFluid.b) continue;
                                this.lastLavaContact = blockposition_mutableblockposition.i();
                            }
                        }
                    }
                }
            }
        } else {
            for (int l1 = minBlockX; l1 < maxBlockX; ++l1) {
                for (int i2 = minBlockY; i2 < maxBlockY; ++i2) {
                    for (int j2 = minBlockZ; j2 < maxBlockZ; ++j2) {
                        double d2;
                        blockposition_mutableblockposition.d(l1, i2, j2);
                        Fluid fluid = this.H.b_(blockposition_mutableblockposition);
                        if (!fluid.a(tag) || !((d2 = (double)((float)i2 + fluid.a((IBlockAccess)this.H, (BlockPosition)blockposition_mutableblockposition))) >= axisalignedbb.b)) continue;
                        flag1 = true;
                        d1 = Math.max(d2 - axisalignedbb.b, d1);
                        if (flag) {
                            Vec3D vec3d1 = fluid.c(this.H, blockposition_mutableblockposition);
                            if (d1 < 0.4) {
                                vec3d1 = vec3d1.a(d1);
                            }
                            vec3d = vec3d.e(vec3d1);
                            ++k1;
                        }
                        if (tag != TagsFluid.b) continue;
                        this.lastLavaContact = blockposition_mutableblockposition.i();
                    }
                }
            }
        }
        if (vec3d.f() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.a(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.d();
            }
            Vec3D vec3d2 = this.dj();
            vec3d = vec3d.a(speed * 1.0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.c) < 0.003 && Math.abs(vec3d2.e) < 0.003 && vec3d.f() < 0.0045000000000000005) {
                vec3d = vec3d.d().a(0.0045000000000000005);
            }
            this.f(this.dj().e(vec3d));
        }
        this.ai.put(tag, d1);
        return flag1;
    }

    public boolean da() {
        int l2;
        AxisAlignedBB axisalignedbb = this.cD().g(1.0);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.c);
        return !this.H.b(i2, k2, j2, l2 = MathHelper.c(axisalignedbb.f));
    }

    public double b(TagKey<FluidType> fluid) {
        return this.ai.getDouble(fluid);
    }

    public double db() {
        return (double)this.cE() < 0.4 ? 0.0 : 0.4;
    }

    public final float dc() {
        return this.be.a;
    }

    public final float dd() {
        return this.be.b;
    }

    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    public EntitySize a(EntityPose pose) {
        return this.p.n();
    }

    public Vec3D de() {
        return this.t;
    }

    public Vec3D df() {
        return this.de();
    }

    @Override
    public BlockPosition dg() {
        return this.u;
    }

    public IBlockData dh() {
        if (this.bj == null) {
            this.bj = this.H.a_(this.dg());
        }
        return this.bj;
    }

    public ChunkCoordIntPair di() {
        return this.aC;
    }

    public Vec3D dj() {
        return this.aD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void f(Vec3D velocity) {
        Object object = this.posLock;
        synchronized (object) {
            this.aD = velocity;
        }
    }

    public void g(Vec3D velocity) {
        this.f(this.dj().e(velocity));
    }

    public void o(double x2, double y2, double z2) {
        this.f(new Vec3D(x2, y2, z2));
    }

    public final int dk() {
        return this.u.u();
    }

    public final double dl() {
        return this.t.c;
    }

    public double c(double widthScale) {
        return this.t.c + (double)this.dc() * widthScale;
    }

    public double d(double widthScale) {
        return this.c((2.0 * this.af.j() - 1.0) * widthScale);
    }

    public final int dm() {
        return this.u.v();
    }

    public final double dn() {
        return this.t.d;
    }

    public double e(double heightScale) {
        return this.t.d + (double)this.dd() * heightScale;
    }

    public double do() {
        return this.e(this.af.j());
    }

    public double dp() {
        return this.t.d + (double)this.bf;
    }

    public final int dq() {
        return this.u.w();
    }

    public final double dr() {
        return this.t.e;
    }

    public double f(double widthScale) {
        return this.t.e + (double)this.dc() * widthScale;
    }

    public double g(double widthScale) {
        return this.f((2.0 * this.af.j() - 1.0) * widthScale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        String entityInfo = null;
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        c.error("New entity position is invalid! Tried to set invalid position (" + newX + "," + newY + "," + newZ + ") for entity " + entity.getClass().getName() + " located at " + entity.t + ", entity info: " + entityInfo, new Throwable());
        return false;
    }

    public final void p(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x2, double y2, double z2, boolean forceBoundingBoxUpdate) {
        if (!Entity.checkPosition(this, x2, y2, z2)) {
            return;
        }
        if (this.updatingSectionStatus) {
            c.error("Refusing to update position for entity " + this + " to position " + new Vec3D(x2, y2, z2) + " since it is processing a section status update", new Throwable());
            return;
        }
        if (this instanceof EntityItem && GlobalConfiguration.get().misc.fixEntityPositionDesync) {
            x2 = (double)MathHelper.b(x2 * 4096.0) * 2.44140625E-4;
            y2 = (double)MathHelper.b(y2 * 4096.0) * 2.44140625E-4;
            z2 = (double)MathHelper.b(z2 * 4096.0) * 2.44140625E-4;
        }
        if (this.t.c != x2 || this.t.d != y2 || this.t.e != z2) {
            Object object = this.posLock;
            synchronized (object) {
                this.t = new Vec3D(x2, y2, z2);
            }
            int i2 = MathHelper.a(x2);
            int j2 = MathHelper.a(y2);
            int k2 = MathHelper.a(z2);
            if (i2 != this.u.u() || j2 != this.u.v() || k2 != this.u.w()) {
                this.u = new BlockPosition(i2, j2, k2);
                this.bj = null;
                if (SectionPosition.a(i2) != this.aC.e || SectionPosition.a(k2) != this.aC.f) {
                    this.aC = new ChunkCoordIntPair(this.u);
                }
            }
            this.aW.a();
        }
        if (!(this instanceof EntityHanging) && (forceBoundingBoxUpdate || this.t.c != x2 || this.t.d != y2 || this.t.e != z2)) {
            this.a(this.am());
        }
    }

    public void ds() {
    }

    public Vec3D u(float delta) {
        return this.p(delta).b(0.0, (double)this.bf * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packet) {
        int i2 = packet.a();
        double d0 = packet.e();
        double d1 = packet.f();
        double d2 = packet.g();
        this.f(d0, d1, d2);
        this.d(d0, d1, d2);
        this.e(packet.k());
        this.f(packet.l());
        this.e(i2);
        this.a_(packet.c());
    }

    @javax.annotation.Nullable
    public ItemStack dt() {
        return null;
    }

    public void o(boolean inPowderSnow) {
        this.az = inPowderSnow;
    }

    public boolean du() {
        return !this.ae().a(TagsEntity.i);
    }

    public boolean dv() {
        return (this.az || this.aA) && this.du();
    }

    public float dw() {
        return this.aE;
    }

    public float dx() {
        return this.dw();
    }

    public void f(float yaw) {
        if (!Float.isFinite(yaw)) {
            SystemUtils.a("Invalid entity rotation: " + yaw + ", discarding.");
        } else {
            this.aE = yaw;
        }
    }

    public float dy() {
        return this.aF;
    }

    public void e(float pitch) {
        if (!Float.isFinite(pitch)) {
            SystemUtils.a("Invalid entity rotation: " + pitch + ", discarding.");
        } else {
            this.aF = pitch;
        }
    }

    public boolean dz() {
        return false;
    }

    public float dA() {
        return this.aJ;
    }

    public void v(float stepHeight) {
        this.aJ = stepHeight;
    }

    public final boolean dB() {
        return this.aH != null;
    }

    @javax.annotation.Nullable
    public RemovalReason dC() {
        return this.aH;
    }

    @Override
    public final void b(RemovalReason reason) {
        TickThread.ensureTickThread(this, "Cannot remove entity off-main");
        if (this.updatingSectionStatus) {
            c.warn("Entity " + this + " is currently prevented from being added/removed to world since it is processing section status updates", new Throwable());
            return;
        }
        if (this.aH == null) {
            this.aH = reason;
        }
        if (this.aH.a()) {
            this.bz();
        }
        if (reason != RemovalReason.c) {
            this.cM().forEach(Entity::bz);
        }
        this.aW.a(reason);
    }

    public void dD() {
        this.aH = null;
    }

    @Override
    public void a(EntityInLevelCallback changeListener) {
        this.aW = changeListener;
    }

    @Override
    public boolean dE() {
        return this.aH != null && !this.aH.b() ? false : (this.bL() ? false : !this.bM() || !this.hasAnyPlayerPassengers());
    }

    @Override
    public boolean dF() {
        return false;
    }

    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return true;
    }

    public net.minecraft.world.level.World Y() {
        return this.H;
    }

    public DamageSources dG() {
        return this.H.af();
    }

    public static int nextEntityId() {
        return d.incrementAndGet();
    }

    public boolean isTicking() {
        return ((ChunkProviderServer)this.H.I()).isPositionTicking(this);
    }

    public NBTTagCompound getLeavesData() {
        return this.leavesData;
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private static final class RandomRandomSource
    extends Random
    implements BitRandomSource {
        private boolean locked = false;

        private RandomRandomSource() {
        }

        @Override
        public synchronized void b(long seed) {
            if (this.locked) {
                c.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.setSeed(seed);
                this.locked = true;
            }
        }

        @Override
        public RandomSource d() {
            return new LegacyRandomSource(this.g());
        }

        @Override
        public PositionalRandomFactory e() {
            return new LegacyRandomSource.a(this.g());
        }

        @Override
        public int c(int bits) {
            return super.next(bits);
        }

        @Override
        public int b(int origin, int bound) {
            return BitRandomSource.super.b(origin, bound);
        }

        @Override
        public long g() {
            return BitRandomSource.super.g();
        }

        @Override
        public int f() {
            return BitRandomSource.super.f();
        }

        @Override
        public int a(int bound) {
            return BitRandomSource.super.a(bound);
        }

        @Override
        public boolean h() {
            return BitRandomSource.super.h();
        }

        @Override
        public float i() {
            return BitRandomSource.super.i();
        }

        @Override
        public double j() {
            return BitRandomSource.super.j();
        }

        @Override
        public double k() {
            return super.nextGaussian();
        }
    }
}

