/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger d = LogUtils.getLogger();
    private static final int e = 5;
    private static final DataWatcherObject<Float> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> i = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float j = 32.0f;
    private static final float k = 0.5f;
    private static final float l = 3.0f;
    public static final float b = 6.0f;
    public static final float c = 0.5f;
    private PotionRegistry m = Potions.b;
    public List<MobEffect> n = Lists.newArrayList();
    private final Map<Entity, Integer> o = Maps.newHashMap();
    private int p = 600;
    public int q = 20;
    public int r = 20;
    private boolean s;
    public int t;
    public float u;
    public float aC;
    @Nullable
    private EntityLiving aD;
    @Nullable
    private UUID aE;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> type, World world) {
        super(type, world);
        this.ae = true;
    }

    public EntityAreaEffectCloud(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.c, world);
        this.e(x2, y2, z2);
    }

    @Override
    protected void a_() {
        this.aj().a(g, 0);
        this.aj().a(f, Float.valueOf(3.0f));
        this.aj().a(h, false);
        this.aj().a(i, Particles.v);
    }

    public void a(float radius) {
        if (!this.H.B) {
            this.aj().b(f, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void c_() {
        double d0 = this.dl();
        double d1 = this.dn();
        double d2 = this.dr();
        super.c_();
        this.e(d0, d1, d2);
    }

    public float h() {
        return this.aj().a(f).floatValue();
    }

    public void a(PotionRegistry potion) {
        this.m = potion;
        if (!this.s) {
            this.w();
        }
    }

    private void w() {
        if (this.m == Potions.b && this.n.isEmpty()) {
            this.aj().b(g, 0);
        } else {
            this.aj().b(g, PotionUtil.a(PotionUtil.a(this.m, this.n)));
        }
    }

    public void a(MobEffect effect) {
        this.n.add(effect);
        if (!this.s) {
            this.w();
        }
    }

    public void refreshEffects() {
        if (!this.s) {
            this.aj().b(g, PotionUtil.a(PotionUtil.a(this.m, this.n)));
        }
    }

    public String getPotionType() {
        return BuiltInRegistries.j.b(this.m).toString();
    }

    public void setPotionType(String string) {
        this.a(BuiltInRegistries.j.a(new MinecraftKey(string)));
    }

    public int i() {
        return this.aj().a(g);
    }

    public void a(int rgb) {
        this.s = true;
        this.aj().b(g, rgb);
    }

    public ParticleParam j() {
        return this.aj().a(i);
    }

    public void a(ParticleParam particle) {
        this.aj().b(i, particle);
    }

    protected void a(boolean waiting) {
        this.aj().b(h, waiting);
    }

    @Override
    public boolean k() {
        return this.aj().a(h);
    }

    public int m() {
        return this.p;
    }

    public void b(int duration) {
        this.p = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.ag >= this.q + this.p) {
            this.ai();
            return;
        }
    }

    @Override
    public void l() {
        block22: {
            ArrayList list;
            float f2;
            block23: {
                boolean flag1;
                boolean flag;
                block21: {
                    float f1;
                    int i2;
                    super.l();
                    flag = this.k();
                    f2 = this.h();
                    if (!this.H.B) break block21;
                    if (flag && this.af.h()) {
                        return;
                    }
                    ParticleParam particleparam = this.j();
                    if (flag) {
                        i2 = 2;
                        f1 = 0.2f;
                    } else {
                        i2 = MathHelper.f((float)Math.PI * f2 * f2);
                        f1 = f2;
                    }
                    for (int j2 = 0; j2 < i2; ++j2) {
                        double d5;
                        double d4;
                        double d3;
                        float f22 = this.af.i() * ((float)Math.PI * 2);
                        float f3 = MathHelper.c(this.af.i()) * f1;
                        double d0 = this.dl() + (double)(MathHelper.b(f22) * f3);
                        double d1 = this.dn();
                        double d2 = this.dr() + (double)(MathHelper.a(f22) * f3);
                        if (particleparam.b() == Particles.v) {
                            int k2 = flag && this.af.h() ? 0xFFFFFF : this.i();
                            d3 = (float)(k2 >> 16 & 0xFF) / 255.0f;
                            d4 = (float)(k2 >> 8 & 0xFF) / 255.0f;
                            d5 = (float)(k2 & 0xFF) / 255.0f;
                        } else if (flag) {
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        } else {
                            d3 = (0.5 - this.af.j()) * 0.15;
                            d4 = 0.01f;
                            d5 = (0.5 - this.af.j()) * 0.15;
                        }
                        this.H.b(particleparam, d0, d1, d2, d3, d4, d5);
                    }
                    break block22;
                }
                if (this.ag >= this.q + this.p) {
                    this.ai();
                    return;
                }
                boolean bl = flag1 = this.ag < this.q;
                if (flag != flag1) {
                    this.a(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.aC != 0.0f) {
                    if ((f2 += this.aC) < 0.5f) {
                        this.ai();
                        return;
                    }
                    this.a(f2);
                }
                if (this.ag % 5 != 0) break block22;
                this.o.entrySet().removeIf(entry -> this.ag >= (Integer)entry.getValue());
                list = Lists.newArrayList();
                for (MobEffect mobeffect : this.m.a()) {
                    list.add(new MobEffect(mobeffect.c(), mobeffect.a(l2 -> l2 / 4), mobeffect.e(), mobeffect.f(), mobeffect.g()));
                }
                list.addAll(this.n);
                if (!list.isEmpty()) break block23;
                this.o.clear();
                break block22;
            }
            List<EntityLiving> list1 = this.H.a(EntityLiving.class, this.cD());
            if (list1.isEmpty()) break block22;
            Iterator<EntityLiving> iterator1 = list1.iterator();
            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
            while (iterator1.hasNext()) {
                double d7;
                double d6;
                double d8;
                EntityLiving entityliving = iterator1.next();
                if (this.o.containsKey(entityliving) || !entityliving.fp() || !((d8 = (d6 = entityliving.dl() - this.dl()) * d6 + (d7 = entityliving.dr() - this.dr()) * d7) <= (double)(f2 * f2))) continue;
                entities.add((LivingEntity)entityliving.getBukkitEntity());
            }
            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
            if (!event.isCancelled()) {
                for (LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof CraftLivingEntity)) continue;
                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                    this.o.put(entityliving, this.ag + this.r);
                    for (MobEffect mobeffect1 : list) {
                        if (mobeffect1.c().a()) {
                            mobeffect1.c().a(this, this.s(), entityliving, mobeffect1.e(), 0.5);
                            continue;
                        }
                        entityliving.addEffect(new MobEffect(mobeffect1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                    }
                    if (this.u != 0.0f) {
                        if ((f2 += this.u) < 0.5f) {
                            this.ai();
                            return;
                        }
                        this.a(f2);
                    }
                    if (this.t == 0) continue;
                    this.p += this.t;
                    if (this.p > 0) continue;
                    this.ai();
                    return;
                }
            }
        }
    }

    public float o() {
        return this.u;
    }

    public void b(float radiusOnUse) {
        this.u = radiusOnUse;
    }

    public float p() {
        return this.aC;
    }

    public void c(float radiusGrowth) {
        this.aC = radiusGrowth;
    }

    public int q() {
        return this.t;
    }

    public void c(int durationOnUse) {
        this.t = durationOnUse;
    }

    public int r() {
        return this.q;
    }

    public void d(int waitTime) {
        this.q = waitTime;
    }

    public void a(@Nullable EntityLiving owner) {
        this.aD = owner;
        this.aE = owner == null ? null : owner.cs();
    }

    @Nullable
    public EntityLiving s() {
        Entity entity;
        if (this.aD == null && this.aE != null && this.H instanceof WorldServer && (entity = ((WorldServer)this.H).a(this.aE)) instanceof EntityLiving) {
            this.aD = (EntityLiving)entity;
        }
        return this.aD;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.ag = nbt.h("Age");
        this.p = nbt.h("Duration");
        this.q = nbt.h("WaitTime");
        this.r = nbt.h("ReapplicationDelay");
        this.t = nbt.h("DurationOnUse");
        this.u = nbt.j("RadiusOnUse");
        this.aC = nbt.j("RadiusPerTick");
        this.a(nbt.j("Radius"));
        if (nbt.b("Owner")) {
            this.aE = nbt.a("Owner");
        }
        if (nbt.b("Particle", 8)) {
            try {
                this.a(ArgumentParticle.a(new StringReader(nbt.l("Particle")), BuiltInRegistries.k.p()));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                d.warn("Couldn't load custom particle {}", (Object)nbt.l("Particle"), (Object)commandsyntaxexception);
            }
        }
        if (nbt.b("Color", 99)) {
            this.a(nbt.h("Color"));
        }
        if (nbt.b("Potion", 8)) {
            this.a(PotionUtil.c(nbt));
        }
        if (nbt.b("Effects", 9)) {
            NBTTagList nbttaglist = nbt.c("Effects", 10);
            this.n.clear();
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                MobEffect mobeffect = MobEffect.b(nbttaglist.a(i2));
                if (mobeffect == null) continue;
                this.a(mobeffect);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Age", this.ag);
        nbt.a("Duration", this.p);
        nbt.a("WaitTime", this.q);
        nbt.a("ReapplicationDelay", this.r);
        nbt.a("DurationOnUse", this.t);
        nbt.a("RadiusOnUse", this.u);
        nbt.a("RadiusPerTick", this.aC);
        nbt.a("Radius", this.h());
        nbt.a("Particle", this.j().a());
        if (this.aE != null) {
            nbt.a("Owner", this.aE);
        }
        if (this.s) {
            nbt.a("Color", this.i());
        }
        if (this.m != Potions.b) {
            nbt.a("Potion", BuiltInRegistries.j.b(this.m).toString());
        }
        if (!this.n.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.n) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbt.a("Effects", nbttaglist);
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (f.equals(data)) {
            this.c_();
        }
        super.a(data);
    }

    public PotionRegistry t() {
        return this.m;
    }

    @Override
    public EnumPistonReaction C_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.h() * 2.0f, 0.5f);
    }
}

