/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftMob;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import top.leavesmc.leaves.LeavesConfig;

public abstract class EntityInsentient
extends EntityLiving
implements Targeting {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int c = 1;
    private static final int d = 2;
    private static final int e = 4;
    protected static final int f = 1;
    private static final BaseBlockPosition bR = new BaseBlockPosition(1, 0, 1);
    public static final float bz = 0.15f;
    public static final float bA = 0.55f;
    public static final float bB = 0.5f;
    public static final float bC = 0.25f;
    public static final String bD = "Leash";
    public static final float bE = 0.085f;
    public static final int bF = 2;
    public static final int bG = 2;
    public int bH;
    protected int bI;
    protected ControllerLook bJ;
    protected ControllerMove bK;
    protected ControllerJump bL;
    private final EntityAIBodyControl bS;
    protected NavigationAbstract bM;
    public PathfinderGoalSelector bN;
    @Nullable
    public PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector bO;
    @Nullable
    private EntityLiving bT;
    private final EntitySenses bU;
    private final NonNullList<ItemStack> bV = NonNullList.a(2, ItemStack.b);
    public final float[] bP = new float[2];
    private final NonNullList<ItemStack> bW = NonNullList.a(4, ItemStack.b);
    public final float[] bQ = new float[4];
    private boolean bX;
    private boolean bY;
    private final Map<PathType, Float> bZ = Maps.newEnumMap(PathType.class);
    @Nullable
    public MinecraftKey ca;
    public long cb;
    @Nullable
    private Entity cc;
    private int cd;
    @Nullable
    private NBTTagCompound ce;
    private BlockPosition cf = BlockPosition.b;
    private float cg = -1.0f;
    public boolean aware = true;
    int inactiveTickDisableCounter = 0;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        this.bN = new PathfinderGoalSelector(world.ad());
        this.bO = new PathfinderGoalSelector(world.ad());
        this.bJ = new ControllerLook(this);
        this.bK = new ControllerMove(this);
        this.bL = new ControllerJump(this);
        this.bS = this.A();
        this.bM = this.a(world);
        this.bU = new EntitySenses(this);
        Arrays.fill(this.bQ, 0.085f);
        Arrays.fill(this.bP, 0.085f);
        if (world != null && !world.B) {
            this.x();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.bY = persistenceRequired;
    }

    protected void x() {
    }

    public static AttributeProvider.Builder y() {
        return EntityLiving.dJ().a(GenericAttributes.b, 16.0).a(GenericAttributes.g);
    }

    protected NavigationAbstract a(World world) {
        return new Navigation(this, world);
    }

    protected boolean z() {
        return false;
    }

    public float a(PathType nodeType) {
        EntityInsentient entityinsentient1;
        Entity entity = this.cW();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).z() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.bZ.get((Object)nodeType);
        return ofloat == null ? nodeType.a() : ofloat.floatValue();
    }

    public void a(PathType nodeType, float penalty) {
        this.bZ.put(nodeType, Float.valueOf(penalty));
    }

    protected EntityAIBodyControl A() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook C() {
        return this.bJ;
    }

    @Override
    public void inactiveTick() {
        boolean isThrottled;
        super.inactiveTick();
        boolean bl = isThrottled = LeavesConfig.throttleInactiveGoalSelectorTick && this.inactiveTickDisableCounter++ % 20 != 0;
        if (this.bN.inactiveTick() && !isThrottled) {
            this.bN.a();
        }
        if (this.bO.inactiveTick()) {
            this.bO.a();
        }
    }

    public ControllerMove D() {
        Entity entity = this.cW();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.D();
        }
        return this.bK;
    }

    public ControllerJump E() {
        return this.bL;
    }

    public NavigationAbstract G() {
        Entity entity = this.cW();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.G();
        }
        return this.bM;
    }

    @Override
    @Nullable
    public EntityLiving cK() {
        Entity entity;
        if (!this.fK() && (entity = this.cN()) instanceof EntityInsentient) {
            EntityInsentient entityinsentient1;
            EntityInsentient entityinsentient = entityinsentient1 = (EntityInsentient)entity;
            return entityinsentient;
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses I() {
        return this.bU;
    }

    @Override
    @Nullable
    public EntityLiving P_() {
        return this.bT;
    }

    public CraftMob getBukkitMob() {
        return (CraftMob)super.getBukkitEntity();
    }

    public void i(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.P_() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.P_() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.P_().bq() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.H.getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.H.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.bT = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.Q;
    }

    public boolean a(ItemProjectileWeapon weapon) {
        return false;
    }

    public void J() {
        this.a(GameEvent.n);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, (byte)0);
    }

    public int K() {
        return 80;
    }

    public void L() {
        SoundEffect soundeffect = this.s();
        if (soundeffect != null) {
            this.a(soundeffect, this.eN(), this.eO());
        }
    }

    @Override
    public void ao() {
        super.ao();
        this.H.ac().a("mobBaseTick");
        if (this.bq() && this.af.a(1000) < this.bH++) {
            this.q();
            this.L();
        }
        this.H.ac().c();
    }

    @Override
    protected void e(DamageSource source) {
        this.q();
        super.e(source);
    }

    private void q() {
        this.bH = -this.K();
    }

    @Override
    public int dX() {
        if (this.bI > 0) {
            int j2;
            int i2 = this.bI;
            for (j2 = 0; j2 < this.bW.size(); ++j2) {
                if (this.bW.get(j2).b() || !(this.bQ[j2] <= 1.0f)) continue;
                i2 += 1 + this.af.a(3);
            }
            for (j2 = 0; j2 < this.bV.size(); ++j2) {
                if (this.bV.get(j2).b() || !(this.bP[j2] <= 1.0f)) continue;
                i2 += 1 + this.af.a(3);
            }
            return i2;
        }
        return this.bI;
    }

    public void M() {
        if (this.H.B) {
            for (int i2 = 0; i2 < 20; ++i2) {
                double d0 = this.af.k() * 0.02;
                double d1 = this.af.k() * 0.02;
                double d2 = this.af.k() * 0.02;
                double d3 = 10.0;
                this.H.a(Particles.Y, this.c(1.0) - d0 * 10.0, this.do() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.H.a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 20) {
            this.M();
        } else {
            super.b(status);
        }
    }

    @Override
    public void l() {
        super.l();
        if (!this.H.B) {
            this.fH();
            if (this.ag % 5 == 0) {
                this.N();
            }
        }
    }

    protected void N() {
        boolean flag = !(this.cK() instanceof EntityInsentient);
        boolean flag1 = !(this.cV() instanceof EntityBoat);
        this.bN.a(PathfinderGoal.Type.a, flag);
        this.bN.a(PathfinderGoal.Type.c, flag && flag1);
        this.bN.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected float e(float bodyRotation, float headRotation) {
        this.bS.a();
        return headRotation;
    }

    @Nullable
    protected SoundEffect s() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.s();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound2;
        super.b(nbt);
        nbt.a("CanPickUpLoot", this.fA());
        nbt.a("PersistenceRequired", this.bY);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.bW) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ItemStack itemstack1 : this.bV) {
            nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbt.a("HandItems", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (float f2 : this.bQ) {
            nbttaglist2.add(NBTTagFloat.a(f2));
        }
        nbt.a("ArmorDropChances", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (float f1 : this.bP) {
            nbttaglist3.add(NBTTagFloat.a(f1));
        }
        nbt.a("HandDropChances", nbttaglist3);
        if (this.cc != null) {
            nbttagcompound2 = new NBTTagCompound();
            if (this.cc instanceof EntityLiving) {
                UUID uuid = this.cc.cs();
                nbttagcompound2.a("UUID", uuid);
            } else if (this.cc instanceof EntityHanging) {
                BlockPosition blockposition = ((EntityHanging)this.cc).x();
                nbttagcompound2.a("X", blockposition.u());
                nbttagcompound2.a("Y", blockposition.v());
                nbttagcompound2.a("Z", blockposition.w());
            }
            nbt.a(bD, nbttagcompound2);
        } else if (this.ce != null) {
            nbt.a(bD, this.ce.h());
        }
        nbt.a("LeftHanded", this.fL());
        if (this.ca != null) {
            nbt.a("DeathLootTable", this.ca.toString());
            if (this.cb != 0L) {
                nbt.a("DeathLootTableSeed", this.cb);
            }
        }
        if (this.fK()) {
            nbt.a("NoAI", this.fK());
        }
        nbt.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist;
        boolean data;
        super.a(nbt);
        if (nbt.b("CanPickUpLoot", 1)) {
            data = nbt.q("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
                this.s(data);
            }
        }
        data = nbt.q("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
            this.bY = data;
        }
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.bW.size(); ++i2) {
                this.bW.set(i2, ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.bV.size(); ++i2) {
                this.bV.set(i2, ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("ArmorDropChances", 9)) {
            nbttaglist = nbt.c("ArmorDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bQ[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b("HandDropChances", 9)) {
            nbttaglist = nbt.c("HandDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bP[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b(bD, 10)) {
            this.ce = nbt.p(bD);
        }
        this.u(nbt.q("LeftHanded"));
        if (nbt.b("DeathLootTable", 8)) {
            this.ca = new MinecraftKey(nbt.l("DeathLootTable"));
            this.cb = nbt.i("DeathLootTableSeed");
        }
        this.t(nbt.q("NoAI"));
        if (nbt.e("Bukkit.Aware")) {
            this.aware = nbt.q("Bukkit.Aware");
        }
    }

    @Override
    protected void a(DamageSource source, boolean causedByPlayer) {
        super.a(source, causedByPlayer);
        this.ca = null;
    }

    @Override
    protected LootTableInfo.Builder a(boolean causedByPlayer, DamageSource source) {
        return super.a(causedByPlayer, source).a(this.cb, this.af);
    }

    @Override
    public final MinecraftKey et() {
        return this.ca == null ? this.O() : this.ca;
    }

    public MinecraftKey O() {
        return super.et();
    }

    public void y(float forwardSpeed) {
        this.bl = forwardSpeed;
    }

    public void z(float upwardSpeed) {
        this.bk = upwardSpeed;
    }

    public void A(float sidewaysSpeed) {
        this.bj = sidewaysSpeed;
    }

    @Override
    public void h(float movementSpeed) {
        super.h(movementSpeed);
        this.y(movementSpeed);
    }

    @Override
    public void b_() {
        super.b_();
        this.H.ac().a("looting");
        if (!this.H.B && this.fA() && this.bq() && !this.aZ && this.H.W().b(GameRules.c)) {
            BaseBlockPosition baseblockposition = this.P();
            List<EntityItem> list = this.H.a(EntityItem.class, this.cD().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()));
            for (EntityItem entityitem : list) {
                if (entityitem.dB() || entityitem.i().b() || entityitem.q() || !this.k(entityitem.i()) || !entityitem.canMobPickup) continue;
                this.b(entityitem);
            }
        }
        this.H.ac().c();
    }

    protected BaseBlockPosition P() {
        return bR;
    }

    protected void b(EntityItem item) {
        ItemStack itemstack = item.i();
        ItemStack itemstack1 = this.equipItemIfPossible(itemstack.o(), item);
        if (!itemstack1.b()) {
            this.a(item);
            this.a((Entity)item, itemstack1.K());
            itemstack.h(itemstack1.K());
            if (itemstack.b()) {
                item.ai();
            }
        }
    }

    public ItemStack i(ItemStack stack) {
        return this.equipItemIfPossible(stack, null);
    }

    public ItemStack equipItemIfPossible(ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
        ItemStack itemstack1 = this.c(enumitemslot);
        boolean flag = this.b(itemstack, itemstack1);
        if (enumitemslot.e() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.c(enumitemslot);
            flag = this.b(itemstack, itemstack1);
        }
        boolean bl = canPickup = flag && this.j(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.f(enumitemslot);
            if (!itemstack1.b() && (double)Math.max(this.af.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
            }
            if (enumitemslot.e() && itemstack.K() > 1) {
                ItemStack itemstack2 = itemstack.c(1);
                this.b(enumitemslot, itemstack2);
                return itemstack2;
            }
            this.b(enumitemslot, itemstack);
            return itemstack;
        }
        return ItemStack.b;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.e(slot);
        this.bY = true;
    }

    public void e(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                this.bP[slot.b()] = 2.0f;
                break;
            }
            case b: {
                this.bQ[slot.b()] = 2.0f;
            }
        }
    }

    protected boolean b(ItemStack newStack, ItemStack oldStack) {
        if (oldStack.b()) {
            return true;
        }
        if (newStack.c() instanceof ItemSword) {
            if (!(oldStack.c() instanceof ItemSword)) {
                return true;
            }
            ItemSword itemsword = (ItemSword)newStack.c();
            ItemSword itemsword1 = (ItemSword)oldStack.c();
            return itemsword.h() != itemsword1.h() ? itemsword.h() > itemsword1.h() : this.c(newStack, oldStack);
        }
        if (newStack.c() instanceof ItemBow && oldStack.c() instanceof ItemBow) {
            return this.c(newStack, oldStack);
        }
        if (newStack.c() instanceof ItemCrossbow && oldStack.c() instanceof ItemCrossbow) {
            return this.c(newStack, oldStack);
        }
        if (newStack.c() instanceof ItemArmor) {
            if (EnchantmentManager.d(oldStack)) {
                return false;
            }
            if (!(oldStack.c() instanceof ItemArmor)) {
                return true;
            }
            ItemArmor itemarmor = (ItemArmor)newStack.c();
            ItemArmor itemarmor1 = (ItemArmor)oldStack.c();
            return itemarmor.e() != itemarmor1.e() ? itemarmor.e() > itemarmor1.e() : (itemarmor.f() != itemarmor1.f() ? itemarmor.f() > itemarmor1.f() : this.c(newStack, oldStack));
        }
        if (newStack.c() instanceof ItemTool) {
            if (oldStack.c() instanceof ItemBlock) {
                return true;
            }
            if (oldStack.c() instanceof ItemTool) {
                ItemTool itemtool = (ItemTool)newStack.c();
                ItemTool itemtool1 = (ItemTool)oldStack.c();
                if (itemtool.d() != itemtool1.d()) {
                    return itemtool.d() > itemtool1.d();
                }
                return this.c(newStack, oldStack);
            }
        }
        return false;
    }

    public boolean c(ItemStack newStack, ItemStack oldStack) {
        return newStack.j() >= oldStack.j() && (!newStack.t() || oldStack.t()) ? (newStack.t() && oldStack.t() ? newStack.u().e().stream().anyMatch(s2 -> !s2.equals("Damage")) && !oldStack.u().e().stream().anyMatch(s2 -> !s2.equals("Damage")) : false) : true;
    }

    public boolean j(ItemStack stack) {
        return true;
    }

    public boolean k(ItemStack stack) {
        return this.j(stack);
    }

    public boolean h(double distanceSquared) {
        return true;
    }

    public boolean Q() {
        return this.bL();
    }

    protected boolean R() {
        return false;
    }

    @Override
    public void ds() {
        if (this.H.ah() == EnumDifficulty.a && this.R()) {
            this.ai();
        } else if (!this.fB() && !this.Q()) {
            EntityHuman entityhuman = this.H.findNearbyPlayer(this, this.H.paperConfig().entities.spawning.despawnRanges.get(this.ae().f()).hard() + 1, IEntitySelector.PLAYER_AFFECTS_SPAWNING);
            if (entityhuman == null) {
                EntityHuman entityHuman = entityhuman = ((WorldServer)this.H).playersAffectingSpawning.isEmpty() ? null : (EntityHuman)((WorldServer)this.H).playersAffectingSpawning.get(0);
            }
            if (entityhuman != null) {
                int i2;
                int j2;
                double d0 = entityhuman.f((Entity)this);
                if (d0 > (double)(j2 = (i2 = this.H.paperConfig().entities.spawning.despawnRanges.get(this.ae().f()).hard()) * i2) && this.h(d0)) {
                    this.ai();
                }
                int k2 = this.H.paperConfig().entities.spawning.despawnRanges.get(this.ae().f()).soft();
                int l2 = k2 * k2;
                if (this.ba > 600 && this.af.a(800) == 0 && d0 > (double)l2 && this.h(d0)) {
                    this.ai();
                } else if (d0 < (double)l2) {
                    this.ba = 0;
                }
            }
        } else {
            this.ba = 0;
        }
    }

    @Override
    protected final void eY() {
        ++this.ba;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.a()) {
                    this.goalFloat.e();
                }
                this.E().b();
            }
            if (this.eX() && this.aV()) {
                this.a(this.dG().h(), 1.0f);
            }
            return;
        }
        this.H.ac().a("sensing");
        this.bU.a();
        this.H.ac().c();
        int i2 = this.H.n().ag() + this.af();
        if (i2 % 2 != 0 && this.ag > 1) {
            this.H.ac().a("targetSelector");
            this.bO.a(false);
            this.H.ac().c();
            this.H.ac().a("goalSelector");
            this.bN.a(false);
            this.H.ac().c();
        } else {
            this.H.ac().a("targetSelector");
            this.bO.a();
            this.H.ac().c();
            this.H.ac().a("goalSelector");
            this.bN.a();
            this.H.ac().c();
        }
        this.H.ac().a("navigation");
        this.bM.c();
        this.H.ac().c();
        this.H.ac().a("mob tick");
        this.U();
        this.H.ac().c();
        this.H.ac().a("controls");
        this.H.ac().a("move");
        this.bK.a();
        this.H.ac().b("look");
        this.bJ.a();
        this.H.ac().b("jump");
        this.bL.b();
        this.H.ac().c();
        this.H.ac().c();
        this.T();
    }

    protected void T() {
        PacketDebug.a(this.H, this, this.bN);
    }

    protected void U() {
    }

    public int V() {
        return 40;
    }

    public int W() {
        return 75;
    }

    public int X() {
        return 10;
    }

    public void a(Entity targetEntity, float maxYawChange, float maxPitchChange) {
        double d2;
        double d0 = targetEntity.dl() - this.dl();
        double d1 = targetEntity.dr() - this.dr();
        if (targetEntity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)targetEntity;
            d2 = entityliving.dp() - this.dp();
        } else {
            d2 = (targetEntity.cD().b + targetEntity.cD().e) / 2.0 - this.dp();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.e(this.a(this.dy(), f3, maxPitchChange));
        this.f(this.a(this.dw(), f2, maxYawChange));
    }

    private float a(float from, float to, float max) {
        float f3 = MathHelper.g(to - from);
        if (f3 > max) {
            f3 = max;
        }
        if (f3 < -max) {
            f3 = -max;
        }
        return from + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockposition1 = pos.d();
        return spawnReason == EnumMobSpawn.c || world.a_(blockposition1).a((IBlockAccess)world, blockposition1, type);
    }

    public boolean a(GeneratorAccess world, EnumMobSpawn spawnReason) {
        return true;
    }

    public boolean a(IWorldReader world) {
        return !world.d(this.cD()) && world.f(this);
    }

    public int fy() {
        return 4;
    }

    public boolean d(int count) {
        return false;
    }

    @Override
    public int cp() {
        if (this.P_() == null) {
            return 3;
        }
        int i2 = (int)(this.eo() - this.eE() * 0.33f);
        if ((i2 -= (3 - this.H.ah().a()) * 4) < 0) {
            i2 = 0;
        }
        return i2 + 3;
    }

    @Override
    public Iterable<ItemStack> bH() {
        return this.bV;
    }

    @Override
    public Iterable<ItemStack> bI() {
        return this.bW;
    }

    @Override
    public ItemStack c(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bV.get(slot.b());
            }
            case b: {
                return this.bW.get(slot.b());
            }
        }
        return ItemStack.b;
    }

    @Override
    public void a(EnumItemSlot slot, ItemStack stack) {
        this.e(stack);
        switch (slot.a()) {
            case a: {
                this.a(slot, this.bV.set(slot.b(), stack), stack);
                break;
            }
            case b: {
                this.a(slot, this.bW.set(slot.b(), stack), stack);
            }
        }
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            boolean flag1;
            ItemStack itemstack = this.c(enumitemslot);
            float f2 = this.f(enumitemslot);
            boolean bl = flag1 = f2 > 1.0f;
            if (itemstack.b() || EnchantmentManager.e(itemstack) || !allowDrops && !flag1 || !(Math.max(this.af.i() - (float)lootingMultiplier * 0.01f, 0.0f) < f2)) continue;
            if (!flag1 && itemstack.h()) {
                itemstack.b(itemstack.k() - this.af.a(1 + this.af.a(Math.max(itemstack.k() - 3, 1))));
            }
            this.b(itemstack);
            if (this.clearEquipmentSlots) {
                this.a(enumitemslot, ItemStack.b);
                continue;
            }
            this.clearedEquipmentSlots.add(enumitemslot);
        }
    }

    protected float f(EnumItemSlot slot) {
        return switch (slot.a()) {
            case EnumItemSlot.Function.a -> this.bP[slot.b()];
            case EnumItemSlot.Function.b -> this.bQ[slot.b()];
            default -> 0.0f;
        };
    }

    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (random.i() < 0.15f * localDifficulty.d()) {
            float f2;
            int i2 = random.a(2);
            float f3 = f2 = this.H.ah() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (random.i() < 0.095f) {
                ++i2;
            }
            if (random.i() < 0.095f) {
                ++i2;
            }
            if (random.i() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                Item item;
                if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
                ItemStack itemstack = this.c(enumitemslot);
                if (!flag && random.i() < f2) break;
                flag = false;
                if (!itemstack.b() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot equipmentSlot, int equipmentLevel) {
        switch (equipmentSlot) {
            case f: {
                if (equipmentLevel == 0) {
                    return Items.oG;
                }
                if (equipmentLevel == 1) {
                    return Items.oW;
                }
                if (equipmentLevel == 2) {
                    return Items.oK;
                }
                if (equipmentLevel == 3) {
                    return Items.oO;
                }
                if (equipmentLevel == 4) {
                    return Items.oS;
                }
            }
            case e: {
                if (equipmentLevel == 0) {
                    return Items.oH;
                }
                if (equipmentLevel == 1) {
                    return Items.oX;
                }
                if (equipmentLevel == 2) {
                    return Items.oL;
                }
                if (equipmentLevel == 3) {
                    return Items.oP;
                }
                if (equipmentLevel == 4) {
                    return Items.oT;
                }
            }
            case d: {
                if (equipmentLevel == 0) {
                    return Items.oI;
                }
                if (equipmentLevel == 1) {
                    return Items.oY;
                }
                if (equipmentLevel == 2) {
                    return Items.oM;
                }
                if (equipmentLevel == 3) {
                    return Items.oQ;
                }
                if (equipmentLevel == 4) {
                    return Items.oU;
                }
            }
            case c: {
                if (equipmentLevel == 0) {
                    return Items.oJ;
                }
                if (equipmentLevel == 1) {
                    return Items.oZ;
                }
                if (equipmentLevel == 2) {
                    return Items.oN;
                }
                if (equipmentLevel == 3) {
                    return Items.oR;
                }
                if (equipmentLevel != 4) break;
                return Items.oV;
            }
        }
        return null;
    }

    protected void b(RandomSource random, DifficultyDamageScaler localDifficulty) {
        float f2 = localDifficulty.d();
        this.a(random, f2);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(random, f2, enumitemslot);
        }
    }

    protected void a(RandomSource random, float power) {
        if (!this.eK().b() && random.i() < 0.25f * power) {
            this.a(EnumItemSlot.a, EnchantmentManager.a(random, this.eK(), (int)(5.0f + power * (float)random.a(18)), false));
        }
    }

    protected void a(RandomSource random, float power, EnumItemSlot slot) {
        ItemStack itemstack = this.c(slot);
        if (!itemstack.b() && random.i() < 0.5f * power) {
            this.a(slot, EnchantmentManager.a(random, itemstack, (int)(5.0f + power * (float)random.a(18)), false));
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.r_();
        this.a(GenericAttributes.b).c(new AttributeModifier("Random spawn bonus", randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        if (randomsource.i() < 0.05f) {
            this.u(true);
        } else {
            this.u(false);
        }
        return entityData;
    }

    public void fz() {
        this.bY = true;
    }

    public void a(EnumItemSlot slot, float chance) {
        switch (slot.a()) {
            case a: {
                this.bP[slot.b()] = chance;
                break;
            }
            case b: {
                this.bQ[slot.b()] = chance;
            }
        }
    }

    public boolean fA() {
        return this.bX;
    }

    public void s(boolean canPickUpLoot) {
        this.bX = canPickUpLoot;
    }

    @Override
    public boolean f(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b() && this.fA();
    }

    public boolean fB() {
        return this.bY;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.bq()) {
            return EnumInteractionResult.d;
        }
        if (this.fJ() == player) {
            PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, hand, !player.fK().d);
            if (event.isCancelled()) {
                ((EntityPlayer)player).b.a(new PacketPlayOutAttachEntity(this, this.fJ()));
                return EnumInteractionResult.d;
            }
            this.a(true, event.isDropLeash());
            this.a(GameEvent.s, (Entity)player);
            return EnumInteractionResult.a(this.H.B);
        }
        EnumInteractionResult enuminteractionresult = this.c(player, hand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.s, (Entity)player);
            return enuminteractionresult;
        }
        enuminteractionresult = this.b(player, hand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.s, (Entity)player);
            return enuminteractionresult;
        }
        return super.a(player, hand);
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.tM) && this.a(player)) {
            if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player, hand).isCancelled()) {
                ((EntityPlayer)player).b.a(new PacketPlayOutAttachEntity(this, this.fJ()));
                return EnumInteractionResult.d;
            }
            this.b((Entity)player, true);
            itemstack.h(1);
            return EnumInteractionResult.a(this.H.B);
        }
        if (itemstack.a(Items.tN) && (enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.c() instanceof ItemMonsterEgg) {
            if (this.H instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.c();
                Optional<EntityInsentient> optional = itemmonsteregg.a(player, this, this.ae(), (WorldServer)this.H, this.de(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(player, (EntityInsentient)entityinsentient));
                return optional.isPresent() ? EnumInteractionResult.a : EnumInteractionResult.d;
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.d;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean fC() {
        return this.a(this.dg());
    }

    public boolean a(BlockPosition pos) {
        return this.cg == -1.0f ? true : this.cf.j(pos) < (double)(this.cg * this.cg);
    }

    public void a(BlockPosition target, int range) {
        this.cf = target;
        this.cg = range;
    }

    public BlockPosition fD() {
        return this.cf;
    }

    public float fE() {
        return this.cg;
    }

    public void fF() {
        this.cg = -1.0f;
    }

    public boolean fG() {
        return this.cg != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, boolean keepEquipment) {
        return this.convertTo(entityType, keepEquipment, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, boolean flag, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.dB()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.H);
        if (t0 == null) {
            return null;
        }
        t0.s(this);
        t0.a(this.y_());
        t0.t(this.fK());
        if (this.aa()) {
            t0.b(this.ab());
            t0.n(this.cx());
        }
        if (this.fB()) {
            t0.fz();
        }
        t0.m(this.cm());
        if (flag) {
            t0.s(this.fA());
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                ItemStack itemstack = this.c(enumitemslot);
                if (itemstack.b()) continue;
                t0.a(enumitemslot, itemstack.o());
                t0.a(enumitemslot, this.f(enumitemslot));
                itemstack.f(0);
            }
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        this.H.addFreshEntity(t0, spawnReason);
        if (this.bL()) {
            Entity entity = this.cV();
            this.bz();
            t0.a(entity, true);
        }
        this.ai();
        return (T)t0;
    }

    protected void fH() {
        if (this.ce != null) {
            this.fP();
        }
        if (!(this.cc == null || this.bq() && this.cc.bq())) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), !this.bq() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, true);
            this.H.getCraftServer().getPluginManager().callEvent((Event)event);
            this.a(true, event.isDropLeash());
        }
    }

    public void a(boolean sendPacket, boolean dropItem) {
        if (this.cc != null) {
            this.cc = null;
            this.ce = null;
            if (!this.H.B && dropItem) {
                this.forceDrops = true;
                this.a((IMaterial)Items.tM);
                this.forceDrops = false;
            }
            if (!this.H.B && sendPacket && this.H instanceof WorldServer) {
                ((WorldServer)this.H).k().b(this, new PacketPlayOutAttachEntity(this, null));
            }
        }
    }

    public boolean a(EntityHuman player) {
        return !this.fI() && !(this instanceof IMonster);
    }

    public boolean fI() {
        return this.cc != null;
    }

    @Nullable
    public Entity fJ() {
        if (this.cc == null && this.cd != 0 && this.H.B) {
            this.cc = this.H.a(this.cd);
        }
        return this.cc;
    }

    public void b(Entity entity, boolean sendPacket) {
        this.cc = entity;
        this.ce = null;
        if (!this.H.B && sendPacket && this.H instanceof WorldServer) {
            ((WorldServer)this.H).k().b(this, new PacketPlayOutAttachEntity(this, this.cc));
        }
        if (this.bL()) {
            this.bz();
        }
    }

    public void q(int id) {
        this.cd = id;
        this.a(false, false);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        boolean flag1 = super.a(entity, force);
        if (flag1 && this.fI()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag1;
            }
            this.a(true, event.isDropLeash());
        }
        return flag1;
    }

    private void fP() {
        if (this.ce != null && this.H instanceof WorldServer) {
            if (this.ce.b("UUID")) {
                UUID uuid = this.ce.a("UUID");
                Entity entity = ((WorldServer)this.H).a(uuid);
                if (entity != null) {
                    this.b(entity, true);
                    return;
                }
            } else if (this.ce.b("X", 99) && this.ce.b("Y", 99) && this.ce.b("Z", 99)) {
                BlockPosition blockposition = GameProfileSerializer.b(this.ce);
                this.b(EntityLeash.b(this.H, blockposition), true);
                return;
            }
            if (this.ag > 100) {
                this.forceDrops = true;
                this.a((IMaterial)Items.tM);
                this.forceDrops = false;
                this.ce = null;
            }
        }
    }

    @Override
    public boolean cU() {
        return super.cU() && !this.fK();
    }

    public void t(boolean aiDisabled) {
        byte b0 = this.am.a(b);
        this.am.b(b, aiDisabled ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void u(boolean leftHanded) {
        byte b0 = this.am.a(b);
        this.am.b(b, leftHanded ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void v(boolean attacking) {
        byte b0 = this.am.a(b);
        this.am.b(b, attacking ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean fK() {
        return (this.am.a(b) & 1) != 0;
    }

    public boolean fL() {
        return (this.am.a(b) & 2) != 0;
    }

    public boolean fM() {
        return (this.am.a(b) & 4) != 0;
    }

    public void a(boolean baby) {
    }

    @Override
    public EnumMainHand fd() {
        return this.fL() ? EnumMainHand.a : EnumMainHand.b;
    }

    public double j(EntityLiving target) {
        return this.dc() * 2.0f * this.dc() * 2.0f + target.dc();
    }

    public double k(EntityLiving target) {
        return Math.max(this.e(target.ew()), this.e(target.de()));
    }

    public boolean l(EntityLiving entity) {
        double d0 = this.k(entity);
        return d0 <= this.j(entity);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag;
        int i2;
        float f2 = (float)this.b(GenericAttributes.f);
        float f1 = (float)this.b(GenericAttributes.g);
        if (target instanceof EntityLiving) {
            f2 += EnchantmentManager.a(this.eK(), ((EntityLiving)target).eJ());
            f1 += (float)EnchantmentManager.c(this);
        }
        if ((i2 = EnchantmentManager.d(this)) > 0) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), i2 * 4);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                target.setSecondsOnFire(combustEvent.getDuration(), false);
            }
        }
        if (flag = target.a(this.dG().b(this), f2)) {
            if (f1 > 0.0f && target instanceof EntityLiving) {
                ((EntityLiving)target).knockback(f1 * 0.5f, MathHelper.a(this.dw() * ((float)Math.PI / 180)), -MathHelper.b(this.dw() * ((float)Math.PI / 180)), this);
                this.f(this.dj().d(0.6, 1.0, 0.6));
            }
            if (target instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)target;
                this.a(entityhuman, this.eK(), entityhuman.fe() ? entityhuman.fg() : ItemStack.b);
            }
            this.a((EntityLiving)this, target);
            this.x(target);
        }
        return flag;
    }

    private void a(EntityHuman player, ItemStack mobStack, ItemStack playerStack) {
        if (!mobStack.b() && !playerStack.b() && mobStack.c() instanceof ItemAxe && playerStack.a(Items.ut)) {
            float f2 = 0.25f + (float)EnchantmentManager.g(this) * 0.05f;
            if (this.af.i() < f2) {
                player.ge().a(Items.ut, 100);
                this.H.a((Entity)player, (byte)30);
            }
        }
    }

    public boolean fN() {
        if (this.H.M() && !this.H.B) {
            boolean flag;
            float f2 = this.bh();
            BlockPosition blockposition = BlockPosition.a(this.dl(), this.dp(), this.dr());
            boolean bl = flag = this.aV() || this.az || this.aA;
            if (f2 > 0.5f && this.af.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.H.g(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        if (this.G().q()) {
            super.c(fluid);
        } else {
            this.f(this.dj().b(0.0, 0.3, 0.0));
        }
    }

    public void fO() {
        this.c((PathfinderGoal pathfindergoal) -> true);
        this.dH().h();
    }

    public void c(Predicate<PathfinderGoal> predicate) {
        this.bN.a(predicate);
    }

    @Override
    protected void cn() {
        super.cn();
        EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
        this.H.getCraftServer().getPluginManager().callEvent((Event)event);
        this.a(true, event.isDropLeash());
        this.bJ().forEach(itemstack -> {
            if (!itemstack.b()) {
                itemstack.f(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack dt() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.ae());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }
}

