/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.EnchantmentFrostWalker;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_19_R3.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import top.leavesmc.leaves.LeavesConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger b = LogUtils.getLogger();
    private static final UUID c = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final UUID d = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID e = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final AttributeModifier bz = new AttributeModifier(c, "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.c);
    public static final int g = 2;
    public static final int h = 4;
    public static final int i = 98;
    public static final int j = 100;
    public static final int k = 6;
    public static final int l = 100;
    private static final int bA = 40;
    public static final double m = 0.003;
    public static final double n = 0.08;
    public static final int o = 20;
    private static final int bB = 7;
    private static final int bC = 10;
    private static final int bD = 2;
    public static final int p = 4;
    private static final double bE = 128.0;
    protected static final int q = 1;
    protected static final int r = 2;
    protected static final int s = 4;
    protected static final DataWatcherObject<Byte> t = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> bF = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> bG = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bH = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bI = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bJ = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bK = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.o);
    protected static final float u = 1.74f;
    protected static final EntitySize aC = EntitySize.c(0.2f, 0.2f);
    public static final float aD = 0.5f;
    private static final int bL = 50;
    private final AttributeMapBase bM;
    public CombatTracker bN = new CombatTracker(this);
    public final Map<MobEffectList, MobEffect> bO = Maps.newHashMap();
    private final NonNullList<ItemStack> bP;
    private final NonNullList<ItemStack> bQ;
    public boolean aE;
    private boolean bR;
    public EnumHand aF;
    public int aG;
    public int aH;
    public int aI;
    public int aJ;
    public int aK;
    public int aL;
    public float aM;
    public float aN;
    protected int aO;
    public final WalkAnimationState aP;
    public int aQ;
    public final float aR;
    public final float aS;
    public float aT;
    public float aU;
    public float aV;
    public float aW;
    @Nullable
    public EntityHuman aX;
    public int aY;
    protected boolean aZ;
    protected int ba;
    protected float bb;
    protected float bc;
    protected float bd;
    protected float be;
    protected float bf;
    protected int bg;
    public float bh;
    public boolean bi;
    public float bj;
    public float bk;
    public float bl;
    protected int bm;
    protected double bn;
    protected double bo;
    protected double bp;
    protected double bq;
    protected double br;
    protected double bs;
    protected int bt;
    public boolean bS;
    @Nullable
    public EntityLiving bT;
    public int bU;
    private EntityLiving bV;
    private int bW;
    private float bX;
    private int bY;
    private float bZ;
    protected ItemStack bu;
    protected int bv;
    protected int bw;
    public BlockPosition ca;
    private Optional<BlockPosition> cb;
    @Nullable
    private DamageSource cc;
    private long cd;
    protected int bx;
    private float ce;
    private float cf;
    protected BehaviorController<?> by;
    private boolean cg;
    public int expToDrop;
    public boolean forceDrops;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EnumItemSlot> clearedEquipmentSlots = new HashSet<EnumItemSlot>();
    private boolean cachedOnClimable = false;
    private BlockPosition lastClimbingPosition = null;
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;
    public int shieldBlockingDelay;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    @Override
    public float getBukkitYaw() {
        return this.ck();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.ba;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> type, net.minecraft.world.level.World world) {
        super(type, world);
        this.shieldBlockingDelay = this.H.paperConfig().misc.shieldBlockingDelay;
        this.bP = NonNullList.a(2, ItemStack.b);
        this.bQ = NonNullList.a(4, ItemStack.b);
        this.bR = false;
        this.aP = new WalkAnimationState();
        this.aQ = 20;
        this.bS = true;
        this.bu = ItemStack.b;
        this.cb = Optional.empty();
        this.bM = new AttributeMapBase(AttributeDefaults.a(type));
        this.craftAttributes = new CraftAttributeMap(this.bM);
        this.am.b(bF, Float.valueOf((float)this.a(GenericAttributes.a).f()));
        this.F = true;
        this.aS = (float)((Math.random() + 1.0) * (double)0.01f);
        this.an();
        this.aR = (float)Math.random() * 12398.0f;
        this.f((float)(Math.random() * 6.2831854820251465));
        this.aV = this.dw();
        this.v(0.6f);
        DynamicOpsNBT dynamicopsnbt = DynamicOpsNBT.a;
        this.by = this.a(new Dynamic<NBTBase>(dynamicopsnbt, (NBTBase)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.a("memories"), (Object)((NBTBase)dynamicopsnbt.emptyMap())))));
    }

    public BehaviorController<?> dH() {
        return this.by;
    }

    protected BehaviorController.b<?> dI() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.dI().a(dynamic);
    }

    @Override
    public void ah() {
        this.a(this.dG().m(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> type) {
        return true;
    }

    @Override
    protected void a_() {
        this.am.a(t, (byte)0);
        this.am.a(bG, 0);
        this.am.a(bH, false);
        this.am.a(bI, 0);
        this.am.a(bJ, 0);
        this.am.a(bF, Float.valueOf(1.0f));
        this.am.a(bK, Optional.empty());
    }

    public static AttributeProvider.Builder dJ() {
        return AttributeProvider.a().a(GenericAttributes.a).a(GenericAttributes.c).a(GenericAttributes.d).a(GenericAttributes.i).a(GenericAttributes.j);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        if (!this.aT()) {
            this.ba();
        }
        if (!this.H.B && onGround && this.aa > 0.0f) {
            this.dO();
            this.dP();
        }
        if (!this.H.B && this.aa > 3.0f && onGround) {
            float f2 = MathHelper.f(this.aa - 3.0f);
            if (!state.h()) {
                double d1 = Math.min((double)(0.2f + f2 / 15.0f), 2.5);
                int i2 = (int)(150.0 * d1);
                if (this instanceof EntityPlayer) {
                    ((WorldServer)this.H).sendParticles((EntityPlayer)this, new ParticleParamBlock(Particles.c, state), this.dl(), this.dn(), this.dr(), i2, 0.0, 0.0, 0.0, 0.15f, false);
                } else {
                    ((WorldServer)this.H).a(new ParticleParamBlock(Particles.c, state), this.dl(), this.dn(), this.dr(), i2, 0.0, 0.0, 0.0, 0.15f);
                }
            }
        }
        super.a(heightDifference, onGround, state, landedPosition);
    }

    public boolean dK() {
        return this.eJ() == EnumMonsterType.b;
    }

    public float a(float tickDelta) {
        return MathHelper.i(tickDelta, this.cf, this.ce);
    }

    @Override
    public void ao() {
        this.aM = this.aN;
        if (this.al) {
            this.fs().ifPresent(this::a);
        }
        if (this.dL()) {
            this.dM();
        }
        super.ao();
        this.H.ac().a("livingEntityBaseTick");
        if (this.aS() || this.H.B) {
            this.av();
        }
        if (this.bq()) {
            BlockPosition blockposition;
            boolean flag = this instanceof EntityHuman;
            if (!this.H.B) {
                double d1;
                double d0;
                if ((!LeavesConfig.enableSuffocationOptimization || this.ag % 10 == 0 && this.couldPossiblyBeHurt(1.0f)) && this.br()) {
                    this.a(this.dG().f(), 1.0f);
                } else if (flag && !this.H.p_().a(this.cD()) && (d0 = this.H.p_().a(this) + this.H.p_().n()) < 0.0 && (d1 = this.H.p_().o()) > 0.0) {
                    this.a(this.dG().f(), (float)Math.max(1, MathHelper.a(-d0 * d1)));
                }
            }
            if (((Entity)this).a(TagsFluid.a) && !this.H.a_(BlockPosition.a(this.dl(), this.dp(), this.dr())).a(Blocks.mZ)) {
                boolean flag1;
                boolean bl = flag1 = !this.dK() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).fK().a);
                if (flag1) {
                    this.i(this.l(this.cd()));
                    if (this.cd() == -20) {
                        this.i(0);
                        Vec3D vec3d = this.dj();
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d2 = this.af.j() - this.af.j();
                            double d3 = this.af.j() - this.af.j();
                            double d4 = this.af.j() - this.af.j();
                            this.H.a(Particles.e, this.dl() + d2, this.dn() + d3, this.dr() + d4, vec3d.c, vec3d.d, vec3d.e);
                        }
                        this.a(this.dG().h(), 2.0f);
                    }
                }
                if (!this.H.B && this.bL() && this.cV() != null && this.cV().bN()) {
                    this.bz();
                }
            } else if (this.cd() < this.cc()) {
                this.i(this.m(this.cd()));
            }
            if (!this.H.B && !com.google.common.base.Objects.equal((Object)this.ca, (Object)(blockposition = this.dg()))) {
                this.ca = blockposition;
                this.c(blockposition);
            }
        }
        if (this.bq() && (this.aV() || this.az)) {
            this.aA();
        }
        if (this.aJ > 0) {
            --this.aJ;
        }
        if (this.ak > 0 && !(this instanceof EntityPlayer)) {
            --this.ak;
        }
        if (this.ep() && this.H.h(this)) {
            this.dU();
        }
        if (this.aY > 0) {
            --this.aY;
        } else {
            this.aX = null;
        }
        if (this.bV != null && !this.bV.bq()) {
            this.bV = null;
        }
        if (this.bT != null) {
            if (!this.bT.bq()) {
                this.a((EntityLiving)null);
            } else if (this.ag - this.bU > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.eg();
        this.be = this.bd;
        this.aU = this.aT;
        this.aW = this.aV;
        this.L = this.dw();
        this.M = this.dy();
        this.H.ac().c();
    }

    public boolean dL() {
        return this.ag % 5 == 0 && this.dj().c != 0.0 && this.dj().e != 0.0 && !this.F_() && EnchantmentManager.k(this) && this.dN();
    }

    protected void dM() {
        Vec3D vec3d = this.dj();
        this.H.a(Particles.K, this.dl() + (this.af.j() - 0.5) * (double)this.dc(), this.dn() + 0.1, this.dr() + (this.af.j() - 0.5) * (double)this.dc(), vec3d.c * -0.2, 0.1, vec3d.e * -0.2);
        float f2 = this.af.i() * 0.4f + this.af.i() > 0.9f ? 0.6f : 0.0f;
        this.a(SoundEffects.vN, f2, 0.6f + this.af.i() * 0.4f);
    }

    protected boolean dN() {
        return this.H.a_(this.aG()).a(TagsBlock.aK);
    }

    @Override
    protected float aF() {
        return this.dN() && EnchantmentManager.a(Enchantments.l, this) > 0 ? 1.0f : super.aF();
    }

    protected boolean b(IBlockData landingState) {
        return !landingState.h() || this.fn();
    }

    protected void dO() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null && attributemodifiable.a(d) != null) {
            attributemodifiable.b(d);
        }
    }

    protected void dP() {
        int i2;
        if (!this.bc().h() && (i2 = EnchantmentManager.a(Enchantments.l, this)) > 0 && this.dN()) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            if (attributemodifiable == null) {
                return;
            }
            attributemodifiable.b(new AttributeModifier(d, "Soul speed boost", (double)(0.03f * (1.0f + (float)i2 * 0.35f)), AttributeModifier.Operation.a));
            if (this.dZ().i() < 0.04f) {
                ItemStack itemstack = this.c(EnumItemSlot.c);
                itemstack.a(1, this, (T entityliving) -> entityliving.d(EnumItemSlot.c));
            }
        }
    }

    protected void dQ() {
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null && attributemodifiable.a(e) != null) {
            attributemodifiable.b(e);
        }
    }

    protected void dR() {
        int i2;
        if (!this.bc().h() && (i2 = this.ce()) > 0) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.cf();
            attributemodifiable.b(new AttributeModifier(e, "Powder snow slow", (double)f2, AttributeModifier.Operation.a));
        }
    }

    protected void c(BlockPosition pos) {
        int i2 = EnchantmentManager.a(Enchantments.j, this);
        if (i2 > 0) {
            EnchantmentFrostWalker.a(this, this.H, pos, i2);
        }
        if (this.b(this.bc())) {
            this.dO();
        }
        this.dP();
    }

    public boolean y_() {
        return false;
    }

    public float dS() {
        return this.y_() ? 0.5f : 1.0f;
    }

    protected boolean dT() {
        return true;
    }

    protected void dU() {
        ++this.aL;
        if (this.aL >= 20 && !this.H.k_() && !this.dB()) {
            this.H.a((Entity)this, (byte)60);
            this.a(Entity.RemovalReason.a);
        }
    }

    public boolean dV() {
        return !this.y_();
    }

    protected boolean dW() {
        return !this.y_();
    }

    protected int l(int air) {
        int j2 = EnchantmentManager.e(this);
        return j2 > 0 && this.af.a(j2 + 1) > 0 ? air : air - 1;
    }

    protected int m(int air) {
        return Math.min(air + 4, this.cc());
    }

    public int dX() {
        return 0;
    }

    protected boolean dY() {
        return false;
    }

    public RandomSource dZ() {
        return this.af;
    }

    @Nullable
    public EntityLiving ea() {
        return this.bT;
    }

    @Override
    public EntityLiving L_() {
        return this.ea();
    }

    public int eb() {
        return this.bU;
    }

    public void c(@Nullable EntityHuman attacking) {
        this.aX = attacking;
        this.aY = this.ag;
    }

    public void a(@Nullable EntityLiving attacker) {
        this.bT = attacker;
        this.bU = this.ag;
    }

    @Nullable
    public EntityLiving ec() {
        return this.bV;
    }

    public int ed() {
        return this.bW;
    }

    public void x(Entity target) {
        this.bV = target instanceof EntityLiving ? (EntityLiving)target : null;
        this.bW = this.ag;
    }

    public int ee() {
        return this.ba;
    }

    public void n(int despawnCounter) {
        this.ba = despawnCounter;
    }

    public boolean ef() {
        return !this.frictionState.toBooleanOrElse(!this.bR);
    }

    public void p(boolean noDrag) {
        this.bR = noDrag;
    }

    protected boolean a(EnumItemSlot slot) {
        return true;
    }

    public void a(EnumItemSlot slot, ItemStack oldStack, ItemStack newStack) {
        this.onEquipItem(slot, oldStack, newStack, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        Equipable equipable;
        boolean flag;
        boolean bl = flag = itemstack1.b() && itemstack.b();
        if (!(flag || ItemStack.d(itemstack, itemstack1) || this.al || (equipable = Equipable.c_(itemstack1)) == null || this.F_() || equipable.g() != enumitemslot)) {
            if (!(this.H.k_() || this.aO() || silent)) {
                this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), equipable.ak_(), this.cX(), 1.0f, 1.0f);
            }
            if (this.a(enumitemslot)) {
                this.a(GameEvent.x);
            }
        }
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.by.a();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", this.eo());
        nbt.a("HurtTime", (short)this.aJ);
        nbt.a("HurtByTimestamp", this.bU);
        nbt.a("DeathTime", (short)this.aL);
        nbt.a("AbsorptionAmount", this.fb());
        nbt.a("Attributes", this.eI().c());
        if (!this.bO.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.bO.values()) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbt.a("ActiveEffects", nbttaglist);
        }
        nbt.a("FallFlying", this.fn());
        this.fs().ifPresent(blockposition -> {
            nbt.a("SleepingX", blockposition.u());
            nbt.a("SleepingY", blockposition.v());
            nbt.a("SleepingZ", blockposition.w());
        });
        DataResult<NBTBase> dataresult = this.by.a(DynamicOpsNBT.a);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("Brain", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        float absorptionAmount = nbt.j("AbsorptionAmount");
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.x(absorptionAmount);
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                b.error("Unknown friction state " + fs + " for " + this);
            }
        }
        if (nbt.b("Attributes", 9) && this.H != null && !this.H.B) {
            this.eI().a(nbt.c("Attributes", 10));
        }
        if (nbt.b("ActiveEffects", 9)) {
            NBTTagList nbttaglist = nbt.c("ActiveEffects", 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(i2);
                MobEffect mobeffect = MobEffect.b(nbttagcompound1);
                if (mobeffect == null) continue;
                this.bO.put(mobeffect.c(), mobeffect);
            }
        }
        if (nbt.e("Bukkit.MaxHealth")) {
            NBTBase nbtbase = nbt.c("Bukkit.MaxHealth");
            if (nbtbase.b() == 5) {
                this.a(GenericAttributes.a).a(((NBTTagFloat)nbtbase).j());
            } else if (nbtbase.b() == 3) {
                this.a(GenericAttributes.a).a(((NBTTagInt)nbtbase).j());
            }
        }
        if (nbt.b("Health", 99)) {
            this.c(nbt.j("Health"));
        }
        this.aJ = nbt.g("HurtTime");
        this.aL = nbt.g("DeathTime");
        this.bU = nbt.h("HurtByTimestamp");
        if (nbt.b("Team", 8)) {
            boolean flag;
            String s2 = nbt.l("Team");
            ScoreboardTeam scoreboardteam = this.H.H().f(s2);
            if (!this.H.paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                scoreboardteam = null;
            }
            boolean bl = flag = scoreboardteam != null && this.H.H().a(this.ct(), scoreboardteam);
            if (!flag) {
                b.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s2);
            }
        }
        if (nbt.q("FallFlying")) {
            this.b(7, true);
        }
        if (nbt.b("SleepingX", 99) && nbt.b("SleepingY", 99) && nbt.b("SleepingZ", 99)) {
            BlockPosition blockposition = new BlockPosition(nbt.h("SleepingX"), nbt.h("SleepingY"), nbt.h("SleepingZ"));
            this.e(blockposition);
            this.am.b(Entity.ar, EntityPose.c);
            if (!this.al) {
                this.a(blockposition);
            }
        }
        if (nbt.b("Brain", 10)) {
            this.by = this.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Brain")));
        }
    }

    protected void eg() {
        Iterator<MobEffectList> iterator = this.bO.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                MobEffectList mobeffectlist = iterator.next();
                MobEffect mobeffect = this.bO.get(mobeffectlist);
                if (!mobeffect.a(this, () -> this.a(mobeffect, true, (Entity)null))) {
                    EntityPotionEffectEvent event;
                    if (this.H.B || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.a(mobeffect);
                    continue;
                }
                if (mobeffect.d() % 600 != 0) continue;
                this.a(mobeffect, false, (Entity)null);
            }
        }
        catch (ConcurrentModificationException mobeffectlist) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect e2 : this.effectsToProcess) {
            if (e2.effect != null) {
                this.addEffect(e2.effect, e2.cause);
                continue;
            }
            this.removeEffect(e2.type, e2.cause);
        }
        this.effectsToProcess.clear();
        if (this.bS) {
            if (!this.H.B) {
                this.F();
                this.q();
            }
            this.bS = false;
        }
        int i2 = this.am.a(bG);
        boolean flag = this.am.a(bH);
        if (i2 > 0) {
            boolean flag1 = this.ca() ? this.af.a(15) == 0 : this.af.h();
            if (flag) {
                flag1 &= this.af.a(5) == 0;
            }
            if (flag1 && i2 > 0) {
                double d0 = (double)(i2 >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i2 >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i2 >> 0 & 0xFF) / 255.0;
                this.H.a(flag ? Particles.a : Particles.v, this.d(0.5), this.do(), this.g(0.5), d0, d1, d2);
            }
        }
    }

    protected void F() {
        if (this.bO.isEmpty()) {
            this.ej();
            this.j(false);
        } else {
            Collection<MobEffect> collection = this.bO.values();
            this.am.b(bH, EntityLiving.c(collection));
            this.am.b(bG, PotionUtil.a(collection));
            this.j(this.a(MobEffects.n));
        }
    }

    private void q() {
        boolean flag = this.bZ();
        if (this.h(6) != flag) {
            this.b(6, flag);
        }
    }

    public double y(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.bR()) {
            d0 *= 0.8;
        }
        if (this.ca()) {
            float f2 = this.eM();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.c(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.ae();
            if (entitytypes == EntityTypes.aJ && itemstack.a(Items.tn) || entitytypes == EntityTypes.bp && itemstack.a(Items.tq) || entitytypes == EntityTypes.aw && itemstack.a(Items.tt) || entitytypes == EntityTypes.ax && itemstack.a(Items.tt) || entitytypes == EntityTypes.u && itemstack.a(Items.tr)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving target) {
        return target instanceof EntityHuman && this.H.ah() == EnumDifficulty.a ? false : target.eh();
    }

    public boolean a(EntityLiving entity, PathfinderTargetCondition predicate) {
        return predicate.a(this, entity);
    }

    public boolean eh() {
        return !this.cm() && this.ei();
    }

    public boolean ei() {
        return !this.F_() && this.bq();
    }

    public static boolean c(Collection<MobEffect> effects) {
        MobEffect mobeffect;
        Iterator<MobEffect> iterator = effects.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(mobeffect = iterator.next()).g() || mobeffect.f());
        return false;
    }

    protected void ej() {
        this.am.b(bH, false);
        this.am.b(bG, 0);
    }

    public boolean ek() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.H.B) {
            return false;
        }
        Iterator<MobEffect> iterator = this.bO.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (!event.isCancelled()) {
                this.a(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public Collection<MobEffect> el() {
        return this.bO.values();
    }

    public Map<MobEffectList, MobEffect> em() {
        return this.bO;
    }

    public boolean a(MobEffectList effect) {
        return this.bO.containsKey(effect);
    }

    @Nullable
    public MobEffect b(MobEffectList effect) {
        return this.bO.get(effect);
    }

    public final boolean b(MobEffect effect) {
        return this.b(effect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect effect, @Nullable Entity source) {
        return this.addEffect(effect, source, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.c(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.bO.get(mobeffect.c());
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.bO.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            return true;
        }
        if (event.isOverride()) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            return true;
        }
        return false;
    }

    public boolean c(MobEffect effect) {
        MobEffectList mobeffectlist;
        return this.eJ() != EnumMonsterType.b || (mobeffectlist = effect.c()) != MobEffects.j && mobeffectlist != MobEffects.s || !this.H.paperConfig().entities.mobEffects.undeadImmuneToCertainEffects;
    }

    public void c(MobEffect effect, @Nullable Entity source) {
        if (this.c(effect)) {
            MobEffect mobeffect1 = this.bO.put(effect.c(), effect);
            if (mobeffect1 == null) {
                this.a(effect, source);
            } else {
                this.a(effect, true, source);
            }
        }
    }

    public boolean en() {
        return this.eJ() == EnumMonsterType.b;
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList type) {
        return this.c(type, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect c(@Nullable MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffectlist, cause));
            return null;
        }
        MobEffect effect = this.bO.get(mobeffectlist);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bO.remove(mobeffectlist);
    }

    public boolean d(MobEffectList type) {
        return this.removeEffect(type, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(MobEffectList mobeffectlist, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.c(mobeffectlist, cause);
        if (mobeffect != null) {
            this.a(mobeffect);
            return true;
        }
        return false;
    }

    protected void a(MobEffect effect, @Nullable Entity source) {
        this.bS = true;
        if (!this.H.B) {
            effect.c().b(this, this.eI(), effect.e());
        }
    }

    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable Entity source) {
        this.bS = true;
        if (reapplyEffect && !this.H.B) {
            MobEffectList mobeffectlist = effect.c();
            mobeffectlist.a(this, this.eI(), effect.e());
            mobeffectlist.b(this, this.eI(), effect.e());
        }
    }

    protected void a(MobEffect effect) {
        this.bS = true;
        if (!this.H.B) {
            effect.c().a(this, this.eI(), effect.e());
        }
    }

    public void b(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(f2, regainReason, false);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float f1 = this.eo();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason, isFastRegen);
            if (this.valid) {
                this.H.getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.c((float)((double)this.eo() + event.getAmount()));
            }
        }
    }

    public float eo() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.am.a(bF).floatValue();
    }

    public void c(float health) {
        if (Float.isNaN(health)) {
            health = this.eE();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.cu() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.am.b(bF, Float.valueOf(MathHelper.a(health, 0.0f, this.eE())));
    }

    public boolean ep() {
        return this.eo() <= 0.0f;
    }

    public boolean couldPossiblyBeHurt(float amount) {
        return !((float)this.ak > (float)this.aQ / 2.0f) || !(amount <= this.bh);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag2;
        boolean knockbackCancelled;
        Entity entity1;
        if (this.b(source)) {
            return false;
        }
        if (this.H.B) {
            return false;
        }
        if (this.dB() || this.aZ || this.eo() <= 0.0f) {
            return false;
        }
        if (source.a(DamageTypeTags.i) && this.a(MobEffects.l)) {
            return false;
        }
        if (this.fu() && !this.H.B) {
            this.fv();
        }
        this.ba = 0;
        float f1 = amount;
        boolean flag = amount > 0.0f && this.f(source);
        float f2 = 0.0f;
        if (source.a(DamageTypeTags.o) && this.ae().a(TagsEntity.j)) {
            amount *= 5.0f;
        }
        this.aP.a(1.5f);
        boolean flag1 = true;
        if ((float)this.ak > (float)this.aQ / 2.0f && !source.a(DamageTypeTags.e)) {
            if (amount <= this.bh) {
                return false;
            }
            if (!this.damageEntity0(source, amount - this.bh)) {
                return false;
            }
            this.bh = amount;
            flag1 = false;
        } else {
            if (!this.damageEntity0(source, amount)) {
                return false;
            }
            this.bh = amount;
            this.ak = this.aQ;
            this.aJ = this.aK = 10;
        }
        if (this instanceof EntityAnimal) {
            ((EntityAnimal)this).fX();
            if (this instanceof EntityTameableAnimal) {
                ((EntityTameableAnimal)this).z(false);
            }
        }
        if ((entity1 = source.d()) != null) {
            EntityWolf entitywolf;
            if (entity1 instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity1;
                if (!source.a(DamageTypeTags.q)) {
                    this.a(entityliving1);
                }
            }
            if (entity1 instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity1;
                this.aY = 100;
                this.aX = entityhuman;
            } else if (entity1 instanceof EntityWolf && (entitywolf = (EntityWolf)entity1).q()) {
                EntityHuman entityhuman1;
                this.aY = 100;
                EntityLiving entityliving2 = entitywolf.H_();
                this.aX = entityliving2 instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entityliving2) : null;
            }
        }
        boolean bl = knockbackCancelled = this.H.paperConfig().environment.disableExplosionKnockback && source.a(DamageTypeTags.l) && this instanceof EntityHuman;
        if (flag1) {
            if (flag) {
                this.H.a((Entity)this, (byte)29);
            } else if (!knockbackCancelled) {
                this.H.a((Entity)this, source);
            }
            if (!(source.a(DamageTypeTags.r) || flag && !(amount > 0.0f))) {
                this.bj();
            }
            if (entity1 != null && !source.a(DamageTypeTags.l)) {
                double d1;
                boolean far = entity1.f(this) > 40000.0;
                double d0 = far ? Math.random() - Math.random() : entity1.dl() - this.dl();
                double d2 = d1 = far ? Math.random() - Math.random() : entity1.dr() - this.dr();
                while (d0 * d0 + d1 * d1 < 1.0E-4) {
                    d0 = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.knockback(0.4f, d0, d1, entity1);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (knockbackCancelled) {
            this.H.a((Entity)this, (byte)2);
        }
        if (this.ep()) {
            if (!this.h(source)) {
                this.silentDeath = !flag1;
                this.a(source);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.e(source);
        }
        boolean bl2 = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            this.cc = source;
            this.cd = this.H.U();
        }
        if (this instanceof EntityPlayer) {
            CriterionTriggers.h.a((EntityPlayer)this, source, f1, amount, flag);
            if (f2 > 0.0f && f2 < 3.4028235E37f) {
                ((EntityPlayer)this).a(StatisticList.K, Math.round(f2 * 10.0f));
            }
        }
        if (entity1 instanceof EntityPlayer) {
            CriterionTriggers.g.a((EntityPlayer)entity1, this, source, f1, amount, flag);
        }
        return flag2;
    }

    protected void d(EntityLiving attacker) {
        attacker.e(this);
    }

    protected void e(EntityLiving target) {
        target.knockback(0.5, target.dl() - this.dl(), target.dr() - this.dr(), this);
    }

    private boolean h(DamageSource source) {
        if (source.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemstack = null;
        EnumHand[] aenumhand = EnumHand.values();
        int i2 = aenumhand.length;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.b;
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumHand enumhand = aenumhand[j2];
            itemstack1 = this.b(enumhand);
            if (!itemstack1.a(Items.uu)) continue;
            hand = enumhand;
            itemstack = itemstack1.o();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot, true);
        event.setCancelled(itemstack == null);
        this.H.getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.b() && itemstack != null && event.isShrink()) {
                itemstack1.h(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(Items.uu));
                CriterionTriggers.B.a(entityplayer, itemstack);
            }
            this.c(1.0f);
            this.removeAllEffects(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.j, 900, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.v, 100, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.l, 800, 0), EntityPotionEffectEvent.Cause.TOTEM);
            this.H.a((Entity)this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Nullable
    public DamageSource eq() {
        if (this.H.U() - this.cd > 40L) {
            this.cc = null;
        }
        return this.cc;
    }

    protected void e(DamageSource source) {
        SoundEffect soundeffect = this.d(source);
        if (soundeffect != null) {
            this.a(soundeffect, this.eN(), this.eO());
        }
    }

    public boolean f(DamageSource source) {
        Vec3D vec3d;
        EntityArrow entityarrow;
        Entity entity = source.c();
        boolean flag = false;
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).t() > 0) {
            flag = true;
        }
        if (!source.a(DamageTypeTags.c) && this.fl() && !flag && (vec3d = source.h()) != null) {
            Vec3D vec3d1 = this.j(1.0f);
            Vec3D vec3d2 = vec3d.a(this.de()).d();
            vec3d2 = new Vec3D(vec3d2.c, 0.0, vec3d2.e);
            if (vec3d2.b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private void i(ItemStack stack) {
        if (!stack.b()) {
            if (!this.aO()) {
                this.H.a(this.dl(), this.dn(), this.dr(), SoundEffects.lQ, this.cX(), 0.8f, 0.8f + this.H.z.i() * 0.4f, false);
            }
            this.a(stack, 5);
        }
    }

    public void a(DamageSource damageSource) {
        if (!this.dB() && !this.aZ) {
            Entity entity = damageSource.d();
            EntityLiving entityliving = this.eD();
            this.aZ = true;
            if (this.H instanceof WorldServer) {
                EntityDeathEvent deathEvent = this.dropAllDeathLoot(damageSource);
                if (deathEvent == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.b);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.fu()) {
                        this.fv();
                    }
                    if (!this.H.B && this.aa() && SpigotConfig.logNamedDeaths) {
                        b.info("Named entity {} died: {}", (Object)this, (Object)this.eC().b().getString());
                    }
                    this.eC().g();
                    if (entity != null) {
                        entity.a((WorldServer)this.H, this);
                    }
                    this.a(GameEvent.q);
                } else {
                    this.aZ = false;
                    this.c((float)deathEvent.getReviveHealth());
                }
                this.f(entityliving);
            }
            if (this.aZ) {
                this.H.a((Entity)this, (byte)3);
                this.b(EntityPose.h);
            }
        }
    }

    protected void f(@Nullable EntityLiving adversary) {
        if (!this.H.B) {
            boolean flag = false;
            if (this.aZ && adversary instanceof EntityWither) {
                if (this.H.W().b(GameRules.c)) {
                    BlockPosition blockposition = this.dg();
                    IBlockData iblockdata = Blocks.cc.o();
                    if (this.H.a_(blockposition).h() && iblockdata.a((IWorldReader)this.H, blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.H, blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.H, this.dl(), this.dn(), this.dr(), new ItemStack(Items.cZ));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.H.b(entityitem);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(DamageSource source) {
        Entity entity = source.d();
        int i2 = entity instanceof EntityHuman ? EnchantmentManager.h((EntityLiving)entity) : 0;
        boolean flag = this.aY > 0;
        this.er();
        if (this.dW() && this.H.W().b(GameRules.f)) {
            this.a(source, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(source, i2, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.drops, () -> {
            EntityLiving entityliving = this.eD();
            if (this.bg >= 0 && entityliving != null) {
                entityliving.a((Entity)this, this.bg, source);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList();
        this.es();
        return deathEvent;
    }

    protected void er() {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward() {
        if (this.H instanceof WorldServer && !this.ev() && (this.dY() || this.aY > 0 && this.dV() && this.H.W().b(GameRules.f))) {
            int i2 = this.dX();
            return i2;
        }
        return 0;
    }

    protected void es() {
        if (!(this instanceof EntityEnderDragon)) {
            EntityLiving attacker = this.aX != null ? this.aX : this.bT;
            EntityExperienceOrb.award((WorldServer)this.H, this.de(), this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, attacker, this);
            this.expToDrop = 0;
        }
    }

    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
    }

    public MinecraftKey et() {
        return this.ae().j();
    }

    protected void a(DamageSource source, boolean causedByPlayer) {
        MinecraftKey minecraftkey = this.et();
        LootTable loottable = this.H.n().aH().a(minecraftkey);
        LootTableInfo.Builder loottableinfo_builder = this.a(causedByPlayer, source);
        loottable.c(loottableinfo_builder.a(LootContextParameterSets.f), this::b);
    }

    protected LootTableInfo.Builder a(boolean causedByPlayer, DamageSource source) {
        LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.H).a(this.af).a(LootContextParameters.a, this).a(LootContextParameters.f, this.de()).a(LootContextParameters.c, source).b(LootContextParameters.d, source.d()).b(LootContextParameters.e, source.c());
        if (causedByPlayer && this.aX != null) {
            loottableinfo_builder = loottableinfo_builder.a(LootContextParameters.b, this.aX).a(this.aX.gf());
        }
        return loottableinfo_builder;
    }

    public void q(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null);
    }

    public void knockback(double strength, double x2, double z2, Entity knockingBackEntity) {
        if ((strength *= 1.0 - this.b(GenericAttributes.c)) > 0.0) {
            this.at = true;
            Vec3D vec3d = this.dj();
            Vec3D vec3d1 = new Vec3D(x2, 0.0, z2).d().a(strength);
            this.o(vec3d.c / 2.0 - vec3d1.c, this.N ? Math.min(0.4, vec3d.d / 2.0 + strength) : vec3d.d, vec3d.e / 2.0 - vec3d1.e);
            Vec3D currentMovement = this.dj();
            Vector delta = new Vector(currentMovement.c - vec3d.c, currentMovement.d - vec3d.d, currentMovement.e - vec3d.e);
            this.f(vec3d);
            if (knockingBackEntity == null || new EntityKnockbackByEntityEvent((LivingEntity)this.getBukkitEntity(), (org.bukkit.entity.Entity)knockingBackEntity.getBukkitEntity(), (float)strength, delta).callEvent()) {
                this.o(vec3d.c + delta.getX(), vec3d.d + delta.getY(), vec3d.e + delta.getZ());
            }
        }
    }

    public void a(double deltaX, double deltaZ) {
    }

    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.iQ;
    }

    @Nullable
    public SoundEffect x_() {
        return SoundEffects.iL;
    }

    private SoundEffect d(int distance) {
        return distance > 4 ? this.ey().b() : this.ey().a();
    }

    public void eu() {
        this.cg = true;
    }

    public boolean ev() {
        return this.cg;
    }

    protected Vec3D ew() {
        Entity entity = this.cV();
        if (entity instanceof RiderShieldingMount) {
            RiderShieldingMount ridershieldingmount = (RiderShieldingMount)((Object)entity);
            return this.de().b(0.0, ridershieldingmount.d(), 0.0);
        }
        return this.de();
    }

    public float ex() {
        return 0.0f;
    }

    public a ey() {
        return new a(SoundEffects.iR, SoundEffects.iJ);
    }

    protected SoundEffect c(ItemStack stack) {
        return stack.M();
    }

    public SoundEffect d(ItemStack stack) {
        return stack.N();
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.d(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.x_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.d(fallHeight);
    }

    public SoundEffect getDrinkingSound0(ItemStack itemstack) {
        return this.c(itemstack);
    }

    public SoundEffect getEatingSound0(ItemStack itemstack) {
        return this.d(itemstack);
    }

    @Override
    public void c(boolean onGround) {
        super.c(onGround);
        if (onGround) {
            this.cb = Optional.empty();
        }
    }

    public Optional<BlockPosition> ez() {
        return this.cb;
    }

    public boolean onClimableCached() {
        if (!LeavesConfig.cacheClimbCheck) {
            return this.z_();
        }
        if (!this.dg().equals(this.lastClimbingPosition)) {
            this.cachedOnClimable = this.z_();
            this.lastClimbingPosition = this.dg();
        }
        return this.cachedOnClimable;
    }

    public boolean z_() {
        if (this.F_()) {
            return false;
        }
        BlockPosition blockposition = this.dg();
        IBlockData iblockdata = this.dh();
        if (iblockdata.a(TagsBlock.aM)) {
            this.cb = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.cb = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        IBlockData iblockdata1;
        return state.c(BlockTrapdoor.a) != false && (iblockdata1 = this.H.a_(pos.d())).a(Blocks.cN) && iblockdata1.c(BlockLadder.a) == state.c(BlockFacingHorizontal.aD);
    }

    @Override
    public boolean bq() {
        return !this.dB() && this.eo() > 0.0f;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        int i2 = this.d(fallDistance, damageMultiplier);
        if (i2 > 0) {
            if (!this.a(damageSource, (float)i2)) {
                return true;
            }
            this.a(this.d(i2), 1.0f, 1.0f);
            this.eA();
            return true;
        }
        return flag;
    }

    protected int d(float fallDistance, float damageMultiplier) {
        if (this.ae().a(TagsEntity.l)) {
            return 0;
        }
        MobEffect mobeffect = this.b(MobEffects.h);
        float f2 = mobeffect == null ? 0.0f : (float)(mobeffect.e() + 1);
        return MathHelper.f((fallDistance - 3.0f - f2) * damageMultiplier);
    }

    protected void eA() {
        int k2;
        int j2;
        int i2;
        IBlockData iblockdata;
        if (!this.aO() && !(iblockdata = this.H.a_(new BlockPosition(i2 = MathHelper.a(this.dl()), j2 = MathHelper.a(this.dn() - (double)0.2f), k2 = MathHelper.a(this.dr())))).h()) {
            SoundEffectType soundeffecttype = iblockdata.t();
            this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
        }
    }

    @Override
    public void q(float yaw) {
        this.aJ = this.aK = 10;
    }

    public int eB() {
        return MathHelper.a(this.b(GenericAttributes.i));
    }

    protected void b(DamageSource source, float amount) {
    }

    protected void c(DamageSource source, float amount) {
    }

    protected void d(float amount) {
    }

    protected float d(DamageSource source, float amount) {
        if (!source.a(DamageTypeTags.b)) {
            amount = CombatMath.a(amount, this.eB(), (float)this.b(GenericAttributes.j));
        }
        return amount;
    }

    protected float e(DamageSource source, float amount) {
        if (source.a(DamageTypeTags.f)) {
            return amount;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        if (source.a(DamageTypeTags.h)) {
            return amount;
        }
        int i2 = EnchantmentManager.a(this.bI(), source);
        if (i2 > 0) {
            amount = CombatMath.a(amount, i2);
        }
        return amount;
    }

    protected boolean damageEntity0(final DamageSource damagesource, float f2) {
        if (!this.b(damagesource)) {
            Entity entity;
            float f3;
            boolean human = this instanceof EntityHuman;
            float originalDamage = f2;
            Function<Double, Double> hardHat = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.c(EnumItemSlot.f).b()) {
                        return -(f2 - f2 * 0.75);
                    }
                    return -0.0;
                }
            };
            float hardHatModifier = ((Double)hardHat.apply((Object)f2)).floatValue();
            Function<Double, Double> blocking = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(EntityLiving.this.f(damagesource) ? f2 : 0.0);
                }
            };
            float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
            Function<Double, Double> armor = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.d(damagesource, f2.floatValue()));
                }
            };
            float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
            Function<Double, Double> resistance = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.a(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                        int i2 = (EntityLiving.this.b(MobEffects.k).e() + 1) * 5;
                        int j2 = 25 - i2;
                        float f1 = f2.floatValue() * (float)j2;
                        return -(f2 - (double)(f1 / 25.0f));
                    }
                    return -0.0;
                }
            };
            float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
            Function<Double, Double> magic = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
                }
            };
            float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
            Function<Double, Double> absorption = new Function<Double, Double>(){

                public Double apply(Double f2) {
                    return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.fb(), 0.0), 0.0);
                }
            };
            float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
            EntityDamageEvent event = CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, hardHat, blocking, armor, resistance, magic, absorption);
            if (damagesource.d() instanceof EntityHuman) {
                if (damagesource.d() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damagesource.d();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.z(0.0f)).callEvent()) {
                        player.gd();
                    }
                } else {
                    ((EntityHuman)damagesource.d()).gd();
                }
            }
            if (event.isCancelled()) {
                return false;
            }
            f2 = (float)event.getFinalDamage();
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.c(EnumItemSlot.f).b()) {
                this.c(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.b)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.b(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.H.a((Entity)this, (byte)29);
                this.d((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity2 = damagesource.c();
                if (entity2 instanceof EntityLiving && entity2.f(this) <= 40000.0) {
                    this.d((EntityLiving)entity2);
                }
            }
            absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.x(Math.max(this.fb() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.L, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.H, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(f2 * 10.0f));
                    }
                }
                float f32 = this.eo();
                this.eC().a(damagesource, f32, f2);
                this.c(f32 - f2);
                if (!human) {
                    this.x(this.fb() - f2);
                }
                this.a(GameEvent.p);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)this, damagesource, originalDamage, f2, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.g.a((EntityPlayer)damagesource.d(), this, damagesource, originalDamage, f2, true);
                }
                return false;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker eC() {
        return this.bN;
    }

    @Nullable
    public EntityLiving eD() {
        return this.bN.c() != null ? this.bN.c() : (this.aX != null ? this.aX : (this.bT != null ? this.bT : null));
    }

    public final float eE() {
        return (float)this.b(GenericAttributes.a);
    }

    public final int eF() {
        return this.am.a(bI);
    }

    public final void o(int stuckArrowCount) {
        this.setArrowCount(stuckArrowCount, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.eF(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.am.b(bI, event.getNewAmount());
    }

    public final int eG() {
        return this.am.a(bJ);
    }

    public final void p(int stingerCount) {
        this.am.b(bJ, stingerCount);
    }

    private int s() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.a(MobEffects.d) ? 6 + (1 + this.b(MobEffects.d).e()) * 2 : 6);
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean fromServerPlayer) {
        if (!this.aE || this.aG >= this.s() / 2 || this.aG < 0) {
            this.aG = -1;
            this.aE = true;
            this.aF = hand;
            if (this.H instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.H).k();
                if (fromServerPlayer) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damageSource) {
        this.aP.a(1.5f);
        this.ak = 20;
        this.aJ = this.aK = 10;
        SoundEffect soundeffect = this.d(damageSource);
        if (soundeffect != null) {
            this.a(soundeffect, this.eN(), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
        }
        this.a(this.dG().n(), 0.0f);
        this.cc = damageSource;
        this.cd = this.H.U();
    }

    @Override
    public void b(byte status) {
        switch (status) {
            case 3: {
                SoundEffect soundeffect = this.x_();
                if (soundeffect != null) {
                    this.a(soundeffect, this.eN(), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.c(0.0f);
                this.a(this.dG().n());
                break;
            }
            case 29: {
                this.a(SoundEffects.uA, 1.0f, 0.8f + this.H.z.i() * 0.4f);
                break;
            }
            case 30: {
                this.a(SoundEffects.uB, 0.8f, 0.8f + this.H.z.i() * 0.4f);
                break;
            }
            case 46: {
                boolean flag = true;
                for (int i2 = 0; i2 < 128; ++i2) {
                    double d0 = (double)i2 / 127.0;
                    float f2 = (this.af.i() - 0.5f) * 0.2f;
                    float f1 = (this.af.i() - 0.5f) * 0.2f;
                    float f22 = (this.af.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.I, this.dl()) + (this.af.j() - 0.5) * (double)this.dc() * 2.0;
                    double d2 = MathHelper.d(d0, this.J, this.dn()) + this.af.j() * (double)this.dd();
                    double d3 = MathHelper.d(d0, this.K, this.dr()) + (this.af.j() - 0.5) * (double)this.dc() * 2.0;
                    this.H.a(Particles.Z, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                return;
            }
            case 47: {
                this.i(this.c(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.i(this.c(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.i(this.c(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.i(this.c(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.i(this.c(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.i(this.c(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.y();
                break;
            }
            case 60: {
                this.x();
                break;
            }
            default: {
                super.b(status);
            }
        }
    }

    private void x() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.H.a(Particles.Y, this.d(1.0), this.do(), this.g(1.0), d0, d1, d2);
        }
    }

    private void y() {
        ItemStack itemstack = this.c(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.c(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void aw() {
        this.a(this.dG().m(), 4.0f);
    }

    protected void eH() {
        int i2 = this.s();
        if (this.aE) {
            ++this.aG;
            if (this.aG >= i2) {
                this.aG = 0;
                this.aE = false;
            }
        } else {
            this.aG = 0;
        }
        this.aN = (float)this.aG / (float)i2;
    }

    @Nullable
    public AttributeModifiable a(AttributeBase attribute) {
        return this.eI().a(attribute);
    }

    public double a(Holder<AttributeBase> attribute) {
        return this.b(attribute.a());
    }

    public double b(AttributeBase attribute) {
        return this.eI().c(attribute);
    }

    public double b(Holder<AttributeBase> attribute) {
        return this.c(attribute.a());
    }

    public double c(AttributeBase attribute) {
        return this.eI().d(attribute);
    }

    public AttributeMapBase eI() {
        return this.bM;
    }

    public EnumMonsterType eJ() {
        return EnumMonsterType.a;
    }

    public ItemStack eK() {
        return this.c(EnumItemSlot.a);
    }

    public ItemStack eL() {
        return this.c(EnumItemSlot.b);
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.eK()) || predicate.test(this.eL());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.c(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.c(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean b(EnumItemSlot slot) {
        return !this.c(slot).b();
    }

    @Override
    public abstract Iterable<ItemStack> bI();

    public abstract ItemStack c(EnumItemSlot var1);

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.a(enumitemslot, itemstack);
    }

    @Override
    public abstract void a(EnumItemSlot var1, ItemStack var2);

    protected void e(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.u();
        if (nbttagcompound != null) {
            stack.c().b(nbttagcompound);
        }
    }

    public float eM() {
        Iterable<ItemStack> iterable = this.bI();
        int i2 = 0;
        int j2 = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.b()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void g(boolean sprinting) {
        super.g(sprinting);
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable.a(c) != null) {
            attributemodifiable.d(bz);
        }
        if (sprinting) {
            attributemodifiable.b(bz);
        }
    }

    public float eN() {
        return 1.0f;
    }

    public float eO() {
        return this.y_() ? (this.af.i() - this.af.i()) * 0.2f + 1.5f : (this.af.i() - this.af.i()) * 0.2f + 1.0f;
    }

    protected boolean eP() {
        return this.ep();
    }

    @Override
    public void g(Entity entity) {
        if (!this.fu()) {
            super.g(entity);
        }
    }

    private void a(Entity vehicle) {
        Vec3D vec3d;
        if (this.dB()) {
            vec3d = this.de();
        } else if (!vehicle.dB() && !this.H.a_(vehicle.dg()).a(TagsBlock.aG)) {
            vec3d = vehicle.b(this);
        } else {
            double d0 = Math.max(this.dn(), vehicle.dn());
            vec3d = new Vec3D(this.dl(), d0, this.dr());
        }
        this.a(vec3d.c, vec3d.d, vec3d.e);
    }

    @Override
    public boolean cy() {
        return this.cx();
    }

    protected float eQ() {
        return 0.42f * this.aE();
    }

    public double eR() {
        return this.a(MobEffects.h) ? (double)(0.1f * (float)(this.b(MobEffects.h).e() + 1)) : 0.0;
    }

    protected void eS() {
        double d0 = (double)this.eQ() + this.eR();
        Vec3D vec3d = this.dj();
        long time = System.nanoTime();
        boolean canCrit = true;
        if (this instanceof EntityHuman) {
            canCrit = false;
            if (time - this.lastJumpTime > 250000000L) {
                this.lastJumpTime = time;
                canCrit = true;
            }
        }
        this.o(vec3d.c, d0, vec3d.e);
        if (this.bU()) {
            float f2 = this.dw() * ((float)Math.PI / 180);
            if (canCrit) {
                this.f(this.dj().b(-MathHelper.a(f2) * 0.2f, 0.0, MathHelper.b(f2) * 0.2f));
            }
        }
        this.at = true;
    }

    protected void eT() {
        this.f(this.dj().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluid) {
        this.f(this.dj().b(0.0, 0.04f, 0.0));
    }

    protected float eU() {
        return 0.8f;
    }

    public boolean a(Fluid state) {
        return false;
    }

    public void h(Vec3D movementInput) {
        if (this.cT()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = this.dj().d <= 0.0;
            if (flag && this.a(MobEffects.B)) {
                d0 = 0.01;
                this.n();
            }
            Fluid fluid = this.H.b_(this.dg());
            if (this.aT() && this.dT() && !this.a(fluid)) {
                double d1 = this.dn();
                float f2 = this.bU() ? 0.9f : this.eU();
                float f1 = 0.02f;
                float f22 = EnchantmentManager.f(this);
                if (f22 > 3.0f) {
                    f22 = 3.0f;
                }
                if (!this.N) {
                    f22 *= 0.5f;
                }
                if (f22 > 0.0f) {
                    f2 += (0.54600006f - f2) * f22 / 3.0f;
                    f1 += (this.eW() - f1) * f22 / 3.0f;
                }
                if (this.a(MobEffects.D)) {
                    f2 = 0.96f;
                }
                this.a(f1, movementInput);
                this.a(EnumMoveType.a, this.dj());
                Vec3D vec3d1 = this.dj();
                if (this.O && this.z_()) {
                    vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
                }
                this.f(vec3d1.d(f2, 0.8f, f2));
                Vec3D vec3d2 = this.a(d0, flag, this.dj());
                this.f(vec3d2);
                if (this.O && this.g(vec3d2.c, vec3d2.d + (double)0.6f - this.dn() + d1, vec3d2.e)) {
                    this.o(vec3d2.c, 0.3f, vec3d2.e);
                }
            } else if (this.bg() && this.dT() && !this.a(fluid)) {
                Vec3D vec3d3;
                double d1 = this.dn();
                this.a(0.02f, movementInput);
                this.a(EnumMoveType.a, this.dj());
                if (this.b(TagsFluid.b) <= this.db()) {
                    this.f(this.dj().d(0.5, 0.8f, 0.5));
                    vec3d3 = this.a(d0, flag, this.dj());
                    this.f(vec3d3);
                } else {
                    this.f(this.dj().a(0.5));
                }
                if (!this.aP()) {
                    this.f(this.dj().b(0.0, -d0 / 4.0, 0.0));
                }
                vec3d3 = this.dj();
                if (this.O && this.g(vec3d3.c, vec3d3.d + (double)0.6f - this.dn() + d1, vec3d3.e)) {
                    this.o(vec3d3.c, 0.3f, vec3d3.e);
                }
            } else if (this.fn()) {
                double d7;
                float f3;
                double d6;
                this.ci();
                Vec3D vec3d4 = this.dj();
                Vec3D vec3d5 = this.bC();
                float f4 = this.dy() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.c * vec3d5.c + vec3d5.e * vec3d5.e);
                double d3 = vec3d4.h();
                double d4 = vec3d5.f();
                double d5 = Math.cos(f4);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3d4 = this.dj().b(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3d4.d < 0.0 && d2 > 0.0) {
                    d6 = vec3d4.d * -0.1 * d5;
                    vec3d4 = vec3d4.b(vec3d5.c * d6 / d2, d6, vec3d5.e * d6 / d2);
                }
                if (f4 < 0.0f && d2 > 0.0) {
                    d6 = d3 * (double)(-MathHelper.a(f4)) * 0.04;
                    vec3d4 = vec3d4.b(-vec3d5.c * d6 / d2, d6 * 3.2, -vec3d5.e * d6 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.b((vec3d5.c / d2 * d3 - vec3d4.c) * 0.1, 0.0, (vec3d5.e / d2 * d3 - vec3d4.e) * 0.1);
                }
                this.f(vec3d4.d(0.99f, 0.98f, 0.99f));
                this.a(EnumMoveType.a, this.dj());
                if (this.O && !this.H.B && (f3 = (float)((d7 = d3 - (d6 = this.dj().h())) * 10.0 - 3.0)) > 0.0f) {
                    this.a(this.d((int)f3), 1.0f, 1.0f);
                    this.a(this.dG().l(), f3);
                }
                if (this.N && !this.H.B && this.h(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
            } else {
                BlockPosition blockposition = this.aG();
                float f4 = this.H.a_(blockposition).b().i();
                float f5 = this.N ? f4 * 0.91f : 0.91f;
                Vec3D vec3d6 = this.a(movementInput, f4);
                double d8 = vec3d6.d;
                if (this.a(MobEffects.y)) {
                    d8 += (0.05 * (double)(this.b(MobEffects.y).e() + 1) - vec3d6.d) * 0.2;
                    this.n();
                } else if (this.H.B && !this.H.D(blockposition)) {
                    d8 = this.dn() > (double)this.H.v_() ? -0.1 : 0.0;
                } else if (!this.aP()) {
                    d8 -= d0;
                }
                if (this.ef()) {
                    this.o(vec3d6.c, d8, vec3d6.e);
                } else {
                    this.o(vec3d6.c * (double)f5, d8 * (double)0.98f, vec3d6.e * (double)f5);
                }
            }
        }
        this.q(this instanceof EntityBird);
    }

    private void c(EntityLiving controllingPassenger, Vec3D movementInput) {
        Vec3D vec3d1 = this.b(controllingPassenger, movementInput);
        this.a(controllingPassenger, vec3d1);
        if (this.cT()) {
            this.h(this.g(controllingPassenger));
            this.h(vec3d1);
        } else {
            this.q(false);
            this.f(Vec3D.b);
            this.ay();
        }
    }

    protected void a(EntityLiving controllingPassenger, Vec3D movementInput) {
    }

    protected Vec3D b(EntityLiving controllingPassenger, Vec3D movementInput) {
        return movementInput;
    }

    protected float g(EntityLiving controllingPassenger) {
        return this.eW();
    }

    public void q(boolean flutter) {
        float f2 = (float)MathHelper.f(this.dl() - this.I, flutter ? this.dn() - this.J : 0.0, this.dr() - this.K);
        this.g(f2);
    }

    protected void g(float posDelta) {
        float f1 = Math.min(posDelta * 4.0f, 1.0f);
        this.aP.a(f1, 0.4f);
    }

    public Vec3D a(Vec3D movementInput, float slipperiness) {
        this.a(this.y(slipperiness), movementInput);
        this.f(this.j(this.dj()));
        this.a(EnumMoveType.a, this.dj());
        Vec3D vec3d1 = this.dj();
        if ((this.O || this.bi) && (this.z_() || this.dh().a(Blocks.qy) && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.c, 0.2, vec3d1.e);
        }
        return vec3d1;
    }

    public Vec3D a(double gravity, boolean falling, Vec3D motion) {
        if (!this.aP() && !this.bU()) {
            double d1 = falling && Math.abs(motion.d - 0.005) >= 0.003 && Math.abs(motion.d - gravity / 16.0) < 0.003 ? -0.003 : motion.d - gravity / 16.0;
            return new Vec3D(motion.c, d1, motion.e);
        }
        return motion;
    }

    private Vec3D j(Vec3D motion) {
        if (this.z_()) {
            this.n();
            float f2 = 0.15f;
            double d0 = MathHelper.a(motion.c, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(motion.e, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(motion.d, (double)-0.15f);
            if (d2 < 0.0 && !this.dh().a(Blocks.nO) && this.fm() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            motion = new Vec3D(d0, d2, d1);
        }
        return motion;
    }

    private float y(float slipperiness) {
        return this.N ? this.eW() * (0.21600002f / (slipperiness * slipperiness * slipperiness)) : this.eV();
    }

    protected float eV() {
        return this.cK() instanceof EntityHuman ? this.eW() * 0.1f : 0.02f;
    }

    public float eW() {
        return this.bX;
    }

    public void h(float movementSpeed) {
        this.bX = movementSpeed;
    }

    public boolean z(Entity target) {
        this.x(target);
        return false;
    }

    @Override
    public void l() {
        super.l();
        this.D();
        this.G();
        if (!this.H.B) {
            int j2;
            int i2 = this.eF();
            if (i2 > 0) {
                if (this.aH <= 0) {
                    this.aH = 20 * (30 - i2);
                }
                --this.aH;
                if (this.aH <= 0) {
                    this.o(i2 - 1);
                }
            }
            if ((j2 = this.eG()) > 0) {
                if (this.aI <= 0) {
                    this.aI = 20 * (30 - j2);
                }
                --this.aI;
                if (this.aI <= 0) {
                    this.p(j2 - 1);
                }
            }
            this.z();
            if (this.ag % 20 == 0) {
                this.eC().g();
            }
            if (this.fu() && !this.I()) {
                this.fv();
            }
        }
        if (!this.dB()) {
            this.b_();
        }
        double d0 = this.dl() - this.I;
        double d1 = this.dr() - this.K;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.aT;
        float f22 = 0.0f;
        this.bb = this.bc;
        float f3 = 0.0f;
        if (f2 > 0.0025000002f) {
            f3 = 1.0f;
            f22 = (float)Math.sqrt(f2) * 3.0f;
            float f4 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f5 = MathHelper.e(MathHelper.g(this.dw()) - f4);
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.aN > 0.0f) {
            f1 = this.dw();
        }
        if (!this.N) {
            f3 = 0.0f;
        }
        this.bc += (f3 - this.bc) * 0.3f;
        this.H.ac().a("headTurn");
        f22 = this.e(f1, f22);
        this.H.ac().c();
        this.H.ac().a("rangeChecks");
        this.L += (float)Math.round((this.dw() - this.L) / 360.0f) * 360.0f;
        this.aU += (float)Math.round((this.aT - this.aU) / 360.0f) * 360.0f;
        this.M += (float)Math.round((this.dy() - this.M) / 360.0f) * 360.0f;
        this.aW += (float)Math.round((this.aV - this.aW) / 360.0f) * 360.0f;
        this.H.ac().c();
        this.bd += f22;
        this.bw = this.fn() ? ++this.bw : 0;
        if (this.fu()) {
            this.e(0.0f);
        }
    }

    public void z() {
        Map<EnumItemSlot, ItemStack> map = this.A();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> A() {
        EnumMap map = null;
        block4: for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack;
            switch (enumitemslot.a()) {
                case a: {
                    itemstack = this.f(enumitemslot);
                    break;
                }
                case b: {
                    itemstack = this.e(enumitemslot);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemstack1 = this.c(enumitemslot);
            if (!this.a(itemstack, itemstack1)) continue;
            if (this instanceof EntityPlayer && enumitemslot.a() == EnumItemSlot.Function.b) {
                org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemstack);
                org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemstack1);
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumitemslot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumitemslot, itemstack1);
            if (!itemstack.b()) {
                this.eI().a(itemstack.a(enumitemslot));
            }
            if (itemstack1.b()) continue;
            this.eI().b(itemstack1.a(enumitemslot));
        }
        return map;
    }

    public boolean a(ItemStack stack, ItemStack stack2) {
        return !ItemStack.b(stack2, stack);
    }

    private void a(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ItemStack itemstack = equipmentChanges.get((Object)EnumItemSlot.a);
        ItemStack itemstack1 = equipmentChanges.get((Object)EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.b(itemstack, this.f(EnumItemSlot.b)) && ItemStack.b(itemstack1, this.f(EnumItemSlot.a))) {
            ((WorldServer)this.H).k().b(this, new PacketPlayOutEntityStatus(this, 55));
            equipmentChanges.remove((Object)EnumItemSlot.a);
            equipmentChanges.remove((Object)EnumItemSlot.b);
            this.c(EnumItemSlot.a, itemstack.o());
            this.c(EnumItemSlot.b, itemstack1.o());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipmentChanges.size());
        equipmentChanges.forEach((enumitemslot, itemstack) -> {
            ItemStack toSend;
            ItemStack itemstack1 = itemstack.o();
            list.add(Pair.of((Object)enumitemslot, (Object)this.stripMeta(toSend, (toSend = EntityLiving.sanitizeItemStack(itemstack1, true)) == itemstack1)));
            switch (enumitemslot.a()) {
                case a: {
                    this.c((EnumItemSlot)((Object)enumitemslot), itemstack1);
                    break;
                }
                case b: {
                    this.b((EnumItemSlot)((Object)enumitemslot), itemstack1);
                }
            }
        });
        ((WorldServer)this.H).k().b(this, new PacketPlayOutEntityEquipment(this.af(), list));
    }

    public ItemStack stripMeta(ItemStack itemStack, boolean copyItemStack) {
        ItemStack copy;
        if (itemStack.b() || !itemStack.t() && itemStack.K() < 2) {
            return itemStack;
        }
        ItemStack itemStack2 = copy = copyItemStack ? itemStack.o() : itemStack;
        if (this.H.paperConfig().anticheat.obfuscation.items.hideDurability && (!copy.a(Items.nd) || copy.j() < copy.k() - 1)) {
            copy.b(0);
        }
        NBTTagCompound tag = copy.u();
        if (this.H.paperConfig().anticheat.obfuscation.items.hideItemmeta) {
            copy.f(copy.K() > 1 ? 2 : 1);
            if (tag != null) {
                NBTTagList enchantmentsTag;
                NBTBase nBTBase = tag.c("display");
                if (nBTBase instanceof NBTTagCompound) {
                    NBTTagCompound displayTag = (NBTTagCompound)nBTBase;
                    displayTag.r("Lore");
                    displayTag.r("Name");
                }
                if ((nBTBase = tag.c("Enchantments")) instanceof NBTTagList && !(enchantmentsTag = (NBTTagList)nBTBase).isEmpty()) {
                    NBTTagList enchantments = new NBTTagList();
                    NBTTagCompound fakeEnchantment = new NBTTagCompound();
                    if (EnchantmentManager.a(Enchantments.l, itemStack) > 0) {
                        fakeEnchantment.a("id", Enchantment.SOUL_SPEED.getKey().asString());
                        fakeEnchantment.a("lvl", 1);
                    }
                    enchantments.add(fakeEnchantment);
                    tag.a("Enchantments", enchantments);
                }
                tag.r("AttributeModifiers");
                tag.r("author");
                tag.r("filtered_title");
                tag.r("pages");
                tag.r("filtered_pages");
                tag.r("title");
                tag.r("generation");
            }
        }
        if (this.H.paperConfig().anticheat.obfuscation.items.hideItemmetaWithVisualEffects && tag != null) {
            tag.r("LodestonePos");
            if (tag.e("LodestoneDimension")) {
                tag.a("LodestoneDimension", "paper:paper");
            }
        }
        return copy;
    }

    public static ItemStack sanitizeItemStack(ItemStack itemStack, boolean copyItemStack) {
        NBTTagList oldItems;
        NBTBase nBTBase;
        if (itemStack.b() || !itemStack.t()) {
            return itemStack;
        }
        ItemStack copy = copyItemStack ? itemStack.o() : itemStack;
        NBTTagCompound tag = copy.u();
        if (copy.a(Items.qc) && (nBTBase = tag.c("Items")) instanceof NBTTagList && !(oldItems = (NBTTagList)nBTBase).isEmpty()) {
            BundleMeta bundleMeta = (BundleMeta)copy.asBukkitMirror().getItemMeta();
            int sizeUsed = 0;
            for (org.bukkit.inventory.ItemStack item : bundleMeta.getItems()) {
                int scale = 64 / item.getMaxStackSize();
                sizeUsed += scale * item.getAmount();
            }
            NBTTagList items = new NBTTagList();
            items.add(new ItemStack(Items.pW, sizeUsed).b(new NBTTagCompound()));
            tag.a("Items", items);
        }
        if ((nBTBase = tag.c("BlockEntityTag")) instanceof NBTTagCompound) {
            NBTTagCompound blockEntityTag = (NBTTagCompound)nBTBase;
            blockEntityTag.r("Items");
        }
        return copy;
    }

    private ItemStack e(EnumItemSlot slot) {
        return this.bQ.get(slot.b());
    }

    private void b(EnumItemSlot slot, ItemStack armor) {
        this.bQ.set(slot.b(), armor);
    }

    private ItemStack f(EnumItemSlot slot) {
        return this.bP.get(slot.b());
    }

    private void c(EnumItemSlot slot, ItemStack stack) {
        this.bP.set(slot.b(), stack);
    }

    protected float e(float bodyRotation, float headRotation) {
        boolean flag;
        float f2 = MathHelper.g(bodyRotation - this.aT);
        this.aT += f2 * 0.3f;
        float f3 = MathHelper.g(this.dw() - this.aT);
        if (Math.abs(f3) > 50.0f) {
            this.aT += f3 - (float)(MathHelper.j((double)f3) * 50);
        }
        boolean bl = flag = f3 < -90.0f || f3 >= 90.0f;
        if (flag) {
            headRotation *= -1.0f;
        }
        return headRotation;
    }

    public void b_() {
        if (this.bY > 0) {
            --this.bY;
        }
        if (this.cT()) {
            this.bm = 0;
            this.f(this.dl(), this.dn(), this.dr());
        }
        if (this.bm > 0) {
            double d0 = this.dl() + (this.bn - this.dl()) / (double)this.bm;
            double d1 = this.dn() + (this.bo - this.dn()) / (double)this.bm;
            double d2 = this.dr() + (this.bp - this.dr()) / (double)this.bm;
            double d3 = MathHelper.d(this.bq - (double)this.dw());
            this.f(this.dw() + (float)d3 / (float)this.bm);
            this.e(this.dy() + (float)(this.br - (double)this.dy()) / (float)this.bm);
            --this.bm;
            this.e(d0, d1, d2);
            this.a(this.dw(), this.dy());
        } else if (!this.cU()) {
            this.f(this.dj().a(0.98));
        }
        if (this.bt > 0) {
            this.aV += (float)MathHelper.d(this.bs - (double)this.aV) / (float)this.bt;
            --this.bt;
        }
        Vec3D vec3d = this.dj();
        double d4 = vec3d.c;
        double d5 = vec3d.d;
        double d6 = vec3d.e;
        if (Math.abs(vec3d.c) < 0.003) {
            d4 = 0.0;
        }
        if (Math.abs(vec3d.d) < 0.003) {
            d5 = 0.0;
        }
        if (Math.abs(vec3d.e) < 0.003) {
            d6 = 0.0;
        }
        this.o(d4, d5, d6);
        this.H.ac().a("ai");
        if (this.eP()) {
            this.bi = false;
            this.bj = 0.0f;
            this.bl = 0.0f;
        } else if (this.cU()) {
            this.H.ac().a("newAi");
            this.eY();
            this.H.ac().c();
        }
        this.H.ac().c();
        this.H.ac().a("jump");
        if (this.bi && this.dT()) {
            double d7 = this.bg() ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            boolean flag = this.aT() && d7 > 0.0;
            double d8 = this.db();
            if (flag && (!this.N || d7 > d8)) {
                this.c(TagsFluid.a);
            } else if (this.bg() && (!this.N || d7 > d8)) {
                this.c(TagsFluid.b);
            } else if ((this.N || flag && d7 <= d8) && this.bY == 0) {
                if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                    this.eS();
                    this.bY = 10;
                } else {
                    this.r(false);
                }
            }
        } else {
            this.bY = 0;
        }
        this.H.ac().c();
        this.H.ac().a("travel");
        this.bj *= 0.98f;
        this.bl *= 0.98f;
        this.C();
        AxisAlignedBB axisalignedbb = this.cD();
        EntityLiving entityliving = this.cK();
        Vec3D vec3d1 = new Vec3D(this.bj, this.bk, this.bl);
        if (entityliving != null && this.bq()) {
            this.c(entityliving, vec3d1);
        } else {
            this.h(vec3d1);
        }
        this.H.ac().c();
        this.H.ac().a("freezing");
        if (!(this.H.B || this.ep() || this.freezeLocked)) {
            int i2 = this.ce();
            if (this.az && this.du()) {
                this.j(Math.min(this.ch(), i2 + 1));
            } else {
                this.j(Math.max(0, i2 - 2));
            }
        }
        this.dQ();
        this.dR();
        if (!this.H.B && this.ag % 40 == 0 && this.cg() && this.du()) {
            this.a(this.dG().t(), 1.0f);
        }
        this.H.ac().c();
        this.H.ac().a("push");
        if (this.bx > 0) {
            --this.bx;
            this.a(axisalignedbb, this.cD());
        }
        this.eZ();
        this.H.ac().c();
        if (((WorldServer)this.H).hasEntityMoveEvent && !(this instanceof EntityHuman) && (this.I != this.dl() || this.J != this.dn() || this.K != this.dr() || this.L != this.dw() || this.M != this.dy())) {
            Location from = new Location((World)this.H.getWorld(), this.I, this.J, this.K, this.L, this.M);
            Location to = new Location((World)this.H.getWorld(), this.dl(), this.dn(), this.dr(), this.dw(), this.dy());
            EntityMoveEvent event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if (!this.H.B && this.eX() && this.aV()) {
            this.a(this.dG().h(), 1.0f);
        }
    }

    public boolean eX() {
        return false;
    }

    private void C() {
        boolean flag = this.h(7);
        if (flag && !this.N && !this.bL() && !this.a(MobEffects.y)) {
            ItemStack itemstack = this.c(EnumItemSlot.e);
            if (itemstack.a(Items.nd) && ItemElytra.d(itemstack)) {
                flag = true;
                int i2 = this.bw + 1;
                if (!this.H.B && i2 % 10 == 0) {
                    int j2 = i2 / 10;
                    if (j2 % 2 == 0) {
                        itemstack.a(1, this, (T entityliving) -> entityliving.d(EnumItemSlot.e));
                    }
                    this.a(GameEvent.o);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.H.B && flag != this.h(7) && !CraftEventFactory.callToggleGlideEvent(this, flag).isCancelled()) {
            this.b(7, flag);
        }
    }

    protected void eY() {
    }

    protected void eZ() {
        if (this.H.k_()) {
            this.H.a(EntityTypeTest.a(EntityHuman.class), this.cD(), IEntitySelector.a(this)).forEach(this::A);
        } else {
            if (!this.bn()) {
                return;
            }
            ScoreboardTeamBase team = this.cb();
            if (team != null && team.l() == ScoreboardTeamBase.EnumTeamPush.b) {
                return;
            }
            int i2 = this.H.W().c(GameRules.t);
            if (i2 <= 0 && this.H.paperConfig().collisions.maxEntityCollisions <= 0) {
                return;
            }
            List<Entity> list = this.H.a((Entity)this, this.cD(), IEntitySelector.pushable(this, this.H.paperConfig().collisions.fixClimbingBypassingCrammingRule));
            if (!list.isEmpty()) {
                int j2;
                if (i2 > 0 && list.size() > i2 - 1 && this.af.a(4) == 0) {
                    j2 = 0;
                    for (int k2 = 0; k2 < list.size(); ++k2) {
                        if (list.get(k2).bL()) continue;
                        ++j2;
                    }
                    if (j2 > i2 - 1) {
                        this.a(this.dG().g(), 6.0f);
                    }
                }
                this.numCollisions = Math.max(0, this.numCollisions - this.H.paperConfig().collisions.maxEntityCollisions);
                for (j2 = 0; j2 < list.size() && this.numCollisions < this.H.paperConfig().collisions.maxEntityCollisions; ++j2) {
                    Entity entity = list.get(j2);
                    ++entity.numCollisions;
                    ++this.numCollisions;
                    this.A(entity);
                }
            }
        }
    }

    protected void a(AxisAlignedBB a2, AxisAlignedBB b2) {
        AxisAlignedBB axisalignedbb2 = a2.b(b2);
        List<Entity> list = this.H.a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Entity entity = list.get(i2);
                if (!(entity instanceof EntityLiving)) continue;
                this.h((EntityLiving)entity);
                this.bx = 0;
                this.f(this.dj().a(-0.2));
                break;
            }
        } else if (this.O) {
            this.bx = 0;
        }
        if (!this.H.B && this.bx <= 0) {
            this.c(4, false);
        }
    }

    protected void A(Entity entity) {
        entity.g(this);
    }

    protected void h(EntityLiving target) {
    }

    public boolean fa() {
        return (this.am.a(t) & 4) != 0;
    }

    @Override
    public void bz() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity entity = this.cV();
        super.stopRiding(suppressCancellation);
        if (entity != null && entity != this.cV() && !this.H.B && entity.valid) {
            this.a(entity);
        }
    }

    @Override
    public void bt() {
        super.bt();
        this.bb = this.bc;
        this.bc = 0.0f;
        this.n();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.bn = x2;
        this.bo = y2;
        this.bp = z2;
        this.bq = yaw;
        this.br = pitch;
        this.bm = interpolationSteps;
    }

    @Override
    public void a(float yaw, int interpolationSteps) {
        this.bs = yaw;
        this.bt = interpolationSteps;
    }

    public void r(boolean jumping) {
        this.bi = jumping;
    }

    public void a(EntityItem item) {
        EntityHuman entity;
        EntityHuman entityHuman = entity = item.j != null ? this.H.getGlobalPlayerByUUID(item.j) : null;
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.O.a((EntityPlayer)entity, item.i(), this);
        }
    }

    public void a(Entity item, int count) {
        if (!item.dB() && !this.H.B && (item instanceof EntityItem || item instanceof EntityArrow || item instanceof EntityExperienceOrb)) {
            ((WorldServer)this.H).k().b(item, new PacketPlayOutCollect(item.af(), this.af(), count));
        }
    }

    public boolean B(Entity entity) {
        if (entity.H != this.H) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dl(), this.dp(), this.dr());
        Vec3D vec3d1 = new Vec3D(entity.dl(), entity.dp(), entity.dr());
        if (LeavesConfig.entityStripRaytracing) {
            return vec3d1.g(vec3d) > 16384.0 ? false : this.H.rayTraceDirect(vec3d, vec3d1, VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.a;
        }
        return vec3d1.g(vec3d) > 16384.0 ? false : this.H.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this)).c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float l(float tickDelta) {
        return tickDelta == 1.0f ? this.aV : MathHelper.i(tickDelta, this.aW, this.aV);
    }

    public float w(float tickDelta) {
        float f1 = this.aN - this.aM;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.aM + f1 * tickDelta;
    }

    @Override
    public boolean bm() {
        return !this.dB() && this.collides;
    }

    @Override
    public boolean bn() {
        return this.isCollidable(this.H.paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.bq() && !this.F_() && (ignoreClimbing || !this.z_()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bn() && this.collides != this.collidableExemptions.contains(entity.cs());
    }

    @Override
    public float ck() {
        return this.aV;
    }

    @Override
    public void r(float headYaw) {
        this.aV = headYaw;
    }

    @Override
    public void s(float bodyYaw) {
        this.aT = bodyYaw;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    public static Vec3D i(Vec3D pos) {
        return new Vec3D(pos.c, pos.d, 0.0);
    }

    public float fb() {
        return this.bZ;
    }

    public void x(float amount) {
        if (amount < 0.0f || Float.isNaN(amount)) {
            amount = 0.0f;
        }
        this.bZ = amount;
    }

    public void E_() {
    }

    public void j() {
    }

    protected void fc() {
        this.bS = true;
    }

    public abstract EnumMainHand fd();

    public boolean fe() {
        return (this.am.a(t) & 1) > 0;
    }

    public EnumHand ff() {
        return (this.am.a(t) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    private void D() {
        if (this.fe()) {
            if (ItemStack.c(this.b(this.ff()), this.bu)) {
                this.bu = this.b(this.ff());
                this.a(this.bu);
            } else {
                this.fk();
            }
        }
    }

    protected void a(ItemStack stack) {
        boolean shouldLagCompensate;
        stack.b(this.H, this, this.fh());
        if (this.E()) {
            this.b(stack, 5);
        }
        boolean bl = shouldLagCompensate = this.bu.c().u() && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (long)((1 + this.totalEatTimeTicks) * 50 * 1000000);
        if (!(--this.bv != 0 && !shouldLagCompensate || this.H.B || this.bu.s())) {
            this.bv = 0;
            this.Y_();
        }
    }

    private boolean E() {
        int i2 = this.fh();
        FoodInfo foodinfo = this.bu.c().v();
        boolean flag = foodinfo != null && foodinfo.e();
        return (flag |= i2 <= this.bu.q() - 7) && i2 % 4 == 0;
    }

    private void G() {
        this.cf = this.ce;
        this.ce = this.bW() ? Math.min(1.0f, this.ce + 0.09f) : Math.max(0.0f, this.ce - 0.09f);
    }

    protected void c(int mask, boolean value) {
        byte b0 = this.am.a(t);
        int j2 = value ? b0 | mask : b0 & ~mask;
        this.am.b(t, (byte)j2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemstack = this.b(hand);
        if (!itemstack.b() && !this.fe() || forceUpdate) {
            this.bu = itemstack;
            this.bv = this.totalEatTimeTicks = itemstack.q();
            this.eatStartTime = System.nanoTime();
            if (!this.H.B) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
                this.a(GameEvent.F);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (bK.equals(data)) {
            if (this.H.B) {
                this.fs().ifPresent(this::a);
            }
        } else if (t.equals(data) && this.H.B) {
            if (this.fe() && this.bu.b()) {
                this.bu = this.b(this.ff());
                if (!this.bu.b()) {
                    this.bv = this.bu.q();
                }
            } else if (!this.fe() && !this.bu.b()) {
                this.bu = ItemStack.b;
                this.totalEatTimeTicks = 0;
                this.bv = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.aW = this.aV;
        this.aU = this.aT = this.aV;
    }

    protected void b(ItemStack stack, int particleCount) {
        if (!stack.b() && this.fe()) {
            if (stack.r() == EnumAnimation.c) {
                this.a(this.c(stack), 0.5f, this.H.z.i() * 0.1f + 0.9f);
            }
            if (stack.r() == EnumAnimation.b) {
                this.a(stack, particleCount);
                this.a(this.d(stack), 0.5f + 0.5f * (float)this.af.a(2), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
            }
        }
    }

    private void a(ItemStack stack, int count) {
        for (int j2 = 0; j2 < count; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.af.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.dy() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dw() * ((float)Math.PI / 180));
            double d0 = (double)(-this.af.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.af.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.dy() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dw() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dl(), this.dp(), this.dr());
            this.H.a(new ParticleParamItem(Particles.Q, stack), vec3d1.c, vec3d1.d, vec3d1.e, vec3d.c, vec3d.d + 0.05, vec3d.e);
        }
    }

    protected void Y_() {
        if (!this.H.B || this.fe()) {
            EnumHand enumhand = this.ff();
            if (!this.bu.equals(this.b(enumhand))) {
                this.fj();
            } else if (!this.bu.b() && this.fe()) {
                ItemStack itemstack;
                this.startUsingItem(this.ff(), true);
                this.b(this.bu, 16);
                PlayerItemConsumeEvent event = null;
                if (this instanceof EntityPlayer) {
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bu);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.fk();
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                        ((EntityPlayer)this).getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bu.a(this.H, this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.H, this);
                } else {
                    itemstack = this.bu.a(this.H, this);
                }
                ItemStack defaultReplacement = itemstack;
                if (event != null && event.getReplacement() != null) {
                    itemstack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemstack != this.bu) {
                    this.a(enumhand, itemstack);
                }
                this.fk();
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).getBukkitEntity().updateInventory();
                }
            }
        }
    }

    public ItemStack fg() {
        return this.bu;
    }

    public int fh() {
        return this.bv;
    }

    public int fi() {
        return this.fe() ? this.bu.q() - this.fh() : 0;
    }

    public void fj() {
        if (!this.bu.b()) {
            if (this instanceof EntityPlayer) {
                new PlayerStopUsingItemEvent((Player)this.getBukkitEntity(), this.bu.asBukkitMirror(), this.fi()).callEvent();
            }
            this.bu.a(this.H, this, this.fh());
            if (this.bu.s()) {
                this.D();
            }
        }
        this.fk();
    }

    public void fk() {
        if (!this.H.B) {
            boolean flag = this.fe();
            this.c(1, false);
            if (flag) {
                this.a(GameEvent.E);
            }
        }
        this.bu = ItemStack.b;
        this.totalEatTimeTicks = 0;
        this.bv = 0;
        this.eatStartTime = -1L;
    }

    public boolean fl() {
        if (this.fe() && !this.bu.b()) {
            net.minecraft.world.item.Item item = this.bu.c();
            return item.c(this.bu) != EnumAnimation.d ? false : item.b(this.bu) - this.bv >= this.getShieldBlockingDelay();
        }
        return false;
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dl(), this.dn() + (double)this.cE(), this.dr());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.c + dir.getX(), start.d + dir.getY(), start.e + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.H.a(raytrace);
    }

    @Nullable
    public MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.n(1.0f);
        Vec3D direction = this.bC();
        Vec3D end = start.b(direction.c * (double)maxDistance, direction.d * (double)maxDistance, direction.e * (double)maxDistance);
        List<Entity> entityList = this.H.a((Entity)this, this.cD().b(direction.c * (double)maxDistance, direction.d * (double)maxDistance, direction.e * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.f.and(Entity::bm));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.bB();
            AxisAlignedBB aabb = entity.cD().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public int getShieldBlockingDelay() {
        return this.shieldBlockingDelay;
    }

    public void setShieldBlockingDelay(int shieldBlockingDelay) {
        this.shieldBlockingDelay = shieldBlockingDelay;
    }

    public boolean fm() {
        return this.bO();
    }

    public boolean fn() {
        return this.h(7);
    }

    @Override
    public boolean bW() {
        return super.bW() || !this.fn() && this.c(EntityPose.b);
    }

    public int fo() {
        return this.bw;
    }

    public boolean a(double x2, double y2, double z2, boolean particleEffects) {
        return this.randomTeleport(x2, y2, z2, particleEffects, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dl();
        double d4 = this.dn();
        double d5 = this.dr();
        double d6 = d1;
        boolean flag1 = false;
        net.minecraft.world.level.World world = this.H;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        if (world.D(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.v_()) {
                BlockPosition blockposition1 = blockposition.d();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d().c()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.e(d0, d6, d2);
                if (world.g(this) && !world.d(this.cD())) {
                    flag1 = true;
                }
                this.e(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.H.getWorld(), d3, d4, d5), new Location((World)this.H.getWorld(), d0, d6, d2));
                        this.H.getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (((EntityPlayer)this).b.teleport(d0, d6, d2, this.dw(), this.dy(), Collections.emptySet(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        ((EntityCreature)this).G().n();
        return Optional.of(true);
    }

    public boolean fp() {
        return true;
    }

    public boolean fq() {
        return true;
    }

    public void a(BlockPosition songPosition, boolean playing) {
    }

    public boolean f(ItemStack stack) {
        return false;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? aC : super.a(pose).a(this.dS());
    }

    public ImmutableList<EntityPose> fr() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB g(EntityPose pose) {
        EntitySize entitysize = this.a(pose);
        return new AxisAlignedBB(-entitysize.a / 2.0f, 0.0, -entitysize.a / 2.0f, entitysize.a / 2.0f, entitysize.b, entitysize.a / 2.0f);
    }

    @Override
    public boolean co() {
        return super.co() && !this.fu();
    }

    public Optional<BlockPosition> fs() {
        return this.am.a(bK);
    }

    public void e(BlockPosition pos) {
        this.am.b(bK, Optional.of(pos));
    }

    public void ft() {
        this.am.b(bK, Optional.empty());
    }

    public boolean fu() {
        return this.fs().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData iblockdata;
        if (this.bL()) {
            this.bz();
        }
        if ((iblockdata = this.H.a_(pos)).b() instanceof BlockBed) {
            this.H.a(pos, (IBlockData)iblockdata.a(BlockBed.b, true), 3);
        }
        this.b(EntityPose.c);
        this.a(pos);
        this.e(pos);
        this.f(Vec3D.b);
        this.at = true;
    }

    private void a(BlockPosition pos) {
        this.e((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean I() {
        return this.fs().map(blockposition -> this.H.a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void fv() {
        Optional<BlockPosition> optional = this.fs();
        net.minecraft.world.level.World world = this.H;
        Objects.requireNonNull(this.H);
        optional.filter(world::D).ifPresent(blockposition -> {
            IBlockData iblockdata = this.H.a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = iblockdata.c(BlockFacingHorizontal.aD);
                this.H.a((BlockPosition)blockposition, (IBlockData)iblockdata.a(BlockBed.b, false), 3);
                Vec3D vec3d = BlockBed.a(this.ae(), (ICollisionAccess)this.H, blockposition, enumdirection, this.dw()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.c();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec3d1.e, vec3d1.c) * 57.2957763671875 - 90.0);
                this.e(vec3d.c, vec3d.d, vec3d.e);
                this.f(f2);
                this.e(0.0f);
            }
        });
        Vec3D vec3d = this.de();
        this.b(EntityPose.a);
        this.e(vec3d.c, vec3d.d, vec3d.e);
        this.ft();
    }

    @Nullable
    public EnumDirection fw() {
        BlockPosition blockposition = this.fs().orElse(null);
        return blockposition != null ? BlockBed.a(this.H, blockposition) : null;
    }

    @Override
    public boolean br() {
        return !this.fu() && super.br();
    }

    @Override
    protected final float a(EntityPose pose, EntitySize dimensions) {
        return pose == EntityPose.c ? 0.2f : this.b(pose, dimensions);
    }

    protected float b(EntityPose pose, EntitySize dimensions) {
        return super.a(pose, dimensions);
    }

    public ItemStack g(ItemStack stack) {
        return ItemStack.b;
    }

    public ItemStack a(net.minecraft.world.level.World world, ItemStack stack) {
        if (stack.L()) {
            world.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), this.d(stack), SoundCategory.g, 1.0f, 1.0f + (world.z.i() - world.z.i()) * 0.4f);
            this.a(stack, world, this);
            if (!(this instanceof EntityHuman) || !((EntityHuman)this).fK().d) {
                stack.h(1);
            }
            this.a(GameEvent.n);
        }
        return stack;
    }

    private void a(ItemStack stack, net.minecraft.world.level.World world, EntityLiving targetEntity) {
        net.minecraft.world.item.Item item = stack.c();
        if (item.u()) {
            List<Pair<MobEffect, Float>> list = item.v().f();
            for (Pair<MobEffect, Float> pair : list) {
                if (world.B || pair.getFirst() == null || !(world.z.i() < ((Float)pair.getSecond()).floatValue())) continue;
                targetEntity.addEffect(new MobEffect((MobEffect)pair.getFirst()), EntityPotionEffectEvent.Cause.FOOD);
            }
        }
    }

    public static byte g(EnumItemSlot slot) {
        switch (slot) {
            case a: {
                return 47;
            }
            case b: {
                return 48;
            }
            case f: {
                return 49;
            }
            case e: {
                return 50;
            }
            case c: {
                return 52;
            }
            case d: {
                return 51;
            }
        }
        return 47;
    }

    public void d(EnumItemSlot slot) {
        this.H.a((Entity)this, EntityLiving.g(slot));
    }

    public void d(EnumHand hand) {
        this.d(hand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b);
    }

    @Override
    public AxisAlignedBB A_() {
        if (this.c(EnumItemSlot.f).a(Items.ts)) {
            float f2 = 0.5f;
            return this.cD().c(0.5, 0.5, 0.5);
        }
        return super.A_();
    }

    public static EnumItemSlot h(ItemStack stack) {
        Equipable equipable = Equipable.c_(stack);
        return equipable != null ? equipable.g() : EnumItemSlot.a;
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, itemstack -> itemstack.b() || EntityInsentient.h(itemstack) == slot) : SlotAccess.a(entity, slot);
    }

    @Nullable
    private static EnumItemSlot q(int slotId) {
        return slotId == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (slotId == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (slotId == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (slotId == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (slotId == 98 ? EnumItemSlot.a : (slotId == 99 ? EnumItemSlot.b : null)))));
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        EnumItemSlot enumitemslot = EntityLiving.q(mappedIndex);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(mappedIndex);
    }

    @Override
    public boolean du() {
        if (this.F_()) {
            return false;
        }
        boolean flag = !this.c(EnumItemSlot.f).a(TagsItem.ay) && !this.c(EnumItemSlot.e).a(TagsItem.ay) && !this.c(EnumItemSlot.d).a(TagsItem.ay) && !this.c(EnumItemSlot.c).a(TagsItem.ay);
        return flag && super.du();
    }

    @Override
    public boolean bZ() {
        return !this.H.k_() && this.a(MobEffects.x) || super.bZ();
    }

    @Override
    public float dx() {
        return this.aT;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        double d0 = packet.e();
        double d1 = packet.f();
        double d2 = packet.g();
        float f2 = packet.l();
        float f1 = packet.k();
        this.f(d0, d1, d2);
        this.aT = packet.m();
        this.aV = packet.m();
        this.aU = this.aT;
        this.aW = this.aV;
        this.e(packet.a());
        this.a_(packet.c());
        this.a(d0, d1, d2, f2, f1);
        this.o(packet.h(), packet.i(), packet.j());
    }

    public boolean fx() {
        return this.eK().c() instanceof ItemAxe;
    }

    @Override
    public float dA() {
        float f2 = super.dA();
        return this.cK() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    private static class ProcessableEffect {
        private MobEffectList type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(MobEffectList type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

