/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.entity.Tameable;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    protected static final DataWatcherObject<Byte> bS = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Optional<UUID>> bT = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.q);
    private boolean bV;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.r();
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bS, (byte)0);
        this.am.a(bT, Optional.empty());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.T_() != null) {
            nbt.a("Owner", this.T_());
        }
        nbt.a("Sitting", this.bV);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        UUID uUID;
        super.a(nbt);
        if (nbt.b("Owner")) {
            uUID = nbt.a("Owner");
        } else {
            String string = nbt.l("Owner");
            uUID = NameReferencingFileConverter.a(this.cH(), string);
        }
        if (uUID != null) {
            try {
                this.b(uUID);
                this.x(true);
            }
            catch (Throwable var4) {
                this.x(false);
            }
        }
        this.bV = nbt.q("Sitting");
        this.setInSittingPose(this.bV, false);
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.fI();
    }

    protected void w(boolean positive) {
        ParticleType particleOptions = Particles.O;
        if (!positive) {
            particleOptions = Particles.ab;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.af.k() * 0.02;
            double e2 = this.af.k() * 0.02;
            double f2 = this.af.k() * 0.02;
            this.H.a(particleOptions, this.d(1.0), this.do() + 0.5, this.g(1.0), d2, e2, f2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.w(true);
        } else if (status == 6) {
            this.w(false);
        } else {
            super.b(status);
        }
    }

    public boolean q() {
        return (this.am.a(bS) & 4) != 0;
    }

    public void x(boolean tamed) {
        byte b2 = this.am.a(bS);
        if (tamed) {
            this.am.b(bS, (byte)(b2 | 4));
        } else {
            this.am.b(bS, (byte)(b2 & 0xFFFFFFFB));
        }
        this.r();
    }

    protected void r() {
    }

    public boolean w() {
        return (this.am.a(bS) & 1) != 0;
    }

    public void y(boolean inSittingPose) {
        this.setInSittingPose(inSittingPose, true);
    }

    public void setInSittingPose(boolean inSittingPose, boolean callEvent) {
        if (callEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), inSittingPose).callEvent()) {
            return;
        }
        byte b2 = this.am.a(bS);
        if (inSittingPose) {
            this.am.b(bS, (byte)(b2 | 1));
        } else {
            this.am.b(bS, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID T_() {
        return this.am.a(bT).orElse(null);
    }

    public void b(@Nullable UUID uuid) {
        this.am.b(bT, Optional.ofNullable(uuid));
    }

    public void e(EntityHuman player) {
        this.x(true);
        this.b(player.cs());
        if (player instanceof EntityPlayer) {
            CriterionTriggers.x.a((EntityPlayer)player, this);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return this.m(target) ? false : super.c(target);
    }

    public boolean m(EntityLiving entity) {
        return entity == this.H_();
    }

    public boolean a(EntityLiving target, EntityLiving owner) {
        return true;
    }

    @Override
    public ScoreboardTeamBase cb() {
        EntityLiving livingEntity;
        if (this.q() && (livingEntity = this.H_()) != null) {
            return livingEntity.cb();
        }
        return super.cb();
    }

    @Override
    public boolean p(Entity other) {
        if (this.q()) {
            EntityLiving livingEntity = this.H_();
            if (other == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.p(other);
            }
        }
        return super.p(other);
    }

    @Override
    public void a(DamageSource damageSource) {
        TameableDeathMessageEvent event;
        if (!this.H.B && this.H.W().b(GameRules.m) && this.H_() instanceof EntityPlayer && (event = new TameableDeathMessageEvent((Tameable)this.getBukkitEntity(), PaperAdventure.asAdventure(this.eC().b()))).callEvent()) {
            this.H_().a(PaperAdventure.asVanilla(event.deathMessage()));
        }
        super.a(damageSource);
    }

    public boolean fS() {
        return this.bV;
    }

    public void z(boolean sitting) {
        this.bV = sitting;
    }
}

