/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorAttackTargetSet {
    public static <E extends EntityInsentient> BehaviorControl<E> a(Function<E, Optional<? extends EntityLiving>> targetGetter) {
        return BehaviorAttackTargetSet.a(entityinsentient -> true, targetGetter);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> a(Predicate<E> startCondition, Function<E, Optional<? extends EntityLiving>> targetGetter) {
        return BehaviorBuilder.a((BehaviorBuilder.b<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.c(MemoryModuleType.o), behaviorbuilder_b.a(MemoryModuleType.E)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i2) -> {
            if (!startCondition.test(entityinsentient)) {
                return false;
            }
            Optional optional = (Optional)targetGetter.apply(entityinsentient);
            if (optional.isEmpty()) {
                return false;
            }
            EntityLiving entityliving = (EntityLiving)optional.get();
            if (!entityinsentient.c(entityliving)) {
                return false;
            }
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, entityliving, entityliving instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() == null) {
                memoryaccessor.b();
                return true;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            memoryaccessor.a(entityliving);
            memoryaccessor1.b();
            return true;
        }));
    }
}

