/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class GoAndGiveItemsToTarget<E extends EntityLiving>
extends Behavior<E> {
    private static final int c = 3;
    private static final int d = 60;
    private final Function<EntityLiving, Optional<BehaviorPosition>> e;
    private final float f;

    public GoAndGiveItemsToTarget(Function<EntityLiving, Optional<BehaviorPosition>> lookTargetFunction, float speed, int runTime) {
        super(Map.of(MemoryModuleType.n, MemoryStatus.c, MemoryModuleType.m, MemoryStatus.c, MemoryModuleType.aO, MemoryStatus.c), runTime);
        this.e = lookTargetFunction;
        this.f = speed;
    }

    @Override
    @Override
    protected boolean a(WorldServer world, E entity) {
        return this.b(entity);
    }

    @Override
    @Override
    protected boolean a(WorldServer world, E entity, long time) {
        return this.b(entity);
    }

    @Override
    @Override
    protected void d(WorldServer world, E entity, long time) {
        this.e.apply((EntityLiving)entity).ifPresent(target -> BehaviorUtil.a(entity, target, this.f, 3));
    }

    @Override
    @Override
    protected void c(WorldServer world, E entity, long time) {
        ItemStack itemStack;
        Optional<BehaviorPosition> optional = this.e.apply((EntityLiving)entity);
        if (optional.isEmpty()) {
            return;
        }
        BehaviorPosition positionTracker = optional.get();
        double d2 = positionTracker.a().f(((Entity)entity).bk());
        if (d2 < 3.0 && !(itemStack = ((InventoryCarrier)entity).w().a(0, 1)).b()) {
            GoAndGiveItemsToTarget.a(entity, itemStack, GoAndGiveItemsToTarget.a(positionTracker));
            if (entity instanceof Allay) {
                Allay allay = (Allay)entity;
                AllayAi.a((EntityLiving)allay).ifPresent(player -> this.a(positionTracker, itemStack, (EntityPlayer)player));
            }
            ((EntityLiving)entity).dH().a(MemoryModuleType.aO, Integer.valueOf(60));
        }
    }

    private void a(BehaviorPosition target, ItemStack stack, EntityPlayer player) {
        BlockPosition blockPos = target.b().d();
        CriterionTriggers.X.a(player, blockPos, stack);
    }

    private boolean b(E entity) {
        if (((InventoryCarrier)entity).w().aa_()) {
            return false;
        }
        Optional<BehaviorPosition> optional = this.e.apply((EntityLiving)entity);
        return optional.isPresent();
    }

    private static Vec3D a(BehaviorPosition target) {
        return target.a().b(0.0, 1.0, 0.0);
    }

    public static void a(EntityLiving entity, ItemStack stack, Vec3D target) {
        Vec3D vec3 = new Vec3D(0.2f, 0.3f, 0.2f);
        BehaviorUtil.a(entity, stack, target, vec3, 0.2f);
        World level = entity.H;
        if (level.U() % 7L == 0L && level.z.j() < 0.9) {
            float f2 = SystemUtils.a(Allay.d, level.r_()).floatValue();
            level.a(null, entity, SoundEffects.g, SoundCategory.g, 1.0f, f2);
        }
    }
}

