/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.EntityHuman;

public class SensorNearestPlayers
extends Sensor<EntityLiving> {
    @Override
    public Set<MemoryModuleType<?>> a() {
        return ImmutableSet.of(MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l);
    }

    @Override
    protected void a(WorldServer world, EntityLiving entity) {
        List<EntityPlayer> players = world.getNearbyPlayers(entity, entity.dl(), entity.dn(), entity.dr(), 16.0, IEntitySelector.f);
        players.sort((e1, e2) -> Double.compare(entity.f((Entity)e1), entity.f((Entity)e2)));
        BehaviorController<?> brain = entity.dH();
        brain.a(MemoryModuleType.j, players);
        EntityHuman firstTargetable = null;
        EntityHuman firstAttackable = null;
        int len = players.size();
        for (int index = 0; index < len; ++index) {
            EntityHuman player = players.get(index);
            if (firstTargetable == null && SensorNearestPlayers.b(entity, player)) {
                firstTargetable = player;
            }
            if (firstAttackable == null && SensorNearestPlayers.c(entity, player)) {
                firstAttackable = player;
            }
            if (firstAttackable != null && firstTargetable != null) break;
        }
        brain.a(MemoryModuleType.k, firstTargetable);
        brain.a(MemoryModuleType.l, Optional.ofNullable(firstAttackable));
    }
}

