/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.targeting;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import top.leavesmc.leaves.LeavesConfig;

public class PathfinderTargetCondition {
    public static final PathfinderTargetCondition a = PathfinderTargetCondition.a();
    private static final double b = 2.0;
    private final boolean c;
    private double d = -1.0;
    private boolean e = true;
    private boolean f = true;
    @Nullable
    private Predicate<EntityLiving> g;
    private boolean useFollowRange = false;

    private PathfinderTargetCondition(boolean attackable) {
        this.c = attackable;
    }

    public static PathfinderTargetCondition a() {
        return new PathfinderTargetCondition(true);
    }

    public static PathfinderTargetCondition b() {
        return new PathfinderTargetCondition(false);
    }

    public PathfinderTargetCondition c() {
        PathfinderTargetCondition targetingConditions = this.c ? PathfinderTargetCondition.a() : PathfinderTargetCondition.b();
        targetingConditions.d = this.d;
        targetingConditions.e = this.e;
        targetingConditions.f = this.f;
        targetingConditions.g = this.g;
        return targetingConditions;
    }

    public PathfinderTargetCondition a(double baseMaxDistance) {
        this.d = baseMaxDistance;
        return this;
    }

    public PathfinderTargetCondition d() {
        this.e = false;
        return this;
    }

    public PathfinderTargetCondition e() {
        this.f = false;
        return this;
    }

    public PathfinderTargetCondition a(@Nullable Predicate<EntityLiving> predicate) {
        this.g = predicate;
        return this;
    }

    public boolean a(@Nullable EntityLiving baseEntity, EntityLiving targetEntity) {
        if (baseEntity == targetEntity) {
            return false;
        }
        if (!targetEntity.ei()) {
            return false;
        }
        if (this.g != null && !this.g.test(targetEntity)) {
            return false;
        }
        if (baseEntity == null) {
            if (this.c && (!targetEntity.eh() || targetEntity.H.ah() == EnumDifficulty.a)) {
                return false;
            }
        } else {
            EntityInsentient mob;
            if (this.c && (!baseEntity.c(targetEntity) || !baseEntity.a(targetEntity.ae()) || baseEntity.p(targetEntity))) {
                return false;
            }
            if (this.d > 0.0) {
                double d2;
                double e2;
                double f2 = baseEntity.i(targetEntity.dl(), targetEntity.dn(), targetEntity.dr());
                if (LeavesConfig.entityTargetFindingOptimization) {
                    double followRangeRaw;
                    double d3 = followRangeRaw = this.useFollowRange ? this.getFollowRange(baseEntity) : this.d;
                    if (f2 > followRangeRaw * followRangeRaw) {
                        return false;
                    }
                }
                if (f2 > (e2 = Math.max((this.useFollowRange ? this.getFollowRange(baseEntity) : this.d) * (d2 = this.f ? targetEntity.y(baseEntity) : 1.0), 2.0)) * e2) {
                    return false;
                }
            }
            if (this.e && baseEntity instanceof EntityInsentient && !(mob = (EntityInsentient)baseEntity).I().a(targetEntity)) {
                return false;
            }
        }
        return true;
    }

    public PathfinderTargetCondition useFollowRange() {
        this.useFollowRange = true;
        return this;
    }

    private double getFollowRange(EntityLiving entityliving) {
        AttributeModifiable attributeinstance = entityliving.a(GenericAttributes.b);
        return attributeinstance == null ? 16.0 : attributeinstance.f();
    }
}

