/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int bU = 6000;
    public int bS;
    @Nullable
    public UUID bT;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    protected void U() {
        if (this.h() != 0) {
            this.bS = 0;
        }
        super.U();
    }

    @Override
    public void b_() {
        super.b_();
        if (this.h() != 0) {
            this.bS = 0;
        }
        if (this.bS > 0) {
            --this.bS;
            if (this.bS % 10 == 0) {
                double d0 = this.af.k() * 0.02;
                double d1 = this.af.k() * 0.02;
                double d2 = this.af.k() * 0.02;
                this.H.a(Particles.O, this.d(1.0), this.do() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos.d()).a(Blocks.i) ? 10.0f : world.y(pos);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("InLove", this.bS);
        if (this.bT != null) {
            nbt.a("LoveCause", this.bT);
        }
    }

    @Override
    public double bu() {
        return 0.14;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.bS = nbt.h("InLove");
        this.bT = nbt.b("LoveCause") ? nbt.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bJ) && EntityAnimal.a(world, pos);
    }

    protected static boolean a(IBlockLightAccess world, BlockPosition pos) {
        return world.b(pos, 0) > 8;
    }

    @Override
    public int K() {
        return 120;
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    public int dX() {
        return 1 + this.H.z.a(3);
    }

    public boolean m(ItemStack stack) {
        return stack.a(Items.oE);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.m(itemstack)) {
            int i2 = this.h();
            if (!this.H.B && i2 == 0 && this.fT()) {
                this.a(player, hand, itemstack);
                this.f(player);
                return EnumInteractionResult.a;
            }
            if (this.y_()) {
                this.a(player, hand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                return EnumInteractionResult.a(this.H.B);
            }
            if (this.H.B) {
                return EnumInteractionResult.b;
            }
        }
        return super.b(player, hand);
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (!player.fK().d) {
            stack.h(1);
        }
    }

    public boolean fT() {
        return this.bS <= 0;
    }

    public void f(@Nullable EntityHuman player) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.bS = entityEnterLoveModeEvent.getTicksInLove();
        if (player != null) {
            this.bT = player.cs();
        }
        this.breedItem = player.fJ().f();
        this.H.a((Entity)this, (byte)18);
    }

    public void r(int loveTicks) {
        this.bS = loveTicks;
    }

    public int fU() {
        return this.bS;
    }

    @Nullable
    public EntityPlayer fV() {
        if (this.bT == null) {
            return null;
        }
        EntityHuman entityhuman = this.H.getGlobalPlayerByUUID(this.bT);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean fW() {
        return this.bS > 0;
    }

    public void fX() {
        this.bS = 0;
    }

    public boolean a(EntityAnimal other) {
        return other == this ? false : (other.getClass() != this.getClass() ? false : this.fW() && other.fW());
    }

    public void a(WorldServer world, EntityAnimal other) {
        EntityAgeable entityageable = this.a(world, (EntityAgeable)other);
        if (entityageable != null) {
            EntityPlayer entityplayer = this.fV();
            if (entityplayer == null && other.fV() != null) {
                entityplayer = other.fV();
            }
            entityageable.a(true);
            entityageable.b(this.dl(), this.dn(), this.dr(), 0.0f, 0.0f);
            int experience = this.dZ().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, other, entityplayer, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            if (entityplayer != null) {
                entityplayer.a(StatisticList.P);
                CriterionTriggers.o.a(entityplayer, this, other, entityageable);
            }
            this.c_(6000);
            other.c_(6000);
            this.fX();
            other.fX();
            world.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
            world.a((Entity)this, (byte)18);
            if (world.W().b(GameRules.f) && experience > 0) {
                world.b(new EntityExperienceOrb(world, this.dl(), this.dn(), this.dr(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityageable));
            }
        }
    }

    @Override
    public void b(byte status) {
        if (status == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.af.k() * 0.02;
                double d1 = this.af.k() * 0.02;
                double d2 = this.af.k() * 0.02;
                this.H.a(Particles.O, this.d(1.0), this.do() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.b(status);
        }
    }
}

