/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float bS = 120.32113f;
    public static final int bT = MathHelper.f(1.4959966f);
    private static final DataWatcherObject<Byte> cc = DataWatcher.a(EntityBee.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> cd = DataWatcher.a(EntityBee.class, DataWatcherRegistry.b);
    private static final int ce = 2;
    private static final int cf = 4;
    private static final int cg = 8;
    private static final int ch = 1200;
    private static final int ci = 2400;
    private static final int cj = 3600;
    private static final int ck = 4;
    private static final int cl = 10;
    private static final int cm = 10;
    private static final int cn = 18;
    private static final int co = 32;
    private static final int cp = 2;
    private static final int cq = 16;
    private static final int cr = 20;
    public static final String bV = "CropsGrownSincePollination";
    public static final String bW = "CannotEnterHiveTicks";
    public static final String bX = "TicksSincePollination";
    public static final String bY = "HasStung";
    public static final String bZ = "HasNectar";
    public static final String ca = "FlowerPos";
    public static final String cb = "HivePos";
    private static final UniformInt cs = TimeRange.a(20, 39);
    @Nullable
    private UUID ct;
    private float cu;
    private float cv;
    private int cw;
    public int cx;
    public int cy;
    public int cz;
    private static final int cA = 200;
    int cB;
    private static final int cC = 200;
    int cD;
    @Nullable
    BlockPosition cE;
    @Nullable
    public BlockPosition cF;
    k cG;
    e cH;
    private f cI;
    private int cJ;
    public TriState rollingOverride = TriState.NOT_SET;

    public EntityBee(EntityTypes<? extends EntityBee> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.cD = MathHelper.a(this.af, 20, 60);
        class BeeFlyingMoveControl
        extends ControllerMoveFlying {
            public BeeFlyingMoveControl(EntityInsentient entity, int maxPitchChange, boolean noGravity) {
                super(entity, maxPitchChange, noGravity);
            }

            @Override
            public void a() {
                if (this.d.dn() <= (double)EntityBee.this.H.v_()) {
                    this.d.e(false);
                }
                super.a();
            }
        }
        this.bK = new BeeFlyingMoveControl(this, 20, true);
        this.bJ = new j(this);
        this.a(PathType.n, -1.0f);
        this.a(PathType.j, -1.0f);
        this.a(PathType.k, 16.0f);
        this.a(PathType.x, -1.0f);
        this.a(PathType.h, -1.0f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cc, (byte)0);
        this.am.a(cd, 0);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).h() ? 10.0f : 0.0f;
    }

    @Override
    protected void x() {
        this.bN.a(0, new b(this, 1.4f, true));
        this.bN.a(1, new d());
        this.bN.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bN.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(TagsItem.R), false));
        this.cG = new k();
        this.bN.a(4, this.cG);
        this.bN.a(5, new PathfinderGoalFollowParent(this, 1.25));
        this.bN.a(5, new i());
        this.cH = new e();
        this.bN.a(5, this.cH);
        this.cI = new f();
        this.bN.a(6, this.cI);
        this.bN.a(7, new g());
        this.bN.a(8, new l());
        this.bN.a(9, new PathfinderGoalFloat(this));
        this.bO.a(1, new h(this).a(new Class[0]));
        this.bO.a(2, new c(this));
        this.bO.a(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.fZ()) {
            nbt.a(cb, GameProfileSerializer.a(this.ga()));
        }
        if (this.r()) {
            nbt.a(ca, GameProfileSerializer.a(this.q()));
        }
        nbt.a(bZ, this.gc());
        nbt.a(bY, this.gd());
        nbt.a(bX, this.cx);
        nbt.a(bW, this.cy);
        nbt.a(bV, this.cz);
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.cF = null;
        if (nbt.e(cb)) {
            this.cF = GameProfileSerializer.b(nbt.p(cb));
        }
        this.cE = null;
        if (nbt.e(ca)) {
            this.cE = GameProfileSerializer.b(nbt.p(ca));
        }
        super.a(nbt);
        this.w(nbt.q(bZ));
        this.x(nbt.q(bY));
        this.cx = nbt.h(bX);
        this.cy = nbt.h(bW);
        this.cz = nbt.h(bV);
        this.a(this.H, nbt);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag = target.a(this.dG().a(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
            if (target instanceof EntityLiving) {
                ((EntityLiving)target).p(((EntityLiving)target).eG() + 1);
                int b0 = 0;
                if (this.H.ah() == EnumDifficulty.c) {
                    b0 = 10;
                } else if (this.H.ah() == EnumDifficulty.d) {
                    b0 = 18;
                }
                if (b0 > 0) {
                    ((EntityLiving)target).addEffect(new MobEffect(MobEffects.s, b0 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.x(true);
            this.N_();
            this.a(SoundEffects.bC, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void l() {
        super.l();
        if (this.gc() && this.gl() < 10 && this.af.i() < 0.05f) {
            for (int i2 = 0; i2 < this.af.a(2) + 1; ++i2) {
                this.a(this.H, this.dl() - (double)0.3f, this.dl() + (double)0.3f, this.dr() - (double)0.3f, this.dr() + (double)0.3f, this.e(0.5), Particles.au);
            }
        }
        this.gj();
    }

    private void a(World world, double lastX, double x2, double lastZ, double z2, double y2, ParticleParam effect) {
        world.a(effect, MathHelper.d(world.z.j(), lastX, x2), y2, MathHelper.d(world.z.j(), lastZ, z2), 0.0, 0.0, 0.0);
    }

    void h(BlockPosition pos) {
        Vec3D vec3d1;
        Vec3D vec3d = Vec3D.c(pos);
        int b0 = 0;
        BlockPosition blockposition1 = this.dg();
        int i2 = (int)vec3d.d - blockposition1.v();
        if (i2 > 2) {
            b0 = 4;
        } else if (i2 < -2) {
            b0 = -4;
        }
        int j2 = 6;
        int k2 = 8;
        int l2 = blockposition1.k(pos);
        if (l2 < 15) {
            j2 = l2 / 2;
            k2 = l2 / 2;
        }
        if ((vec3d1 = AirRandomPos.a(this, j2, k2, b0, vec3d, 0.3141592741012573)) != null) {
            this.bM.a(0.5f);
            this.bM.a(vec3d1.c, vec3d1.d, vec3d1.e, 1.0);
        }
    }

    @Nullable
    public BlockPosition q() {
        return this.cE;
    }

    public boolean r() {
        return this.cE != null;
    }

    public void g(BlockPosition flowerPos) {
        this.cE = flowerPos;
    }

    @VisibleForDebug
    public int w() {
        return Math.max(this.cH.d, this.cI.d);
    }

    @VisibleForDebug
    public List<BlockPosition> fS() {
        return this.cH.f;
    }

    private boolean gh() {
        return this.cx > 3600;
    }

    boolean gi() {
        if (this.cy <= 0 && !this.cG.l() && !this.gd() && this.P_() == null) {
            boolean flag = this.gh() || this.H.Y() || this.H.N() || this.gc();
            return flag && !this.gk();
        }
        return false;
    }

    public void s(int cannotEnterHiveTicks) {
        this.cy = cannotEnterHiveTicks;
    }

    public float C(float tickDelta) {
        return MathHelper.i(tickDelta, this.cv, this.cu);
    }

    private void gj() {
        this.cv = this.cu;
        this.cu = this.gp() ? Math.min(1.0f, this.cu + 0.2f) : Math.max(0.0f, this.cu - 0.24f);
    }

    @Override
    protected void U() {
        boolean flag = this.gd();
        this.cJ = this.aW() ? ++this.cJ : 0;
        if (this.cJ > 20) {
            this.a(this.dG().h(), 1.0f);
        }
        if (flag) {
            ++this.cw;
            if (this.cw % 5 == 0 && this.af.a(MathHelper.a(1200 - this.cw, 1, 1200)) == 0) {
                this.a(this.dG().n(), this.eo());
            }
        }
        if (!this.gc()) {
            ++this.cx;
        }
        if (!this.H.B) {
            this.a((WorldServer)this.H, false);
        }
    }

    public void fY() {
        this.cx = 0;
    }

    private boolean gk() {
        if (this.cF == null) {
            return false;
        }
        if (!this.H.isLoadedAndInBounds(this.cF)) {
            return false;
        }
        TileEntity tileentity = this.H.c_(this.cF);
        return tileentity instanceof TileEntityBeehive && ((TileEntityBeehive)tileentity).c();
    }

    @Override
    public int a() {
        return this.am.a(cd);
    }

    @Override
    public void a(int angerTime) {
        this.am.b(cd, angerTime);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.ct;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.ct = angryAt;
    }

    @Override
    public void c() {
        this.a(cs.a(this.af));
    }

    private boolean i(BlockPosition pos) {
        if (!this.H.isLoadedAndInBounds(pos)) {
            return false;
        }
        TileEntity tileentity = this.H.c_(pos);
        return tileentity instanceof TileEntityBeehive ? !((TileEntityBeehive)tileentity).f() : false;
    }

    @VisibleForDebug
    public boolean fZ() {
        return this.cF != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition ga() {
        return this.cF;
    }

    @VisibleForDebug
    public PathfinderGoalSelector gb() {
        return this.bN;
    }

    @Override
    protected void T() {
        super.T();
        PacketDebug.a(this);
    }

    int gl() {
        return this.cz;
    }

    private void gm() {
        this.cz = 0;
    }

    void gn() {
        ++this.cz;
    }

    @Override
    public void b_() {
        super.b_();
        if (!this.H.B) {
            if (this.cy > 0) {
                --this.cy;
            }
            if (this.cB > 0) {
                --this.cB;
            }
            if (this.cD > 0) {
                --this.cD;
            }
            boolean flag = this.R_() && !this.gd() && this.P_() != null && this.P_().f((Entity)this) < 4.0;
            this.y(flag);
            if (this.ag % 20 == 0 && !this.go()) {
                this.cF = null;
            }
        }
    }

    boolean go() {
        if (!this.fZ()) {
            return false;
        }
        if (this.j(this.cF)) {
            return false;
        }
        if (this.H.getChunkIfLoadedImmediately(this.cF.u() >> 4, this.cF.w() >> 4) == null) {
            return true;
        }
        TileEntity tileentity = this.H.c_(this.cF);
        return tileentity != null && tileentity.u() == TileEntityTypes.H;
    }

    public boolean gc() {
        return this.t(8);
    }

    public void w(boolean hasNectar) {
        if (hasNectar) {
            this.fY();
        }
        this.d(8, hasNectar);
    }

    public boolean gd() {
        return this.t(4);
    }

    public void x(boolean hasStung) {
        this.d(4, hasStung);
    }

    public boolean gp() {
        return this.t(2);
    }

    public void y(boolean nearTarget) {
        nearTarget = this.rollingOverride.toBooleanOrElse(nearTarget);
        this.d(2, nearTarget);
    }

    boolean j(BlockPosition pos) {
        return !this.b(pos, 32);
    }

    private void d(int bit, boolean value) {
        if (value) {
            this.am.b(cc, (byte)(this.am.a(cc) | bit));
        } else {
            this.am.b(cc, (byte)(this.am.a(cc) & ~bit));
        }
    }

    private boolean t(int location) {
        return (this.am.a(cc) & location) != 0;
    }

    public static AttributeProvider.Builder ge() {
        return EntityInsentient.y().a(GenericAttributes.a, 10.0).a(GenericAttributes.e, 0.6f).a(GenericAttributes.d, 0.3f).a(GenericAttributes.f, 2.0).a(GenericAttributes.b, 48.0);
    }

    @Override
    protected NavigationAbstract a(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world){

            @Override
            public boolean a(BlockPosition pos) {
                return !this.b.a_(pos.d()).h();
            }

            @Override
            public void c() {
                if (!EntityBee.this.cG.l()) {
                    super.c();
                }
            }
        };
        navigationflying.b(false);
        navigationflying.a(false);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.R);
    }

    boolean k(BlockPosition pos) {
        return this.H.o(pos) && this.H.a_(pos).a(TagsBlock.T);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    protected SoundEffect s() {
        return null;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.bz;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.by;
    }

    @Override
    public float eN() {
        return 0.4f;
    }

    @Nullable
    public EntityBee b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.h.a(world);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? dimensions.b * 0.5f : dimensions.b * 0.5f;
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    public boolean aN() {
        return this.gf() && this.ag % bT == 0;
    }

    @Override
    public boolean gf() {
        return !this.N;
    }

    public void gg() {
        this.w(false);
        this.gm();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        boolean result = super.a(source, amount);
        if (result && !this.H.B) {
            this.cG.m();
        }
        return result;
    }

    @Override
    public EnumMonsterType eJ() {
        return EnumMonsterType.c;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        this.f(this.dj().b(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D cF() {
        return new Vec3D(0.0, 0.5f * this.cE(), this.dc() * 0.2f);
    }

    boolean b(BlockPosition pos, int distance) {
        return pos.a(this.dg(), (double)distance);
    }

    private class j
    extends ControllerLook {
        j(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
            if (!EntityBee.this.R_()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityBee.this.cG.l();
        }
    }

    private class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        @Override
        public boolean a() {
            return super.a() && EntityBee.this.R_() && !EntityBee.this.gd();
        }

        @Override
        public boolean b() {
            return super.b() && EntityBee.this.R_() && !EntityBee.this.gd();
        }
    }

    private class d
    extends a {
        d() {
        }

        @Override
        public boolean h() {
            if (EntityBee.this.fZ() && EntityBee.this.gi() && EntityBee.this.cF.a(EntityBee.this.de(), 2.0)) {
                if (!EntityBee.this.H.isLoadedAndInBounds(EntityBee.this.cF)) {
                    return false;
                }
                TileEntity tileentity = EntityBee.this.H.c_(EntityBee.this.cF);
                if (tileentity instanceof TileEntityBeehive) {
                    TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                    if (!tileentitybeehive.f()) {
                        return true;
                    }
                    EntityBee.this.cF = null;
                }
            }
            return false;
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void c() {
            if (!EntityBee.this.H.isLoadedAndInBounds(EntityBee.this.cF)) {
                return;
            }
            TileEntity tileentity = EntityBee.this.H.c_(EntityBee.this.cF);
            if (tileentity instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                tileentitybeehive.a(EntityBee.this, EntityBee.this.gc());
            }
        }
    }

    private class k
    extends a {
        private static final int c = 400;
        private static final int d = 20;
        private static final int e = 60;
        private final Predicate<IBlockData> f;
        private static final double g = 0.1;
        private static final int h = 25;
        private static final float i = 0.35f;
        private static final float j = 0.6f;
        private static final float k = 0.33333334f;
        private int l;
        private int m;
        private boolean n;
        @Nullable
        private Vec3D o;
        private int p;
        private static final int q = 600;

        k() {
            this.f = iblockdata -> iblockdata.b(BlockProperties.C) && iblockdata.c(BlockProperties.C).booleanValue() ? false : (iblockdata.a(TagsBlock.T) ? (iblockdata.a(Blocks.iC) ? iblockdata.c(BlockTallPlant.a) == BlockPropertyDoubleBlockHalf.a : true) : false);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            if (EntityBee.this.cD > 0) {
                return false;
            }
            if (EntityBee.this.gc()) {
                return false;
            }
            if (EntityBee.this.H.Y()) {
                return false;
            }
            Optional<BlockPosition> optional = this.p();
            if (optional.isPresent()) {
                EntityBee.this.cE = optional.get();
                EntityBee.this.bM.a((double)EntityBee.this.cE.u() + 0.5, (double)EntityBee.this.cE.v() + 0.5, (double)EntityBee.this.cE.w() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.cD = MathHelper.a(EntityBee.this.af, 20, 60);
            return false;
        }

        @Override
        public boolean i() {
            if (!this.n) {
                return false;
            }
            if (!EntityBee.this.r()) {
                return false;
            }
            if (EntityBee.this.H.Y()) {
                return false;
            }
            if (this.k()) {
                return EntityBee.this.af.i() < 0.2f;
            }
            if (EntityBee.this.ag % 20 == 0 && !EntityBee.this.k(EntityBee.this.cE)) {
                EntityBee.this.cE = null;
                return false;
            }
            return true;
        }

        private boolean k() {
            return this.l > 400;
        }

        boolean l() {
            return this.n;
        }

        void m() {
            this.n = false;
        }

        @Override
        public void c() {
            this.l = 0;
            this.p = 0;
            this.m = 0;
            this.n = true;
            EntityBee.this.fY();
        }

        @Override
        public void d() {
            if (this.k()) {
                EntityBee.this.w(true);
            }
            this.n = false;
            EntityBee.this.bM.n();
            EntityBee.this.cD = 200;
        }

        @Override
        public boolean J_() {
            return true;
        }

        @Override
        public void e() {
            ++this.p;
            if (this.p > 600) {
                EntityBee.this.cE = null;
            } else if (EntityBee.this.cE != null) {
                Vec3D vec3d = Vec3D.c(EntityBee.this.cE).b(0.0, 0.6f, 0.0);
                if (vec3d.f(EntityBee.this.de()) > 1.0) {
                    this.o = vec3d;
                    this.n();
                } else {
                    if (this.o == null) {
                        this.o = vec3d;
                    }
                    boolean flag = EntityBee.this.de().f(this.o) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.p > 600) {
                        EntityBee.this.cE = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = EntityBee.this.af.a(25) == 0;
                            if (flag2) {
                                this.o = new Vec3D(vec3d.a() + (double)this.o(), vec3d.b(), vec3d.c() + (double)this.o());
                                EntityBee.this.bM.n();
                            } else {
                                flag1 = false;
                            }
                            EntityBee.this.C().a(vec3d.a(), vec3d.b(), vec3d.c());
                        }
                        if (flag1) {
                            this.n();
                        }
                        ++this.l;
                        if (EntityBee.this.af.i() < 0.05f && this.l > this.m + 60) {
                            this.m = this.l;
                            EntityBee.this.a(SoundEffects.bD, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void n() {
            EntityBee.this.D().a(this.o.a(), this.o.b(), this.o.c(), 0.35f);
        }

        private float o() {
            return (EntityBee.this.af.i() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> p() {
            return this.a(this.f, 5.0);
        }

        private Optional<BlockPosition> a(Predicate<IBlockData> predicate, double searchDistance) {
            BlockPosition blockposition = EntityBee.this.dg();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int i2 = 0;
            while ((double)i2 <= searchDistance) {
                int j2 = 0;
                while ((double)j2 < searchDistance) {
                    int k2 = 0;
                    while (k2 <= j2) {
                        int l2;
                        int n2 = l2 = k2 < j2 && k2 > -j2 ? j2 : 0;
                        while (l2 <= j2) {
                            blockposition_mutableblockposition.a(blockposition, k2, i2 - 1, l2);
                            if (blockposition.a(blockposition_mutableblockposition, searchDistance) && predicate.test(EntityBee.this.H.a_(blockposition_mutableblockposition))) {
                                return Optional.of(blockposition_mutableblockposition);
                            }
                            l2 = l2 > 0 ? -l2 : 1 - l2;
                        }
                        k2 = k2 > 0 ? -k2 : 1 - k2;
                    }
                    ++j2;
                }
                i2 = i2 > 0 ? -i2 : 1 - i2;
            }
            return Optional.empty();
        }
    }

    private class i
    extends a {
        i() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.cB == 0 && !EntityBee.this.fZ() && EntityBee.this.gi();
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void c() {
            EntityBee.this.cB = 200;
            List<BlockPosition> list = this.k();
            if (!list.isEmpty()) {
                BlockPosition blockposition;
                Iterator<BlockPosition> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    EntityBee.this.cH.k();
                    EntityBee.this.cF = list.get(0);
                    return;
                } while (EntityBee.this.cH.b(blockposition = iterator.next()));
                EntityBee.this.cF = blockposition;
            }
        }

        private List<BlockPosition> k() {
            BlockPosition blockposition = EntityBee.this.dg();
            VillagePlace villageplace = ((WorldServer)EntityBee.this.H).w();
            Stream<VillagePlaceRecord> stream = villageplace.c(holder -> holder.a(PoiTypeTags.c), blockposition, 20, VillagePlace.Occupancy.c);
            return stream.map(VillagePlaceRecord::f).filter(EntityBee.this::i).sorted(Comparator.comparingDouble(blockposition1 -> blockposition1.j(blockposition))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int b = 600;
        int d;
        private static final int e = 3;
        final List<BlockPosition> f;
        @Nullable
        private PathEntity g;
        private static final int h = 60;
        private int i;

        e() {
            this.d = EntityBee.this.af.a(10);
            this.f = Lists.newArrayList();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cF != null && !EntityBee.this.fG() && EntityBee.this.gi() && !this.d(EntityBee.this.cF) && EntityBee.this.H.a_(EntityBee.this.cF).a(TagsBlock.aD);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void c() {
            this.d = 0;
            this.i = 0;
            super.c();
        }

        @Override
        public void d() {
            this.d = 0;
            this.i = 0;
            EntityBee.this.bM.n();
            EntityBee.this.bM.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.cF != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    this.l();
                } else if (!EntityBee.this.bM.m()) {
                    if (!EntityBee.this.b(EntityBee.this.cF, 16)) {
                        if (EntityBee.this.j(EntityBee.this.cF)) {
                            this.m();
                        } else {
                            EntityBee.this.h(EntityBee.this.cF);
                        }
                    } else {
                        boolean flag = this.a(EntityBee.this.cF);
                        if (!flag) {
                            this.l();
                        } else if (this.g != null && EntityBee.this.bM.j().a(this.g)) {
                            ++this.i;
                            if (this.i > 60) {
                                this.m();
                                this.i = 0;
                            }
                        } else {
                            this.g = EntityBee.this.bM.j();
                        }
                    }
                }
            }
        }

        private boolean a(BlockPosition pos) {
            EntityBee.this.bM.a(10.0f);
            EntityBee.this.bM.a((double)pos.u(), (double)pos.v(), (double)pos.w(), 1.0);
            return EntityBee.this.bM.j() != null && EntityBee.this.bM.j().j();
        }

        boolean b(BlockPosition pos) {
            return this.f.contains(pos);
        }

        private void c(BlockPosition pos) {
            this.f.add(pos);
            while (this.f.size() > 3) {
                this.f.remove(0);
            }
        }

        void k() {
            this.f.clear();
        }

        private void l() {
            if (EntityBee.this.cF != null) {
                this.c(EntityBee.this.cF);
            }
            this.m();
        }

        private void m() {
            EntityBee.this.cF = null;
            EntityBee.this.cB = 200;
        }

        private boolean d(BlockPosition pos) {
            if (EntityBee.this.b(pos, 2)) {
                return true;
            }
            PathEntity pathentity = EntityBee.this.bM.j();
            return pathentity != null && pathentity.m().equals(pos) && pathentity.j() && pathentity.c();
        }
    }

    public class f
    extends a {
        private static final int c = 600;
        int d;

        f() {
            this.d = EntityBee.this.af.a(10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cE != null && !EntityBee.this.fG() && this.k() && EntityBee.this.k(EntityBee.this.cE) && !EntityBee.this.b(EntityBee.this.cE, 2);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void c() {
            this.d = 0;
            super.c();
        }

        @Override
        public void d() {
            this.d = 0;
            EntityBee.this.bM.n();
            EntityBee.this.bM.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.cE != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    EntityBee.this.cE = null;
                } else if (!EntityBee.this.bM.m()) {
                    if (EntityBee.this.j(EntityBee.this.cE)) {
                        EntityBee.this.cE = null;
                    } else {
                        EntityBee.this.h(EntityBee.this.cE);
                    }
                }
            }
        }

        private boolean k() {
            return EntityBee.this.cx > 2400;
        }
    }

    private class g
    extends a {
        static final int b = 30;

        g() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.gl() >= 10 ? false : (EntityBee.this.af.i() < 0.3f ? false : EntityBee.this.gc() && EntityBee.this.go());
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void e() {
            if (EntityBee.this.af.a(this.a(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    BlockPosition blockposition = EntityBee.this.dg().c(i2);
                    IBlockData iblockdata = EntityBee.this.H.a_(blockposition);
                    Block block = iblockdata.b();
                    boolean flag = false;
                    BlockStateInteger blockstateinteger = null;
                    if (!iblockdata.a(TagsBlock.aF)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops blockcrops = (BlockCrops)block;
                        if (!blockcrops.h(iblockdata)) {
                            flag = true;
                            blockstateinteger = blockcrops.b();
                        }
                    } else if (block instanceof BlockStem) {
                        int j2 = iblockdata.c(BlockStem.b);
                        if (j2 < 7) {
                            flag = true;
                            blockstateinteger = BlockStem.b;
                        }
                    } else if (iblockdata.a(Blocks.oe)) {
                        int j3 = iblockdata.c(BlockSweetBerryBush.b);
                        if (j3 < 3) {
                            flag = true;
                            blockstateinteger = BlockSweetBerryBush.b;
                        }
                    } else if (iblockdata.a(Blocks.rp) || iblockdata.a(Blocks.rq)) {
                        ((IBlockFragilePlantElement)((Object)iblockdata.b())).a((WorldServer)EntityBee.this.H, EntityBee.this.af, blockposition, iblockdata);
                    }
                    if (!flag || CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockposition, (IBlockData)iblockdata.a(blockstateinteger, iblockdata.c(blockstateinteger) + 1)).isCancelled()) continue;
                    EntityBee.this.H.c(2005, blockposition, 0);
                    EntityBee.this.H.b(blockposition, (IBlockData)iblockdata.a(blockstateinteger, iblockdata.c(blockstateinteger) + 1));
                    EntityBee.this.gn();
                }
            }
        }
    }

    private class l
    extends PathfinderGoal {
        private static final int b = 22;

        l() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityBee.this.bM.l() && EntityBee.this.af.a(10) == 0;
        }

        @Override
        public boolean b() {
            return EntityBee.this.bM.m();
        }

        @Override
        public void c() {
            Vec3D vec3d = this.h();
            if (vec3d != null) {
                EntityBee.this.bM.a(EntityBee.this.bM.a(BlockPosition.a(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D h() {
            Vec3D vec3d;
            if (EntityBee.this.go() && !EntityBee.this.b(EntityBee.this.cF, 22)) {
                Vec3D vec3d1 = Vec3D.b(EntityBee.this.cF);
                vec3d = vec3d1.d(EntityBee.this.de()).d();
            } else {
                vec3d = EntityBee.this.j(0.0f);
            }
            boolean flag = true;
            Vec3D vec3d2 = HoverRandomPos.a(EntityBee.this, 8, 7, vec3d.c, vec3d.e, 1.5707964f, 3, 1);
            return vec3d2 != null ? vec3d2 : AirAndWaterRandomPos.a(EntityBee.this, 8, 4, -2, vec3d.c, vec3d.e, 1.5707963705062866);
        }
    }

    private class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee entitybee) {
            super(entitybee, new Class[0]);
        }

        @Override
        public boolean b() {
            return EntityBee.this.R_() && super.b();
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityBee && this.e.B(target)) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee bee) {
            super(bee, EntityHuman.class, 10, true, false, bee::a_);
        }

        @Override
        public boolean a() {
            return this.i() && super.a();
        }

        @Override
        public boolean b() {
            boolean flag = this.i();
            if (flag && this.e.P_() != null) {
                return super.b();
            }
            this.g = null;
            return false;
        }

        private boolean i() {
            EntityBee entitybee = (EntityBee)this.e;
            return entitybee.R_() && !entitybee.gd();
        }
    }

    private abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean h();

        public abstract boolean i();

        @Override
        public boolean a() {
            return this.h() && !EntityBee.this.R_();
        }

        @Override
        public boolean b() {
            return this.i() && !EntityBee.this.R_();
        }
    }
}

