/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityCat
extends EntityTameableAnimal
implements VariantHolder<CatVariant> {
    public static final double bV = 0.6;
    public static final double bW = 0.8;
    public static final double bX = 1.33;
    private static final RecipeItemStack bY = RecipeItemStack.a(Items.qh, Items.qi);
    private static final DataWatcherObject<CatVariant> bZ = DataWatcher.a(EntityCat.class, DataWatcherRegistry.w);
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cc = DataWatcher.a(EntityCat.class, DataWatcherRegistry.b);
    private a<EntityHuman> cd;
    @Nullable
    private PathfinderGoalTempt ce;
    private float cf;
    private float cg;
    private float ch;
    private float ci;
    private float cj;
    private float ck;

    public EntityCat(EntityTypes<? extends EntityCat> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
    }

    public MinecraftKey fY() {
        return this.fZ().a();
    }

    @Override
    protected void x() {
        this.ce = new PathfinderGoalTemptChance(this, 0.6, bY, true);
        this.bN.a(1, new PathfinderGoalFloat(this));
        this.bN.a(1, new PathfinderGoalPanic(this, 1.5));
        this.bN.a(2, new PathfinderGoalSit(this));
        this.bN.a(3, new b(this));
        this.bN.a(4, this.ce);
        this.bN.a(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.bN.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f, false));
        this.bN.a(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.bN.a(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.bN.a(9, new PathfinderGoalOcelotAttack(this));
        this.bN.a(10, new PathfinderGoalBreed(this, 0.8));
        this.bN.a(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.bN.a(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.bO.a(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, (Predicate<EntityLiving>)null));
        this.bO.a(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bT));
    }

    public CatVariant fZ() {
        return this.am.a(bZ);
    }

    @Override
    public void a(CatVariant variant) {
        this.am.b(bZ, variant);
    }

    public void A(boolean sleeping) {
        this.am.b(ca, sleeping);
    }

    public boolean ga() {
        return this.am.a(ca);
    }

    public void B(boolean headDown) {
        this.am.b(cb, headDown);
    }

    public boolean gb() {
        return this.am.a(cb);
    }

    public EnumColor gc() {
        return EnumColor.a(this.am.a(cc));
    }

    @Override
    public void a(EnumColor color) {
        this.am.b(cc, color.a());
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bZ, BuiltInRegistries.ai.e(CatVariant.b));
        this.am.a(ca, false);
        this.am.a(cb, false);
        this.am.a(cc, EnumColor.o.a());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("variant", BuiltInRegistries.ai.b(this.fZ()).toString());
        nbt.a("CollarColor", (byte)this.gc().a());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        CatVariant catvariant = BuiltInRegistries.ai.a(MinecraftKey.a(nbt.l("variant")));
        if (catvariant != null) {
            this.a(catvariant);
        }
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
    }

    @Override
    public void U() {
        if (this.D().b()) {
            double d0 = this.D().c();
            if (d0 == 0.6) {
                this.b(EntityPose.f);
                this.g(false);
            } else if (d0 == 1.33) {
                this.b(EntityPose.a);
                this.g(true);
            } else {
                this.b(EntityPose.a);
                this.g(false);
            }
        } else {
            this.b(EntityPose.a);
            this.g(false);
        }
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return this.q() ? (this.fW() ? SoundEffects.dm : (this.af.a(4) == 0 ? SoundEffects.dn : SoundEffects.df)) : SoundEffects.dg;
    }

    @Override
    public int K() {
        return 120;
    }

    public void gd() {
        this.a(SoundEffects.dj, this.eN(), this.eO());
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.dl;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.dh;
    }

    public static AttributeProvider.Builder ge() {
        return EntityInsentient.y().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.f, 3.0);
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (this.m(stack)) {
            this.a(SoundEffects.di, 1.0f, 1.0f);
        }
        super.a(player, hand, stack);
    }

    private float gf() {
        return (float)this.b(GenericAttributes.f);
    }

    @Override
    public boolean z(Entity target) {
        return target.a(this.dG().b(this), this.gf());
    }

    @Override
    public void l() {
        super.l();
        if (this.ce != null && this.ce.i() && !this.q() && this.ag % 100 == 0) {
            this.a(SoundEffects.dk, 1.0f, 1.0f);
        }
        this.gg();
    }

    private void gg() {
        if ((this.ga() || this.gb()) && this.ag % 5 == 0) {
            this.a(SoundEffects.dm, 0.6f + 0.4f * (this.af.i() - this.af.i()), 1.0f);
        }
        this.gh();
        this.gi();
    }

    private void gh() {
        this.cg = this.cf;
        this.ci = this.ch;
        if (this.ga()) {
            this.cf = Math.min(1.0f, this.cf + 0.15f);
            this.ch = Math.min(1.0f, this.ch + 0.08f);
        } else {
            this.cf = Math.max(0.0f, this.cf - 0.22f);
            this.ch = Math.max(0.0f, this.ch - 0.13f);
        }
    }

    private void gi() {
        this.ck = this.cj;
        this.cj = this.gb() ? Math.min(1.0f, this.cj + 0.1f) : Math.max(0.0f, this.cj - 0.13f);
    }

    public float C(float tickDelta) {
        return MathHelper.i(tickDelta, this.cg, this.cf);
    }

    public float D(float tickDelta) {
        return MathHelper.i(tickDelta, this.ci, this.ch);
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.ck, this.cj);
    }

    @Nullable
    public EntityCat b(WorldServer world, EntityAgeable entity) {
        EntityCat entitycat = EntityTypes.m.a(world);
        if (entitycat != null && entity instanceof EntityCat) {
            EntityCat entitycat1 = (EntityCat)entity;
            if (this.af.h()) {
                entitycat.a(this.fZ());
            } else {
                entitycat.a(entitycat1.fZ());
            }
            if (this.q()) {
                entitycat.b(this.T_());
                entitycat.x(true);
                if (this.af.h()) {
                    entitycat.a(this.gc());
                } else {
                    entitycat.a(entitycat1.gc());
                }
            }
        }
        return entitycat;
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (!this.q()) {
            return false;
        }
        if (!(other instanceof EntityCat)) {
            return false;
        }
        EntityCat entitycat = (EntityCat)other;
        return entitycat.q() && super.a(other);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        entityData = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        boolean flag = world.am() > 0.9f;
        TagKey<CatVariant> tagkey = flag ? CatVariantTags.b : CatVariantTags.a;
        BuiltInRegistries.ai.b(tagkey).flatMap(holderset_named -> holderset_named.a(world.r_())).ifPresent(holder -> this.a((CatVariant)holder.a()));
        WorldServer worldserver = world.C();
        if (worldserver.a().getStructureWithPieceAt(this.dg(), StructureTags.g, world).b()) {
            this.a(BuiltInRegistries.ai.e(CatVariant.k));
            this.fz();
        }
        return entityData;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.c();
        if (this.H.B) {
            return this.q() && this.m(player) ? EnumInteractionResult.a : (this.m(itemstack) && (this.eo() < this.eE() || !this.q()) ? EnumInteractionResult.a : EnumInteractionResult.d);
        }
        if (this.q()) {
            if (this.m(player)) {
                if (!(item instanceof ItemDye)) {
                    if (item.u() && this.m(itemstack) && this.eo() < this.eE()) {
                        this.a(player, hand, itemstack);
                        this.heal(item.v().a(), EntityRegainHealthEvent.RegainReason.EATING);
                        return EnumInteractionResult.b;
                    }
                    EnumInteractionResult enuminteractionresult2 = super.b(player, hand);
                    if (!enuminteractionresult2.a() || this.y_()) {
                        this.z(!this.fS());
                    }
                    return enuminteractionresult2;
                }
                EnumColor enumcolor = ((ItemDye)item).d();
                if (enumcolor != this.gc()) {
                    EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)enumcolor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                    if (!event.callEvent()) {
                        return EnumInteractionResult.e;
                    }
                    enumcolor = EnumColor.a(event.getColor().getWoolData());
                    this.a(enumcolor);
                    if (!player.fK().d) {
                        itemstack.h(1);
                    }
                    this.fz();
                    return EnumInteractionResult.b;
                }
            }
        } else if (this.m(itemstack)) {
            this.a(player, hand, itemstack);
            if (this.af.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                this.e(player);
                this.z(true);
                this.H.a((Entity)this, (byte)7);
            } else {
                this.H.a((Entity)this, (byte)6);
            }
            this.fz();
            return EnumInteractionResult.b;
        }
        if ((enuminteractionresult = super.b(player, hand)).a()) {
            this.fz();
        }
        return enuminteractionresult;
    }

    @Override
    public boolean m(ItemStack stack) {
        return bY.a(stack);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.5f;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.q() && this.ag > 2400;
    }

    @Override
    protected void r() {
        if (this.cd == null) {
            this.cd = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.bN.a(this.cd);
        if (!this.q()) {
            this.bN.a(4, this.cd);
        }
    }

    @Override
    public boolean bP() {
        return this.bT() || super.bP();
    }

    private static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityLiving selectedPlayer;
        private final EntityCat d;

        public PathfinderGoalTemptChance(EntityCat cat, double speed, RecipeItemStack food, boolean canBeScared) {
            super(cat, speed, food, canBeScared);
            this.d = cat;
        }

        @Override
        public void e() {
            super.e();
            if (this.selectedPlayer == null && this.a.dZ().a(this.a(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.a.dZ().a(this.a(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean h() {
            return this.selectedPlayer != null && this.selectedPlayer.equals(this.player) ? false : super.h();
        }

        @Override
        public boolean a() {
            return super.a() && !this.d.q();
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityCat a;
        @Nullable
        private EntityHuman b;
        @Nullable
        private BlockPosition c;
        private int d;

        public b(EntityCat cat) {
            this.a = cat;
        }

        @Override
        public boolean a() {
            if (!this.a.q()) {
                return false;
            }
            if (this.a.fS()) {
                return false;
            }
            EntityLiving entityliving = this.a.H_();
            if (entityliving instanceof EntityHuman) {
                this.b = (EntityHuman)entityliving;
                if (!entityliving.fu()) {
                    return false;
                }
                if (this.a.f((Entity)this.b) > 100.0) {
                    return false;
                }
                BlockPosition blockposition = this.b.dg();
                IBlockData iblockdata = this.a.H.a_(blockposition);
                if (iblockdata.a(TagsBlock.Q)) {
                    this.c = iblockdata.d(BlockFacingHorizontal.aD).map(enumdirection -> blockposition.a(enumdirection.g())).orElseGet(() -> new BlockPosition(blockposition));
                    return !this.h();
                }
            }
            return false;
        }

        private boolean h() {
            EntityCat entitycat;
            List<EntityCat> list = this.a.H.a(EntityCat.class, new AxisAlignedBB(this.c).g(2.0));
            Iterator<EntityCat> iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((entitycat = iterator.next()) == this.a || !entitycat.ga() && !entitycat.gb());
            return true;
        }

        @Override
        public boolean b() {
            return this.a.q() && !this.a.fS() && this.b != null && this.b.fu() && this.c != null && !this.h();
        }

        @Override
        public void c() {
            if (this.c != null) {
                this.a.y(false);
                this.a.G().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
            }
        }

        @Override
        public void d() {
            this.a.A(false);
            float f2 = this.a.H.f(1.0f);
            if (this.b.fN() >= 100 && (double)f2 > 0.77 && (double)f2 < 0.8 && (double)this.a.H.r_().i() < 0.7) {
                this.i();
            }
            this.d = 0;
            this.a.B(false);
            this.a.G().n();
        }

        private void i() {
            RandomSource randomsource = this.a.dZ();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            blockposition_mutableblockposition.g(this.a.fI() ? this.a.fJ().dg() : this.a.dg());
            this.a.a((double)(blockposition_mutableblockposition.u() + randomsource.a(11) - 5), (double)(blockposition_mutableblockposition.v() + randomsource.a(5) - 2), (double)(blockposition_mutableblockposition.w() + randomsource.a(11) - 5), false);
            blockposition_mutableblockposition.g(this.a.dg());
            LootTable loottable = this.a.H.n().aH().a(LootTables.am);
            LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.a.H).a(LootContextParameters.f, this.a.de()).a(LootContextParameters.a, this.a).a(randomsource);
            ObjectArrayList<ItemStack> list = loottable.a(loottableinfo_builder.a(LootContextParameterSets.h));
            for (ItemStack itemstack : list) {
                EntityItem entityitem = new EntityItem(this.a.H, (double)blockposition_mutableblockposition.u() - (double)MathHelper.a(this.a.aT * ((float)Math.PI / 180)), blockposition_mutableblockposition.v(), (double)blockposition_mutableblockposition.w() + (double)MathHelper.b(this.a.aT * ((float)Math.PI / 180)), itemstack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), (org.bukkit.entity.Item)entityitem.getBukkitEntity());
                entityitem.H.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.a.H.b(entityitem);
            }
        }

        @Override
        public void e() {
            if (this.b != null && this.c != null) {
                this.a.y(false);
                this.a.G().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
                if (this.a.f((Entity)this.b) < 2.5) {
                    ++this.d;
                    if (this.d > this.a(16)) {
                        this.a.A(true);
                        this.a.B(false);
                    } else {
                        this.a.a((Entity)this.b, 45.0f, 45.0f);
                        this.a.B(true);
                    }
                } else {
                    this.a.A(false);
                }
            }
        }
    }

    private static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat i;

        public a(EntityCat cat, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super(cat, fleeFromType, distance, slowSpeed, fastSpeed, IEntitySelector.e::test);
            this.i = cat;
        }

        @Override
        public boolean a() {
            return !this.i.q() && super.a();
        }

        @Override
        public boolean b() {
            return !this.i.q() && super.b();
        }
    }
}

