/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class EntityFox
extends EntityAnimal
implements VariantHolder<Type> {
    private static final DataWatcherObject<Integer> bW = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> bX = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int bY = 1;
    public static final int bS = 4;
    public static final int bT = 8;
    public static final int bV = 16;
    private static final int bZ = 32;
    private static final int ca = 64;
    private static final int cb = 128;
    public static final DataWatcherObject<Optional<UUID>> cc = DataWatcher.a(EntityFox.class, DataWatcherRegistry.q);
    public static final DataWatcherObject<Optional<UUID>> cd = DataWatcher.a(EntityFox.class, DataWatcherRegistry.q);
    static final Predicate<EntityItem> ce = entityitem -> !entityitem.q() && entityitem.bq();
    private static final Predicate<Entity> cf = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.ec() != null && entityliving.ed() < entityliving.ag + 600;
    };
    static final Predicate<Entity> cg = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> ch = entity -> !entity.bR() && IEntitySelector.e.test((Entity)entity);
    private static final int ci = 600;
    private PathfinderGoal cj;
    private PathfinderGoal ck;
    private PathfinderGoal cl;
    private float cm;
    private float cn;
    float co;
    float cp;
    private int cq;

    public EntityFox(EntityTypes<? extends EntityFox> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bJ = new k();
        this.bK = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.s(true);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cc, Optional.empty());
        this.am.a(cd, Optional.empty());
        this.am.a(bW, 0);
        this.am.a(bX, (byte)0);
    }

    @Override
    protected void x() {
        this.cj = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, entityliving -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.ck = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.bT);
        this.cl = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, entityliving -> entityliving instanceof EntityFishSchool);
        this.bN.a(0, new g());
        this.bN.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.H));
        this.bN.a(1, new b());
        this.bN.a(2, new n(2.2));
        this.bN.a(3, new e(1.0));
        this.bN.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> ch.test((Entity)entityliving) && !this.c(entityliving.cs()) && !this.ge()));
        this.bN.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).q() && !this.ge()));
        this.bN.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.ge()));
        this.bN.a(5, new u());
        this.bN.a(6, new o());
        this.bN.a(6, new s(1.25));
        this.bN.a(7, new l((double)1.2f, true));
        this.bN.a(7, new t());
        this.bN.a(8, new h(this, 1.25));
        this.bN.a(9, new q(32, 200));
        this.bN.a(10, new f((double)1.2f, 12, 1));
        this.bN.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bN.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bN.a(11, new p());
        this.bN.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bN.a(13, new r());
        this.bO.a(3, new a(EntityLiving.class, false, false, entityliving -> cf.test((Entity)entityliving) && !this.c(entityliving.cs())));
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return SoundEffects.hY;
    }

    @Override
    public void b_() {
        if (!this.H.B && this.bq() && this.cU()) {
            EntityLiving entityliving;
            ++this.cq;
            ItemStack itemstack = this.c(EnumItemSlot.a);
            if (this.l(itemstack)) {
                if (this.cq > 600) {
                    ItemStack itemstack1 = itemstack.a(this.H, this);
                    if (!itemstack1.b()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.cq = 0;
                } else if (this.cq > 560 && this.af.i() < 0.1f) {
                    this.a(this.d(itemstack), 1.0f, 1.0f);
                    this.H.a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.P_()) == null || !entityliving.bq()) {
                this.y(false);
                this.z(false);
            }
        }
        if (this.fu() || this.eP()) {
            this.bi = false;
            this.bj = 0.0f;
            this.bl = 0.0f;
        }
        super.b_();
        if (this.ge() && this.af.i() < 0.05f) {
            this.a(SoundEffects.hU, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean eP() {
        return this.ep();
    }

    private boolean l(ItemStack stack) {
        return stack.c().u() && this.P_() == null && this.N && !this.fu();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (random.i() < 0.2f) {
            float f2 = random.i();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.nH) : (f2 < 0.2f ? new ItemStack(Items.pZ) : (f2 < 0.4f ? (random.h() ? new ItemStack(Items.tF) : new ItemStack(Items.tG)) : (f2 < 0.6f ? new ItemStack(Items.oE) : (f2 < 0.8f ? new ItemStack(Items.pL) : new ItemStack(Items.oB)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 45) {
            ItemStack itemstack = this.c(EnumItemSlot.a);
            if (!itemstack.b()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.af.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dy() * ((float)Math.PI / 180)).b(-this.dw() * ((float)Math.PI / 180));
                    this.H.a(new ParticleParamItem(Particles.Q, itemstack), this.dl() + this.bC().c / 2.0, this.dn(), this.dr() + this.bC().e / 2.0, vec3d.c, vec3d.d + 0.05, vec3d.e);
                }
            }
        } else {
            super.b(status);
        }
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 10.0).a(GenericAttributes.b, 32.0).a(GenericAttributes.f, 2.0);
    }

    @Nullable
    public EntityFox b(WorldServer world, EntityAgeable entity) {
        EntityFox entityfox = EntityTypes.N.a(world);
        if (entityfox != null) {
            entityfox.a(this.af.h() ? this.r() : ((EntityFox)entity).r());
        }
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bQ) && EntityFox.a(world, pos);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        Holder<BiomeBase> holder = world.v(this.dg());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (entityData instanceof i) {
            i entityfox_i = (i)entityData;
            entityfox_type = entityfox_i.a;
            if (entityfox_i.a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.c_(-24000);
        }
        if (world instanceof WorldServer) {
            this.gc();
        }
        this.a(world.r_(), difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private void gc() {
        if (this.r() == Type.a) {
            this.bO.a(4, this.cj);
            this.bO.a(4, this.ck);
            this.bO.a(6, this.cl);
        } else {
            this.bO.a(4, this.cl);
            this.bO.a(6, this.cj);
            this.bO.a(6, this.ck);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (this.m(stack)) {
            this.a(this.d(stack), 1.0f, 1.0f);
        }
        super.a(player, hand, stack);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? dimensions.b * 0.85f : 0.4f;
    }

    public Type r() {
        return Type.a(this.am.a(bW));
    }

    @Override
    public void a(Type variant) {
        this.am.b(bW, variant.a());
    }

    List<UUID> gd() {
        ArrayList list = Lists.newArrayList();
        list.add(this.am.a(cc).orElse(null));
        list.add(this.am.a(cd).orElse(null));
        return list;
    }

    void b(@Nullable UUID uuid) {
        if (this.am.a(cc).isPresent()) {
            this.am.b(cd, Optional.ofNullable(uuid));
        } else {
            this.am.b(cc, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        List<UUID> list = this.gd();
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbt.a("Trusted", nbttaglist);
        nbt.a("Sleeping", this.fu());
        nbt.a("Type", this.r().c());
        nbt.a("Sitting", this.w());
        nbt.a("Crouching", this.bT());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagList nbttaglist = nbt.c("Trusted", 11);
        for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
            this.b(GameProfileSerializer.a(nbttaglist.k(i2)));
        }
        this.C(nbt.q("Sleeping"));
        this.a(Type.a(nbt.l("Type")));
        this.setSitting(nbt.q("Sitting"), false);
        this.y(nbt.q("Crouching"));
        if (this.H instanceof WorldServer) {
            this.gc();
        }
    }

    public boolean w() {
        return this.s(1);
    }

    public void w(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean fireEvent) {
        if (fireEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(1, sitting);
    }

    public boolean fS() {
        return this.s(64);
    }

    public void A(boolean walking) {
        this.d(64, walking);
    }

    public boolean ge() {
        return this.s(128);
    }

    public void B(boolean aggressive) {
        this.d(128, aggressive);
    }

    @Override
    public boolean fu() {
        return this.s(32);
    }

    public void C(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int mask, boolean value) {
        if (value) {
            this.am.b(bX, (byte)(this.am.a(bX) | mask));
        } else {
            this.am.b(bX, (byte)(this.am.a(bX) & ~mask));
        }
    }

    private boolean s(int bitmask) {
        return (this.am.a(bX) & bitmask) != 0;
    }

    @Override
    public boolean f(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return !this.c(enumitemslot).b() ? false : enumitemslot == EnumItemSlot.a && super.f(stack);
    }

    @Override
    public boolean j(ItemStack stack) {
        Item item = stack.c();
        ItemStack itemstack1 = this.c(EnumItemSlot.a);
        return itemstack1.b() || this.cq > 0 && item.u() && !itemstack1.c().u();
    }

    private void n(ItemStack stack) {
        if (!stack.b() && !this.H.B) {
            EntityItem entityitem = new EntityItem(this.H, this.dl() + this.bC().c, this.dn() + 1.0, this.dr() + this.bC().e, stack);
            entityitem.b(40);
            entityitem.c(this.cs());
            this.a(SoundEffects.id, 1.0f, 1.0f);
            this.spawnAtLocation(entityitem);
        }
    }

    private void o(ItemStack stack) {
        EntityItem entityitem = new EntityItem(this.H, this.dl(), this.dn(), this.dr(), stack);
        this.spawnAtLocation(entityitem);
    }

    @Override
    protected void b(EntityItem item) {
        ItemStack itemstack = item.i();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, item, itemstack.K() - 1, !this.j(itemstack)).isCancelled()) {
            itemstack = item.i();
            int i2 = itemstack.K();
            if (i2 > 1) {
                this.o(itemstack.a(i2 - 1));
            }
            this.n(this.c(EnumItemSlot.a));
            this.a(item);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.e(EnumItemSlot.a);
            this.a((Entity)item, itemstack.K());
            item.ai();
            this.cq = 0;
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.cU()) {
            boolean flag = this.aT();
            if (flag || this.P_() != null || this.H.X()) {
                this.gf();
            }
            if (flag || this.fu()) {
                this.w(false);
            }
            if (this.fS() && this.H.z.i() < 0.2f) {
                BlockPosition blockposition = this.dg();
                IBlockData iblockdata = this.H.a_(blockposition);
                this.H.c(2001, blockposition, Block.i(iblockdata));
            }
        }
        this.cn = this.cm;
        this.cm = this.gb() ? (this.cm += (1.0f - this.cm) * 0.4f) : (this.cm += (0.0f - this.cm) * 0.4f);
        this.cp = this.co;
        if (this.bT()) {
            this.co += 0.2f;
            if (this.co > 3.0f) {
                this.co = 3.0f;
            }
        } else {
            this.co = 0.0f;
        }
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.W);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).b(player.cs());
    }

    public boolean fY() {
        return this.s(16);
    }

    public void x(boolean chasing) {
        this.d(16, chasing);
    }

    public boolean fZ() {
        return this.bi;
    }

    public boolean ga() {
        return this.co == 3.0f;
    }

    public void y(boolean crouching) {
        this.d(4, crouching);
    }

    @Override
    public boolean bT() {
        return this.s(4);
    }

    public void z(boolean rollingHead) {
        this.d(8, rollingHead);
    }

    public boolean gb() {
        return this.s(8);
    }

    public float C(float tickDelta) {
        return MathHelper.i(tickDelta, this.cn, this.cm) * 0.11f * (float)Math.PI;
    }

    public float D(float tickDelta) {
        return MathHelper.i(tickDelta, this.cp, this.co);
    }

    @Override
    public void i(@Nullable EntityLiving target) {
        if (this.ge() && target == null) {
            this.B(false);
        }
        super.i(target);
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return MathHelper.f((fallDistance - 5.0f) * damageMultiplier);
    }

    void gf() {
        this.C(false);
    }

    void gg() {
        this.z(false);
        this.y(false);
        this.w(false);
        this.C(false);
        this.B(false);
        this.A(false);
    }

    boolean gh() {
        return !this.fu() && !this.w() && !this.fS();
    }

    @Override
    public void L() {
        SoundEffect soundeffect = this.s();
        if (soundeffect == SoundEffects.ia) {
            this.a(soundeffect, 2.0f, this.eO());
        } else {
            super.L();
        }
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        List<Entity> list;
        if (this.fu()) {
            return SoundEffects.ib;
        }
        if (!this.H.M() && this.af.i() < 0.1f && (list = this.H.a(EntityHuman.class, this.cD().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.ia;
        }
        return SoundEffects.hV;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.hZ;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.hX;
    }

    boolean c(UUID uuid) {
        return this.gd().contains(uuid);
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(DamageSource source) {
        ItemStack itemstack = this.c(EnumItemSlot.a).o();
        EntityDeathEvent deathEvent = super.dropAllDeathLoot(source);
        if (deathEvent == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (!itemstack.b()) {
            this.b(itemstack);
            this.a(EnumItemSlot.a, ItemStack.b);
        }
        return deathEvent;
    }

    public static boolean a(EntityFox fox, EntityLiving chasedEntity) {
        double d0 = chasedEntity.dr() - fox.dr();
        double d1 = chasedEntity.dl() - fox.dl();
        double d2 = d0 / d1;
        boolean flag = true;
        for (int i2 = 0; i2 < 6; ++i2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i2 / 6.0f) : d3 / d2;
            for (int j2 = 1; j2 < 4; ++j2) {
                if (fox.H.a_(BlockPosition.a(fox.dl() + d4, fox.dn() + (double)j2, fox.dr() + d3)).o()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D cF() {
        return new Vec3D(0.0, 0.55f * this.cE(), this.dc() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fu()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.fY() && !EntityFox.this.bT() && !EntityFox.this.gb() && !EntityFox.this.fS();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gh()) {
                super.a();
            }
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void c() {
            super.c();
            EntityFox.this.gg();
        }

        @Override
        public boolean a() {
            return EntityFox.this.aT() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bg();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityFox.this.fS();
        }

        @Override
        public boolean b() {
            return this.a() && this.a > 0;
        }

        @Override
        public void c() {
            this.a = this.a(40);
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
        }

        @Override
        public void e() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.ge() && super.h();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public void c() {
            ((EntityFox)this.a).gg();
            ((EntityFox)this.c).gg();
            super.c();
        }

        @Override
        protected void g() {
            WorldServer worldserver = (WorldServer)this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.fV();
                EntityPlayer entityplayer1 = this.c.fV();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.b(entityplayer.cs());
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.b(entityplayer1.cs());
                }
                entityfox.c_(-24000);
                entityfox.b(this.a.dl(), this.a.dn(), this.a.dr(), 0.0f, 0.0f);
                int experience = this.a.dZ().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.P);
                    CriterionTriggers.o.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.fX();
                this.c.fX();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (this.b.W().b(GameRules.f) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dl(), this.a.dn(), this.a.dr(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityfox));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            if (EntityFox.this.fu()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.P_();
            return entityliving != null && entityliving.bq() && cg.test(entityliving) && EntityFox.this.f((Entity)entityliving) > 36.0 && !EntityFox.this.bT() && !EntityFox.this.gb() && !EntityFox.this.bi;
        }

        @Override
        public void c() {
            EntityFox.this.w(false);
            EntityFox.this.A(false);
        }

        @Override
        public void d() {
            EntityLiving entityliving = EntityFox.this.P_();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.z(true);
                EntityFox.this.y(true);
                EntityFox.this.G().n();
                EntityFox.this.C().a(entityliving, (float)EntityFox.this.W(), (float)EntityFox.this.V());
            } else {
                EntityFox.this.z(false);
                EntityFox.this.y(false);
            }
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.P_();
            if (entityliving != null) {
                EntityFox.this.C().a(entityliving, (float)EntityFox.this.W(), (float)EntityFox.this.V());
                if (EntityFox.this.f((Entity)entityliving) <= 36.0) {
                    EntityFox.this.z(true);
                    EntityFox.this.y(true);
                    EntityFox.this.G().n();
                } else {
                    EntityFox.this.G().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean a() {
            if (!EntityFox.this.ga()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.P_();
            if (entityliving != null && entityliving.bq()) {
                if (entityliving.cB() != entityliving.cA()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.G().a((Entity)entityliving, 0);
                    EntityFox.this.y(false);
                    EntityFox.this.z(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityFox.this.P_();
            if (entityliving != null && entityliving.bq()) {
                double d0 = EntityFox.this.dj().d;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.dy()) >= 15.0f || !EntityFox.this.N) && !EntityFox.this.fS();
            }
            return false;
        }

        @Override
        public boolean I_() {
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.r(true);
            EntityFox.this.x(true);
            EntityFox.this.z(false);
            EntityLiving entityliving = EntityFox.this.P_();
            if (entityliving != null) {
                EntityFox.this.C().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dl() - EntityFox.this.dl(), entityliving.dn() - EntityFox.this.dn(), entityliving.dr() - EntityFox.this.dr()).d();
                EntityFox.this.f(EntityFox.this.dj().b(vec3d.c * 0.8, 0.9, vec3d.e * 0.8));
            }
            EntityFox.this.G().n();
        }

        @Override
        public void d() {
            EntityFox.this.y(false);
            EntityFox.this.co = 0.0f;
            EntityFox.this.cp = 0.0f;
            EntityFox.this.z(false);
            EntityFox.this.x(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.P_();
            if (entityliving != null) {
                EntityFox.this.C().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.fS()) {
                Vec3D vec3d = EntityFox.this.dj();
                if (vec3d.d * vec3d.d < (double)0.03f && EntityFox.this.dy() != 0.0f) {
                    EntityFox.this.e(MathHelper.j(0.2f, EntityFox.this.dy(), 0.0f));
                } else {
                    double d0 = vec3d.h();
                    double d1 = Math.signum(-vec3d.d) * Math.acos(d0 / vec3d.f()) * 57.2957763671875;
                    EntityFox.this.e((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.e((Entity)entityliving) <= 2.0f) {
                EntityFox.this.z(entityliving);
            } else if (EntityFox.this.dy() > 0.0f && EntityFox.this.N && (float)EntityFox.this.dj().d != 0.0f && EntityFox.this.H.a_(EntityFox.this.dg()).a(Blocks.dM)) {
                EntityFox.this.e(60.0f);
                EntityFox.this.i((EntityLiving)null);
                EntityFox.this.A(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.fu() && this.a.P_() == null) {
                if (EntityFox.this.H.X() && EntityFox.this.H.g(this.a.dg())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.dg();
                return EntityFox.this.H.M() && EntityFox.this.H.g(blockposition) && !((WorldServer)EntityFox.this.H).b(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.gg();
            super.c();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving target, double squaredDistance) {
            double d1 = this.a(target);
            if (squaredDistance <= d1 && this.i()) {
                this.h();
                this.a.z(target);
                EntityFox.this.a(SoundEffects.hW, 1.0f, 1.0f);
            }
        }

        @Override
        public void c() {
            EntityFox.this.z(false);
            super.c();
        }

        @Override
        public boolean a() {
            return !EntityFox.this.w() && !EntityFox.this.fu() && !EntityFox.this.bT() && !EntityFox.this.fS() && super.a();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.af.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean a() {
            return EntityFox.this.bj == 0.0f && EntityFox.this.bk == 0.0f && EntityFox.this.bl == 0.0f ? this.k() || EntityFox.this.fu() : false;
        }

        @Override
        public boolean b() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.H.M() && this.h() && !this.i() && !EntityFox.this.az;
        }

        @Override
        public void d() {
            this.d = EntityFox.this.af.a(c);
            EntityFox.this.gg();
        }

        @Override
        public void c() {
            EntityFox.this.w(false);
            EntityFox.this.y(false);
            EntityFox.this.z(false);
            EntityFox.this.r(false);
            EntityFox.this.C(true);
            EntityFox.this.G().n();
            EntityFox.this.D().a(EntityFox.this.dl(), EntityFox.this.dn(), EntityFox.this.dr(), 0.0);
        }
    }

    private class h
    extends PathfinderGoalFollowParent {
        private final EntityFox e;

        public h(EntityFox entityfox, double d0) {
            super(entityfox, d0);
            this.e = entityfox;
        }

        @Override
        public boolean a() {
            return !this.e.ge() && super.a();
        }

        @Override
        public boolean b() {
            return !this.e.ge() && super.b();
        }

        @Override
        public void c() {
            this.e.gg();
            super.c();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void c() {
            EntityFox.this.gg();
            super.c();
        }

        @Override
        public boolean a() {
            return super.a() && this.h();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fu() && !EntityFox.this.w() && !EntityFox.this.ge() && EntityFox.this.P_() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            IBlockData iblockdata = world.a_(pos);
            return iblockdata.a(Blocks.oe) && iblockdata.c(BlockSweetBerryBush.b) >= 2 || CaveVines.a(iblockdata);
        }

        @Override
        public void e() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.af.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.ic, 1.0f, 1.0f);
            }
            super.e();
        }

        protected void o() {
            if (EntityFox.this.H.W().b(GameRules.c)) {
                IBlockData iblockdata = EntityFox.this.H.a_(this.e);
                if (iblockdata.a(Blocks.oe)) {
                    this.b(iblockdata);
                } else if (CaveVines.a(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.a(EntityFox.this, state, EntityFox.this.H, this.e);
        }

        private void b(IBlockData state) {
            int i2 = state.c(BlockSweetBerryBush.b);
            state.a(BlockSweetBerryBush.b, 1);
            if (CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.a(BlockSweetBerryBush.b, 1)).isCancelled()) {
                return;
            }
            int j2 = 1 + EntityFox.this.H.z.a(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.c(EnumItemSlot.a);
            if (itemstack.b()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.vp));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.H, this.e, new ItemStack(Items.vp, j2));
            }
            EntityFox.this.a(SoundEffects.xg, 1.0f, 1.0f);
            EntityFox.this.H.a(this.e, (IBlockData)state.a(BlockSweetBerryBush.b, 1), 2);
        }

        @Override
        public boolean a() {
            return !EntityFox.this.fu() && super.a();
        }

        @Override
        public void c() {
            this.g = 0;
            EntityFox.this.w(false);
            super.c();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.c(EnumItemSlot.a).b()) {
                return false;
            }
            if (EntityFox.this.P_() == null && EntityFox.this.ea() == null) {
                if (!EntityFox.this.gh()) {
                    return false;
                }
                if (EntityFox.this.dZ().a(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.H.a(EntityItem.class, EntityFox.this.cD().c(8.0, 8.0, 8.0), ce);
                return !list.isEmpty() && EntityFox.this.c(EnumItemSlot.a).b();
            }
            return false;
        }

        @Override
        public void e() {
            List<EntityItem> list = EntityFox.this.H.a(EntityItem.class, EntityFox.this.cD().c(8.0, 8.0, 8.0), ce);
            ItemStack itemstack = EntityFox.this.c(EnumItemSlot.a);
            if (itemstack.b() && !list.isEmpty()) {
                EntityFox.this.G().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void c() {
            List<EntityItem> list = EntityFox.this.H.a(EntityItem.class, EntityFox.this.cD().c(8.0, 8.0, 8.0), ce);
            if (!list.isEmpty()) {
                EntityFox.this.G().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class targetType, float range) {
            super(mob, targetType, range);
        }

        @Override
        public boolean a() {
            return super.a() && !EntityFox.this.fS() && !EntityFox.this.gb();
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.fS() && !EntityFox.this.gb();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityFox.this.ea() == null && EntityFox.this.dZ().i() < 0.02f && !EntityFox.this.fu() && EntityFox.this.P_() == null && EntityFox.this.G().l() && !this.i() && !EntityFox.this.fY() && !EntityFox.this.bT();
        }

        @Override
        public boolean b() {
            return this.f > 0;
        }

        @Override
        public void c() {
            this.k();
            this.f = 2 + EntityFox.this.dZ().a(3);
            EntityFox.this.w(true);
            EntityFox.this.G().n();
        }

        @Override
        public void d() {
            EntityFox.this.w(false);
        }

        @Override
        public void e() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.C().a(EntityFox.this.dl() + this.c, EntityFox.this.dp(), EntityFox.this.dr() + this.d, EntityFox.this.W(), EntityFox.this.V());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.dZ().j();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.dZ().a(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, Predicate<EntityLiving> predicate) {
            super(EntityFox.this, oclass, 10, flag, flag1, predicate);
        }

        @Override
        public boolean a() {
            if (this.b > 0 && this.e.dZ().a(this.b) != 0) {
                return false;
            }
            for (UUID uuid : EntityFox.this.gd()) {
                EntityLiving entityliving;
                Entity entity;
                if (uuid == null || !(EntityFox.this.H instanceof WorldServer) || !((entity = ((WorldServer)EntityFox.this.H).a(uuid)) instanceof EntityLiving)) continue;
                this.k = entityliving = (EntityLiving)entity;
                this.j = entityliving.ea();
                int i2 = entityliving.eb();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void c() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.eb();
            }
            EntityFox.this.a(SoundEffects.hU, 1.0f, 1.0f);
            EntityFox.this.B(true);
            EntityFox.this.gf();
            super.c();
        }
    }

    public static enum Type implements INamable
    {
        a(0, "red"),
        b(1, "snow");

        public static final INamable.a<Type> c;
        private static final IntFunction<Type> d;
        private final int e;
        private final String f;

        private Type(int i2, String s2) {
            this.e = i2;
            this.f = s2;
        }

        @Override
        public String c() {
            return this.f;
        }

        public int a() {
            return this.e;
        }

        public static Type a(String name) {
            return c.a(name, a);
        }

        public static Type a(int id) {
            return d.apply(id);
        }

        public static Type a(Holder<BiomeBase> biome) {
            return biome.a(BiomeTags.ap) ? b : a;
        }

        static {
            c = INamable.a(Type::values);
            d = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type type) {
            super(false);
            this.a = type;
        }
    }

    public class c
    implements Predicate<EntityLiving> {
        public boolean a(EntityLiving entityliving) {
            return entityliving instanceof EntityFox ? false : (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster) ? (entityliving instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entityliving).q() : (entityliving instanceof EntityHuman && (entityliving.F_() || ((EntityHuman)entityliving).f()) ? false : (EntityFox.this.c(entityliving.cs()) ? false : !entityliving.fu() && !entityliving.bR()))) : true);
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = BlockPosition.a(EntityFox.this.dl(), EntityFox.this.cD().e, EntityFox.this.dr());
            return !EntityFox.this.H.g(blockposition) && EntityFox.this.f(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !EntityFox.this.H.a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cD().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

