/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityParrot
extends EntityPerchable
implements VariantHolder<Variant>,
EntityBird {
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> ca = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient entityinsentient) {
            return entityinsentient != null && cd.containsKey(entityinsentient.ae());
        }
    };
    private static final Item cb = Items.ra;
    private static final Set<Item> cc = Sets.newHashSet((Object[])new Item[]{Items.oD, Items.rg, Items.rf, Items.um, Items.uk});
    static final Map<EntityTypes<?>, SoundEffect> cd = SystemUtils.a(Maps.newHashMap(), (T hashmap) -> {
        hashmap.put(EntityTypes.i, SoundEffects.qK);
        hashmap.put(EntityTypes.n, SoundEffects.rg);
        hashmap.put(EntityTypes.u, SoundEffects.qL);
        hashmap.put(EntityTypes.y, SoundEffects.qM);
        hashmap.put(EntityTypes.A, SoundEffects.qN);
        hashmap.put(EntityTypes.C, SoundEffects.qO);
        hashmap.put(EntityTypes.F, SoundEffects.qP);
        hashmap.put(EntityTypes.G, SoundEffects.qQ);
        hashmap.put(EntityTypes.Q, SoundEffects.qR);
        hashmap.put(EntityTypes.V, SoundEffects.qS);
        hashmap.put(EntityTypes.W, SoundEffects.qT);
        hashmap.put(EntityTypes.Z, SoundEffects.qU);
        hashmap.put(EntityTypes.aa, SoundEffects.qV);
        hashmap.put(EntityTypes.al, SoundEffects.qW);
        hashmap.put(EntityTypes.au, SoundEffects.qX);
        hashmap.put(EntityTypes.aw, SoundEffects.qY);
        hashmap.put(EntityTypes.ax, SoundEffects.qZ);
        hashmap.put(EntityTypes.ay, SoundEffects.ra);
        hashmap.put(EntityTypes.aD, SoundEffects.rb);
        hashmap.put(EntityTypes.aG, SoundEffects.rc);
        hashmap.put(EntityTypes.aI, SoundEffects.rd);
        hashmap.put(EntityTypes.aJ, SoundEffects.re);
        hashmap.put(EntityTypes.aL, SoundEffects.rf);
        hashmap.put(EntityTypes.aS, SoundEffects.rg);
        hashmap.put(EntityTypes.aU, SoundEffects.rh);
        hashmap.put(EntityTypes.be, SoundEffects.ri);
        hashmap.put(EntityTypes.bg, SoundEffects.rj);
        hashmap.put(EntityTypes.bi, SoundEffects.rk);
        hashmap.put(EntityTypes.bj, SoundEffects.rl);
        hashmap.put(EntityTypes.bk, SoundEffects.rm);
        hashmap.put(EntityTypes.bl, SoundEffects.rn);
        hashmap.put(EntityTypes.bo, SoundEffects.ro);
        hashmap.put(EntityTypes.bp, SoundEffects.rp);
        hashmap.put(EntityTypes.br, SoundEffects.rq);
    });
    public float bV;
    public float bW;
    public float bX;
    public float bY;
    private float ce = 1.0f;
    private float cf = 1.0f;
    private boolean cg;
    @Nullable
    private BlockPosition ch;

    public EntityParrot(EntityTypes<? extends EntityParrot> type, World world) {
        super((EntityTypes<? extends EntityPerchable>)type, world);
        this.bK = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a((Variant)SystemUtils.a((Object[])Variant.values(), world.r_()));
        if (entityData == null) {
            entityData = new EntityAgeable.a(false);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean y_() {
        return false;
    }

    @Override
    protected void x() {
        this.bN.a(0, new PathfinderGoalPanic(this, 1.25));
        this.bN.a(0, new PathfinderGoalFloat(this));
        this.bN.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(2, new PathfinderGoalSit(this));
        this.bN.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f, true));
        this.bN.a(2, new a(this, 1.0));
        this.bN.a(3, new PathfinderGoalPerch(this));
        this.bN.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder fY() {
        return EntityInsentient.y().a(GenericAttributes.a, 6.0).a(GenericAttributes.e, 0.4f).a(GenericAttributes.d, 0.2f);
    }

    @Override
    protected NavigationAbstract a(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.b(false);
        navigationflying.a(true);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.6f;
    }

    @Override
    public void b_() {
        if (this.ch == null || !this.ch.a(this.de(), 3.46) || !this.H.a_(this.ch).a(Blocks.dS)) {
            this.cg = false;
            this.ch = null;
        }
        if (this.H.z.a(400) == 0) {
            EntityParrot.a(this.H, this);
        }
        super.b_();
        this.gc();
    }

    @Override
    public void a(BlockPosition songPosition, boolean playing) {
        this.ch = songPosition;
        this.cg = playing;
    }

    public boolean fZ() {
        return this.cg;
    }

    private void gc() {
        this.bY = this.bV;
        this.bX = this.bW;
        this.bW += (float)(!this.N && !this.bL() ? 4 : -1) * 0.3f;
        this.bW = MathHelper.a(this.bW, 0.0f, 1.0f);
        if (!this.N && this.ce < 1.0f) {
            this.ce = 1.0f;
        }
        this.ce *= 0.9f;
        Vec3D vec3d = this.dj();
        if (!this.N && vec3d.d < 0.0) {
            this.f(vec3d.d(1.0, 0.6, 1.0));
        }
        this.bV += this.ce * 2.0f;
    }

    public static boolean a(World world, Entity parrot) {
        if (parrot.bq() && !parrot.aO() && world.z.a(2) == 0) {
            EntityInsentient entityinsentient;
            List<EntityInsentient> list = world.a(EntityInsentient.class, parrot.cD().g(20.0), ca);
            if (!list.isEmpty() && !(entityinsentient = list.get(world.z.a(list.size()))).aO()) {
                SoundEffect soundeffect = EntityParrot.b(entityinsentient.ae());
                world.a((EntityHuman)null, parrot.dl(), parrot.dn(), parrot.dr(), soundeffect, parrot.cX(), 0.7f, EntityParrot.a(world.z));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!this.q() && cc.contains(itemstack.c())) {
            if (!player.fK().d) {
                itemstack.h(1);
            }
            if (!this.aO()) {
                this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), SoundEffects.qH, this.cX(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
            }
            if (!this.H.B) {
                if (this.af.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                    this.e(player);
                    this.H.a((Entity)this, (byte)7);
                } else {
                    this.H.a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a(this.H.B);
        }
        if (itemstack.a(cb)) {
            if (!player.fK().d) {
                itemstack.h(1);
            }
            this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
            if (player.f() || !this.cm()) {
                this.a(this.dG().a(player), Float.MAX_VALUE);
            }
            return EnumInteractionResult.a(this.H.B);
        }
        if (!this.gf() && this.q() && this.m(player)) {
            if (!this.H.B) {
                this.z(!this.fS());
            }
            return EnumInteractionResult.a(this.H.B);
        }
        return super.b(player, hand);
    }

    @Override
    public boolean m(ItemStack stack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bN) && EntityParrot.a(world, pos);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    public boolean a(EntityAnimal other) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    @Override
    public boolean z(Entity target) {
        return target.a(this.dG().b(this), 3.0f);
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return EntityParrot.a(this.H, this.H.z);
    }

    public static SoundEffect a(World world, RandomSource random) {
        if (world.ah() != EnumDifficulty.a && random.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(cd.keySet());
            return EntityParrot.b((EntityTypes)list.get(random.a(list.size())));
        }
        return SoundEffects.qF;
    }

    private static SoundEffect b(EntityTypes<?> imitate) {
        return cd.getOrDefault(imitate, SoundEffects.qF);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.qJ;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.qG;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.rr, 0.15f, 1.0f);
    }

    @Override
    protected boolean aN() {
        return this.Z > this.cf;
    }

    @Override
    protected void aM() {
        this.a(SoundEffects.qI, 0.15f, 1.0f);
        this.cf = this.Z + this.bW / 2.0f;
    }

    @Override
    public float eO() {
        return EntityParrot.a(this.af);
    }

    public static float a(RandomSource random) {
        return (random.i() - random.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory cX() {
        return SoundCategory.g;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return super.isCollidable(ignoreClimbing);
    }

    @Override
    protected void A(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.A(entity);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.H.B) {
            // empty if block
        }
        return super.a(source, amount);
    }

    public Variant ga() {
        return Variant.a(this.am.a(bZ));
    }

    @Override
    public void a(Variant variant) {
        this.am.b(bZ, variant.h);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bZ, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.ga().h);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Variant.a(nbt.h("Variant")));
    }

    @Override
    public boolean gf() {
        return !this.N;
    }

    @Override
    public Vec3D cF() {
        return new Vec3D(0.0, 0.5f * this.cE(), this.dc() * 0.4f);
    }

    public static enum Variant implements INamable
    {
        a(0, "red_blue"),
        b(1, "blue"),
        c(2, "green"),
        d(3, "yellow_blue"),
        e(4, "gray");

        public static final Codec<Variant> f;
        private static final IntFunction<Variant> g;
        final int h;
        private final String i;

        private Variant(int i2, String s2) {
            this.h = i2;
            this.i = s2;
        }

        public int a() {
            return this.h;
        }

        public static Variant a(int index) {
            return g.apply(index);
        }

        @Override
        public String c() {
            return this.i;
        }

        static {
            f = INamable.a(Variant::values);
            g = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    private static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature mob, double speed) {
            super(mob, speed);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3d = null;
            if (this.b.aT()) {
                vec3d = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.dZ().i() >= this.j) {
                vec3d = this.k();
            }
            return vec3d == null ? super.h() : vec3d;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockposition = this.b.dg();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
            Iterable<BlockPosition> iterable = BlockPosition.b(MathHelper.a(this.b.dl() - 3.0), MathHelper.a(this.b.dn() - 6.0), MathHelper.a(this.b.dr() - 3.0), MathHelper.a(this.b.dl() + 3.0), MathHelper.a(this.b.dn() + 6.0), MathHelper.a(this.b.dr() + 3.0));
            for (BlockPosition blockposition1 : iterable) {
                IBlockData iblockdata;
                boolean flag;
                if (blockposition.equals(blockposition1) || !(flag = (iblockdata = this.b.H.a_(blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition1, EnumDirection.a))).b() instanceof BlockLeaves || iblockdata.a(TagsBlock.s)) || !this.b.H.w(blockposition1) || !this.b.H.w(blockposition_mutableblockposition.a((BaseBlockPosition)blockposition1, EnumDirection.b))) continue;
                return Vec3D.c(blockposition1);
            }
            return null;
        }
    }
}

