/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityPig
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final DataWatcherObject<Boolean> bS = DataWatcher.a(EntityPig.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bT = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final RecipeItemStack bV = RecipeItemStack.a(Items.th, Items.ti, Items.ul);
    public final SaddleStorage bW;

    public EntityPig(EntityTypes<? extends EntityPig> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bW = new SaddleStorage(this.am, bT, bS);
    }

    @Override
    protected void x() {
        this.bN.a(0, new PathfinderGoalFloat(this));
        this.bN.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bN.a(3, new PathfinderGoalBreed(this, 1.0));
        this.bN.a(4, new PathfinderGoalTempt(this, 1.2, RecipeItemStack.a(Items.nb), false));
        this.bN.a(4, new PathfinderGoalTempt(this, 1.2, bV, false));
        this.bN.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.bN.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bN.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bN.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving cK() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.i() && (entity = this.cN()) instanceof EntityHuman && ((entityhuman = (EntityHuman)entity).eK().a(Items.nb) || entityhuman.eL().a(Items.nb))) {
            return entityhuman;
        }
        return null;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bT.equals(data) && this.H.B) {
            this.bW.a();
        }
        super.a(data);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bS, false);
        this.am.a(bT, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.bW.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.bW.b(nbt);
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.ry;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.rA;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.rz;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.rC, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.m(player.b(hand));
        if (!flag && this.i() && !this.bM() && !player.fz()) {
            if (!this.H.B) {
                player.k(this);
            }
            return EnumInteractionResult.a(this.H.B);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.mV) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.d;
        }
        return enuminteractionresult;
    }

    @Override
    public boolean g() {
        return this.bq() && !this.y_();
    }

    @Override
    protected void er() {
        super.er();
        if (this.i()) {
            this.a((IMaterial)Items.mV);
        }
    }

    @Override
    public boolean i() {
        return this.bW.d();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.bW.a(true);
        if (sound != null) {
            this.H.a((EntityHuman)null, this, SoundEffects.rB, sound, 0.5f, 1.0f);
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cB();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dg();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EntityPose entitypose : passenger.fr()) {
            AxisAlignedBB axisalignedbb = passenger.g(entitypose);
            int[][] aint1 = aint;
            int i2 = aint.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec3d;
                int[] aint2 = aint1[j2];
                blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v(), blockposition.w() + aint2[1]);
                double d0 = this.H.i(blockposition_mutableblockposition);
                if (!DismountUtil.a(d0) || !DismountUtil.a(this.H, passenger, axisalignedbb.c(vec3d = Vec3D.a(blockposition_mutableblockposition, d0)))) continue;
                passenger.b(entitypose);
                return vec3d;
            }
        }
        return super.b(passenger);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.ah() != EnumDifficulty.a) {
            EntityPigZombie entitypigzombie = EntityTypes.bs.a(world);
            if (entitypigzombie != null) {
                entitypigzombie.a(EnumItemSlot.a, new ItemStack(Items.od));
                entitypigzombie.b(this.dl(), this.dn(), this.dr(), this.dw(), this.dy());
                entitypigzombie.t(this.fK());
                entitypigzombie.a(this.y_());
                if (this.aa()) {
                    entitypigzombie.b(this.ab());
                    entitypigzombie.n(this.cx());
                }
                entitypigzombie.fz();
                if (CraftEventFactory.callPigZapEvent(this, lightning, entitypigzombie).isCancelled()) {
                    return;
                }
                world.addFreshEntity(entitypigzombie, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                this.ai();
            } else {
                super.a(world, lightning);
            }
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    protected void a(EntityLiving controllingPassenger, Vec3D movementInput) {
        super.a(controllingPassenger, movementInput);
        this.a(controllingPassenger.dw(), controllingPassenger.dy() * 0.5f);
        this.aT = this.aV = this.dw();
        this.L = this.aV;
        this.bW.b();
    }

    @Override
    protected Vec3D b(EntityLiving controllingPassenger, Vec3D movementInput) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float g(EntityLiving controllingPassenger) {
        return (float)(this.b(GenericAttributes.d) * 0.225 * (double)this.bW.c());
    }

    @Override
    public boolean a() {
        return this.bW.a(this.dZ());
    }

    @Nullable
    public EntityPig b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.av.a(world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return bV.a(stack);
    }

    @Override
    public Vec3D cF() {
        return new Vec3D(0.0, 0.6f * this.cE(), this.dc() * 0.4f);
    }
}

