/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bS = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.k);
    private static final float bT = 6.0f;
    private float bV;
    private float bW;
    private int bX;
    private static final UniformInt bY = TimeRange.a(20, 39);
    private int bZ;
    @Nullable
    private UUID ca;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    @Nullable
    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.az.a(world);
    }

    @Override
    @Override
    public boolean m(ItemStack stack) {
        return false;
    }

    @Override
    @Override
    protected void x() {
        super.x();
        this.bN.a(0, new PathfinderGoalFloat(this));
        this.bN.a(1, new c());
        this.bN.a(1, new d());
        this.bN.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bN.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.bN.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bN.a(7, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new b());
        this.bO.a(2, new a());
        this.bO.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bO.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.bO.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.a, 30.0).a(GenericAttributes.b, 20.0).a(GenericAttributes.d, 0.25).a(GenericAttributes.f, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        Holder<BiomeBase> holder = world.v(pos);
        if (holder.a(BiomeTags.am)) {
            return EntityPolarBear.a(world, pos) && world.a_(pos.d()).a(TagsBlock.bO);
        }
        return EntityPolarBear.b(type, world, spawnReason, pos, random);
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(this.H, nbt);
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.c(nbt);
    }

    @Override
    @Override
    public void c() {
        this.a(bY.a(this.af));
    }

    @Override
    @Override
    public void a(int angerTime) {
        this.bZ = angerTime;
    }

    @Override
    @Override
    public int a() {
        return this.bZ;
    }

    @Override
    @Override
    public void a(@Nullable UUID angryAt) {
        this.ca = angryAt;
    }

    @Override
    @Nullable
    @Override
    public UUID b() {
        return this.ca;
    }

    @Override
    @Override
    protected SoundEffect s() {
        if (this.y_()) {
            return SoundEffects.su;
        }
        return SoundEffects.st;
    }

    @Override
    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.sw;
    }

    @Override
    @Override
    public SoundEffect x_() {
        return SoundEffects.sv;
    }

    @Override
    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.sx, 0.15f, 1.0f);
    }

    protected void r() {
        if (this.bX <= 0) {
            this.a(SoundEffects.sy, 1.0f, this.eO());
            this.bX = 40;
        }
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
        this.am.a(bS, false);
    }

    @Override
    @Override
    public void l() {
        super.l();
        if (this.H.B) {
            if (this.bW != this.bV) {
                this.c_();
            }
            this.bV = this.bW;
            this.bW = this.w() ? MathHelper.a(this.bW + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.bW - 1.0f, 0.0f, 6.0f);
        }
        if (this.bX > 0) {
            --this.bX;
        }
        if (!this.H.B) {
            this.a((WorldServer)this.H, true);
        }
    }

    @Override
    @Override
    public EntitySize a(EntityPose pose) {
        if (this.bW > 0.0f) {
            float f2 = this.bW / 6.0f;
            float g2 = 1.0f + f2;
            return super.a(pose).a(1.0f, g2);
        }
        return super.a(pose);
    }

    @Override
    @Override
    public boolean z(Entity target) {
        boolean bl = target.a(this.dG().b(this), (float)((int)this.b(GenericAttributes.f)));
        if (bl) {
            this.a((EntityLiving)this, target);
        }
        return bl;
    }

    public boolean w() {
        return this.am.a(bS);
    }

    public void w(boolean warning) {
        this.am.b(bS, warning);
    }

    public float C(float tickDelta) {
        return MathHelper.i(tickDelta, this.bV, this.bW) / 6.0f;
    }

    @Override
    @Override
    protected float eU() {
        return 0.98f;
    }

    @Override
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        @Override
        protected void a(EntityLiving target, double squaredDistance) {
            double d2 = this.a(target);
            if (squaredDistance <= d2 && this.i()) {
                this.h();
                this.a.z(target);
                EntityPolarBear.this.w(false);
            } else if (squaredDistance <= d2 * 2.0) {
                if (this.i()) {
                    EntityPolarBear.this.w(false);
                    this.h();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.w(true);
                    EntityPolarBear.this.r();
                }
            } else {
                this.h();
                EntityPolarBear.this.w(false);
            }
        }

        @Override
        @Override
        public void d() {
            EntityPolarBear.this.w(false);
            super.d();
        }

        @Override
        @Override
        protected double a(EntityLiving entity) {
            return 4.0f + entity.dc();
        }
    }

    class d
    extends PathfinderGoalPanic {
        public d() {
            super(EntityPolarBear.this, 2.0);
        }

        @Override
        @Override
        protected boolean h() {
            return this.b.ea() != null && this.b.y_() || this.b.bK();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        @Override
        public void c() {
            super.c();
            if (EntityPolarBear.this.y_()) {
                this.h();
                this.d();
            }
        }

        @Override
        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPolarBear && !mob.y_()) {
                super.a(mob, target);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        @Override
        public boolean a() {
            if (EntityPolarBear.this.y_()) {
                return false;
            }
            if (super.a()) {
                List<EntityPolarBear> list = EntityPolarBear.this.H.a(EntityPolarBear.class, EntityPolarBear.this.cD().c(8.0, 4.0, 8.0));
                for (EntityPolarBear polarBear : list) {
                    if (!polarBear.y_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

