/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte c = 16;
    private static final float d = 1.7f;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
    }

    @Override
    protected void x() {
        this.bN.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.bN.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.bN.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bN.a(4, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, entityliving -> entityliving instanceof IMonster));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.a, 4.0).a(GenericAttributes.d, 0.2f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, (byte)16);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Pumpkin", this.r());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("Pumpkin")) {
            this.w(nbt.q("Pumpkin"));
        }
    }

    @Override
    public boolean eX() {
        return true;
    }

    @Override
    public void b_() {
        super.b_();
        if (!this.H.B) {
            if (this.H.v(this.dg()).a(BiomeTags.ac)) {
                this.a(this.dG().melting, 1.0f);
            }
            if (!this.H.W().b(GameRules.c)) {
                return;
            }
            IBlockData iblockdata = Blocks.dM.o();
            for (int i2 = 0; i2 < 4; ++i2) {
                int l2;
                int k2;
                int j2 = MathHelper.a(this.dl() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockposition = new BlockPosition(j2, k2 = MathHelper.a(this.dn()), l2 = MathHelper.a(this.dr() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f)));
                if (!this.H.a_(blockposition).h() || !iblockdata.a((IWorldReader)this.H, blockposition) || !CraftEventFactory.handleBlockFormEvent(this.H, blockposition, iblockdata, this)) continue;
                this.H.a(GameEvent.i, blockposition, GameEvent.a.a(this, iblockdata));
            }
        }
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        EntitySnowball entitysnowball = new EntitySnowball(this.H, this);
        double d0 = target.dp() - (double)1.1f;
        double d1 = target.dl() - this.dl();
        double d2 = d0 - entitysnowball.dn();
        double d3 = target.dr() - this.dr();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        entitysnowball.c(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.a(SoundEffects.wA, 1.0f, 0.4f / (this.dZ().i() * 0.4f + 0.8f));
        this.H.b(entitysnowball);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 1.7f;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.rc) && this.a()) {
            if (!CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand)) {
                return EnumInteractionResult.d;
            }
            this.a(SoundCategory.h);
            this.a(GameEvent.Q, (Entity)player);
            if (!this.H.B) {
                itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
            }
            return EnumInteractionResult.a(this.H.B);
        }
        return EnumInteractionResult.d;
    }

    @Override
    public void a(SoundCategory shearedSoundCategory) {
        this.H.a((EntityHuman)null, this, SoundEffects.wB, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.H.k_()) {
            this.w(false);
            this.forceDrops = true;
            this.a(new ItemStack(Items.eN), 1.7f);
            this.forceDrops = false;
        }
    }

    @Override
    public boolean a() {
        return this.bq() && this.r();
    }

    public boolean r() {
        return (this.am.a(b) & 0x10) != 0;
    }

    public void w(boolean hasPumpkin) {
        byte b0 = this.am.a(b);
        if (hasPumpkin) {
            this.am.b(b, (byte)(b0 | 0x10));
        } else {
            this.am.b(b, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return SoundEffects.wx;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.wz;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.wy;
    }

    @Override
    public Vec3D cF() {
        return new Vec3D(0.0, 0.75f * this.cE(), this.dc() * 0.4f);
    }
}

