/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import io.papermc.paper.util.MCUtil;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Turtle;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<BlockPosition> bV = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.n);
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bX = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<BlockPosition> bY = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.n);
    private static final DataWatcherObject<Boolean> bZ = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    public static final RecipeItemStack bS = RecipeItemStack.a(Blocks.bv.k());
    int cb;
    public static final Predicate<EntityLiving> bT = entityliving -> entityliving.y_() && !entityliving.aT();

    public EntityTurtle(EntityTypes<? extends EntityTurtle> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
        this.a(PathType.t, -1.0f);
        this.a(PathType.s, -1.0f);
        this.a(PathType.r, -1.0f);
        this.bK = new e(this);
        this.v(1.0f);
    }

    public void g(BlockPosition pos) {
        this.am.b(bV, pos.i());
    }

    public BlockPosition fS() {
        return this.am.a(bV);
    }

    void h(BlockPosition pos) {
        this.am.b(bY, pos);
    }

    BlockPosition fY() {
        return this.am.a(bY);
    }

    public boolean q() {
        return this.am.a(bW);
    }

    public void w(boolean hasEgg) {
        this.am.b(bW, hasEgg);
    }

    public boolean r() {
        return this.am.a(bX);
    }

    void x(boolean diggingSand) {
        this.cb = diggingSand ? 1 : 0;
        this.am.b(bX, diggingSand);
    }

    public boolean fZ() {
        return this.am.a(bZ);
    }

    public void y(boolean landBound) {
        this.am.b(bZ, landBound);
    }

    public boolean ga() {
        return this.am.a(ca);
    }

    public void z(boolean traveling) {
        this.am.b(ca, traveling);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bV, BlockPosition.b);
        this.am.a(bW, false);
        this.am.a(bY, BlockPosition.b);
        this.am.a(bZ, false);
        this.am.a(ca, false);
        this.am.a(bX, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("HomePosX", this.fS().u());
        nbt.a("HomePosY", this.fS().v());
        nbt.a("HomePosZ", this.fS().w());
        nbt.a("HasEgg", this.q());
        nbt.a("TravelPosX", this.fY().u());
        nbt.a("TravelPosY", this.fY().v());
        nbt.a("TravelPosZ", this.fY().w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2 = nbt.h("HomePosX");
        int j2 = nbt.h("HomePosY");
        int k2 = nbt.h("HomePosZ");
        this.g(new BlockPosition(i2, j2, k2));
        super.a(nbt);
        this.w(nbt.q("HasEgg"));
        int l2 = nbt.h("TravelPosX");
        int i1 = nbt.h("TravelPosY");
        int j1 = nbt.h("TravelPosZ");
        this.h(new BlockPosition(l2, i1, j1));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.g(this.dg());
        this.h(BlockPosition.b);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static boolean c(EntityTypes<EntityTurtle> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return pos.v() < world.m_() + 4 && BlockTurtleEgg.a(world, pos) && EntityTurtle.a(world, pos);
    }

    @Override
    protected void x() {
        this.bN.a(0, new f(this, 1.2));
        this.bN.a(1, new a(this, 1.0));
        this.bN.a(1, new d(this, 1.0));
        this.bN.a(2, new PathfinderGoalTempt(this, 1.1, bS, false));
        this.bN.a(3, new c(this, 1.0));
        this.bN.a(4, new b(this, 1.0));
        this.bN.a(7, new i(this, 1.0));
        this.bN.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder w() {
        return EntityInsentient.y().a(GenericAttributes.a, 30.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    public boolean cv() {
        return false;
    }

    @Override
    public boolean dK() {
        return true;
    }

    @Override
    public EnumMonsterType eJ() {
        return EnumMonsterType.e;
    }

    @Override
    public int K() {
        return 200;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return !this.aT() && this.N && !this.y_() ? SoundEffects.xJ : super.s();
    }

    @Override
    protected void i(float volume) {
        super.i(volume * 1.5f);
    }

    @Override
    protected SoundEffect aI() {
        return SoundEffects.xU;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return this.y_() ? SoundEffects.xQ : SoundEffects.xP;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return this.y_() ? SoundEffects.xL : SoundEffects.xK;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffect soundeffect = this.y_() ? SoundEffects.xT : SoundEffects.xS;
        this.a(soundeffect, 0.15f, 1.0f);
    }

    @Override
    public boolean fT() {
        return super.fT() && !this.q();
    }

    @Override
    protected float aH() {
        return this.Y + 0.15f;
    }

    @Override
    public float dS() {
        return this.y_() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new g(this, world);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.bd.a(world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(Blocks.bv.k());
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return !this.fZ() && world.b_(pos).a(TagsFluid.a) ? 10.0f : (BlockTurtleEgg.a(world, pos) ? 10.0f : world.y(pos));
    }

    @Override
    public void b_() {
        BlockPosition blockposition;
        super.b_();
        if (this.bq() && this.r() && this.cb >= 1 && this.cb % 5 == 0 && BlockTurtleEgg.a(this.H, blockposition = this.dg())) {
            this.H.c(2001, blockposition, Block.i(this.H.a_(blockposition.d())));
        }
    }

    @Override
    protected void m() {
        super.m();
        if (!this.y_() && this.H.W().b(GameRules.f)) {
            this.forceDrops = true;
            this.a(Items.nz, 1);
            this.forceDrops = false;
        }
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.cT() && this.aT()) {
            this.a(0.1f, movementInput);
            this.a(EnumMoveType.a, this.dj());
            this.f(this.dj().a(0.9));
            if (!(this.P_() != null || this.fZ() && this.fS().a(this.de(), 20.0))) {
                this.f(this.dj().b(0.0, -0.005, 0.0));
            }
        } else {
            super.h(movementInput);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return false;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        CraftEventFactory.entityDamage = lightning;
        this.a(this.dG().b(), Float.MAX_VALUE);
        CraftEventFactory.entityDamage = null;
    }

    private static class e
    extends ControllerMove {
        private final EntityTurtle l;

        e(EntityTurtle turtle) {
            super(turtle);
            this.l = turtle;
        }

        private void g() {
            if (this.l.aT()) {
                this.l.f(this.l.dj().b(0.0, 0.005, 0.0));
                if (!this.l.fS().a(this.l.de(), 16.0)) {
                    this.l.h(Math.max(this.l.eW() / 2.0f, 0.08f));
                }
                if (this.l.y_()) {
                    this.l.h(Math.max(this.l.eW() / 3.0f, 0.06f));
                }
            } else if (this.l.N) {
                this.l.h(Math.max(this.l.eW() / 2.0f, 0.06f));
            }
        }

        @Override
        public void a() {
            this.g();
            if (this.k == ControllerMove.Operation.b && !this.l.G().l()) {
                double d2;
                double d1;
                double d0 = this.e - this.l.dl();
                double d3 = Math.sqrt(d0 * d0 + (d1 = this.f - this.l.dn()) * d1 + (d2 = this.g - this.l.dr()) * d2);
                if (d3 < (double)1.0E-5f) {
                    this.d.h(0.0f);
                } else {
                    d1 /= d3;
                    float f2 = (float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f;
                    this.l.f(this.a(this.l.dw(), f2, 90.0f));
                    this.l.aT = this.l.dw();
                    float f1 = (float)(this.h * this.l.b(GenericAttributes.d));
                    this.l.h(MathHelper.i(0.125f, this.l.eW(), f1));
                    this.l.f(this.l.dj().b(0.0, (double)this.l.eW() * d1 * 0.1, 0.0));
                }
            } else {
                this.l.h(0.0f);
            }
        }
    }

    private static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle turtle, double speed) {
            super(turtle, speed);
        }

        @Override
        public boolean a() {
            if (!this.h()) {
                return false;
            }
            BlockPosition blockposition = this.a(this.b.H, this.b, 7);
            if (blockposition != null) {
                this.d = blockposition.u();
                this.e = blockposition.v();
                this.f = blockposition.w();
                return true;
            }
            return this.i();
        }
    }

    private static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle d;

        a(EntityTurtle turtle, double speed) {
            super(turtle, speed);
            this.d = turtle;
        }

        @Override
        public boolean a() {
            return super.a() && !this.d.q();
        }

        @Override
        protected void g() {
            EntityPlayer entityplayer = this.a.fV();
            if (entityplayer == null && this.c.fV() != null) {
                entityplayer = this.c.fV();
            }
            RandomSource randomsource = this.a.dZ();
            int experience = randomsource.a(7) + 1;
            EntityFertilizeEggEvent event = new EntityFertilizeEggEvent((LivingEntity)this.d.getBukkitEntity(), (LivingEntity)this.c.getBukkitEntity(), (Player)(entityplayer == null ? null : entityplayer.getBukkitEntity()), this.d.breedItem == null ? null : CraftItemStack.asCraftMirror(this.d.breedItem).clone(), experience);
            if (!event.callEvent()) {
                this.a.fX();
                this.c.fX();
                return;
            }
            experience = event.getExperience();
            if (entityplayer != null) {
                entityplayer.a(StatisticList.P);
                CriterionTriggers.o.a(entityplayer, this.a, this.c, null);
            }
            this.d.w(true);
            this.a.c_(6000);
            this.c.c_(6000);
            this.a.fX();
            this.c.fX();
            if (experience > 0 && this.b.W().b(GameRules.f)) {
                this.b.b(new EntityExperienceOrb(this.b, this.a.dl(), this.a.dn(), this.a.dr(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer));
            }
        }
    }

    private static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle g;

        d(EntityTurtle turtle, double speed) {
            super(turtle, speed, 16);
            this.g = turtle;
        }

        @Override
        public boolean a() {
            return this.g.q() && this.g.fS().a(this.g.de(), 9.0) ? super.a() : false;
        }

        @Override
        public boolean b() {
            return super.b() && this.g.q() && this.g.fS().a(this.g.de(), 9.0);
        }

        @Override
        public void e() {
            super.e();
            BlockPosition blockposition = this.g.dg();
            if (!this.g.aT() && this.m()) {
                if (this.g.cb < 1) {
                    this.g.x(new TurtleStartDiggingEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.H, this.getTargetPosition())).callEvent());
                } else if (this.g.cb > this.a(200)) {
                    World world = this.g.H;
                    int eggCount = this.g.af.a(4) + 1;
                    TurtleLayEggEvent layEggEvent = new TurtleLayEggEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.H, this.e.c()), eggCount);
                    if (layEggEvent.callEvent() && !CraftEventFactory.callEntityChangeBlockEvent(this.g, this.e.c(), (IBlockData)Blocks.mc.o().a(BlockTurtleEgg.e, layEggEvent.getEggCount())).isCancelled()) {
                        world.a((EntityHuman)null, blockposition, SoundEffects.xR, SoundCategory.e, 0.3f, 0.9f + world.z.i() * 0.2f);
                        BlockPosition blockposition1 = this.e.c();
                        IBlockData iblockdata = (IBlockData)Blocks.mc.o().a(BlockTurtleEgg.e, layEggEvent.getEggCount());
                        world.a(blockposition1, iblockdata, 3);
                        world.a(GameEvent.i, blockposition1, GameEvent.a.a(this.g, iblockdata));
                    }
                    this.g.w(false);
                    this.g.x(false);
                    this.g.r(600);
                }
                if (this.g.r()) {
                    ++this.g.cb;
                }
            }
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return !world.w(pos.c()) ? false : BlockTurtleEgg.b(world, pos);
        }
    }

    private static class c
    extends PathfinderGoalGotoTarget {
        private static final int g = 1200;
        private final EntityTurtle h;

        c(EntityTurtle turtle, double speed) {
            super(turtle, turtle.y_() ? 2.0 : speed, 24);
            this.h = turtle;
            this.f = -1;
        }

        @Override
        public boolean b() {
            return !this.h.aT() && this.d <= 1200 && this.a(this.h.H, this.e);
        }

        @Override
        public boolean a() {
            return this.h.y_() && !this.h.aT() ? super.a() : (!this.h.fZ() && !this.h.aT() && !this.h.q() ? super.a() : false);
        }

        @Override
        public boolean l() {
            return this.d % 160 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.G);
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;
        private int d;
        private static final int e = 600;

        b(EntityTurtle turtle, double speed) {
            this.a = turtle;
            this.b = speed;
        }

        @Override
        public boolean a() {
            return this.a.y_() ? false : (this.a.q() || this.a.dZ().a(net.minecraft.world.entity.animal.EntityTurtle$b.b(700)) == 0 && !this.a.fS().a(this.a.de(), 64.0)) && new TurtleGoHomeEvent((Turtle)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void c() {
            this.a.y(true);
            this.c = false;
            this.d = 0;
        }

        @Override
        public void d() {
            this.a.y(false);
        }

        @Override
        public boolean b() {
            return !this.a.fS().a(this.a.de(), 7.0) && !this.c && this.d <= this.a(600);
        }

        @Override
        public void e() {
            BlockPosition blockposition = this.a.fS();
            boolean flag = blockposition.a(this.a.de(), 16.0);
            if (flag) {
                ++this.d;
            }
            if (this.a.G().l()) {
                Vec3D vec3d = Vec3D.c(blockposition);
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 != null && !flag && !this.a.H.a_(BlockPosition.a(vec3d1)).a(Blocks.G)) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 5, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.c = true;
                    return;
                }
                this.a.G().a(vec3d1.c, vec3d1.d, vec3d1.e, this.b);
            }
        }
    }

    private static class i
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;

        i(EntityTurtle turtle, double speed) {
            this.a = turtle;
            this.b = speed;
        }

        @Override
        public boolean a() {
            return !this.a.fZ() && !this.a.q() && this.a.aT();
        }

        @Override
        public void c() {
            boolean flag = true;
            boolean flag1 = true;
            RandomSource randomsource = this.a.af;
            int i2 = randomsource.a(1025) - 512;
            int j2 = randomsource.a(9) - 4;
            int k2 = randomsource.a(1025) - 512;
            if ((double)j2 + this.a.dn() > (double)(this.a.H.m_() - 1)) {
                j2 = 0;
            }
            BlockPosition blockposition = BlockPosition.a((double)i2 + this.a.dl(), (double)j2 + this.a.dn(), (double)k2 + this.a.dr());
            this.a.h(blockposition);
            this.a.z(true);
            this.c = false;
        }

        @Override
        public void e() {
            if (this.a.G().l()) {
                Vec3D vec3d = Vec3D.c(this.a.fY());
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 != null) {
                    int i2 = MathHelper.a(vec3d1.c);
                    int j2 = MathHelper.a(vec3d1.e);
                    boolean flag = true;
                    if (!this.a.H.b(i2 - 34, j2 - 34, i2 + 34, j2 + 34)) {
                        vec3d1 = null;
                    }
                }
                if (vec3d1 == null) {
                    this.c = true;
                    return;
                }
                this.a.G().a(vec3d1.c, vec3d1.d, vec3d1.e, this.b);
            }
        }

        @Override
        public boolean b() {
            return !this.a.G().l() && !this.c && !this.a.fZ() && !this.a.fW() && !this.a.q();
        }

        @Override
        public void d() {
            this.a.z(false);
            super.d();
        }
    }

    private static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle i;

        h(EntityTurtle turtle, double speed, int chance) {
            super(turtle, speed, chance);
            this.i = turtle;
        }

        @Override
        public boolean a() {
            return !this.b.aT() && !this.i.fZ() && !this.i.q() ? super.a() : false;
        }
    }

    private static class g
    extends AmphibiousPathNavigation {
        g(EntityTurtle owner, World world) {
            super(owner, world);
        }

        @Override
        public boolean a(BlockPosition pos) {
            EntityTurtle entityturtle;
            EntityInsentient entityinsentient = this.a;
            if (entityinsentient instanceof EntityTurtle && (entityturtle = (EntityTurtle)entityinsentient).ga()) {
                return this.b.a_(pos).a(Blocks.G);
            }
            return !this.b.a_(pos.d()).h();
        }
    }
}

