/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    public static final Predicate<EntityLiving> bV = entityliving -> {
        EntityTypes<?> entitytypes = entityliving.ae();
        return entitytypes == EntityTypes.aF || entitytypes == EntityTypes.aC || entitytypes == EntityTypes.N;
    };
    private static final float bZ = 8.0f;
    private static final float ca = 20.0f;
    private float cb;
    private float cc;
    private boolean cd;
    private boolean ce;
    private float cf;
    private float cg;
    private static final UniformInt ch = TimeRange.a(20, 39);
    @Nullable
    private UUID ci;

    public EntityWolf(EntityTypes<? extends EntityWolf> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
        this.x(false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void x() {
        this.bN.a(1, new PathfinderGoalFloat(this));
        this.bN.a(1, new b(1.5));
        this.bN.a(2, new PathfinderGoalSit(this));
        this.bN.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bN.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bN.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bN.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f, false));
        this.bN.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bN.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bN.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bN.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(10, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bO.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bO.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bO.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bO.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, bV));
        this.bO.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bT));
        this.bO.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bO.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public static AttributeProvider.Builder fY() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 8.0).a(GenericAttributes.f, 2.0);
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fire) {
        if (!super.setTarget(entityliving, reason, fire)) {
            return false;
        }
        entityliving = this.P_();
        return true;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bW, false);
        this.am.a(bX, EnumColor.o.a());
        this.am.a(bY, 0);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.zV, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("CollarColor", (byte)this.gb().a());
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
        this.a(this.H, nbt);
    }

    @Override
    protected SoundEffect s() {
        return this.R_() ? SoundEffects.zQ : (this.af.a(3) == 0 ? (this.q() && this.eo() < 10.0f ? SoundEffects.zW : SoundEffects.zT) : SoundEffects.zO);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.zS;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.zP;
    }

    @Override
    public float eN() {
        return 0.4f;
    }

    @Override
    public void b_() {
        super.b_();
        if (!this.H.B && this.cd && !this.ce && !this.fP() && this.N) {
            this.ce = true;
            this.cf = 0.0f;
            this.cg = 0.0f;
            this.H.a((Entity)this, (byte)8);
        }
        if (!this.H.B) {
            this.a((WorldServer)this.H, true);
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.bq()) {
            this.cc = this.cb;
            this.cb = this.gc() ? (this.cb += (1.0f - this.cb) * 0.4f) : (this.cb += (0.0f - this.cb) * 0.4f);
            if (this.aV()) {
                this.cd = true;
                if (this.ce && !this.H.B) {
                    this.H.a((Entity)this, (byte)56);
                    this.gd();
                }
            } else if ((this.cd || this.ce) && this.ce) {
                if (this.cf == 0.0f) {
                    this.a(SoundEffects.zU, this.eN(), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
                    this.a(GameEvent.w);
                }
                this.cg = this.cf;
                this.cf += 0.05f;
                if (this.cg >= 2.0f) {
                    this.cd = false;
                    this.ce = false;
                    this.cg = 0.0f;
                    this.cf = 0.0f;
                }
                if (this.cf > 0.4f) {
                    float f2 = (float)this.dn();
                    int i2 = (int)(MathHelper.a((this.cf - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D vec3d = this.dj();
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f1 = (this.af.i() * 2.0f - 1.0f) * this.dc() * 0.5f;
                        float f22 = (this.af.i() * 2.0f - 1.0f) * this.dc() * 0.5f;
                        this.H.a(Particles.ai, this.dl() + (double)f1, (double)(f2 + 0.8f), this.dr() + (double)f22, vec3d.c, vec3d.d, vec3d.e);
                    }
                }
            }
        }
    }

    private void gd() {
        this.ce = false;
        this.cf = 0.0f;
        this.cg = 0.0f;
    }

    @Override
    public void a(DamageSource damageSource) {
        this.cd = false;
        this.ce = false;
        this.cg = 0.0f;
        this.cf = 0.0f;
        super.a(damageSource);
    }

    public boolean fZ() {
        return this.cd;
    }

    public float C(float tickDelta) {
        return Math.min(0.5f + MathHelper.i(tickDelta, this.cg, this.cf) / 2.0f * 0.5f, 1.0f);
    }

    public float f(float tickDelta, float f1) {
        float f2 = (MathHelper.i(tickDelta, this.cg, this.cf) + f1) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.a(f2 * (float)Math.PI) * MathHelper.a(f2 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float D(float tickDelta) {
        return MathHelper.i(tickDelta, this.cc, this.cb) * 0.15f * (float)Math.PI;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.8f;
    }

    @Override
    public int V() {
        return this.w() ? 20 : super.V();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        Entity entity = source.d();
        if (!this.H.B) {
            // empty if block
        }
        if (entity != null && !(entity instanceof EntityHuman) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.a(source, amount);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag = target.a(this.dG().b(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
        }
        return flag;
    }

    @Override
    public void x(boolean tamed) {
        super.x(tamed);
        if (tamed) {
            this.a(GenericAttributes.a).a(20.0);
            this.c(this.eE());
        } else {
            this.a(GenericAttributes.a).a(8.0);
        }
        this.a(GenericAttributes.f).a(4.0);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.c();
        if (this.H.B) {
            boolean flag = this.m(player) || this.q() || itemstack.a(Items.qH) && !this.q() && !this.R_();
            return flag ? EnumInteractionResult.b : EnumInteractionResult.d;
        }
        if (this.q()) {
            if (this.m(itemstack) && this.eo() < this.eE()) {
                if (!player.fK().d) {
                    itemstack.h(1);
                }
                this.heal(item.v().a(), EntityRegainHealthEvent.RegainReason.EATING);
                return EnumInteractionResult.a;
            }
            if (!(item instanceof ItemDye)) {
                EnumInteractionResult enuminteractionresult = super.b(player, hand);
                if ((!enuminteractionresult.a() || this.y_()) && this.m(player)) {
                    this.z(!this.fS());
                    this.bi = false;
                    this.bM.n();
                    this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                    return EnumInteractionResult.a;
                }
                return enuminteractionresult;
            }
            EnumColor enumcolor = ((ItemDye)item).d();
            if (enumcolor != this.gb()) {
                EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)enumcolor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                if (!event.callEvent()) {
                    return EnumInteractionResult.e;
                }
                enumcolor = EnumColor.a(event.getColor().getWoolData());
                this.a(enumcolor);
                if (!player.fK().d) {
                    itemstack.h(1);
                }
                return EnumInteractionResult.a;
            }
        } else if (itemstack.a(Items.qH) && !this.R_()) {
            if (!player.fK().d) {
                itemstack.h(1);
            }
            if (this.af.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                this.e(player);
                this.bM.n();
                this.i((EntityLiving)null);
                this.z(true);
                this.H.a((Entity)this, (byte)7);
            } else {
                this.H.a((Entity)this, (byte)6);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public void b(byte status) {
        if (status == 8) {
            this.ce = true;
            this.cf = 0.0f;
            this.cg = 0.0f;
        } else if (status == 56) {
            this.gd();
        } else {
            super.b(status);
        }
    }

    public float ga() {
        return this.R_() ? 1.5393804f : (this.q() ? (0.55f - (this.eE() - this.eo()) * 0.02f) * (float)Math.PI : 0.62831855f);
    }

    @Override
    public boolean m(ItemStack stack) {
        Item item = stack.c();
        return item.u() && item.v().c();
    }

    @Override
    public int fy() {
        return 8;
    }

    @Override
    public int a() {
        return this.am.a(bY);
    }

    @Override
    public void a(int angerTime) {
        this.am.b(bY, angerTime);
    }

    @Override
    public void c() {
        this.a(ch.a(this.af));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.ci;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.ci = angryAt;
    }

    public EnumColor gb() {
        return EnumColor.a(this.am.a(bX));
    }

    public void a(EnumColor color) {
        this.am.b(bX, color.a());
    }

    @Nullable
    public EntityWolf b(WorldServer world, EntityAgeable entity) {
        UUID uuid;
        EntityWolf entitywolf = EntityTypes.bn.a(world);
        if (entitywolf != null && (uuid = this.T_()) != null) {
            entitywolf.b(uuid);
            entitywolf.x(true);
        }
        return entitywolf;
    }

    public void A(boolean begging) {
        this.am.b(bW, begging);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (!this.q()) {
            return false;
        }
        if (!(other instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)other;
        return !entitywolf.q() ? false : (entitywolf.w() ? false : this.fW() && entitywolf.fW());
    }

    public boolean gc() {
        return this.am.a(bW);
    }

    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            if (target instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)target;
                return !entitywolf.q() || entitywolf.H_() != owner;
            }
            return target instanceof EntityHuman && owner instanceof EntityHuman && !((EntityHuman)owner).a((EntityHuman)target) ? false : (target instanceof EntityHorseAbstract && ((EntityHorseAbstract)target).gh() ? false : !(target instanceof EntityTameableAnimal) || !((EntityTameableAnimal)target).q());
        }
        return false;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.R_() && super.a(player);
    }

    @Override
    public Vec3D cF() {
        return new Vec3D(0.0, 0.6f * this.cE(), this.dc() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bR) && EntityWolf.a(world, pos);
    }

    private class b
    extends PathfinderGoalPanic {
        public b(double d0) {
            super(EntityWolf.this, d0);
        }

        @Override
        protected boolean h() {
            return this.b.dv() || this.b.bK();
        }
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean a() {
            return super.a() && this.b instanceof EntityLlama ? !this.j.q() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama llama) {
            return llama.gc() >= EntityWolf.this.af.a(5);
        }

        @Override
        public void c() {
            EntityWolf.this.i((EntityLiving)null);
            super.c();
        }

        @Override
        public void e() {
            EntityWolf.this.i((EntityLiving)null);
            super.e();
        }
    }
}

