/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.LerpingModel;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.joml.Vector3f;

public class Axolotl
extends EntityAnimal
implements LerpingModel,
VariantHolder<Variant>,
Bucketable {
    public static final int bS = 200;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> bT = ImmutableList.of(SensorType.c, SensorType.n, SensorType.f, SensorType.o, SensorType.p);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bV = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.J, (Object[])new MemoryModuleType[]{MemoryModuleType.y, MemoryModuleType.M, MemoryModuleType.B, MemoryModuleType.N, MemoryModuleType.O, MemoryModuleType.Q, MemoryModuleType.T, MemoryModuleType.Y});
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double bW = 20.0;
    public static final int bX = 1200;
    private static final int cc = 6000;
    public static final String bY = "Variant";
    private static final int cd = 1800;
    private static final int ce = 2400;
    private final Map<String, Vector3f> cf = Maps.newHashMap();
    private static final int cg = 100;

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    public Axolotl(EntityTypes<? extends Axolotl> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
        this.bK = new c(this);
        this.bJ = new b(this, 20);
        this.v(1.0f);
    }

    @Override
    public Map<String, Vector3f> a() {
        return this.cf;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bZ, 0);
        this.am.a(ca, false);
        this.am.a(cb, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(bY, this.fS().a());
        nbt.a("FromBucket", this.r());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Variant.a(nbt.h(bY)));
        this.w(nbt.q("FromBucket"));
    }

    @Override
    public void L() {
        if (!this.fY()) {
            super.L();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        boolean flag = false;
        if (spawnReason == EnumMobSpawn.l) {
            return entityData;
        }
        RandomSource randomsource = world.r_();
        if (entityData instanceof a) {
            if (((a)entityData).a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new a(Variant.a(randomsource), Variant.a(randomsource));
        }
        this.a(((a)entityData).a(randomsource));
        if (flag) {
            this.c_(-24000);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void ao() {
        int i2 = this.cd();
        super.ao();
        if (!this.fK()) {
            this.s(i2);
        }
    }

    protected void s(int air) {
        if (this.bq() && !this.aV()) {
            this.i(air - 1);
            if (this.cd() == -20) {
                this.i(0);
                this.a(this.dG().r(), 2.0f);
            }
        } else {
            this.i(this.cc());
        }
    }

    public void q() {
        int i2 = this.cd() + 1800;
        this.i(Math.min(i2, this.cc()));
    }

    @Override
    public int cc() {
        return this.maxAirTicks;
    }

    public Variant fS() {
        return Variant.a(this.am.a(bZ));
    }

    @Override
    public void a(Variant variant) {
        this.am.b(bZ, variant.a());
    }

    private static boolean a(RandomSource random) {
        return random.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    public boolean dK() {
        return true;
    }

    @Override
    public boolean cv() {
        return false;
    }

    @Override
    public EnumMonsterType eJ() {
        return EnumMonsterType.e;
    }

    public void x(boolean playingDead) {
        this.am.b(ca, playingDead);
    }

    public boolean fY() {
        return this.am.a(ca);
    }

    @Override
    public boolean r() {
        return this.am.a(cb);
    }

    @Override
    public void w(boolean fromBucket) {
        this.am.b(cb, fromBucket);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        Axolotl axolotl = EntityTypes.f.a(world);
        if (axolotl != null) {
            Variant axolotl_variant = Axolotl.a(this.af) ? Variant.b(this.af) : (this.af.h() ? this.fS() : ((Axolotl)entity).fS());
            axolotl.a(axolotl_variant);
            axolotl.fz();
        }
        return axolotl;
    }

    @Override
    public double j(EntityLiving target) {
        return 1.5 + (double)target.dc() * 2.0;
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.az);
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    @Override
    protected void U() {
        this.H.ac().a("axolotlBrain");
        this.dH().a((WorldServer)this.H, this);
        this.H.ac().c();
        this.H.ac().a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        this.H.ac().c();
        if (!this.fK()) {
            Optional<Integer> optional = this.dH().c(MemoryModuleType.M);
            this.x(optional.isPresent() && optional.get() > 0);
        }
    }

    public static AttributeProvider.Builder fZ() {
        return EntityInsentient.y().a(GenericAttributes.a, 14.0).a(GenericAttributes.d, 1.0).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new AmphibiousPathNavigation(this, world);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag = target.a(this.dG().b(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
            this.a(SoundEffects.au, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        float f1 = this.eo();
        if (!(this.H.B || this.fK() || this.H.z.a(3) != 0 || !((float)this.H.z.a(3) < amount) && !(f1 / this.eE() < 0.5f) || !(amount < f1) || !this.aT() || source.d() == null && source.c() == null || this.fY())) {
            this.by.a(MemoryModuleType.M, Integer.valueOf(200));
        }
        return super.a(source, amount);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.655f;
    }

    @Override
    public int V() {
        return 1;
    }

    @Override
    public int W() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void l(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        NBTTagCompound nbttagcompound = stack.v();
        nbttagcompound.a(bY, this.fS().a());
        nbttagcompound.a("Age", this.h());
        BehaviorController<Axolotl> behaviorcontroller = this.dH();
        if (behaviorcontroller.a(MemoryModuleType.T)) {
            nbttagcompound.a("HuntingCooldown", behaviorcontroller.e(MemoryModuleType.T));
        }
    }

    @Override
    public void c(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
        this.a(Variant.a(nbt.h(bY)));
        if (nbt.e("Age")) {
            this.c_(nbt.h("Age"));
        }
        if (nbt.e("HuntingCooldown")) {
            this.dH().a(MemoryModuleType.T, true, nbt.i("HuntingCooldown"));
        }
    }

    @Override
    public ItemStack b() {
        return new ItemStack(Items.pR);
    }

    @Override
    public SoundEffect w() {
        return SoundEffects.cy;
    }

    @Override
    public boolean eh() {
        return !this.fY() && super.eh();
    }

    public static void a(Axolotl axolotl, EntityLiving entity) {
        Entity entity1;
        DamageSource damagesource;
        World world = axolotl.H;
        if (entity.ep() && (damagesource = entity.eq()) != null && (entity1 = damagesource.d()) != null && entity1.ae() == EntityTypes.bt) {
            EntityHuman entityhuman = (EntityHuman)entity1;
            List<EntityHuman> list = world.a(EntityHuman.class, axolotl.cD().g(20.0));
            if (list.contains(entityhuman)) {
                axolotl.e(entityhuman);
            }
        }
    }

    public void e(EntityHuman player) {
        MobEffect mobeffect = player.b(MobEffects.j);
        if (mobeffect == null || mobeffect.a(2399)) {
            int i2 = mobeffect != null ? mobeffect.d() : 0;
            int j2 = Math.min(2400, 100 + i2);
            player.addEffect(new MobEffect(MobEffects.j, j2, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        player.removeEffect(MobEffects.d, EntityPotionEffectEvent.Cause.AXOLOTL);
    }

    @Override
    public boolean Q() {
        return super.Q() || this.r();
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.aw;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.av;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return this.aT() ? SoundEffects.ay : SoundEffects.ax;
    }

    @Override
    protected SoundEffect aJ() {
        return SoundEffects.az;
    }

    @Override
    protected SoundEffect aI() {
        return SoundEffects.aA;
    }

    protected BehaviorController.b<Axolotl> dI() {
        return BehaviorController.a(bV, bT);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.dI().a(dynamic));
    }

    public BehaviorController<Axolotl> dH() {
        return super.dH();
    }

    @Override
    protected void T() {
        super.T();
        PacketDebug.a(this);
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.cT() && this.aT()) {
            this.a(this.eW(), movementInput);
            this.a(EnumMoveType.a, this.dj());
            this.f(this.dj().a(0.9));
        } else {
            super.h(movementInput);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(Items.pQ)) {
            player.a(hand, new ItemStack(Items.pH));
        } else {
            super.a(player, hand, stack);
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.r() && !this.aa();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> type, WorldAccess world, EnumMobSpawn reason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bK);
    }

    private static class c
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public c(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.fY()) {
                super.a();
            }
        }
    }

    private class b
    extends SmoothSwimmingLookControl {
        public b(Axolotl axolotl, int i2) {
            super(axolotl, i2);
        }

        @Override
        public void a() {
            if (!Axolotl.this.fY()) {
                super.a();
            }
        }
    }

    public static enum Variant implements INamable
    {
        a(0, "lucy", true),
        b(1, "wild", true),
        c(2, "gold", true),
        d(3, "cyan", true),
        e(4, "blue", false);

        private static final IntFunction<Variant> g;
        public static final Codec<Variant> f;
        private final int h;
        private final String i;
        private final boolean j;

        private Variant(int i2, String s2, boolean flag) {
            this.h = i2;
            this.i = s2;
            this.j = flag;
        }

        public int a() {
            return this.h;
        }

        public String b() {
            return this.i;
        }

        @Override
        public String c() {
            return this.i;
        }

        public static Variant a(int id) {
            return g.apply(id);
        }

        public static Variant a(RandomSource random) {
            return Variant.a(random, true);
        }

        public static Variant b(RandomSource random) {
            return Variant.a(random, false);
        }

        private static Variant a(RandomSource random, boolean natural) {
            Variant[] aaxolotl_variant = (Variant[])Arrays.stream(Variant.values()).filter(axolotl_variant -> axolotl_variant.j == natural).toArray(Variant[]::new);
            return (Variant)SystemUtils.a((Object[])aaxolotl_variant, random);
        }

        static {
            g = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            f = INamable.a(Variant::values);
        }
    }

    public static class a
    extends EntityAgeable.a {
        public final Variant[] a;

        public a(Variant ... variants) {
            super(false);
            this.a = variants;
        }

        public Variant a(RandomSource random) {
            return this.a[random.a(this.a.length)];
        }
    }
}

