/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class Frog
extends EntityAnimal
implements VariantHolder<FrogVariant> {
    public static final RecipeItemStack bS = RecipeItemStack.a(Items.pY);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Frog>>> bT = ImmutableList.of(SensorType.c, SensorType.f, SensorType.t, SensorType.r, SensorType.u);
    protected static final ImmutableList<MemoryModuleType<?>> bV = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.r, MemoryModuleType.R, MemoryModuleType.S, MemoryModuleType.o, MemoryModuleType.N, MemoryModuleType.O, (Object[])new MemoryModuleType[]{MemoryModuleType.Q, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.B, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.Y, MemoryModuleType.Z});
    private static final DataWatcherObject<FrogVariant> cb = DataWatcher.a(Frog.class, DataWatcherRegistry.x);
    private static final DataWatcherObject<OptionalInt> cc = DataWatcher.a(Frog.class, DataWatcherRegistry.u);
    private static final int cd = 5;
    public static final String bW = "variant";
    public final AnimationState bX = new AnimationState();
    public final AnimationState bY = new AnimationState();
    public final AnimationState bZ = new AnimationState();
    public final AnimationState ca = new AnimationState();

    public Frog(EntityTypes<? extends EntityAnimal> type, World world) {
        super(type, world);
        this.bJ = new a(this);
        this.a(PathType.j, 4.0f);
        this.a(PathType.e, -1.0f);
        this.bK = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.v(1.0f);
    }

    protected BehaviorController.b<Frog> dI() {
        return BehaviorController.a(bV, bT);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return FrogAi.a(this.dI().a(dynamic));
    }

    public BehaviorController<Frog> dH() {
        return super.dH();
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cb, FrogVariant.a);
        this.am.a(cc, OptionalInt.empty());
    }

    public void q() {
        this.am.b(cc, OptionalInt.empty());
    }

    public Optional<Entity> r() {
        return this.am.a(cc).stream().mapToObj(this.H::a).filter(Objects::nonNull).findFirst();
    }

    @Override
    public void a(Entity entity) {
        this.am.b(cc, OptionalInt.of(entity.af()));
    }

    @Override
    public int X() {
        return 35;
    }

    @Override
    public int W() {
        return 5;
    }

    public FrogVariant w() {
        return this.am.a(cb);
    }

    @Override
    public void a(FrogVariant variant) {
        this.am.b(cb, variant);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(bW, BuiltInRegistries.aj.b(this.w()).toString());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        FrogVariant frogVariant = BuiltInRegistries.aj.a(MinecraftKey.a(nbt.l(bW)));
        if (frogVariant != null) {
            this.a(frogVariant);
        }
    }

    @Override
    public boolean dK() {
        return true;
    }

    @Override
    protected void U() {
        this.H.ac().a("frogBrain");
        this.dH().a((WorldServer)this.H, this);
        this.H.ac().c();
        this.H.ac().a("frogActivityUpdate");
        FrogAi.a(this);
        this.H.ac().c();
        super.U();
    }

    @Override
    public void l() {
        if (this.H.k_()) {
            this.ca.a(this.aW() && !this.aP.c(), this.ag);
        }
        super.l();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (Entity.ar.equals(data)) {
            EntityPose pose = this.al();
            if (pose == EntityPose.g) {
                this.bX.a(this.ag);
            } else {
                this.bX.a();
            }
            if (pose == EntityPose.i) {
                this.bY.a(this.ag);
            } else {
                this.bY.a();
            }
            if (pose == EntityPose.j) {
                this.bZ.a(this.ag);
            } else {
                this.bZ.a();
            }
        }
        super.a(data);
    }

    @Override
    protected void g(float posDelta) {
        float f2 = this.bX.c() ? 0.0f : Math.min(posDelta * 25.0f, 1.0f);
        this.aP.a(f2, 0.4f);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        Frog frog = EntityTypes.O.a(world);
        if (frog != null) {
            FrogAi.a(frog, world.r_());
        }
        return frog;
    }

    @Override
    public boolean y_() {
        return false;
    }

    @Override
    public void a(boolean baby) {
    }

    @Override
    public void a(WorldServer world, EntityAnimal other) {
        EntityPlayer serverPlayer = this.fV();
        if (serverPlayer == null) {
            serverPlayer = other.fV();
        }
        int experience = this.dZ().a(7) + 1;
        EntityFertilizeEggEvent event = new EntityFertilizeEggEvent((LivingEntity)this.getBukkitEntity(), (LivingEntity)other.getBukkitEntity(), (Player)(serverPlayer == null ? null : serverPlayer.getBukkitEntity()), this.breedItem == null ? null : CraftItemStack.asCraftMirror(this.breedItem).clone(), experience);
        if (!event.callEvent()) {
            this.fX();
            other.fX();
            return;
        }
        experience = event.getExperience();
        if (serverPlayer != null) {
            serverPlayer.a(StatisticList.P);
            CriterionTriggers.o.a(serverPlayer, this, other, null);
        }
        this.c_(6000);
        other.c_(6000);
        this.fX();
        other.fX();
        this.dH().a(MemoryModuleType.X, Unit.a);
        world.a((Entity)this, (byte)18);
        if (experience > 0 && world.W().b(GameRules.f)) {
            world.b(new EntityExperienceOrb(world, this.dl(), this.dn(), this.dr(), experience, ExperienceOrb.SpawnReason.BREED, serverPlayer));
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        Holder<BiomeBase> holder = world.v(this.dg());
        if (holder.a(BiomeTags.ag)) {
            this.a(FrogVariant.c);
        } else if (holder.a(BiomeTags.ah)) {
            this.a(FrogVariant.b);
        } else {
            this.a(FrogVariant.a);
        }
        FrogAi.a(this, world.r_());
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static AttributeProvider.Builder fS() {
        return EntityInsentient.y().a(GenericAttributes.d, 1.0).a(GenericAttributes.a, 10.0).a(GenericAttributes.f, 10.0);
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return SoundEffects.iv;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.iy;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.iw;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.iB, 0.15f, 1.0f);
    }

    @Override
    public boolean cv() {
        return false;
    }

    @Override
    protected void T() {
        super.T();
        PacketDebug.a(this);
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return super.d(fallDistance, damageMultiplier) - 5;
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.cT() && this.aT()) {
            this.a(this.eW(), movementInput);
            this.a(EnumMoveType.a, this.dj());
            this.f(this.dj().a(0.9));
        } else {
            super.h(movementInput);
        }
    }

    public static boolean m(EntityLiving entity) {
        EntitySlime slime;
        if (entity instanceof EntitySlime && (slime = (EntitySlime)entity).fU() != 1) {
            return false;
        }
        return entity.ae().a(TagsEntity.k);
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new c(this, world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return bS.a(stack);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn reason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bS) && Frog.a(world, pos);
    }

    class a
    extends ControllerLook {
        a(EntityInsentient entity) {
            super(entity);
        }

        @Override
        protected boolean c() {
            return Frog.this.r().isEmpty();
        }
    }

    static class c
    extends AmphibiousPathNavigation {
        c(Frog frog, World world) {
            super(frog, world);
        }

        @Override
        public boolean b(PathType nodeType) {
            return nodeType != PathType.k && super.b(nodeType);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new b(true);
            this.o.a(true);
            return new Pathfinder(this.o, range);
        }
    }

    static class b
    extends AmphibiousNodeEvaluator {
        private final BlockPosition.MutableBlockPosition m = new BlockPosition.MutableBlockPosition();

        public b(boolean penalizeDeepWater) {
            super(penalizeDeepWater);
        }

        @Override
        public PathPoint a() {
            return !this.b.aT() ? super.a() : this.c(new BlockPosition(MathHelper.a(this.b.cD().a), MathHelper.a(this.b.cD().b), MathHelper.a(this.b.cD().c)));
        }

        @Override
        public PathType a(IBlockAccess world, int x2, int y2, int z2) {
            this.m.d(x2, y2 - 1, z2);
            IBlockData blockState = world.a_(this.m);
            return blockState.a(TagsBlock.bF) ? PathType.b : super.a(world, x2, y2, z2);
        }
    }
}

