/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bS = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int bZ = 2;
    private static final int ca = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bT = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.n, SensorType.f, SensorType.q);
    protected static final ImmutableList<MemoryModuleType<?>> bV = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.au, MemoryModuleType.r, MemoryModuleType.R, MemoryModuleType.S, MemoryModuleType.N, MemoryModuleType.J, MemoryModuleType.O, (Object[])new MemoryModuleType[]{MemoryModuleType.Q, MemoryModuleType.U, MemoryModuleType.V, MemoryModuleType.Y});
    public static final int bW = 10;
    public static final double bX = 0.02;
    public static final double bY = (double)0.1f;
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cc = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cd = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private boolean ce;
    private int cf;

    public Goat(EntityTypes<? extends Goat> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.G().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack q() {
        RandomSource randomsource = RandomSource.a(this.cs().hashCode());
        TagKey<Instrument> tagkey = this.gc() ? InstrumentTags.b : InstrumentTags.a;
        HolderSet.Named<Instrument> holderset = BuiltInRegistries.al.a(tagkey);
        return InstrumentItem.a(Items.vc, holderset.a(randomsource).get());
    }

    protected BehaviorController.b<Goat> dI() {
        return BehaviorController.a(bV, bT);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.dI().a(dynamic));
    }

    public static AttributeProvider.Builder r() {
        return EntityInsentient.y().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.2f).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected void m() {
        if (this.y_()) {
            this.a(GenericAttributes.f).a(1.0);
            this.gb();
        } else {
            this.a(GenericAttributes.f).a(2.0);
            this.ga();
        }
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return super.d(fallDistance, damageMultiplier) - 10;
    }

    @Override
    protected SoundEffect s() {
        return this.gc() ? SoundEffects.jE : SoundEffects.ju;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.gc() ? SoundEffects.jH : SoundEffects.jx;
    }

    @Override
    public SoundEffect x_() {
        return this.gc() ? SoundEffects.jF : SoundEffects.jv;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.jN, 0.15f, 1.0f);
    }

    protected SoundEffect w() {
        return this.gc() ? SoundEffects.jJ : SoundEffects.jz;
    }

    @Nullable
    public Goat b(WorldServer world, EntityAgeable entity) {
        Goat goat = EntityTypes.U.a(world);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, world.r_());
            EntityAgeable object = world.r_().h() ? this : entity;
            boolean flag = object instanceof Goat && ((Goat)(goat1 = object)).gc() || !(world.r_().j() >= 0.02);
            boolean flag1 = flag;
            goat.w(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> dH() {
        return super.dH();
    }

    @Override
    protected void U() {
        this.H.ac().a("goatBrain");
        this.dH().a((WorldServer)this.H, this);
        this.H.ac().c();
        this.H.ac().a("goatActivityUpdate");
        GoatAi.a(this);
        this.H.ac().c();
        super.U();
    }

    @Override
    public int W() {
        return 15;
    }

    @Override
    public void r(float headYaw) {
        int i2 = this.W();
        float f1 = MathHelper.c(this.aT, headYaw);
        float f2 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.r(this.aT + f2);
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return this.gc() ? SoundEffects.jG : SoundEffects.jw;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.pG) && !this.y_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.H, player, this.dg(), this.dg(), null, itemstack, Items.pM, hand);
            if (event.isCancelled()) {
                return EnumInteractionResult.d;
            }
            player.a(this.w(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemstack1);
            return EnumInteractionResult.a(this.H.B);
        }
        boolean isFood = this.m(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && isFood) {
            this.H.a((EntityHuman)null, this, this.d(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.H.z, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.r_();
        GoatAi.a(this, randomsource);
        this.w(randomsource.j() < 0.02);
        this.m();
        if (!this.y_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? cc : cd;
            this.am.b(datawatcherobject, false);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void T() {
        super.T();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.g ? bS.a(this.dS()) : super.a(pose);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsScreamingGoat", this.gc());
        nbt.a("HasLeftHorn", this.fS());
        nbt.a("HasRightHorn", this.fY());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.w(nbt.q("IsScreamingGoat"));
        this.am.b(cc, nbt.q("HasLeftHorn"));
        this.am.b(cd, nbt.q("HasRightHorn"));
    }

    @Override
    public void b(byte status) {
        if (status == 58) {
            this.ce = true;
        } else if (status == 59) {
            this.ce = false;
        } else {
            super.b(status);
        }
    }

    @Override
    public void b_() {
        this.cf = this.ce ? ++this.cf : (this.cf -= 2);
        this.cf = MathHelper.a(this.cf, 0, 20);
        super.b_();
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cb, false);
        this.am.a(cc, true);
        this.am.a(cd, true);
    }

    public boolean fS() {
        return this.am.a(cc);
    }

    public boolean fY() {
        return this.am.a(cd);
    }

    public boolean fZ() {
        boolean flag = this.fS();
        boolean flag1 = this.fY();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? cd : (!flag1 ? cc : (this.af.h() ? cc : cd));
        this.am.b(datawatcherobject, false);
        Vec3D vec3d = this.de();
        ItemStack itemstack = this.q();
        double d0 = MathHelper.b(this.af, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.af, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.af, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.H, vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        return this.spawnAtLocation(entityitem) != null;
    }

    public void ga() {
        this.am.b(cc, true);
        this.am.b(cd, true);
    }

    public void gb() {
        this.am.b(cc, false);
        this.am.b(cd, false);
    }

    public boolean gc() {
        return this.am.a(cb);
    }

    public void w(boolean screaming) {
        this.am.b(cb, screaming);
    }

    public float gd() {
        return (float)this.cf / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bL) && Goat.a(world, pos);
    }

    public void ram(EntityLiving entity) {
        BehaviorController<Goat> brain = this.dH();
        brain.a(MemoryModuleType.V, entity.de());
        brain.b(MemoryModuleType.U);
        brain.b(MemoryModuleType.r);
        brain.b(MemoryModuleType.N);
        brain.a(Activity.r);
    }
}

