/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.inventory.InventoryHolder;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.PcaSyncProtocol;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
OwnableEntity,
IJumpable,
ISaddleable {
    public static final int cd = 400;
    public static final int ce = 499;
    public static final int cf = 500;
    public static final double cg = 0.15;
    private static final float bS = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float bT = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float bV = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float bW = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float bX = EntityHorseAbstract.a((int i2) -> 0);
    private static final float bY = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float bZ = 0.25f;
    private static final float ca = 0.5f;
    private static final Predicate<EntityLiving> cb = entityliving -> entityliving instanceof EntityHorseAbstract && ((EntityHorseAbstract)entityliving).gm();
    private static final PathfinderTargetCondition cc = PathfinderTargetCondition.b().a(16.0).d().a(cb);
    private static final RecipeItemStack ct = RecipeItemStack.a(Items.oE, Items.qI, Blocks.ii.k(), Items.nB, Items.tm, Items.pi, Items.pj);
    private static final DataWatcherObject<Byte> cu = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cv = 2;
    private static final int cw = 4;
    private static final int cx = 8;
    private static final int cy = 16;
    private static final int cz = 32;
    private static final int cA = 64;
    public static final int ch = 0;
    public static final int ci = 1;
    public static final int cj = 2;
    private int cB;
    private int cC;
    private int cD;
    public int ck;
    public int cl;
    protected boolean cm;
    public InventorySubcontainer cn;
    protected int co;
    protected float cp;
    protected boolean cq;
    private float cE;
    private float cF;
    private float cG;
    private float cH;
    private float cI;
    private float cJ;
    protected boolean cr = true;
    protected int cs;
    @Nullable
    private UUID cK;
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.v(1.0f);
        this.go();
    }

    @Override
    protected void x() {
        this.bN.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bN.a(1, new PathfinderGoalTame(this, 1.2));
        this.bN.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bN.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bN.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bN.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bN.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.fY()) {
            this.bN.a(9, new RandomStandGoal(this));
        }
        this.gi();
    }

    protected void gi() {
        this.bN.a(0, new PathfinderGoalFloat(this));
        this.bN.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.tm, Items.pi, Items.pj), false));
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cu, (byte)0);
    }

    protected boolean s(int bitmask) {
        return (this.am.a(cu) & bitmask) != 0;
    }

    protected void d(int bitmask, boolean flag) {
        byte b0 = this.am.a(cu);
        if (flag) {
            this.am.b(cu, (byte)(b0 | bitmask));
        } else {
            this.am.b(cu, (byte)(b0 & ~bitmask));
        }
    }

    public boolean gh() {
        return this.s(2);
    }

    @Override
    @Nullable
    public UUID T_() {
        return this.cK;
    }

    public void b(@Nullable UUID ownerUuid) {
        this.cK = ownerUuid;
    }

    public boolean gj() {
        return this.cm;
    }

    public void x(boolean tame) {
        this.d(2, tame);
    }

    public void y(boolean inAir) {
        this.cm = inAir;
    }

    @Override
    protected void B(float leashLength) {
        if (leashLength > 6.0f && this.gk()) {
            this.A(false);
        }
    }

    public boolean gk() {
        return this.s(16);
    }

    public boolean gl() {
        return this.s(32);
    }

    public boolean gm() {
        return this.s(8);
    }

    public void z(boolean bred) {
        this.d(8, bred);
    }

    @Override
    public boolean g() {
        return this.bq() && !this.y_() && this.gh();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.equipSaddle(sound, null);
    }

    @Override
    public void equipSaddle(@Nullable SoundCategory sound, @Nullable ItemStack stack) {
        this.cn.a(0, stack != null ? stack : new ItemStack(Items.mV));
        if (sound != null) {
            this.H.a((EntityHuman)null, this, this.Q_(), sound, 0.5f, 1.0f);
        }
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.l(stack)) {
            this.cn.a(1, stack.c(1));
            if (!player.fK().d) {
                stack.h(1);
            }
        }
    }

    @Override
    public boolean i() {
        return this.s(4);
    }

    public int gn() {
        return this.co;
    }

    public void t(int temper) {
        this.co = temper;
    }

    public int u(int difference) {
        int j2 = MathHelper.a(this.gn() + difference, 0, this.gt());
        this.t(j2);
        return j2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.bM();
    }

    private void q() {
        SoundEffect soundeffect;
        this.fS();
        if (!this.aO() && (soundeffect = this.fZ()) != null) {
            this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), soundeffect, this.cX(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0f) {
            this.a(SoundEffects.le, 0.4f, 1.0f);
        }
        if ((i2 = this.d(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        if (this.bM()) {
            for (Entity entity : this.cQ()) {
                entity.a(damageSource, (float)i2);
            }
        }
        this.eA();
        return true;
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return MathHelper.f((fallDistance * 0.5f - 3.0f) * damageMultiplier);
    }

    protected int U_() {
        return 2;
    }

    public void go() {
        InventorySubcontainer inventorysubcontainer = this.cn;
        this.cn = new InventorySubcontainer(this.U_(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity())){

            @Override
            public Location getLocation() {
                return EntityHorseAbstract.this.getBukkitEntity().getLocation();
            }
        };
        if (inventorysubcontainer != null) {
            inventorysubcontainer.b(this);
            int i2 = Math.min(inventorysubcontainer.b(), this.cn.b());
            for (int j2 = 0; j2 < i2; ++j2) {
                ItemStack itemstack = inventorysubcontainer.a(j2);
                if (itemstack.b()) continue;
                this.cn.a(j2, itemstack.o());
            }
        }
        this.cn.a(this);
        this.gp();
    }

    protected void gp() {
        if (!this.H.B) {
            this.d(4, !this.cn.a(0).b());
        }
    }

    @Override
    public void a(IInventory sender) {
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.syncEntityToClient(this);
        }
        boolean flag = this.i();
        this.gp();
        if (this.ag > 20 && !flag && this.i()) {
            this.a(SoundEffects.lf, 0.5f, 1.0f);
        }
    }

    public double gq() {
        return this.b(GenericAttributes.m);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (flag && this.af.a(3) == 0) {
            this.gx();
        }
        return flag;
    }

    protected boolean fY() {
        return true;
    }

    @Nullable
    protected SoundEffect fZ() {
        return null;
    }

    @Nullable
    protected SoundEffect gr() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (!state.d().a()) {
            IBlockData iblockdata1 = this.H.a_(pos.c());
            SoundEffectType soundeffecttype = state.t();
            if (iblockdata1.a(Blocks.dM)) {
                soundeffecttype = iblockdata1.t();
            }
            if (this.bM() && this.cr) {
                ++this.cs;
                if (this.cs > 5 && this.cs % 3 == 0) {
                    this.a(soundeffecttype);
                } else if (this.cs <= 5) {
                    this.a(SoundEffects.lh, soundeffecttype.a() * 0.15f, soundeffecttype.b());
                }
            } else if (soundeffecttype == SoundEffectType.a) {
                this.a(SoundEffects.lh, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            } else {
                this.a(SoundEffects.lg, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            }
        }
    }

    protected void a(SoundEffectType group) {
        this.a(SoundEffects.lb, group.a() * 0.15f, group.b());
    }

    public static AttributeProvider.Builder gs() {
        return EntityInsentient.y().a(GenericAttributes.m).a(GenericAttributes.a, 53.0).a(GenericAttributes.d, 0.225f);
    }

    @Override
    public int fy() {
        return 6;
    }

    public int gt() {
        return this.maxDomestication;
    }

    @Override
    public float eN() {
        return 0.8f;
    }

    @Override
    public int K() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.H.B && (!this.bM() || this.u(player)) && this.gh()) {
            player.a(this, this.cn);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (!player.fK().d) {
            stack.h(1);
        }
        return this.H.B ? EnumInteractionResult.b : (flag ? EnumInteractionResult.a : EnumInteractionResult.d);
    }

    protected boolean a(EntityHuman player, ItemStack item) {
        boolean flag = false;
        float f2 = 0.0f;
        int short0 = 0;
        int b0 = 0;
        if (item.a(Items.oE)) {
            f2 = 2.0f;
            short0 = 20;
            b0 = 3;
        } else if (item.a(Items.qI)) {
            f2 = 1.0f;
            short0 = 30;
            b0 = 3;
        } else if (item.a(Blocks.ii.k())) {
            f2 = 20.0f;
            short0 = 180;
        } else if (item.a(Items.nB)) {
            f2 = 3.0f;
            short0 = 60;
            b0 = 3;
        } else if (item.a(Items.tm)) {
            f2 = 4.0f;
            short0 = 60;
            b0 = 5;
            if (!this.H.B && this.gh() && this.h() == 0 && !this.fW()) {
                flag = true;
                this.f(player);
            }
        } else if (item.a(Items.pi) || item.a(Items.pj)) {
            f2 = 10.0f;
            short0 = 240;
            b0 = 10;
            if (!this.H.B && this.gh() && this.h() == 0 && !this.fW()) {
                flag = true;
                this.f(player);
            }
        }
        if (this.eo() < this.eE() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.y_() && short0 > 0) {
            this.H.a(Particles.M, this.d(1.0), this.do() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.H.B) {
                this.b_(short0);
            }
            flag = true;
        }
        if (b0 > 0 && (flag || !this.gh()) && this.gn() < this.gt()) {
            flag = true;
            if (!this.H.B) {
                this.u(b0);
            }
        }
        if (flag) {
            this.q();
            this.a(GameEvent.n);
        }
        return flag;
    }

    protected void e(EntityHuman player) {
        this.A(false);
        this.B(false);
        if (!this.H.B) {
            player.f(this.dw());
            player.e(this.dy());
            player.k(this);
        }
    }

    @Override
    public boolean eP() {
        return super.eP() && this.bM() && this.i() || this.gk() || this.gl();
    }

    @Override
    public boolean m(ItemStack stack) {
        return ct.a(stack);
    }

    private void r() {
        this.ck = 1;
    }

    @Override
    protected void er() {
        super.er();
        if (this.cn != null) {
            for (int i2 = 0; i2 < this.cn.b(); ++i2) {
                ItemStack itemstack = this.cn.a(i2);
                if (itemstack.b() || EnchantmentManager.e(itemstack)) continue;
                this.b(itemstack);
            }
        }
    }

    @Override
    public void b_() {
        if (this.af.a(200) == 0) {
            this.r();
        }
        super.b_();
        if (!this.H.B && this.bq()) {
            if (this.af.a(900) == 0 && this.aL == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.gv()) {
                if (!this.gk() && !this.bM() && this.af.a(300) == 0 && this.H.a_(this.dg().d()).a(Blocks.i)) {
                    this.A(true);
                }
                if (this.gk() && ++this.cB > 50) {
                    this.cB = 0;
                    this.A(false);
                }
            }
            this.gu();
        }
    }

    protected void gu() {
        EntityHorseAbstract entityliving;
        if (this.gm() && this.y_() && !this.gk() && (entityliving = this.H.a(EntityHorseAbstract.class, cc, this, this.dl(), this.dn(), this.dr(), this.cD().g(16.0))) != null && this.f((Entity)entityliving) > 4.0) {
            this.bM.a((Entity)entityliving, 0);
        }
    }

    public boolean gv() {
        return true;
    }

    @Override
    public void l() {
        super.l();
        if (this.cC > 0 && ++this.cC > 30) {
            this.cC = 0;
            this.d(64, false);
        }
        if (this.cU() && this.cD > 0 && ++this.cD > 20) {
            this.cD = 0;
            this.B(false);
        }
        if (this.ck > 0 && ++this.ck > 8) {
            this.ck = 0;
        }
        if (this.cl > 0) {
            ++this.cl;
            if (this.cl > 300) {
                this.cl = 0;
            }
        }
        this.cF = this.cE;
        if (this.gk()) {
            this.cE += (1.0f - this.cE) * 0.4f + 0.05f;
            if (this.cE > 1.0f) {
                this.cE = 1.0f;
            }
        } else {
            this.cE += (0.0f - this.cE) * 0.4f - 0.05f;
            if (this.cE < 0.0f) {
                this.cE = 0.0f;
            }
        }
        this.cH = this.cG;
        if (this.gl()) {
            this.cF = this.cE = 0.0f;
            this.cG += (1.0f - this.cG) * 0.4f + 0.05f;
            if (this.cG > 1.0f) {
                this.cG = 1.0f;
            }
        } else {
            this.cq = false;
            this.cG += (0.8f * this.cG * this.cG * this.cG - this.cG) * 0.6f - 0.05f;
            if (this.cG < 0.0f) {
                this.cG = 0.0f;
            }
        }
        this.cJ = this.cI;
        if (this.s(64)) {
            this.cI += (1.0f - this.cI) * 0.7f + 0.05f;
            if (this.cI > 1.0f) {
                this.cI = 1.0f;
            }
        } else {
            this.cI += (0.0f - this.cI) * 0.7f - 0.05f;
            if (this.cI < 0.0f) {
                this.cI = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.s(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (!this.bM() && !this.y_()) {
            if (this.gh() && player.fz()) {
                this.b(player);
                return EnumInteractionResult.a(this.H.B);
            }
            ItemStack itemstack = player.b(hand);
            if (!itemstack.b()) {
                EnumInteractionResult enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand);
                if (enuminteractionresult.a()) {
                    return enuminteractionresult;
                }
                if (this.gB() && this.l(itemstack) && !this.gC()) {
                    this.b(player, itemstack);
                    return EnumInteractionResult.a(this.H.B);
                }
            }
            this.e(player);
            return EnumInteractionResult.a(this.H.B);
        }
        return super.b(player, hand);
    }

    private void fS() {
        if (!this.H.B) {
            this.cC = 1;
            this.d(64, true);
        }
    }

    public void A(boolean eatingGrass) {
        this.d(16, eatingGrass);
    }

    public void setForceStanding(boolean standing) {
        this.d(32, standing);
    }

    public void B(boolean angry) {
        if (angry) {
            this.A(false);
        }
        this.d(32, angry);
    }

    @Nullable
    public SoundEffect gw() {
        return this.s();
    }

    public void gx() {
        if (this.fY() && this.cU()) {
            this.cD = 1;
            this.B(true);
        }
    }

    public void gy() {
        if (!this.gl()) {
            this.gx();
            SoundEffect soundeffect = this.gr();
            if (soundeffect != null) {
                this.a(soundeffect, this.eN(), this.eO());
            }
        }
    }

    public boolean g(EntityHuman player) {
        this.b(player.cs());
        this.x(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.x.a((EntityPlayer)player, this);
        }
        this.H.a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityLiving controllingPassenger, Vec3D movementInput) {
        super.a(controllingPassenger, movementInput);
        Vec2F vec2f = this.m(controllingPassenger);
        this.a(vec2f.j, vec2f.i);
        this.aT = this.aV = this.dw();
        this.L = this.aV;
        if (this.cT()) {
            if (movementInput.e <= 0.0) {
                this.cs = 0;
            }
            if (this.N) {
                this.y(false);
                if (this.cp > 0.0f && !this.gj()) {
                    this.b(this.cp, movementInput);
                }
                this.cp = 0.0f;
            }
        }
    }

    protected Vec2F m(EntityLiving controllingPassenger) {
        return new Vec2F(controllingPassenger.dy() * 0.5f, controllingPassenger.dw());
    }

    @Override
    protected Vec3D b(EntityLiving controllingPassenger, Vec3D movementInput) {
        if (this.N && this.cp == 0.0f && this.gl() && !this.cq) {
            return Vec3D.b;
        }
        float f2 = controllingPassenger.bj * 0.5f;
        float f1 = controllingPassenger.bl;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float g(EntityLiving controllingPassenger) {
        return (float)this.b(GenericAttributes.d);
    }

    protected void b(float strength, Vec3D movementInput) {
        double d0 = this.gq() * (double)strength * (double)this.aE();
        double d1 = d0 + this.eR();
        Vec3D vec3d1 = this.dj();
        this.o(vec3d1.c, d1, vec3d1.e);
        this.y(true);
        this.at = true;
        if (movementInput.e > 0.0) {
            float f1 = MathHelper.a(this.dw() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dw() * ((float)Math.PI / 180));
            this.f(this.dj().b(-0.4f * f1 * strength, 0.0, 0.4f * f2 * strength));
        }
    }

    protected void gz() {
        this.a(SoundEffects.ld, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("EatingHaystack", this.gk());
        nbt.a("Bred", this.gm());
        nbt.a("Temper", this.gn());
        nbt.a("Tame", this.gh());
        if (this.T_() != null) {
            nbt.a("Owner", this.T_());
        }
        nbt.a("Bukkit.MaxDomestication", this.maxDomestication);
        if (!this.cn.a(0).b()) {
            nbt.a("SaddleItem", this.cn.a(0).b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemstack;
        UUID uuid;
        super.a(nbt);
        this.A(nbt.q("EatingHaystack"));
        this.z(nbt.q("Bred"));
        this.t(nbt.h("Temper"));
        this.x(nbt.q("Tame"));
        if (nbt.b("Owner")) {
            uuid = nbt.a("Owner");
        } else {
            String s2 = nbt.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cH(), s2);
        }
        if (uuid != null) {
            this.b(uuid);
        }
        if (nbt.e("Bukkit.MaxDomestication")) {
            this.maxDomestication = nbt.h("Bukkit.MaxDomestication");
        }
        if (nbt.b("SaddleItem", 10) && (itemstack = ItemStack.a(nbt.p("SaddleItem"))).a(Items.mV)) {
            this.cn.a(0, itemstack);
        }
        this.gp();
    }

    @Override
    public boolean a(EntityAnimal other) {
        return false;
    }

    protected boolean gA() {
        return !this.bM() && !this.bL() && this.gh() && !this.y_() && this.eo() >= this.eE() && this.fW();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    protected void a(EntityAgeable other, EntityHorseAbstract child) {
        this.a(other, child, GenericAttributes.a, (double)bX, (double)bY);
        this.a(other, child, GenericAttributes.m, (double)bV, (double)bW);
        this.a(other, child, GenericAttributes.d, (double)bS, (double)bT);
    }

    private void a(EntityAgeable other, EntityHorseAbstract child, AttributeBase attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.c(attribute), other.c(attribute), min, max, this.af);
        child.a(attribute).a(d2);
    }

    static double a(double parentBase, double otherParentBase, double min, double max, RandomSource random) {
        double d7;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        parentBase = MathHelper.a(parentBase, min, max);
        otherParentBase = MathHelper.a(otherParentBase, min, max);
        double d4 = 0.15 * (max - min);
        double d6 = (parentBase + otherParentBase) / 2.0;
        double d5 = Math.abs(parentBase - otherParentBase) + d4 * 2.0;
        double d8 = d6 + d5 * (d7 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d8 > max) {
            double d9 = d8 - max;
            return max - d9;
        }
        if (d8 < min) {
            double d9 = min - d8;
            return min + d9;
        }
        return d8;
    }

    public float C(float tickDelta) {
        return MathHelper.i(tickDelta, this.cF, this.cE);
    }

    public float D(float tickDelta) {
        return MathHelper.i(tickDelta, this.cH, this.cG);
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.cJ, this.cI);
    }

    @Override
    public void b(int strength) {
        if (this.i()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.cq = true;
                this.gx();
            }
            this.cp = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.i();
    }

    @Override
    public void c(int height) {
        float power = height >= 90 ? 1.0f : 0.4f + 0.4f * (float)height / 90.0f;
        HorseJumpEvent event = CraftEventFactory.callHorseJumpEvent(this, power);
        if (event.isCancelled()) {
            return;
        }
        this.cq = true;
        this.gx();
        this.gz();
    }

    @Override
    public void b() {
    }

    protected void C(boolean positive) {
        ParticleType particletype = positive ? Particles.O : Particles.ab;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.H.a(particletype, this.d(1.0), this.do() + 0.5, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.C(true);
        } else if (status == 6) {
            this.C(false);
        } else {
            super.b(status);
        }
    }

    @Override
    public void i(Entity passenger) {
        super.i(passenger);
        if (passenger instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)passenger;
            this.aT = entityinsentient.aT;
        }
        if (this.cH > 0.0f) {
            float f2 = MathHelper.a(this.aT * ((float)Math.PI / 180));
            float f1 = MathHelper.b(this.aT * ((float)Math.PI / 180));
            float f22 = 0.7f * this.cH;
            float f3 = 0.15f * this.cH;
            passenger.e(this.dl() + (double)(f22 * f2), this.dn() + this.bv() + passenger.bu() + (double)f3, this.dr() - (double)(f22 * f1));
            if (passenger instanceof EntityLiving) {
                ((EntityLiving)passenger).aT = this.aT;
            }
        }
    }

    protected static float a(IntUnaryOperator randomIntGetter) {
        return 15.0f + (float)randomIntGetter.applyAsInt(8) + (float)randomIntGetter.applyAsInt(9);
    }

    protected static double a(DoubleSupplier randomDoubleGetter) {
        return (double)0.4f + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier randomDoubleGetter) {
        return ((double)0.45f + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean z_() {
        return false;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.95f;
    }

    public boolean gB() {
        return false;
    }

    public boolean gC() {
        return !this.c(EnumItemSlot.e).b();
    }

    public boolean l(ItemStack item) {
        return false;
    }

    private SlotAccess a(final int slot, final Predicate<ItemStack> predicate) {
        return new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityHorseAbstract.this.cn.a(slot);
            }

            @Override
            public boolean a(ItemStack stack) {
                if (!predicate.test(stack)) {
                    return false;
                }
                EntityHorseAbstract.this.cn.a(slot, stack);
                EntityHorseAbstract.this.gp();
                return true;
            }
        };
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int k2;
        int j2 = mappedIndex - 400;
        if (j2 >= 0 && j2 < 2 && j2 < this.cn.b()) {
            if (j2 == 0) {
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || itemstack.a(Items.mV));
            }
            if (j2 == 1) {
                if (!this.gB()) {
                    return SlotAccess.b;
                }
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || this.l((ItemStack)itemstack));
            }
        }
        return (k2 = mappedIndex - 500 + 2) >= 2 && k2 < this.cn.b() ? SlotAccess.a(this.cn, k2) : super.a_(mappedIndex);
    }

    @Override
    @Nullable
    public EntityLiving cK() {
        Entity entity;
        if (this.i() && (entity = this.cN()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            return entityliving;
        }
        return null;
    }

    @Nullable
    private Vec3D a(Vec3D offset, EntityLiving passenger) {
        double d0 = this.dl() + offset.c;
        double d1 = this.cD().b;
        double d2 = this.dr() + offset.e;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose entitypose : passenger.fr()) {
            blockposition_mutableblockposition.b(d0, d1, d2);
            double d3 = this.cD().e + 0.75;
            do {
                Vec3D vec3d1;
                AxisAlignedBB axisalignedbb;
                double d4 = this.H.i(blockposition_mutableblockposition);
                if ((double)blockposition_mutableblockposition.v() + d4 > d3) continue block0;
                if (DismountUtil.a(d4) && DismountUtil.a(this.H, passenger, (axisalignedbb = passenger.g(entitypose)).c(vec3d1 = new Vec3D(d0, (double)blockposition_mutableblockposition.v() + d4, d2)))) {
                    passenger.b(entitypose);
                    return vec3d1;
                }
                blockposition_mutableblockposition.c(EnumDirection.b);
            } while (!((double)blockposition_mutableblockposition.v() >= d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = EntityHorseAbstract.a(this.dc(), (double)passenger.dc(), this.dw() + (passenger.fd() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D vec3d1 = this.a(vec3d, passenger);
        if (vec3d1 != null) {
            return vec3d1;
        }
        Vec3D vec3d2 = EntityHorseAbstract.a(this.dc(), (double)passenger.dc(), this.dw() + (passenger.fd() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D vec3d3 = this.a(vec3d2, passenger);
        return vec3d3 != null ? vec3d3 : this.de();
    }

    protected void a(RandomSource random) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(0.2f);
        }
        this.a(world.r_());
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean b(IInventory inventory) {
        return this.cn != inventory;
    }

    public int gD() {
        return this.K();
    }
}

