/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLlamaFollow;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarpet;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityLlama
extends EntityHorseChestedAbstract
implements VariantHolder<Variant>,
IRangedEntity {
    private static final int bT = 5;
    private static final RecipeItemStack bV = RecipeItemStack.a(Items.oE, Blocks.ii.k());
    private static final DataWatcherObject<Integer> bW = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    boolean bZ;
    @Nullable
    private EntityLlama ca;
    @Nullable
    public EntityLlama cb;

    public EntityLlama(EntityTypes<? extends EntityLlama> type, World world) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)type, world);
    }

    public boolean gb() {
        return false;
    }

    public void setStrengthPublic(int i2) {
        this.v(i2);
    }

    private void v(int strength) {
        this.am.b(bW, Math.max(1, Math.min(5, strength)));
    }

    private void b(RandomSource random) {
        int i2 = random.i() < 0.04f ? 5 : 3;
        this.v(1 + random.a(i2));
    }

    public int gc() {
        return this.am.a(bW);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.ge().g);
        nbt.a("Strength", this.gc());
        if (!this.cn.a(1).b()) {
            nbt.a("DecorItem", this.cn.a(1).b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.v(nbt.h("Strength"));
        super.a(nbt);
        this.a(Variant.a(nbt.h("Variant")));
        if (nbt.b("DecorItem", 10)) {
            this.cn.a(1, ItemStack.a(nbt.p("DecorItem")));
        }
        this.gp();
    }

    @Override
    protected void x() {
        this.bN.a(0, new PathfinderGoalFloat(this));
        this.bN.a(1, new PathfinderGoalTame(this, 1.2));
        this.bN.a(2, new PathfinderGoalLlamaFollow(this, 2.1f));
        this.bN.a(3, new PathfinderGoalArrowAttack(this, 1.25, 40, 20.0f));
        this.bN.a(3, new PathfinderGoalPanic(this, 1.2));
        this.bN.a(4, new PathfinderGoalBreed(this, 1.0));
        this.bN.a(5, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.hf), false));
        this.bN.a(6, new PathfinderGoalFollowParent(this, 1.0));
        this.bN.a(7, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bN.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bN.a(9, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new c(this));
        this.bO.a(2, new a(this));
    }

    public static AttributeProvider.Builder gd() {
        return EntityLlama.q().a(GenericAttributes.b, 40.0);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bW, 0);
        this.am.a(bX, -1);
        this.am.a(bY, 0);
    }

    public Variant ge() {
        return Variant.a(this.am.a(bY));
    }

    @Override
    public void a(Variant variant) {
        this.am.b(bY, variant.g);
    }

    @Override
    protected int U_() {
        return this.r() ? 2 + 3 * this.ga() : super.U_();
    }

    @Override
    public void i(Entity passenger) {
        if (this.u(passenger)) {
            float f2 = MathHelper.b(this.aT * ((float)Math.PI / 180));
            float f1 = MathHelper.a(this.aT * ((float)Math.PI / 180));
            float f22 = 0.3f;
            passenger.e(this.dl() + (double)(0.3f * f1), this.dn() + this.bv() + passenger.bu(), this.dr() - (double)(0.3f * f2));
        }
    }

    @Override
    public double bv() {
        return (double)this.dd() * 0.6;
    }

    @Override
    @Nullable
    public EntityLiving cK() {
        return null;
    }

    @Override
    public boolean m(ItemStack stack) {
        return bV.a(stack);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack item) {
        SoundEffect soundeffect;
        int b0 = 0;
        int b1 = 0;
        float f2 = 0.0f;
        boolean flag = false;
        if (item.a(Items.oE)) {
            b0 = 10;
            b1 = 3;
            f2 = 2.0f;
        } else if (item.a(Blocks.ii.k())) {
            b0 = 90;
            b1 = 6;
            f2 = 10.0f;
            if (this.gh() && this.h() == 0 && this.fT()) {
                flag = true;
                this.f(player);
            }
        }
        if (this.eo() < this.eE() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.y_() && b0 > 0) {
            this.H.a(Particles.M, this.d(1.0), this.do() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.H.B) {
                this.b_(b0);
            }
            flag = true;
        }
        if (b1 > 0 && (flag || !this.gh()) && this.gn() < this.gt()) {
            flag = true;
            if (!this.H.B) {
                this.u(b1);
            }
        }
        if (flag && !this.aO() && (soundeffect = this.fZ()) != null) {
            this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), this.fZ(), this.cX(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
        }
        return flag;
    }

    @Override
    public boolean eP() {
        return this.ep() || this.gk();
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        Variant entityllama_variant;
        RandomSource randomsource = world.r_();
        this.b(randomsource);
        if (entityData instanceof b) {
            entityllama_variant = ((b)entityData).a;
        } else {
            entityllama_variant = (Variant)SystemUtils.a((Object[])Variant.values(), randomsource);
            entityData = new b(entityllama_variant);
        }
        this.a(entityllama_variant);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean fY() {
        return false;
    }

    @Override
    protected SoundEffect gr() {
        return SoundEffects.mo;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.mn;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.ms;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.mq;
    }

    @Override
    @Nullable
    protected SoundEffect fZ() {
        return SoundEffects.mr;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.mu, 0.15f, 1.0f);
    }

    @Override
    protected void fS() {
        this.a(SoundEffects.mp, 1.0f, (this.af.i() - this.af.i()) * 0.2f + 1.0f);
    }

    @Override
    public int ga() {
        return this.gc();
    }

    @Override
    public boolean gB() {
        return true;
    }

    @Override
    public boolean gC() {
        return !this.cn.a(1).b();
    }

    @Override
    public boolean l(ItemStack item) {
        return item.a(TagsItem.f);
    }

    @Override
    public boolean g() {
        return false;
    }

    @Override
    public void a(IInventory sender) {
        EnumColor enumcolor = this.gf();
        super.a(sender);
        EnumColor enumcolor1 = this.gf();
        if (this.ag > 20 && enumcolor1 != null && enumcolor1 != enumcolor) {
            this.a(SoundEffects.mv, 0.5f, 1.0f);
        }
    }

    @Override
    protected void gp() {
        if (!this.H.B) {
            super.gp();
            this.a(EntityLlama.n(this.cn.a(1)));
        }
    }

    @Override
    private void a(@Nullable EnumColor color) {
        this.am.b(bX, color == null ? -1 : color.a());
    }

    @Nullable
    private static EnumColor n(ItemStack color) {
        Block block = Block.a(color.c());
        return block instanceof BlockCarpet ? ((BlockCarpet)block).b() : null;
    }

    @Nullable
    public EnumColor gf() {
        int i2 = this.am.a(bX);
        return i2 == -1 ? null : EnumColor.a(i2);
    }

    @Override
    public int gt() {
        return 30;
    }

    @Override
    public boolean a(EntityAnimal other) {
        return other != this && other instanceof EntityLlama && this.gA() && ((EntityLlama)other).gA();
    }

    @Nullable
    public EntityLlama b(WorldServer world, EntityAgeable entity) {
        EntityLlama entityllama = this.gg();
        if (entityllama != null) {
            this.a(entity, entityllama);
            EntityLlama entityllama1 = (EntityLlama)entity;
            int i2 = this.af.a(Math.max(this.gc(), entityllama1.gc())) + 1;
            if (this.af.i() < 0.03f) {
                ++i2;
            }
            entityllama.v(i2);
            entityllama.a(this.af.h() ? this.ge() : entityllama1.ge());
        }
        return entityllama;
    }

    @Nullable
    protected EntityLlama gg() {
        return EntityTypes.aj.a(this.H);
    }

    private void n(EntityLiving target) {
        EntityLlamaSpit entityllamaspit = new EntityLlamaSpit(this.H, this);
        double d0 = target.dl() - this.dl();
        double d1 = target.e(0.3333333333333333) - entityllamaspit.dn();
        double d2 = target.dr() - this.dr();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        entityllamaspit.c(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.aO()) {
            this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), SoundEffects.mt, this.cX(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
        }
        this.H.b(entityllamaspit);
        this.bZ = true;
    }

    void D(boolean spit) {
        this.bZ = spit;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2 = this.d(fallDistance, damageMultiplier);
        if (i2 <= 0) {
            return false;
        }
        if (fallDistance >= 6.0f) {
            this.a(damageSource, (float)i2);
            if (this.bM()) {
                for (Entity entity : this.cQ()) {
                    entity.a(damageSource, (float)i2);
                }
            }
        }
        this.eA();
        return true;
    }

    public void gE() {
        if (this.ca != null) {
            this.ca.cb = null;
        }
        this.ca = null;
    }

    @Override
    public void a(EntityLlama llama) {
        this.ca = llama;
        this.ca.cb = this;
    }

    public boolean gF() {
        return this.cb != null;
    }

    public boolean gG() {
        return this.ca != null;
    }

    @Nullable
    public EntityLlama gH() {
        return this.ca;
    }

    @Override
    protected double fR() {
        return 2.0;
    }

    @Override
    protected void gu() {
        if (!this.gG() && this.y_()) {
            super.gu();
        }
    }

    @Override
    public boolean gv() {
        return false;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.n(target);
    }

    @Override
    public Vec3D cF() {
        return new Vec3D(0.0, 0.75 * (double)this.cE(), (double)this.dc() * 0.5);
    }

    public static enum Variant implements INamable
    {
        a(0, "creamy"),
        b(1, "white"),
        c(2, "brown"),
        d(3, "gray");

        public static final Codec<Variant> e;
        private static final IntFunction<Variant> f;
        final int g;
        private final String h;

        private Variant(int i2, String s2) {
            this.g = i2;
            this.h = s2;
        }

        public int a() {
            return this.g;
        }

        public static Variant a(int id) {
            return f.apply(id);
        }

        @Override
        public String c() {
            return this.h;
        }

        static {
            e = INamable.a(Variant::values);
            f = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    private static class c
    extends PathfinderGoalHurtByTarget {
        public c(EntityLlama llama) {
            super(llama, new Class[0]);
        }

        @Override
        public boolean b() {
            if (this.e instanceof EntityLlama) {
                EntityLlama entityllama = (EntityLlama)this.e;
                if (entityllama.bZ) {
                    entityllama.D(false);
                    return false;
                }
            }
            return super.b();
        }
    }

    private static class a
    extends PathfinderGoalNearestAttackableTarget<EntityWolf> {
        public a(EntityLlama llama) {
            super(llama, EntityWolf.class, 16, false, true, entityliving -> !((EntityWolf)entityliving).q());
        }

        @Override
        protected double l() {
            return super.l() * 0.25;
        }
    }

    private static class b
    extends EntityAgeable.a {
        public final Variant a;

        b(Variant variant) {
            super(true);
            this.a = variant;
        }
    }
}

