/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import top.leavesmc.leaves.LeavesConfig;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.k);
    public int b;
    public boolean generatedByDragonFight = false;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> type, World world) {
        super(type, world);
        this.F = true;
        this.b = this.af.a(100000);
    }

    public EntityEnderCrystal(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.B, world);
        this.e(x2, y2, z2);
    }

    @Override
    protected Entity.MovementEmission aQ() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.aj().a(c, Optional.empty());
        this.aj().a(d, true);
    }

    @Override
    public void l() {
        ++this.b;
        if (this.H instanceof WorldServer) {
            BlockPosition blockposition = this.dg();
            if (((WorldServer)this.H).B() != null && this.H.a_(blockposition).h() && !CraftEventFactory.callBlockIgniteEvent(this.H, blockposition, this).isCancelled()) {
                this.H.b(blockposition, BlockFireAbstract.a(this.H, blockposition));
            }
            if (!LeavesConfig.mcTechnicalMode && this.H.paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.cm() && (!Objects.equals(((WorldServer)this.H).uuid, this.getOriginWorld()) || ((WorldServer)this.H).B() == null || ((WorldServer)this.H).B().x == null || ((WorldServer)this.H).B().x.ordinal() > EnumDragonRespawn.d.ordinal())) {
                this.m(false);
                this.a((BlockPosition)null);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.i() != null) {
            nbt.a("BeamTarget", GameProfileSerializer.a(this.i()));
        }
        nbt.a("ShowBottom", this.j());
        if (this.generatedByDragonFight) {
            nbt.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("BeamTarget", 10)) {
            this.a(GameProfileSerializer.b(nbt.p("BeamTarget")));
        }
        if (nbt.b("ShowBottom", 1)) {
            this.a(nbt.q("ShowBottom"));
        }
        if (nbt.b("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = nbt.q("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean bm() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source.d() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.dB() && !this.H.B) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                return false;
            }
            this.a(Entity.RemovalReason.a);
            if (!source.a(DamageTypeTags.l)) {
                DamageSource damagesource1 = source.d() != null ? this.dG().d(this, source.d()) : null;
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 6.0f, false);
                this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.dD();
                    return false;
                }
                this.H.a(this, damagesource1, null, this.dl(), this.dn(), this.dr(), event.getRadius(), event.getFire(), World.a.b);
            }
            this.a(source);
        }
        return true;
    }

    @Override
    public void ah() {
        this.a(this.dG().n());
        super.ah();
    }

    private void a(DamageSource source) {
        EnderDragonBattle enderdragonbattle;
        if (this.H instanceof WorldServer && (enderdragonbattle = ((WorldServer)this.H).B()) != null) {
            enderdragonbattle.a(this, source);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.aj().b(c, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition i() {
        return this.aj().a(c).orElse(null);
    }

    public void a(boolean showBottom) {
        this.aj().b(d, showBottom);
    }

    @Override
    public boolean j() {
        return this.aj().a(d);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.i() != null;
    }

    @Override
    public ItemStack dt() {
        return new ItemStack(Items.uh);
    }
}

