/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger bX = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> b = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition bY = PathfinderTargetCondition.a().a(64.0);
    private static final int bZ = 200;
    private static final int ca = 400;
    private static final float cb = 0.25f;
    private static final String cc = "DragonDeathTime";
    private static final String cd = "DragonPhase";
    public final double[][] c = new double[64][3];
    public int d = -1;
    public final EntityComplexPart[] ce;
    public final EntityComplexPart e = new EntityComplexPart(this, "head", 1.0f, 1.0f);
    private final EntityComplexPart cf = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
    private final EntityComplexPart cg = new EntityComplexPart(this, "body", 5.0f, 3.0f);
    private final EntityComplexPart ch = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart ci = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart cj = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart ck = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
    private final EntityComplexPart cl = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
    public float bR;
    public float bS;
    public boolean bT;
    public int bU;
    public float bV;
    @Nullable
    public EntityEnderCrystal bW;
    @Nullable
    private final EnderDragonBattle cm;
    private final DragonControllerManager cn;
    private int co = 100;
    private float cp;
    private final PathPoint[] cq = new PathPoint[24];
    private final int[] cr = new int[24];
    private final Path cs = new Path();
    private final Explosion explosionSource;
    @Nullable
    private BlockPosition podium;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.C, world);
        this.ce = new EntityComplexPart[]{this.e, this.cf, this.cg, this.ch, this.ci, this.cj, this.ck, this.cl};
        this.c(this.eE());
        this.ae = true;
        this.as = true;
        this.cm = world instanceof WorldServer ? ((WorldServer)world).B() : null;
        this.cn = new DragonControllerManager(this);
        this.explosionSource = new Explosion(world, this, null, null, Double.NaN, Double.NaN, Double.NaN, Float.NaN, true, Explosion.Effect.b);
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.a, 200.0);
    }

    public BlockPosition getPodium() {
        if (this.podium == null) {
            return WorldGenEndTrophy.e;
        }
        return this.podium;
    }

    public void setPodium(@Nullable BlockPosition blockPos) {
        this.podium = blockPos;
    }

    @Override
    public boolean aN() {
        float f2 = MathHelper.b(this.bS * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.bR * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void aM() {
        if (this.H.B && !this.aO()) {
            this.H.a(this.dl(), this.dn(), this.dr(), SoundEffects.gS, this.cX(), 5.0f, 0.8f + this.af.i() * 0.3f, false);
        }
    }

    @Override
    protected void a_() {
        super.a_();
        this.aj().a(b, DragonControllerPhase.k.b());
    }

    public double[] a(int segmentNumber, float tickDelta) {
        if (this.ep()) {
            tickDelta = 0.0f;
        }
        tickDelta = 1.0f - tickDelta;
        int j2 = this.d - segmentNumber & 0x3F;
        int k2 = this.d - segmentNumber - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.c[j2][0];
        double d1 = MathHelper.d(this.c[k2][0] - d0);
        adouble[0] = d0 + d1 * (double)tickDelta;
        d0 = this.c[j2][1];
        d1 = this.c[k2][1] - d0;
        adouble[1] = d0 + d1 * (double)tickDelta;
        adouble[2] = MathHelper.d((double)tickDelta, this.c[j2][2], this.c[k2][2]);
        return adouble;
    }

    @Override
    public void b_() {
        this.aB();
        if (this.H.B) {
            this.c(this.eo());
            if (!this.aO() && !this.cn.a().a() && --this.co < 0) {
                this.H.a(this.dl(), this.dn(), this.dr(), SoundEffects.gT, this.cX(), 2.5f, 0.8f + this.af.i() * 0.3f, false);
                this.co = 200 + this.af.a(200);
            }
        }
        this.bR = this.bS;
        if (this.ep()) {
            float f1 = (this.af.i() - 0.5f) * 8.0f;
            float f2 = (this.af.i() - 0.5f) * 4.0f;
            float f22 = (this.af.i() - 0.5f) * 8.0f;
            this.H.a(Particles.x, this.dl() + (double)f1, this.dn() + 2.0 + (double)f2, this.dr() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.fS();
            Vec3D vec3d = this.dj();
            float f3 = 0.2f / ((float)vec3d.h() * 10.0f + 1.0f);
            this.bS = this.cn.a().a() ? (this.bS += 0.1f) : (this.bT ? (this.bS += f3 * 0.5f) : (this.bS += (f3 *= (float)Math.pow(2.0, vec3d.d))));
            this.f(MathHelper.g(this.dw()));
            if (this.fK()) {
                this.bS = 0.5f;
            } else {
                int k2;
                float f5;
                float f4;
                float f32;
                if (this.d < 0) {
                    for (int i2 = 0; i2 < this.c.length; ++i2) {
                        this.c[i2][0] = this.dw();
                        this.c[i2][1] = this.dn();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dw();
                this.c[this.d][1] = this.dn();
                if (this.H.B) {
                    if (this.bm > 0) {
                        double d3 = this.dl() + (this.bn - this.dl()) / (double)this.bm;
                        double d0 = this.dn() + (this.bo - this.dn()) / (double)this.bm;
                        d1 = this.dr() + (this.bp - this.dr()) / (double)this.bm;
                        d2 = MathHelper.d(this.bq - (double)this.dw());
                        this.f(this.dw() + (float)d2 / (float)this.bm);
                        this.e(this.dy() + (float)(this.br - (double)this.dy()) / (float)this.bm);
                        --this.bm;
                        this.e(d3, d0, d1);
                        this.a(this.dw(), this.dy());
                    }
                    this.cn.a().b();
                } else {
                    Vec3D vec3d1;
                    IDragonController idragoncontroller = this.cn.a();
                    idragoncontroller.c();
                    if (this.cn.a() != idragoncontroller) {
                        idragoncontroller = this.cn.a();
                        idragoncontroller.c();
                    }
                    if ((vec3d1 = idragoncontroller.g()) != null && idragoncontroller.i() != DragonControllerPhase.k) {
                        double d0 = vec3d1.c - this.dl();
                        d1 = vec3d1.d - this.dn();
                        d2 = vec3d1.e - this.dr();
                        double d4 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.f();
                        double d5 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d5 > 0.0) {
                            d1 = MathHelper.a(d1 / d5, (double)(-f6), (double)f6);
                        }
                        this.f(this.dj().b(0.0, d1 * 0.01, 0.0));
                        this.f(MathHelper.g(this.dw()));
                        Vec3D vec3d2 = vec3d1.a(this.dl(), this.dn(), this.dr()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dw() * ((float)Math.PI / 180)), this.dj().d, -MathHelper.b(this.dw() * ((float)Math.PI / 180))).d();
                        f32 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            f4 = MathHelper.a(MathHelper.g(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.dw()), -50.0f, 50.0f);
                            this.bV *= 0.8f;
                            this.bV += f4 * idragoncontroller.h();
                            this.f(this.dw() + this.bV * 0.1f);
                        }
                        f4 = (float)(2.0 / (d4 + 1.0));
                        f5 = 0.06f;
                        this.a(0.06f * (f32 * f4 + (1.0f - f4)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.bT) {
                            this.a(EnumMoveType.a, this.dj().a((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dj());
                        }
                        Vec3D vec3d4 = this.dj().d();
                        double d6 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.f(this.dj().d(d6, 0.91f, d6));
                    }
                }
                this.aT = this.dw();
                Vec3D[] avec3d = new Vec3D[this.ce.length];
                for (int j2 = 0; j2 < this.ce.length; ++j2) {
                    avec3d[j2] = new Vec3D(this.ce[j2].dl(), this.ce[j2].dn(), this.ce[j2].dr());
                }
                float f7 = (float)(this.a(5, 1.0f)[1] - this.a(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f8 = MathHelper.b(f7);
                float f9 = MathHelper.a(f7);
                float f10 = this.dw() * ((float)Math.PI / 180);
                float f11 = MathHelper.a(f10);
                float f12 = MathHelper.b(f10);
                this.a(this.cg, (double)(f11 * 0.5f), 0.0, (double)(-f12 * 0.5f));
                this.a(this.ck, (double)(f12 * 4.5f), 2.0, (double)(f11 * 4.5f));
                this.a(this.cl, (double)(f12 * -4.5f), 2.0, (double)(f11 * -4.5f));
                if (!this.H.B && this.aJ == 0) {
                    this.b(this.H.a((Entity)this, this.ck.cD().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.b(this.H.a((Entity)this, this.cl.cD().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.c(this.H.a((Entity)this, this.e.cD().g(1.0), IEntitySelector.e));
                    this.c(this.H.a((Entity)this, this.cf.cD().g(1.0), IEntitySelector.e));
                }
                float f13 = MathHelper.a(this.dw() * ((float)Math.PI / 180) - this.bV * 0.01f);
                float f14 = MathHelper.b(this.dw() * ((float)Math.PI / 180) - this.bV * 0.01f);
                float f15 = this.fR();
                this.a(this.e, (double)(f13 * 6.5f * f8), (double)(f15 + f9 * 6.5f), (double)(-f14 * 6.5f * f8));
                this.a(this.cf, (double)(f13 * 5.5f * f8), (double)(f15 + f9 * 5.5f), (double)(-f14 * 5.5f * f8));
                double[] adouble = this.a(5, 1.0f);
                for (k2 = 0; k2 < 3; ++k2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (k2 == 0) {
                        entitycomplexpart = this.ch;
                    }
                    if (k2 == 1) {
                        entitycomplexpart = this.ci;
                    }
                    if (k2 == 2) {
                        entitycomplexpart = this.cj;
                    }
                    double[] adouble1 = this.a(12 + k2 * 2, 1.0f);
                    float f16 = this.dw() * ((float)Math.PI / 180) + this.i(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    f32 = MathHelper.a(f16);
                    f4 = MathHelper.b(f16);
                    f5 = 1.5f;
                    float f17 = (float)(k2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f11 * 1.5f + f32 * f17) * f8), adouble1[1] - adouble[1] - (double)((f17 + 1.5f) * f9) + 1.5, (double)((f12 * 1.5f + f4 * f17) * f8));
                }
                if (!this.H.B) {
                    this.bT = this.b(this.e.cD()) | this.b(this.cf.cD()) | this.b(this.cg.cD());
                    if (this.cm != null) {
                        this.cm.b(this);
                    }
                }
                for (k2 = 0; k2 < this.ce.length; ++k2) {
                    this.ce[k2].I = avec3d[k2].c;
                    this.ce[k2].J = avec3d[k2].d;
                    this.ce[k2].K = avec3d[k2].e;
                    this.ce[k2].ab = avec3d[k2].c;
                    this.ce[k2].ac = avec3d[k2].d;
                    this.ce[k2].ad = avec3d[k2].e;
                }
            }
        }
    }

    private void a(EntityComplexPart enderDragonPart, double dx, double dy, double dz) {
        enderDragonPart.e(this.dl() + dx, this.dn() + dy, this.dr() + dz);
    }

    private float fR() {
        if (this.cn.a().a()) {
            return -1.0f;
        }
        double[] adouble = this.a(5, 1.0f);
        double[] adouble1 = this.a(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void fS() {
        if (this.bW != null) {
            if (this.bW.dB()) {
                this.bW = null;
            } else if (this.ag % 10 == 0 && this.eo() < this.eE()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.c((float)((double)this.eo() + event.getAmount()));
                }
            }
        }
        if (this.af.a(10) == 0) {
            List<EntityEnderCrystal> list = this.H.a(EntityEnderCrystal.class, this.cD().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.f(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.bW = entityendercrystal;
        }
    }

    private void b(List<Entity> entities) {
        double d0 = (this.cg.cD().a + this.cg.cD().d) / 2.0;
        double d1 = (this.cg.cD().c + this.cg.cD().f) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            double d2 = entity.dl() - d0;
            double d3 = entity.dr() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0, this);
            if (this.cn.a().a() || ((EntityLiving)entity).eb() >= entity.ag - 2) continue;
            entity.a(this.dG().b(this), 5.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private void c(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            entity.a(this.dG().b(this), 10.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private float i(double yawDegrees) {
        return (float)MathHelper.d(yawDegrees);
    }

    private boolean b(AxisAlignedBB box) {
        int i2 = MathHelper.a(box.a);
        int j2 = MathHelper.a(box.b);
        int k2 = MathHelper.a(box.c);
        int l2 = MathHelper.a(box.d);
        int i1 = MathHelper.a(box.e);
        int j1 = MathHelper.a(box.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<CraftBlock> destroyedBlocks = new ArrayList<CraftBlock>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = this.H.a_(blockposition);
                    if (iblockdata.h() || iblockdata.a(TagsBlock.aA)) continue;
                    if (this.H.W().b(GameRules.c) && !iblockdata.a(TagsBlock.az)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(this.H, blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        CraftEntity bukkitEntity = this.getBukkitEntity();
        EntityExplodeEvent event = new EntityExplodeEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), destroyedBlocks, 0.0f);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.H.a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                org.bukkit.block.Block tntBlock;
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().q() ? this.H.c_(blockposition) : null;
                    LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.H).a(this.H.z).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.b).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.H, blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.H, blockposition, ItemStack.b, false);
                }
                if (!new TNTPrimeEvent(tntBlock = this.H.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.e().getBukkitEntity()).callEvent()) continue;
                nmsBlock.a(this.H, blockposition, this.explosionSource);
                this.H.a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.af.a(l2 - i2 + 1), j2 + this.af.a(i1 - j2 + 1), k2 + this.af.a(j1 - k2 + 1));
            this.H.c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(EntityComplexPart part, DamageSource source, float amount) {
        if (this.cn.a().i() == DragonControllerPhase.j) {
            return false;
        }
        amount = this.cn.a().a(source, amount);
        if (part != this.e) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (source.d() instanceof EntityHuman || source.a(DamageTypeTags.y)) {
            float f1 = this.eo();
            this.g(source, amount);
            if (this.ep() && !this.cn.a().a()) {
                this.c(1.0f);
                this.cn.a(DragonControllerPhase.j);
            }
            if (this.cn.a().a()) {
                this.cp = this.cp + f1 - this.eo();
                if (this.cp > 0.25f * this.eE()) {
                    this.cp = 0.0f;
                    this.cn.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        return !this.H.B ? this.a(this.cg, source, amount) : false;
    }

    protected boolean g(DamageSource source, float amount) {
        return super.a(source, amount);
    }

    @Override
    public void ah() {
        this.a(Entity.RemovalReason.a);
        this.a(GameEvent.q);
        if (this.cm != null) {
            this.cm.b(this);
            this.cm.a(this);
        }
    }

    @Override
    public int getExpReward() {
        boolean flag = this.H.W().b(GameRules.f);
        int short0 = 500;
        if (this.cm != null && !this.cm.d()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void dU() {
        if (this.cm != null) {
            this.cm.b(this);
        }
        ++this.bU;
        if (this.bU >= 180 && this.bU <= 200) {
            float f2 = (this.af.i() - 0.5f) * 8.0f;
            float f1 = (this.af.i() - 0.5f) * 4.0f;
            float f22 = (this.af.i() - 0.5f) * 8.0f;
            this.H.a(Particles.w, this.dl() + (double)f2, this.dn() + 2.0 + (double)f1, this.dr() + (double)f22, 0.0, 0.0, 0.0);
        }
        int short0 = this.expToDrop;
        if (this.H instanceof WorldServer) {
            if (this.bU > 150 && this.bU % 5 == 0) {
                EntityExperienceOrb.award((WorldServer)this.H, this.de(), MathHelper.d((float)short0 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.aX, this);
            }
            if (this.bU == 1 && !this.aO()) {
                int viewDistance = ((WorldServer)this.H).getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : this.H.spigotConfig.dragonDeathSoundRadius > 0 ? ((WorldServer)this.H).v() : this.H.n().ac().k) {
                    double deltaX = this.dl() - player.dl();
                    double deltaZ = this.dr() - player.dr();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (this.H.spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(this.H.spigotConfig.dragonDeathSoundRadius * this.H.spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dl() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dr() + deltaZ / deltaLength * (double)viewDistance;
                        player.b.a(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dn(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.b.a(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dl(), (int)this.dn(), (int)this.dr()), 0, true));
                }
            }
        }
        this.a(EnumMoveType.a, new Vec3D(0.0, 0.1f, 0.0));
        if (this.bU == 200 && this.H instanceof WorldServer) {
            EntityExperienceOrb.award((WorldServer)this.H, this.de(), MathHelper.d((float)short0 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.aX, this);
            if (this.cm != null) {
                this.cm.a(this);
            }
            this.a(Entity.RemovalReason.a);
            this.a(GameEvent.q);
        }
    }

    public int r() {
        if (this.cq[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    i1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(this.H.m_() + 10, this.H.a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cq[i2] = new PathPoint(k2, j1, l2);
            }
            this.cr[0] = 6146;
            this.cr[1] = 8197;
            this.cr[2] = 8202;
            this.cr[3] = 16404;
            this.cr[4] = 32808;
            this.cr[5] = 32848;
            this.cr[6] = 65696;
            this.cr[7] = 131392;
            this.cr[8] = 131712;
            this.cr[9] = 263424;
            this.cr[10] = 526848;
            this.cr[11] = 525313;
            this.cr[12] = 1581057;
            this.cr[13] = 3166214;
            this.cr[14] = 2138120;
            this.cr[15] = 6373424;
            this.cr[16] = 4358208;
            this.cr[17] = 12910976;
            this.cr[18] = 9044480;
            this.cr[19] = 9706496;
            this.cr[20] = 15216640;
            this.cr[21] = 0xD0E000;
            this.cr[22] = 11763712;
            this.cr[23] = 0x7E0000;
        }
        return this.r(this.dl(), this.dn(), this.dr());
    }

    public int r(double x2, double y2, double z2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.a(x2), MathHelper.a(y2), MathHelper.a(z2));
        int b0 = 0;
        if (this.cm == null || this.cm.c() == 0) {
            b0 = 12;
        }
        for (int j2 = b0; j2 < 24; ++j2) {
            float f1;
            if (this.cq[j2] == null || !((f1 = this.cq[j2].c(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = j2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int from, int to, @Nullable PathPoint pathNode) {
        PathPoint pathpoint1;
        for (int k2 = 0; k2 < 24; ++k2) {
            pathpoint1 = this.cq[k2];
            pathpoint1.i = false;
            pathpoint1.f = 0.0f;
            pathpoint1.g = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.cq[from];
        pathpoint1 = this.cq[to];
        pathpoint2.g = 0.0f;
        pathpoint2.f = pathpoint2.f = pathpoint2.a(pathpoint1);
        this.cs.a();
        this.cs.a(pathpoint2);
        PathPoint pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.cm == null || this.cm.c() == 0) {
            b0 = 12;
        }
        while (!this.cs.e()) {
            int i1;
            PathPoint pathpoint4 = this.cs.c();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathNode != null) {
                    pathNode.h = pathpoint1;
                    pathpoint1 = pathNode;
                }
                return this.a(pathpoint2, pathpoint1);
            }
            if (pathpoint4.a(pathpoint1) < pathpoint3.a(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.i = true;
            int l2 = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.cq[i1] != pathpoint4) {
                    continue;
                }
                l2 = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.cr[l2] & 1 << i1) <= 0) continue;
                PathPoint pathpoint5 = this.cq[i1];
                if (pathpoint5.i) continue;
                float f2 = pathpoint4.g + pathpoint4.a(pathpoint5);
                if (pathpoint5.c() && !(f2 < pathpoint5.g)) continue;
                pathpoint5.h = pathpoint4;
                pathpoint5.g = f2;
                pathpoint5.f = pathpoint5.a(pathpoint1);
                if (pathpoint5.c()) {
                    this.cs.a(pathpoint5, pathpoint5.g + pathpoint5.f);
                    continue;
                }
                pathpoint5.f = pathpoint5.g + pathpoint5.f;
                this.cs.a(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        bX.debug("Failed to find path from {} to {}", (Object)from, (Object)to);
        if (pathNode != null) {
            pathNode.h = pathpoint3;
            pathpoint3 = pathNode;
        }
        return this.a(pathpoint2, pathpoint3);
    }

    private PathEntity a(PathPoint unused, PathPoint node) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = node;
        list.add(0, node);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(node.a, node.b, node.c), true);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(cd, this.cn.a().i().b());
        nbt.a(cc, this.bU);
        nbt.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e(cd)) {
            this.cn.a(DragonControllerPhase.a(nbt.h(cd)));
        }
        if (nbt.e(cc)) {
            this.bU = nbt.h(cc);
        }
        if (nbt.e("Bukkit.expToDrop")) {
            this.expToDrop = nbt.h("Bukkit.expToDrop");
        }
    }

    @Override
    public void ds() {
    }

    public EntityComplexPart[] w() {
        return this.ce;
    }

    @Override
    public boolean bm() {
        return false;
    }

    @Override
    public SoundCategory cX() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.gP;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.gU;
    }

    @Override
    public float eN() {
        return 5.0f;
    }

    public float a(int segmentOffset, double[] segment1, double[] segment2) {
        double d0;
        IDragonController idragoncontroller = this.cn.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            d0 = idragoncontroller.a() ? (double)segmentOffset : (segmentOffset == 6 ? 0.0 : segment2[1] - segment1[1]);
        } else {
            BlockPosition blockposition = this.H.a(HeightMap.Type.f, this.getPodium());
            double d1 = Math.max(Math.sqrt(blockposition.b(this.de())) / 4.0, 1.0);
            d0 = (double)segmentOffset / d1;
        }
        return (float)d0;
    }

    public Vec3D B(float tickDelta) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cn.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f2 = this.dy();
                float f1 = 1.5f;
                this.e(-45.0f);
                vec3d = this.j(tickDelta);
                this.e(f2);
            } else {
                vec3d = this.j(tickDelta);
            }
        } else {
            BlockPosition blockposition = this.H.a(HeightMap.Type.f, this.getPodium());
            float f1 = Math.max((float)Math.sqrt(blockposition.b(this.de())) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.dy();
            float f5 = 1.5f;
            this.e(-f3 * 1.5f * 5.0f);
            vec3d = this.j(tickDelta);
            this.e(f4);
        }
        return vec3d;
    }

    public void a(EntityEnderCrystal endCrystal, BlockPosition pos, DamageSource source) {
        EntityHuman entityhuman = source.d() instanceof EntityHuman ? (EntityHuman)source.d() : this.H.a(bY, (double)pos.u(), (double)pos.v(), (double)pos.w());
        if (endCrystal == this.bW) {
            this.a(this.e, this.dG().d(endCrystal, entityhuman), 10.0f);
        }
        this.cn.a().a(endCrystal, pos, source, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (b.equals(data) && this.H.B) {
            this.cn.a(DragonControllerPhase.a(this.aj().a(b)));
        }
        super.a(data);
    }

    public DragonControllerManager fP() {
        return this.cn;
    }

    @Nullable
    public EnderDragonBattle fQ() {
        return this.cm;
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    @Override
    protected boolean l(Entity entity) {
        return false;
    }

    @Override
    public boolean co() {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        EntityComplexPart[] aentitycomplexpart = this.w();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packet.a());
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return target.eh();
    }

    @Override
    public double bv() {
        return this.cg.dd();
    }
}

