/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWither
extends EntityMonster
implements PowerableMob,
IRangedEntity {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> e = ImmutableList.of(b, c, d);
    private static final DataWatcherObject<Integer> bS = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int bT = 220;
    private final float[] bU = new float[2];
    private final float[] bV = new float[2];
    private final float[] bW = new float[2];
    private final float[] bX = new float[2];
    private final int[] bY = new int[2];
    private final int[] bZ = new int[2];
    private int ca;
    public final BossBattleServer cb = (BossBattleServer)new BossBattleServer(this.G_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final Predicate<EntityLiving> cc = entityliving -> entityliving.eJ() != EnumMonsterType.b && entityliving.fq();
    private static final PathfinderTargetCondition cd = PathfinderTargetCondition.a().a(20.0).a(cc);
    private boolean canPortal = false;

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    public EntityWither(EntityTypes<? extends EntityWither> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.bK = new ControllerMoveFlying(this, 10, false);
        this.c(this.eE());
        this.bI = 50;
    }

    @Override
    protected NavigationAbstract a(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.b(false);
        navigationflying.a(true);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    protected void x() {
        this.bN.a(0, new a());
        this.bN.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.bN.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.bN.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(7, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bO.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, cc));
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, 0);
        this.am.a(c, 0);
        this.am.a(d, 0);
        this.am.a(bS, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Invul", this.w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.r(nbt.h("Invul"));
        if (this.aa()) {
            this.cb.a(this.G_());
        }
    }

    @Override
    public void b(@Nullable IChatBaseComponent name) {
        super.b(name);
        this.cb.a(this.G_());
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.zE;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.zH;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.zG;
    }

    @Override
    public void b_() {
        int j2;
        int i2;
        Entity entity;
        Vec3D vec3d = this.dj().d(1.0, 0.6, 1.0);
        if (!this.H.B && this.s(0) > 0 && (entity = this.H.a(this.s(0))) != null) {
            double d0 = vec3d.d;
            if (this.dn() < entity.dn() || !this.a() && this.dn() < entity.dn() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3D(vec3d.c, d0, vec3d.e);
            Vec3D vec3d1 = new Vec3D(entity.dl() - this.dl(), 0.0, entity.dr() - this.dr());
            if (vec3d1.i() > 9.0) {
                Vec3D vec3d2 = vec3d1.d();
                vec3d = vec3d.b(vec3d2.c * 0.3 - vec3d.c * 0.6, 0.0, vec3d2.e * 0.3 - vec3d.e * 0.6);
            }
        }
        this.f(vec3d);
        if (vec3d.i() > 0.05) {
            this.f((float)MathHelper.d(vec3d.e, vec3d.c) * 57.295776f - 90.0f);
        }
        super.b_();
        for (i2 = 0; i2 < 2; ++i2) {
            this.bX[i2] = this.bV[i2];
            this.bW[i2] = this.bU[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int j3 = this.s(i2 + 1);
            Entity entity1 = null;
            if (j3 > 0) {
                entity1 = this.H.a(j3);
            }
            if (entity1 != null) {
                double d1 = this.t(i2 + 1);
                double d2 = this.u(i2 + 1);
                double d3 = this.v(i2 + 1);
                double d4 = entity1.dl() - d1;
                double d5 = entity1.dp() - d2;
                double d6 = entity1.dr() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f2 = (float)(MathHelper.d(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d5, d7) * 57.2957763671875));
                this.bU[i2] = this.a(this.bU[i2], f1, 40.0f);
                this.bV[i2] = this.a(this.bV[i2], f2, 10.0f);
                continue;
            }
            this.bV[i2] = this.a(this.bV[i2], this.aT, 10.0f);
        }
        boolean flag = this.a();
        for (j2 = 0; j2 < 3; ++j2) {
            double d8 = this.t(j2);
            double d9 = this.u(j2);
            double d10 = this.v(j2);
            this.H.a(Particles.ab, d8 + this.af.k() * (double)0.3f, d9 + this.af.k() * (double)0.3f, d10 + this.af.k() * (double)0.3f, 0.0, 0.0, 0.0);
            if (!flag || this.H.z.a(4) != 0) continue;
            this.H.a(Particles.v, d8 + this.af.k() * (double)0.3f, d9 + this.af.k() * (double)0.3f, d10 + this.af.k() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
        }
        if (this.w() > 0) {
            for (j2 = 0; j2 < 3; ++j2) {
                this.H.a(Particles.v, this.dl() + this.af.k(), this.dn() + (double)(this.af.i() * 3.3f), this.dr() + this.af.k(), (double)0.7f, (double)0.7f, 0.9f);
            }
        }
    }

    @Override
    protected void U() {
        if (this.w() > 0) {
            int i2 = this.w() - 1;
            this.cb.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.H.a((Entity)this, this.dl(), this.dp(), this.dr(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.aO()) {
                    int viewDistance = ((WorldServer)this.H).getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : this.H.spigotConfig.witherSpawnSoundRadius > 0 ? ((WorldServer)this.H).v() : this.H.n().ac().k) {
                        double deltaX = this.dl() - player.dl();
                        double deltaZ = this.dr() - player.dr();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        if (this.H.spigotConfig.witherSpawnSoundRadius > 0 && distanceSquared > (double)(this.H.spigotConfig.witherSpawnSoundRadius * this.H.spigotConfig.witherSpawnSoundRadius)) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dl() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dr() + deltaZ / deltaLength * (double)viewDistance;
                            player.b.a(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.dn(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.b.a(new PacketPlayOutWorldEvent(1023, this.dg(), 0, true));
                    }
                }
            }
            this.r(i2);
            if (this.ag % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int j2;
            int i3;
            super.U();
            for (i3 = 1; i3 < 3; ++i3) {
                EntityLiving entityliving1;
                if (this.ag < this.bY[i3 - 1]) continue;
                this.bY[i3 - 1] = this.ag + 10 + this.af.a(10);
                if (this.H.ah() == EnumDifficulty.c || this.H.ah() == EnumDifficulty.d) {
                    int k2 = i3 - 1;
                    int l2 = this.bZ[i3 - 1];
                    this.bZ[k2] = this.bZ[i3 - 1] + 1;
                    if (l2 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.a(this.af, this.dl() - 10.0, this.dl() + 10.0);
                        double d1 = MathHelper.a(this.af, this.dn() - 5.0, this.dn() + 5.0);
                        double d2 = MathHelper.a(this.af, this.dr() - 10.0, this.dr() + 10.0);
                        this.a(i3 + 1, d0, d1, d2, true);
                        this.bZ[i3 - 1] = 0;
                    }
                }
                if ((j2 = this.s(i3)) > 0) {
                    EntityLiving entityliving = (EntityLiving)this.H.a(j2);
                    if (entityliving != null && this.c(entityliving) && this.f((Entity)entityliving) <= 900.0 && this.B(entityliving)) {
                        this.a(i3 + 1, entityliving);
                        this.bY[i3 - 1] = this.ag + 40 + this.af.a(20);
                        this.bZ[i3 - 1] = 0;
                        continue;
                    }
                    this.a(i3, 0);
                    continue;
                }
                List<EntityLiving> list = this.H.a(EntityLiving.class, cd, this, this.cD().c(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.af.a(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(i3, entityliving1.af());
            }
            if (this.P_() != null) {
                this.a(0, this.P_().af());
            } else {
                this.a(0, 0);
            }
            if (this.ca > 0) {
                --this.ca;
                if (this.ca == 0 && this.H.W().b(GameRules.c)) {
                    i3 = MathHelper.a(this.dn());
                    j2 = MathHelper.a(this.dl());
                    int i1 = MathHelper.a(this.dr());
                    boolean flag = false;
                    for (int j1 = -1; j1 <= 1; ++j1) {
                        for (int k1 = -1; k1 <= 1; ++k1) {
                            for (int l1 = 0; l1 <= 3; ++l1) {
                                int i2 = j2 + j1;
                                int j22 = i3 + l1;
                                int k2 = i1 + k1;
                                BlockPosition blockposition = new BlockPosition(i2, j22, k2);
                                IBlockData iblockdata = this.H.a_(blockposition);
                                if (!EntityWither.c(iblockdata) || CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, iblockdata.r().g()).isCancelled()) continue;
                                flag = this.H.a(blockposition, true, this) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.H.a((EntityHuman)null, 1022, this.dg(), 0);
                    }
                }
            }
            if (this.ag % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.cb.a(this.eo() / this.eE());
        }
    }

    public static boolean c(IBlockData block) {
        return !block.h() && !block.a(TagsBlock.aB);
    }

    public void q() {
        this.r(220);
        this.cb.a(0.0f);
        this.c(this.eE() / 3.0f);
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
    }

    @Override
    public void c(EntityPlayer player) {
        super.c(player);
        this.cb.a(player);
    }

    @Override
    public void d(EntityPlayer player) {
        super.d(player);
        this.cb.b(player);
    }

    private double t(int headIndex) {
        if (headIndex <= 0) {
            return this.dl();
        }
        float f2 = (this.aT + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.b(f2);
        return this.dl() + (double)f1 * 1.3;
    }

    private double u(int headIndex) {
        return headIndex <= 0 ? this.dn() + 3.0 : this.dn() + 2.2;
    }

    private double v(int headIndex) {
        if (headIndex <= 0) {
            return this.dr();
        }
        float f2 = (this.aT + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.a(f2);
        return this.dr() + (double)f1 * 1.3;
    }

    private float a(float prevAngle, float desiredAngle, float maxDifference) {
        float f3 = MathHelper.g(desiredAngle - prevAngle);
        if (f3 > maxDifference) {
            f3 = maxDifference;
        }
        if (f3 < -maxDifference) {
            f3 = -maxDifference;
        }
        return prevAngle + f3;
    }

    private void a(int headIndex, EntityLiving target) {
        this.a(headIndex, target.dl(), target.dn() + (double)target.cE() * 0.5, target.dr(), headIndex == 0 && this.af.i() < 0.001f);
    }

    private void a(int headIndex, double targetX, double targetY, double targetZ, boolean charged) {
        if (!this.aO()) {
            this.H.a((EntityHuman)null, 1024, this.dg(), 0);
        }
        double d3 = this.t(headIndex);
        double d4 = this.u(headIndex);
        double d5 = this.v(headIndex);
        double d6 = targetX - d3;
        double d7 = targetY - d4;
        double d8 = targetZ - d5;
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.H, this, d6, d7, d8);
        entitywitherskull.b((Entity)this);
        if (charged) {
            entitywitherskull.a(true);
        }
        entitywitherskull.p(d3, d4, d5);
        this.H.b(entitywitherskull);
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.a(0, target);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!source.a(DamageTypeTags.t) && !(source.d() instanceof EntityWither)) {
            Entity entity;
            if (this.w() > 0 && !source.a(DamageTypeTags.d)) {
                return false;
            }
            if (this.a() && (entity = source.c()) instanceof EntityArrow) {
                return false;
            }
            entity = source.d();
            if (entity != null && !(entity instanceof EntityHuman) && entity instanceof EntityLiving && ((EntityLiving)entity).eJ() == this.eJ()) {
                return false;
            }
            if (this.ca <= 0) {
                this.ca = 20;
            }
            int i2 = 0;
            while (i2 < this.bZ.length) {
                int n2 = i2++;
                this.bZ[n2] = this.bZ[n2] + 3;
            }
            return super.a(source, amount);
        }
        return false;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        EntityItem entityitem = this.a((IMaterial)Items.tu);
        if (entityitem != null) {
            entityitem.s();
        }
    }

    @Override
    public void ds() {
        if (this.H.ah() == EnumDifficulty.a && this.R()) {
            this.ai();
        } else {
            this.ba = 0;
        }
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    public static AttributeProvider.Builder r() {
        return EntityMonster.fY().a(GenericAttributes.a, 300.0).a(GenericAttributes.d, 0.6f).a(GenericAttributes.e, 0.6f).a(GenericAttributes.b, 40.0).a(GenericAttributes.i, 4.0);
    }

    public float b(int headIndex) {
        return this.bV[headIndex];
    }

    public float c(int headIndex) {
        return this.bU[headIndex];
    }

    public int w() {
        return this.am.a(bS);
    }

    public void r(int ticks) {
        this.am.b(bS, ticks);
    }

    public int s(int headIndex) {
        return this.am.a(e.get(headIndex));
    }

    public void a(int headIndex, int id) {
        this.am.b(e.get(headIndex), id);
    }

    @Override
    public boolean a() {
        return this.eo() <= this.eE() / 2.0f;
    }

    @Override
    public EnumMonsterType eJ() {
        return EnumMonsterType.b;
    }

    @Override
    protected boolean l(Entity entity) {
        return false;
    }

    @Override
    public boolean co() {
        return super.co() && this.canPortal;
    }

    @Override
    public boolean c(MobEffect effect) {
        return effect.c() == MobEffects.t && this.H.paperConfig().entities.mobEffects.immuneToWitherEffect.wither ? false : super.c(effect);
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityWither.this.w() > 0;
        }
    }
}

