/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import top.leavesmc.leaves.LeavesConfig;

public class EntityArmorStand
extends EntityLiving {
    public static final int b = 5;
    private static final boolean bJ = true;
    private static final Vector3f bK = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bL = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bM = new Vector3f(-10.0f, 0.0f, -10.0f);
    private static final Vector3f bN = new Vector3f(-15.0f, 0.0f, 10.0f);
    private static final Vector3f bO = new Vector3f(-1.0f, 0.0f, -1.0f);
    private static final Vector3f bP = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize bQ = new EntitySize(0.0f, 0.0f, true);
    private static final EntitySize bR = EntityTypes.d.n().a(0.5f);
    private static final double bS = 0.1;
    private static final double bT = 0.9;
    private static final double bU = 0.4;
    private static final double bV = 1.6;
    public static final int c = 8;
    public static final int d = 16;
    public static final int e = 1;
    public static final int f = 4;
    public static final int bz = 8;
    public static final int bA = 16;
    public static final DataWatcherObject<Byte> bB = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> bC = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bD = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bE = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bF = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bG = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bH = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    private static final Predicate<Entity> bW = entity -> entity instanceof EntityMinecartAbstract && ((EntityMinecartAbstract)entity).s() == EntityMinecartAbstract.EnumMinecartType.a;
    private final NonNullList<net.minecraft.world.item.ItemStack> bX;
    private final NonNullList<net.minecraft.world.item.ItemStack> bY;
    private boolean bZ;
    public long bI;
    public int ca;
    public Vector3f cb;
    public Vector3f cc;
    public Vector3f cd;
    public Vector3f ce;
    public Vector3f cf;
    public Vector3f cg;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        if (world != null) {
            this.canTick = world.paperConfig().entities.armorStands.tick;
        }
        this.bX = NonNullList.a(2, net.minecraft.world.item.ItemStack.b);
        this.bY = NonNullList.a(4, net.minecraft.world.item.ItemStack.b);
        this.cb = bK;
        this.cc = bL;
        this.cd = bM;
        this.ce = bN;
        this.cf = bO;
        this.cg = bP;
        this.v(0.0f);
    }

    public EntityArmorStand(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.d, world);
        this.e(x2, y2, z2);
    }

    @Override
    public float getBukkitYaw() {
        return this.dw();
    }

    @Override
    public void c_() {
        double d0 = this.dl();
        double d1 = this.dn();
        double d2 = this.dr();
        super.c_();
        this.e(d0, d1, d2);
    }

    private boolean E() {
        return !this.w() && !this.aP();
    }

    @Override
    public boolean cU() {
        return super.cU() && this.E();
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bB, (byte)0);
        this.am.a(bC, bK);
        this.am.a(bD, bL);
        this.am.a(bE, bM);
        this.am.a(bF, bN);
        this.am.a(bG, bO);
        this.am.a(bH, bP);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bH() {
        return this.bX;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bI() {
        return this.bY;
    }

    @Override
    public net.minecraft.world.item.ItemStack c(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bX.get(slot.b());
            }
            case b: {
                return this.bY.get(slot.b());
            }
        }
        return net.minecraft.world.item.ItemStack.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        switch (enumitemslot.a()) {
            case a: {
                this.onEquipItem(enumitemslot, this.bX.set(enumitemslot.b(), itemstack), itemstack, silent);
                break;
            }
            case b: {
                this.onEquipItem(enumitemslot, this.bY.set(enumitemslot.b(), itemstack), itemstack, silent);
            }
        }
        this.noTickEquipmentDirty = true;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b() && !this.e(enumitemslot);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack : this.bY) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack1 : this.bX) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbt.a("HandItems", nbttaglist1);
        nbt.a("Invisible", this.ca());
        nbt.a("Small", this.q());
        nbt.a("ShowArms", this.r());
        nbt.a("DisabledSlots", this.ca);
        nbt.a("NoBasePlate", this.s());
        if (this.w()) {
            nbt.a("Marker", this.w());
        }
        nbt.a("Pose", this.G());
        if (this.canTickSetByAPI) {
            nbt.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist;
        super.a(nbt);
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.bY.size(); ++i2) {
                this.bY.set(i2, net.minecraft.world.item.ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.bX.size(); ++i2) {
                this.bX.set(i2, net.minecraft.world.item.ItemStack.a(nbttaglist.a(i2)));
            }
        }
        this.j(nbt.q("Invisible"));
        this.t(nbt.q("Small"));
        this.a(nbt.q("ShowArms"));
        this.ca = nbt.h("DisabledSlots");
        this.s(nbt.q("NoBasePlate"));
        this.u(nbt.q("Marker"));
        boolean bl = this.ae = !this.E();
        if (nbt.e("Paper.CanTickOverride")) {
            this.canTick = nbt.q("Paper.CanTickOverride");
            this.canTickSetByAPI = true;
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Pose");
        this.c(nbttagcompound1);
    }

    private void c(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.c("Head", 5);
        this.a(nbttaglist.isEmpty() ? bK : new Vector3f(nbttaglist));
        NBTTagList nbttaglist1 = nbt.c("Body", 5);
        this.b(nbttaglist1.isEmpty() ? bL : new Vector3f(nbttaglist1));
        NBTTagList nbttaglist2 = nbt.c("LeftArm", 5);
        this.c(nbttaglist2.isEmpty() ? bM : new Vector3f(nbttaglist2));
        NBTTagList nbttaglist3 = nbt.c("RightArm", 5);
        this.d(nbttaglist3.isEmpty() ? bN : new Vector3f(nbttaglist3));
        NBTTagList nbttaglist4 = nbt.c("LeftLeg", 5);
        this.e(nbttaglist4.isEmpty() ? bO : new Vector3f(nbttaglist4));
        NBTTagList nbttaglist5 = nbt.c("RightLeg", 5);
        this.f(nbttaglist5.isEmpty() ? bP : new Vector3f(nbttaglist5));
    }

    private NBTTagCompound G() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!bK.equals(this.cb)) {
            nbttagcompound.a("Head", this.cb.a());
        }
        if (!bL.equals(this.cc)) {
            nbttagcompound.a("Body", this.cc.a());
        }
        if (!bM.equals(this.cd)) {
            nbttagcompound.a("LeftArm", this.cd.a());
        }
        if (!bN.equals(this.ce)) {
            nbttagcompound.a("RightArm", this.ce.a());
        }
        if (!bO.equals(this.cf)) {
            nbttagcompound.a("LeftLeg", this.cf.a());
        }
        if (!bP.equals(this.cg)) {
            nbttagcompound.a("RightLeg", this.cg.a());
        }
        return nbttagcompound;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void A(Entity entity) {
    }

    @Override
    protected void eZ() {
        if (!this.H.paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        List<Entity> list = this.H.a((Entity)this, this.cD(), bW);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Entity entity = list.get(i2);
            if (!(this.f(entity) <= 0.2)) continue;
            entity.g(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack = player.b(hand);
        if (!this.w() && !itemstack.a(Items.tN)) {
            if (player.F_()) {
                return EnumInteractionResult.a;
            }
            if (player.H.B) {
                return EnumInteractionResult.b;
            }
            EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
            if (itemstack.b()) {
                EnumItemSlot enumitemslot2;
                EnumItemSlot enumitemslot1 = this.j(hitPos);
                EnumItemSlot enumItemSlot = enumitemslot2 = this.e(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.b(enumitemslot2) && this.a(player, enumitemslot2, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            } else {
                if (LeavesConfig.stickChangeArmorStandArmStatus && itemstack.a(Items.ox) && player.bO()) {
                    this.a(!this.r());
                }
                if (this.e(enumitemslot)) {
                    return EnumInteractionResult.e;
                }
                if (enumitemslot.a() == EnumItemSlot.Function.a && !this.r()) {
                    return EnumInteractionResult.e;
                }
                if (this.a(player, enumitemslot, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot j(Vec3D hitPos) {
        EnumItemSlot enumitemslot = EnumItemSlot.a;
        boolean flag = this.q();
        double d0 = flag ? hitPos.d * 2.0 : hitPos.d;
        EnumItemSlot enumitemslot1 = EnumItemSlot.c;
        if (d0 >= 0.1) {
            double d2 = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d2 && this.b(enumitemslot1)) {
                return EnumItemSlot.c;
            }
        }
        double d3 = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d3) {
            double d4 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d4 && this.b(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d0 >= 0.4) {
            double d5 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d5 && this.b(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d0 >= 1.6 && this.b(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.b(EnumItemSlot.a)) return enumitemslot;
        if (!this.b(EnumItemSlot.b)) return enumitemslot;
        return EnumItemSlot.b;
    }

    public boolean e(EnumItemSlot slot) {
        return (this.ca & 1 << slot.c()) != 0 || slot.a() == EnumItemSlot.Function.a && !this.r();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.c(slot);
        if (!itemstack1.b() && (this.ca & 1 << slot.c() + 8) != 0) {
            return false;
        }
        if (itemstack1.b() && (this.ca & 1 << slot.c() + 16) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.H.getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.fK().d && itemstack1.b() && !stack.b()) {
            net.minecraft.world.item.ItemStack itemstack2 = stack.o();
            itemstack2.f(1);
            this.a(slot, itemstack2);
            return true;
        }
        if (!stack.b() && stack.K() > 1) {
            if (!itemstack1.b()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack2 = stack.o();
            itemstack2.f(1);
            this.a(slot, itemstack2);
            stack.h(1);
            return true;
        }
        this.a(slot, stack);
        player.a(hand, itemstack1);
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!this.H.B && !this.dB()) {
            if (source.a(DamageTypeTags.d)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
                    return false;
                }
                this.ah();
                return false;
            }
            if (!this.b(source) && !this.w()) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, true, this.bZ)) {
                    return false;
                }
                if (source.a(DamageTypeTags.l)) {
                    this.brokenByAnything(source);
                    this.ah();
                    return false;
                }
                if (source.a(DamageTypeTags.u)) {
                    if (this.bK()) {
                        this.g(source, 0.15f);
                    } else {
                        this.f(5);
                    }
                    return false;
                }
                if (source.a(DamageTypeTags.v) && this.eo() > 0.5f) {
                    this.g(source, 4.0f);
                    return false;
                }
                boolean flag = source.c() instanceof EntityArrow;
                boolean flag1 = flag && ((EntityArrow)source.c()).t() > 0;
                boolean flag2 = "player".equals(source.e());
                if (!flag2 && !flag) {
                    return false;
                }
                Entity entity = source.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman entityhuman = (EntityHuman)entity;
                    if (!entityhuman.fK().e) {
                        return false;
                    }
                }
                if (source.g()) {
                    this.J();
                    this.I();
                    this.ah();
                    return flag1;
                }
                long i2 = this.H.U();
                if (i2 - this.bI > 5L && !flag) {
                    this.H.a((Entity)this, (byte)32);
                    this.a(GameEvent.p, source.d());
                    this.bI = i2;
                } else {
                    EntityDeathEvent event = this.brokenByPlayer(source);
                    this.I();
                    if (!event.isCancelled()) {
                        this.ai();
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void b(byte status) {
        if (status == 32) {
            if (this.H.B) {
                this.H.a(this.dl(), this.dn(), this.dr(), SoundEffects.am, this.cX(), 0.3f, 1.0f, false);
                this.bI = this.H.U();
            }
        } else {
            super.b(status);
        }
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cD().a() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    private void I() {
        if (this.H instanceof WorldServer) {
            ((WorldServer)this.H).a(new ParticleParamBlock(Particles.c, Blocks.n.o()), this.dl(), this.e(0.6666666666666666), this.dr(), 10, (double)(this.dc() / 4.0f), (double)(this.dd() / 4.0f), (double)(this.dc() / 4.0f), 0.05);
        }
    }

    private void g(DamageSource damageSource, float amount) {
        float f1 = this.eo();
        if ((f1 -= amount) <= 0.5f) {
            this.brokenByAnything(damageSource);
            this.ah();
        } else {
            this.c(f1);
            this.a(GameEvent.p, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(Items.tH);
        if (this.aa()) {
            itemstack.a(this.ab());
        }
        this.drops.add(CraftItemStack.asBukkitCopy(itemstack));
        return this.brokenByAnything(damageSource);
    }

    private EntityDeathEvent brokenByAnything(DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack;
        int i2;
        this.J();
        for (i2 = 0; i2 < this.bX.size(); ++i2) {
            itemstack = this.bX.get(i2);
            if (itemstack.b()) continue;
            this.drops.add(CraftItemStack.asCraftMirror(itemstack));
            this.bX.set(i2, net.minecraft.world.item.ItemStack.b);
        }
        for (i2 = 0; i2 < this.bY.size(); ++i2) {
            itemstack = this.bY.get(i2);
            if (itemstack.b()) continue;
            this.drops.add(CraftItemStack.asCraftMirror(itemstack));
            this.bY.set(i2, net.minecraft.world.item.ItemStack.b);
        }
        return this.dropAllDeathLoot(damageSource);
    }

    private void J() {
        this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), SoundEffects.ak, this.cX(), 1.0f, 1.0f);
    }

    @Override
    protected float e(float bodyRotation, float headRotation) {
        this.aU = this.L;
        this.aT = this.dw();
        return 0.0f;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * (this.y_() ? 0.5f : 0.9f);
    }

    @Override
    public double bu() {
        return this.w() ? 0.0 : (double)0.1f;
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.E()) {
            super.h(movementInput);
        }
    }

    @Override
    public void s(float bodyYaw) {
        this.aU = this.L = bodyYaw;
        this.aW = this.aV = bodyYaw;
    }

    @Override
    public void r(float headYaw) {
        this.aU = this.L = headYaw;
        this.aW = this.aV = headYaw;
    }

    @Override
    public void l() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.z();
            }
            return;
        }
        super.l();
        this.updatePose();
    }

    public void updatePose() {
        Vector3f vector3f5;
        Vector3f vector3f4;
        Vector3f vector3f3;
        Vector3f vector3f2;
        Vector3f vector3f1;
        Vector3f vector3f = this.am.a(bC);
        if (!this.cb.equals(vector3f)) {
            this.a(vector3f);
        }
        if (!this.cc.equals(vector3f1 = this.am.a(bD))) {
            this.b(vector3f1);
        }
        if (!this.cd.equals(vector3f2 = this.am.a(bE))) {
            this.c(vector3f2);
        }
        if (!this.ce.equals(vector3f3 = this.am.a(bF))) {
            this.d(vector3f3);
        }
        if (!this.cf.equals(vector3f4 = this.am.a(bG))) {
            this.e(vector3f4);
        }
        if (!this.cg.equals(vector3f5 = this.am.a(bH))) {
            this.f(vector3f5);
        }
    }

    @Override
    protected void F() {
        this.j(this.bZ);
    }

    @Override
    public void j(boolean invisible) {
        this.bZ = invisible;
        super.j(invisible);
    }

    @Override
    public boolean y_() {
        return this.q();
    }

    @Override
    public boolean dV() {
        return true;
    }

    @Override
    public void ah() {
        EntityDeathEvent event = CraftEventFactory.callEntityDeathEvent(this, this.drops);
        if (event.isCancelled()) {
            return;
        }
        this.a(Entity.RemovalReason.a);
        this.a(GameEvent.q);
    }

    @Override
    public boolean cI() {
        return this.ca();
    }

    @Override
    public EnumPistonReaction C_() {
        return this.w() ? EnumPistonReaction.d : super.C_();
    }

    public void t(boolean small) {
        this.am.b(bB, this.a(this.am.a(bB), 1, small));
    }

    public boolean q() {
        return (this.am.a(bB) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.am.b(bB, this.a(this.am.a(bB), 4, showArms));
    }

    public boolean r() {
        return (this.am.a(bB) & 4) != 0;
    }

    public void s(boolean hideBasePlate) {
        this.am.b(bB, this.a(this.am.a(bB), 8, hideBasePlate));
    }

    public boolean s() {
        return (this.am.a(bB) & 8) != 0;
    }

    public void u(boolean marker) {
        this.am.b(bB, this.a(this.am.a(bB), 16, marker));
    }

    public boolean w() {
        return (this.am.a(bB) & 0x10) != 0;
    }

    private byte a(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public void a(Vector3f angle) {
        this.cb = angle;
        this.am.b(bC, angle);
        this.noTickPoseDirty = true;
    }

    public void b(Vector3f angle) {
        this.cc = angle;
        this.am.b(bD, angle);
        this.noTickPoseDirty = true;
    }

    public void c(Vector3f angle) {
        this.cd = angle;
        this.am.b(bE, angle);
        this.noTickPoseDirty = true;
    }

    public void d(Vector3f angle) {
        this.ce = angle;
        this.am.b(bF, angle);
        this.noTickPoseDirty = true;
    }

    public void e(Vector3f angle) {
        this.cf = angle;
        this.am.b(bG, angle);
        this.noTickPoseDirty = true;
    }

    public void f(Vector3f angle) {
        this.cg = angle;
        this.am.b(bH, angle);
        this.noTickPoseDirty = true;
    }

    public Vector3f x() {
        return this.cb;
    }

    public Vector3f y() {
        return this.cc;
    }

    public Vector3f z() {
        return this.cd;
    }

    public Vector3f A() {
        return this.ce;
    }

    public Vector3f C() {
        return this.cf;
    }

    public Vector3f D() {
        return this.cg;
    }

    @Override
    public boolean bm() {
        return super.bm() && !this.w();
    }

    @Override
    public boolean r(Entity attacker) {
        return attacker instanceof EntityHuman && !this.H.a((EntityHuman)attacker, this.dg());
    }

    @Override
    public EnumMainHand fd() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a ey() {
        return new EntityLiving.a(SoundEffects.al, SoundEffects.al);
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.am;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.ak;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public boolean fp() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bB.equals(data)) {
            this.c_();
            this.F = !this.w();
        }
        super.a(data);
    }

    @Override
    public boolean fq() {
        return false;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return this.v(this.w());
    }

    private EntitySize v(boolean marker) {
        return marker ? bQ : (this.y_() ? bR : this.ae().n());
    }

    @Override
    public Vec3D o(float tickDelta) {
        if (this.w()) {
            AxisAlignedBB axisalignedbb = this.v(false).a(this.de());
            BlockPosition blockposition = this.dg();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockposition1 : BlockPosition.a(BlockPosition.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c), BlockPosition.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.f))) {
                int j2 = Math.max(this.H.a(EnumSkyBlock.b, blockposition1), this.H.a(EnumSkyBlock.a, blockposition1));
                if (j2 == 15) {
                    return Vec3D.b(blockposition1);
                }
                if (j2 <= i2) continue;
                i2 = j2;
                blockposition = blockposition1.i();
            }
            return Vec3D.b(blockposition);
        }
        return super.o(tickDelta);
    }

    @Override
    public net.minecraft.world.item.ItemStack dt() {
        return new net.minecraft.world.item.ItemStack(Items.tH);
    }

    @Override
    public boolean ei() {
        return !this.ca() && !this.w();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }

    @Override
    public boolean dK() {
        return true;
    }
}

