/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger f = LogUtils.getLogger();
    private IBlockData g = Blocks.I.o();
    public int b;
    public boolean c = true;
    private boolean h;
    public boolean i;
    public int j = 40;
    public float k;
    @Nullable
    public NBTTagCompound d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.n);
    public boolean autoExpire = false;

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> type, World world) {
        super(type, world);
    }

    public EntityFallingBlock(World world, double x2, double y2, double z2, IBlockData block) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.L, world);
        this.g = block;
        this.F = true;
        this.e(x2, y2, z2);
        this.f(Vec3D.b);
        this.I = x2;
        this.J = y2;
        this.K = z2;
        this.a(this.dg());
    }

    public static EntityFallingBlock a(World world, BlockPosition pos, IBlockData state) {
        return EntityFallingBlock.fall(world, pos, state, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static EntityFallingBlock fall(World world, BlockPosition blockposition, IBlockData iblockdata, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, iblockdata.b(BlockProperties.C) ? (IBlockData)iblockdata.a(BlockProperties.C, false) : iblockdata);
        if (CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, blockposition, iblockdata.r().g()).isCancelled()) {
            return entityfallingblock;
        }
        world.a(blockposition, iblockdata.r().g(), 3);
        world.addFreshEntity(entityfallingblock, spawnReason);
        return entityfallingblock;
    }

    @Override
    public boolean cl() {
        return false;
    }

    public void a(BlockPosition pos) {
        this.am.b(e, pos);
    }

    public BlockPosition i() {
        return this.am.a(e);
    }

    @Override
    protected Entity.MovementEmission aQ() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.am.a(e, BlockPosition.b);
    }

    @Override
    public boolean bm() {
        return !this.dB();
    }

    @Override
    public void l() {
        if (this.g.h()) {
            this.ai();
        } else {
            Block block = this.g.b();
            ++this.b;
            if (!this.aP()) {
                this.f(this.dj().b(0.0, -0.04, 0.0));
            }
            this.a(EnumMoveType.a, this.dj());
            if (this.H.paperConfig().fixes.fallingBlockHeightNerf.test(v2 -> this.dn() > (double)v2)) {
                if (this.c && this.H.W().b(GameRules.h)) {
                    this.a(block);
                }
                this.ai();
                return;
            }
            if (!this.H.B) {
                MovingObjectPositionBlock movingobjectpositionblock;
                BlockPosition blockposition = this.dg();
                boolean flag = this.g.b() instanceof BlockConcretePowder;
                boolean flag1 = flag && this.H.b_(blockposition).a(TagsFluid.a);
                double d0 = this.dj().g();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.H.a(new RayTrace(new Vec3D(this.I, this.J, this.K), this.de(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).c() != MovingObjectPosition.EnumMovingObjectType.a && this.H.b_(movingobjectpositionblock.a()).a(TagsFluid.a)) {
                    blockposition = movingobjectpositionblock.a();
                    flag1 = true;
                }
                if (!this.N && !flag1) {
                    if (!this.H.B && (this.b > 100 && this.autoExpire && (blockposition.v() <= this.H.v_() || blockposition.v() > this.H.ai()) || this.b > 600 && this.autoExpire)) {
                        if (this.c && this.H.W().b(GameRules.h)) {
                            this.a(block);
                        }
                        this.ai();
                    }
                } else {
                    IBlockData iblockdata = this.H.a_(blockposition);
                    this.f(this.dj().d(0.7, -0.5, 0.7));
                    if (!iblockdata.a(Blocks.bP)) {
                        if (!this.h) {
                            boolean flag4;
                            boolean flag2 = iblockdata.a(new BlockActionContextDirectional(this.H, blockposition, EnumDirection.a, ItemStack.b, EnumDirection.b));
                            boolean flag3 = BlockFalling.h(this.H.a_(blockposition.d())) && (!flag || !flag1);
                            boolean bl = flag4 = this.g.a((IWorldReader)this.H, blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.g.b(BlockProperties.C) && this.H.b_(blockposition).a() == FluidTypes.c) {
                                    this.g = (IBlockData)this.g.a(BlockProperties.C, true);
                                }
                                if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.g).isCancelled()) {
                                    this.ai();
                                    return;
                                }
                                if (this.H.a(blockposition, this.g, 3)) {
                                    TileEntity tileentity;
                                    ((WorldServer)this.H).k().a.a(this, new PacketPlayOutBlockChange(blockposition, this.H.a_(blockposition)));
                                    this.ai();
                                    if (block instanceof Fallable) {
                                        ((Fallable)((Object)block)).a(this.H, blockposition, this.g, iblockdata, this);
                                    }
                                    if (this.d != null && this.g.q() && (tileentity = this.H.c_(blockposition)) != null) {
                                        NBTTagCompound nbttagcompound = tileentity.o();
                                        for (String s2 : this.d.e()) {
                                            nbttagcompound.a(s2, this.d.c(s2).d());
                                        }
                                        try {
                                            tileentity.a(nbttagcompound);
                                        }
                                        catch (Exception exception) {
                                            f.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.e();
                                    }
                                } else if (this.c && this.H.W().b(GameRules.h)) {
                                    this.ai();
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            } else {
                                this.ai();
                                if (this.c && this.H.W().b(GameRules.h)) {
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            }
                        } else {
                            this.ai();
                            this.a(block, blockposition);
                        }
                    }
                }
            }
            this.f(this.dj().a(0.98));
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.H, pos, this);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        DamageSource damagesource1;
        Predicate<Entity> predicate;
        if (!this.i) {
            return false;
        }
        int i2 = MathHelper.f(fallDistance - 1.0f);
        if (i2 < 0) {
            return false;
        }
        if (this.g.b() instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)this.g.b());
            predicate = fallable.al_();
            damagesource1 = fallable.a(this);
        } else {
            predicate = IEntitySelector.f;
            damagesource1 = this.dG().a(this);
        }
        float f2 = Math.min(MathHelper.d((float)i2 * this.k), this.j);
        this.H.a((Entity)this, this.cD(), predicate).forEach(entity -> {
            CraftEventFactory.entityDamage = this;
            entity.a(damagesource1, f2);
            CraftEventFactory.entityDamage = null;
        });
        boolean flag = this.g.a(TagsBlock.L);
        if (flag && f2 > 0.0f && this.af.i() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.e(this.g);
            if (iblockdata == null) {
                this.h = true;
            } else {
                this.g = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("BlockState", GameProfileSerializer.a(this.g));
        nbt.a("Time", this.b);
        nbt.a("DropItem", this.c);
        nbt.a("HurtEntities", this.i);
        nbt.a("FallHurtAmount", this.k);
        nbt.a("FallHurtMax", this.j);
        if (this.d != null) {
            nbt.a("TileEntityData", this.d);
        }
        if (!this.autoExpire) {
            nbt.a("Paper.AutoExpire", false);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.g = GameProfileSerializer.a(this.H.a(Registries.e), nbt.p("BlockState"));
        this.b = nbt.h("Time");
        if (nbt.b("HurtEntities", 99)) {
            this.i = nbt.q("HurtEntities");
            this.k = nbt.j("FallHurtAmount");
            this.j = nbt.h("FallHurtMax");
        } else if (this.g.a(TagsBlock.L)) {
            this.i = true;
        }
        if (nbt.b("DropItem", 99)) {
            this.c = nbt.q("DropItem");
        }
        if (!(!nbt.b("TileEntityData", 10) || this.H.paperConfig().entities.spawning.filterBadTileEntityNbtFromFallingBlocks && this.g.b() instanceof GameMasterBlock)) {
            this.d = nbt.p("TileEntityData");
        }
        if (this.g.h()) {
            this.g = Blocks.I.o();
        }
        if (nbt.e("SourceLoc_x")) {
            int srcX = nbt.h("SourceLoc_x");
            int srcY = nbt.h("SourceLoc_y");
            int srcZ = nbt.h("SourceLoc_z");
            this.setOrigin(new Location((org.bukkit.World)this.H.getWorld(), (double)srcX, (double)srcY, (double)srcZ));
        }
        if (nbt.e("Paper.AutoExpire")) {
            this.autoExpire = nbt.q("Paper.AutoExpire");
        }
    }

    public void b(float fallHurtAmount, int fallHurtMax) {
        this.i = true;
        this.k = fallHurtAmount;
        this.j = fallHurtMax;
    }

    public void j() {
        this.h = true;
    }

    @Override
    public boolean cr() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails section) {
        super.a(section);
        section.a("Immitating BlockState", this.g.toString());
    }

    public IBlockData k() {
        return this.g;
    }

    @Override
    protected IChatBaseComponent cj() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.g.b().f());
    }

    @Override
    public boolean cJ() {
        return true;
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntity(this, Block.i(this.k()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.g = Block.a(packet.n());
        this.F = true;
        double d0 = packet.e();
        double d1 = packet.f();
        double d2 = packet.g();
        this.e(d0, d1, d2);
        this.a(this.dg());
    }
}

