/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ShulkerBoxUtils;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final int d = 6000;
    private static final int e = Short.MAX_VALUE;
    private static final int f = Short.MIN_VALUE;
    public int g;
    public int h;
    public int i = 5;
    @Nullable
    public UUID j;
    @Nullable
    public UUID k;
    public final float b;
    private int lastTick = MinecraftServer.currentTick - 1;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public EntityItem(EntityTypes<? extends EntityItem> type, World world) {
        super(type, world);
        this.b = this.af.i() * (float)Math.PI * 2.0f;
        this.f(this.af.i() * 360.0f);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ad, world);
        ItemBlock bi;
        Item item;
        this.e(x2, y2, z2);
        this.o(this.af.j() * 0.2 - 0.1, 0.2, this.af.j() * 0.2 - 0.1);
        this.a(stack);
        if (LeavesConfig.shulkerBoxStackSize > 1 && (item = stack.c()) instanceof ItemBlock && (bi = (ItemBlock)item).e() instanceof BlockShulkerBox) {
            ShulkerBoxUtils.cleanUpShulkerBoxTag(stack);
        }
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ad, world);
        this.e(x2, y2, z2);
        this.o(velocityX, velocityY, velocityZ);
        this.a(stack);
    }

    private EntityItem(EntityItem entity) {
        super(entity.ae(), entity.H);
        this.a(entity.i().o());
        this.s(entity);
        this.g = entity.g;
        this.b = entity.b;
    }

    @Override
    public boolean aR() {
        return this.i().a(TagsItem.aA);
    }

    @Override
    @Nullable
    public Entity v() {
        World world;
        if (this.j != null && (world = this.H) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return worldserver.a(this.j);
        }
        return null;
    }

    @Override
    protected Entity.MovementEmission aQ() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.aj().a(c, ItemStack.b);
    }

    @Override
    public void l() {
        if (this.i().b()) {
            this.ai();
        } else {
            double d0;
            int i2;
            super.l();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.h != Short.MAX_VALUE) {
                this.h -= elapsedTicks;
            }
            this.h = Math.max(0, this.h);
            if (this.g != Short.MIN_VALUE) {
                this.g += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.I = this.dl();
            this.J = this.dn();
            this.K = this.dr();
            Vec3D vec3d = this.dj();
            float f2 = this.cE() - 0.11111111f;
            if (this.aT() && this.b(TagsFluid.a) > (double)f2) {
                this.x();
            } else if (this.bg() && this.b(TagsFluid.b) > (double)f2) {
                this.y();
            } else if (!this.aP()) {
                this.f(this.dj().b(0.0, -0.04, 0.0));
            }
            if (this.H.B) {
                this.ae = false;
            } else {
                boolean bl = this.ae = !this.H.a((Entity)this, this.cD().h(1.0E-7));
                if (this.ae) {
                    this.m(this.dl(), (this.cD().b + this.cD().e) / 2.0, this.dr());
                }
            }
            if (!this.N || this.dj().i() > (double)1.0E-5f || (this.ag + this.af()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dj());
                float f1 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f1 = 1.0f;
                } else if (this.N) {
                    f1 = this.H.a_(BlockPosition.a(this.dl(), this.dn() - 1.0, this.dr())).b().i() * 0.98f;
                }
                this.f(this.dj().d(f1, 0.98, f1));
                if (this.N) {
                    Vec3D vec3d1 = this.dj();
                    if (vec3d1.d < 0.0) {
                        this.f(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.I) != MathHelper.a(this.dl()) || MathHelper.a(this.J) != MathHelper.a(this.dn()) || MathHelper.a(this.K) != MathHelper.a(this.dr());
            int n2 = i2 = flag ? 2 : 40;
            if (this.ag % i2 == 0 && !this.H.B && this.A()) {
                this.z();
            }
            this.at |= this.aZ();
            if (!this.H.B && (d0 = this.dj().d(vec3d).g()) > 0.01) {
                this.at = true;
            }
            if (!this.H.B && this.g >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.g = 0;
                    return;
                }
                this.ai();
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.h != Short.MAX_VALUE) {
            this.h -= elapsedTicks;
        }
        this.h = Math.max(0, this.h);
        if (this.g != Short.MIN_VALUE) {
            this.g += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.H.B && this.g >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.g = 0;
                return;
            }
            this.ai();
        }
    }

    private void x() {
        Vec3D vec3d = this.dj();
        this.o(vec3d.c * (double)0.99f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.99f);
    }

    private void y() {
        Vec3D vec3d = this.dj();
        this.o(vec3d.c * (double)0.95f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.95f);
    }

    private void z() {
        if (this.A()) {
            double radius = this.H.spigotConfig.itemMerge;
            List<EntityItem> list = this.H.a(EntityItem.class, this.cD().c(radius, radius - 0.5, radius), (? super T entityitem) -> entityitem != this && entityitem.A());
            for (EntityItem entityitem2 : list) {
                RayTrace rayTrace;
                MovingObjectPositionBlock rayTraceResult;
                if (!entityitem2.A() || this.H.paperConfig().fixes.fixItemsMergingThroughWalls && (rayTraceResult = this.H.a(rayTrace = new RayTrace(this.de(), entityitem2.de(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this))).c() == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(entityitem2);
                if (!this.dB()) continue;
                break;
            }
        }
    }

    private boolean A() {
        ItemStack itemstack = this.i();
        return this.bq() && this.h != Short.MAX_VALUE && this.g != Short.MIN_VALUE && this.g < this.despawnRate && itemstack.K() < ShulkerBoxUtils.getItemStackMaxCount(itemstack);
    }

    private boolean tryStackShulkerBoxes(EntityItem other) {
        ItemBlock bi;
        Item item;
        ItemStack selfStack = this.i();
        if (LeavesConfig.shulkerBoxStackSize == 1 || !((item = selfStack.c()) instanceof ItemBlock) || !((bi = (ItemBlock)item).e() instanceof BlockShulkerBox)) {
            return false;
        }
        ItemStack otherStack = other.i();
        if (selfStack.c() == otherStack.c() && !ShulkerBoxUtils.shulkerBoxHasItems(selfStack) && !ShulkerBoxUtils.shulkerBoxHasItems(otherStack) && Objects.equals(selfStack.u(), otherStack.u()) && selfStack.K() != LeavesConfig.shulkerBoxStackSize) {
            int amount = Math.min(otherStack.K(), LeavesConfig.shulkerBoxStackSize - selfStack.K());
            selfStack.g(amount);
            this.a(selfStack);
            this.h = Math.max(other.h, this.h);
            this.g = Math.min(other.j(), this.g);
            otherStack.h(amount);
            if (otherStack.b()) {
                other.ai();
            } else {
                other.a(otherStack);
            }
            return true;
        }
        return false;
    }

    private void a(EntityItem other) {
        if (this.tryStackShulkerBoxes(other)) {
            return;
        }
        ItemStack itemstack = this.i();
        ItemStack itemstack1 = other.i();
        if (Objects.equals(this.k, other.k) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, other, itemstack1);
        }
    }

    public static boolean a(ItemStack stack1, ItemStack stack2) {
        return !stack2.a(stack1.c()) ? false : (stack2.K() + stack1.K() > stack2.f() ? false : (stack2.t() ^ stack1.t() ? false : !stack2.t() || stack2.u().equals(stack1.u())));
    }

    public static ItemStack a(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j2 = Math.min(Math.min(stack1.f(), maxCount) - stack1.K(), stack2.K());
        ItemStack itemstack2 = stack1.o();
        itemstack2.g(j2);
        stack2.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = EntityItem.a(stack1, stack2, 64);
        if (!itemstack2.b()) {
            targetEntity.a(itemstack2);
        }
    }

    private static void a(EntityItem targetEntity, ItemStack targetStack, EntityItem sourceEntity, ItemStack sourceStack) {
        if (CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity).isCancelled()) {
            return;
        }
        EntityItem.a(targetEntity, targetStack, sourceStack);
        targetEntity.h = Math.max(targetEntity.h, sourceEntity.h);
        targetEntity.g = Math.min(targetEntity.g, sourceEntity.g);
        if (sourceStack.b()) {
            sourceEntity.ai();
        }
    }

    @Override
    public boolean aS() {
        return this.i().c().w() || super.aS();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.i().b() && this.i().a(Items.tu) && source.a(DamageTypeTags.l)) {
            return false;
        }
        if (!this.i().c().a(source)) {
            return false;
        }
        if (this.H.B) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.bj();
        this.i = (int)((float)this.i - amount);
        this.a(GameEvent.p, source.d());
        if (this.i <= 0) {
            this.i().a(this);
            this.ai();
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", (short)this.i);
        nbt.a("Age", (short)this.g);
        nbt.a("PickupDelay", (short)this.h);
        if (this.j != null) {
            nbt.a("Thrower", this.j);
        }
        if (this.k != null) {
            nbt.a("Owner", this.k);
        }
        if (!this.i().b()) {
            nbt.a("Item", this.i().b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.i = nbt.g("Health");
        this.g = nbt.g("Age");
        if (nbt.e("PickupDelay")) {
            this.h = nbt.g("PickupDelay");
        }
        if (nbt.b("Owner")) {
            this.k = nbt.a("Owner");
        }
        if (nbt.b("Thrower")) {
            this.j = nbt.a("Thrower");
        }
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + this);
            }
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Item");
        this.a(ItemStack.a(nbttagcompound1));
        if (this.i().b()) {
            this.ai();
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (!this.H.B) {
            ItemStack itemstack = this.i();
            Item item = itemstack.c();
            int i2 = itemstack.K();
            int canHold = player.fJ().canHold(itemstack);
            int remaining = i2 - canHold;
            boolean flyAtPlayer = false;
            if (this.h <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.H.getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
            }
            if (this.h <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.f(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.H.getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.f(i2);
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.H.getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.f(i2);
                    return;
                }
                ItemStack current = this.i();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.f(canHold + remaining);
                }
                this.h = 0;
            } else if (this.h == 0) {
                this.h = -1;
            }
            if (this.h == 0 && (this.k == null || this.k.equals(player.cs())) && player.fJ().e(itemstack)) {
                if (flyAtPlayer) {
                    player.a((Entity)this, i2);
                }
                if (itemstack.b()) {
                    this.ai();
                    itemstack.f(i2);
                }
                player.a(StatisticList.e.b(item), i2);
                player.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent Z() {
        IChatBaseComponent ichatbasecomponent = this.ab();
        return ichatbasecomponent != null ? ichatbasecomponent : IChatBaseComponent.c(this.i().p());
    }

    @Override
    public boolean cl() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        Entity entity = super.b(destination);
        if (!this.H.B && entity instanceof EntityItem) {
            ((EntityItem)entity).z();
        }
        return entity;
    }

    public ItemStack i() {
        return this.aj().a(c);
    }

    public void a(ItemStack stack) {
        this.aj().b(c, stack);
        this.aj().markDirty(c);
        this.despawnRate = this.H.paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.H.paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.c(), this.H.spigotConfig.itemDespawnRate) : this.H.spigotConfig.itemDespawnRate;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (c.equals(data)) {
            this.i().a((Entity)this);
        }
    }

    public void b(@Nullable UUID owner) {
        this.k = owner;
    }

    public void c(@Nullable UUID thrower) {
        this.j = thrower;
    }

    public int j() {
        return this.g;
    }

    public void k() {
        this.h = 10;
    }

    public void o() {
        this.h = 0;
    }

    public void p() {
        this.h = Short.MAX_VALUE;
    }

    public void b(int pickupDelay) {
        this.h = pickupDelay;
    }

    public boolean q() {
        return this.h > 0;
    }

    public void r() {
        this.g = Short.MIN_VALUE;
    }

    public void s() {
        this.g = -6000;
    }

    public void t() {
        this.p();
        this.g = this.despawnRate - 1;
    }

    public float a(float tickDelta) {
        return ((float)this.j() + tickDelta) / 20.0f + this.b;
    }

    public EntityItem w() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory cX() {
        return SoundCategory.i;
    }

    @Override
    public float dx() {
        return 180.0f - this.a(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }
}

