/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster
implements PowerableMob {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private int e;
    public int bS;
    public int bT = 30;
    public int bU = 3;
    private int bV;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void x() {
        this.bN.a(1, new PathfinderGoalFloat(this));
        this.bN.a(2, new PathfinderGoalSwell(this));
        this.bN.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bN.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bN.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bN.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bN.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(6, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bO.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fY().a(GenericAttributes.d, 0.25);
    }

    @Override
    public int cp() {
        return this.P_() == null ? 3 : 3 + (int)(this.eo() - 1.0f);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        this.bS += (int)(fallDistance * 1.5f);
        if (this.bS > this.bT - 5) {
            this.bS = this.bT - 5;
        }
        return flag;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, -1);
        this.am.a(c, false);
        this.am.a(d, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.am.a(c).booleanValue()) {
            nbt.a("powered", true);
        }
        nbt.a("Fuse", (short)this.bT);
        nbt.a("ExplosionRadius", (byte)this.bU);
        nbt.a("ignited", this.w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.am.b(c, nbt.q("powered"));
        if (nbt.b("Fuse", 99)) {
            this.bT = nbt.g("Fuse");
        }
        if (nbt.b("ExplosionRadius", 99)) {
            this.bU = nbt.f("ExplosionRadius");
        }
        if (nbt.q("ignited")) {
            this.am.b(d, true);
        }
    }

    @Override
    public void l() {
        if (this.bq()) {
            int i2;
            this.e = this.bS;
            if (this.w()) {
                this.b(1);
            }
            if ((i2 = this.r()) > 0 && this.bS == 0) {
                this.a(SoundEffects.fc, 1.0f, 0.5f);
                this.a(GameEvent.M);
            }
            this.bS += i2;
            if (this.bS < 0) {
                this.bS = 0;
            }
            if (this.bS >= this.bT) {
                this.bS = this.bT;
                this.fV();
            }
        }
        super.l();
    }

    @Override
    public void i(@Nullable EntityLiving target) {
        if (!(target instanceof Goat)) {
            super.i(target);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.fb;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.fa;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        EntityCreeper entitycreeper;
        super.a(source, lootingMultiplier, allowDrops);
        Entity entity = source.d();
        if (entity != this && entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).fT()) {
            entitycreeper.fU();
            this.a((IMaterial)Items.tr);
        }
    }

    @Override
    public boolean z(Entity target) {
        return true;
    }

    @Override
    public boolean a() {
        return this.am.a(c);
    }

    public float C(float timeDelta) {
        return MathHelper.i(timeDelta, this.e, this.bS) / (float)(this.bT - 2);
    }

    public int r() {
        return this.am.a(b);
    }

    public void b(int fuseSpeed) {
        this.am.b(b, fuseSpeed);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        super.a(world, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.setPowered(true);
    }

    public void setPowered(boolean powered) {
        this.am.b(c, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(TagsItem.aE)) {
            SoundEffect soundeffect = itemstack.a(Items.tb) ? SoundEffects.hz : SoundEffects.hO;
            this.H.a(player, this.dl(), this.dn(), this.dr(), soundeffect, this.cX(), 1.0f, this.af.i() * 0.4f + 0.8f);
            if (!this.H.B) {
                this.fS();
                if (!itemstack.h()) {
                    itemstack.h(1);
                } else {
                    itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
                }
            }
            return EnumInteractionResult.a(this.H.B);
        }
        return super.b(player, hand);
    }

    public void fV() {
        if (!this.H.B) {
            float f2 = this.a() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)this.bU * f2, false);
            this.H.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.aZ = true;
                this.H.a((Entity)this, this.dl(), this.dn(), this.dr(), event.getRadius(), event.getFire(), World.a.c);
                this.ai();
                this.fW();
            } else {
                this.bS = 0;
                this.am.b(d, false);
            }
        }
    }

    private void fW() {
        Collection<MobEffect> collection = this.el();
        if (!collection.isEmpty() && !this.H.paperConfig().entities.behavior.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.H, this.dl(), this.dn(), this.dr());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.b(-0.5f);
            entityareaeffectcloud.d(10);
            entityareaeffectcloud.b(entityareaeffectcloud.m() / 2);
            entityareaeffectcloud.c(-entityareaeffectcloud.h() / (float)entityareaeffectcloud.m());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.H.addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean w() {
        return this.am.a(d);
    }

    public void fS() {
        this.setIgnited(true);
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.w() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.am.b(d, event.isIgnited());
        }
    }

    public boolean fT() {
        return this.a() && this.bV < 1;
    }

    public void fU() {
        ++this.bV;
    }
}

