/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EndermanAttackPlayerEvent;
import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import top.leavesmc.leaves.LeavesConfig;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final UUID c = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier d = new AttributeModifier(c, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.a);
    private static final int e = 400;
    private static final int bS = 600;
    private static final DataWatcherObject<Optional<IBlockData>> bT = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> bU = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int bW = Integer.MIN_VALUE;
    private int bX;
    private static final UniformInt bY = TimeRange.a(20, 39);
    private int bZ;
    @Nullable
    private UUID ca;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.v(1.0f);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void x() {
        this.bN.a(0, new PathfinderGoalFloat(this));
        this.bN.a(1, new a(this));
        this.bN.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bN.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.bN.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(8, new PathfinderGoalRandomLookaround(this));
        this.bN.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.bN.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.bO.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a_));
        this.bO.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bO.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.bO.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fY().a(GenericAttributes.a, 40.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.f, 7.0).a(GenericAttributes.b, 64.0);
    }

    @Override
    public void i(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    private boolean tryEscape(EndermanEscapeEvent.Reason reason) {
        return new EndermanEscapeEvent((Enderman)((CraftEnderman)this.getBukkitEntity()), reason).callEvent();
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (!super.setTarget(entityliving, reason, fireEvent)) {
            return false;
        }
        entityliving = this.P_();
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (entityliving == null) {
            this.bX = 0;
            this.am.b(bU, false);
            this.am.b(bV, false);
            attributemodifiable.d(d);
        } else {
            this.bX = this.ag;
            this.am.b(bU, true);
            if (!attributemodifiable.a(d)) {
                attributemodifiable.b(d);
            }
        }
        return true;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bT, Optional.empty());
        this.am.a(bU, false);
        this.am.a(bV, false);
    }

    @Override
    public void c() {
        this.a(bY.a(this.af));
    }

    @Override
    public void a(int angerTime) {
        this.bZ = angerTime;
    }

    @Override
    public int a() {
        return this.bZ;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.ca = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.ca;
    }

    public void r() {
        if (this.ag >= this.bW + 400) {
            this.bW = this.ag;
            if (!this.aO()) {
                this.H.a(this.dl(), this.dp(), this.dr(), SoundEffects.hc, this.cX(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bU.equals(data) && this.fU() && this.H.B) {
            this.r();
        }
        super.a(data);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        IBlockData iblockdata = this.fS();
        if (iblockdata != null) {
            nbt.a("carriedBlockState", GameProfileSerializer.a(iblockdata));
        }
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        IBlockData iblockdata = null;
        if (nbt.b("carriedBlockState", 10) && (iblockdata = GameProfileSerializer.a(this.H.a(Registries.e), nbt.p("carriedBlockState"))).h()) {
            iblockdata = null;
        }
        this.c(iblockdata);
        this.a(this.H, nbt);
    }

    private boolean f(EntityHuman player) {
        boolean shouldAttack = this.isLookingAtMe_check(player);
        EndermanAttackPlayerEvent event = new EndermanAttackPlayerEvent((Enderman)this.getBukkitEntity(), (Player)player.getBukkitEntity());
        event.setCancelled(!shouldAttack);
        return event.callEvent();
    }

    private boolean isLookingAtMe_check(EntityHuman player) {
        ItemStack itemstack = player.fJ().j.get(3);
        if (itemstack.a(Blocks.ee.k())) {
            return false;
        }
        Vec3D vec3d = player.j(1.0f).d();
        Vec3D vec3d1 = new Vec3D(this.dl() - player.dl(), this.dp() - player.dp(), this.dr() - player.dr());
        double d0 = vec3d1.f();
        double d1 = vec3d.b(vec3d1 = vec3d1.d());
        return d1 > 1.0 - 0.025 / d0 ? player.B(this) : false;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 2.55f;
    }

    @Override
    public void b_() {
        if (this.H.B) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.H.a(Particles.Z, this.d(0.5), this.do() - 0.25, this.g(0.5), (this.af.j() - 0.5) * 2.0, -this.af.j(), (this.af.j() - 0.5) * 2.0);
            }
        }
        this.bi = false;
        if (!this.H.B) {
            this.a((WorldServer)this.H, true);
        }
        super.b_();
    }

    @Override
    public boolean eX() {
        return true;
    }

    @Override
    protected void U() {
        float f2;
        if (this.H.M() && this.ag >= this.bX + 600 && (f2 = this.bh()) > 0.5f && this.H.g(this.dg()) && this.af.i() * 30.0f < (f2 - 0.4f) * 2.0f && this.tryEscape(EndermanEscapeEvent.Reason.RUNAWAY)) {
            this.i((EntityLiving)null);
            this.w();
        }
        super.U();
    }

    public boolean w() {
        if (!this.H.k_() && this.bq()) {
            double d0 = this.dl() + (this.af.j() - 0.5) * 64.0;
            double d1 = this.dn() + (double)(this.af.a(64) - 32);
            double d2 = this.dr() + (this.af.j() - 0.5) * 64.0;
            return this.r(d0, d1, d2);
        }
        return false;
    }

    boolean a(Entity entity) {
        Vec3D vec3d = new Vec3D(this.dl() - entity.dl(), this.e(0.5) - entity.dp(), this.dr() - entity.dr());
        vec3d = vec3d.d();
        double d0 = 16.0;
        double d1 = this.dl() + (this.af.j() - 0.5) * 8.0 - vec3d.c * 16.0;
        double d2 = this.dn() + (double)(this.af.a(16) - 8) - vec3d.d * 16.0;
        double d3 = this.dr() + (this.af.j() - 0.5) * 8.0 - vec3d.e * 16.0;
        return this.r(d1, d2, d3);
    }

    private boolean r(double x2, double y2, double z2) {
        IBlockData iblockdata;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(x2, y2, z2);
        if (LeavesConfig.reduceChuckLoadAndLookup) {
            Chunk chunk = this.H.getChunkIfLoaded(blockposition_mutableblockposition);
            if (chunk == null) {
                return false;
            }
            while (blockposition_mutableblockposition.v() > this.H.v_() && !chunk.a_(blockposition_mutableblockposition).d().c()) {
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
            iblockdata = chunk.a_(blockposition_mutableblockposition);
        } else {
            while (blockposition_mutableblockposition.v() > this.H.v_() && !this.H.a_(blockposition_mutableblockposition).d().c()) {
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
            iblockdata = this.H.a_(blockposition_mutableblockposition);
        }
        boolean flag = iblockdata.d().c();
        boolean flag1 = iblockdata.r().a(TagsFluid.a);
        if (flag && !flag1) {
            Vec3D vec3d = this.de();
            boolean flag2 = this.a(x2, y2, z2, true);
            if (flag2) {
                this.H.a(GameEvent.V, vec3d, GameEvent.a.a(this));
                if (!this.aO()) {
                    this.H.a((EntityHuman)null, this.I, this.J, this.K, SoundEffects.hd, this.cX(), 1.0f, 1.0f);
                    this.a(SoundEffects.hd, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    protected SoundEffect s() {
        return this.fT() ? SoundEffects.hb : SoundEffects.gY;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.ha;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.gZ;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        IBlockData iblockdata = this.fS();
        if (iblockdata != null) {
            ItemStack itemstack = new ItemStack(Items.oq);
            itemstack.a(Enchantments.v, 1);
            LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.H).a(this.H.r_()).a(LootContextParameters.f, this.de()).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, this);
            List<ItemStack> list = iblockdata.a(loottableinfo_builder);
            for (ItemStack itemstack1 : list) {
                this.b(itemstack1);
            }
        }
    }

    public void c(@Nullable IBlockData state) {
        this.am.b(bT, Optional.ofNullable(state));
    }

    @Nullable
    public IBlockData fS() {
        return this.am.a(bT).orElse(null);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag1;
        if (this.b(source)) {
            return false;
        }
        boolean flag = source.c() instanceof EntityPotion;
        if (!source.a(DamageTypeTags.j) && !flag) {
            boolean flag12 = super.a(source, amount);
            if (!this.H.k_() && !(source.d() instanceof EntityLiving) && this.af.a(10) != 0) {
                this.w();
            }
            return flag12;
        }
        boolean bl = flag1 = flag && this.a(source, (EntityPotion)source.c(), amount);
        if (this.tryEscape(EndermanEscapeEvent.Reason.INDIRECT)) {
            for (int i2 = 0; i2 < 64; ++i2) {
                if (!this.w()) continue;
                return true;
            }
        }
        return flag1;
    }

    private boolean a(DamageSource source, EntityPotion potion, float amount) {
        ItemStack itemstack = potion.i();
        PotionRegistry potionregistry = PotionUtil.d(itemstack);
        List<MobEffect> list = PotionUtil.a(itemstack);
        boolean flag = potionregistry == Potions.c && list.isEmpty();
        return flag ? super.a(source, amount) : false;
    }

    public boolean fT() {
        return this.am.a(bU);
    }

    public boolean fU() {
        return this.am.a(bV);
    }

    public void fV() {
        this.am.b(bV, true);
    }

    public void setCreepy(boolean creepy) {
        this.am.b(bU, creepy);
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.am.b(bV, hasBeenStaredAt);
    }

    @Override
    public boolean Q() {
        return super.Q() || this.fS() != null;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman enderman) {
            this.a = enderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            this.b = this.a.P_();
            if (!(this.b instanceof EntityHuman)) {
                return false;
            }
            double d0 = this.b.f((Entity)this.a);
            return d0 > 256.0 ? false : this.a.f((EntityHuman)this.b);
        }

        @Override
        public void c() {
            this.a.G().n();
        }

        @Override
        public void e() {
            this.a.C().a(this.b.dl(), this.b.dp(), this.b.dr());
        }
    }

    private static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean a() {
            return this.a.fS() == null ? false : (!this.a.H.W().b(GameRules.c) ? false : this.a.dZ().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0);
        }

        @Override
        public void e() {
            int k2;
            int j2;
            RandomSource randomsource = this.a.dZ();
            World world = this.a.H;
            int i2 = MathHelper.a(this.a.dl() - 1.0 + randomsource.j() * 2.0);
            BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.a(this.a.dn() + randomsource.j() * 2.0), k2 = MathHelper.a(this.a.dr() - 1.0 + randomsource.j() * 2.0));
            IBlockData iblockdata = world.getBlockStateIfLoaded(blockposition);
            if (iblockdata == null) {
                return;
            }
            BlockPosition blockposition1 = blockposition.d();
            IBlockData iblockdata1 = world.a_(blockposition1);
            IBlockData iblockdata2 = this.a.fS();
            if (iblockdata2 != null && this.a(world, blockposition, iblockdata2 = Block.b(iblockdata2, this.a.H, blockposition), iblockdata, iblockdata1, blockposition1) && !CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata2).isCancelled()) {
                world.a(blockposition, iblockdata2, 3);
                world.a(GameEvent.i, blockposition, GameEvent.a.a(this.a, iblockdata2));
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World world, BlockPosition posAbove, IBlockData carriedState, IBlockData stateAbove, IBlockData state, BlockPosition pos) {
            return stateAbove.h() && !state.h() && !state.a(Blocks.F) && state.r(world, pos) && carriedState.a((IWorldReader)world, posAbove) && world.a_(this.a, AxisAlignedBB.a(Vec3D.a(posAbove))).isEmpty();
        }
    }

    private static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean a() {
            return this.a.fS() != null ? false : (!this.a.H.W().b(GameRules.c) ? false : this.a.dZ().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0);
        }

        @Override
        public void e() {
            int k2;
            int j2;
            RandomSource randomsource = this.a.dZ();
            World world = this.a.H;
            int i2 = MathHelper.a(this.a.dl() - 2.0 + randomsource.j() * 4.0);
            BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.a(this.a.dn() + randomsource.j() * 3.0), k2 = MathHelper.a(this.a.dr() - 2.0 + randomsource.j() * 4.0));
            IBlockData iblockdata = world.getBlockStateIfLoaded(blockposition);
            if (iblockdata == null) {
                return;
            }
            Vec3D vec3d = new Vec3D((double)this.a.dk() + 0.5, (double)j2 + 0.5, (double)this.a.dq() + 0.5);
            Vec3D vec3d1 = new Vec3D((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5);
            MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = movingobjectpositionblock.a().equals(blockposition);
            if (iblockdata.a(TagsBlock.ai) && flag && !CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, Blocks.a.o()).isCancelled()) {
                world.a(blockposition, false);
                world.a(GameEvent.f, blockposition, GameEvent.a.a(this.a, iblockdata));
                this.a.c(iblockdata.b().o());
            }
        }
    }

    private static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final Predicate<EntityLiving> o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman enderman, @Nullable Predicate<EntityLiving> targetPredicate) {
            super(enderman, EntityHuman.class, 10, false, false, targetPredicate);
            this.i = enderman;
            this.o = entityliving -> (enderman.f((EntityHuman)entityliving) || enderman.a_((EntityLiving)entityliving)) && !enderman.w((Entity)entityliving);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean a() {
            this.j = this.i.H.a(this.m, this.i);
            return this.j != null;
        }

        @Override
        public void c() {
            this.k = this.a(5);
            this.l = 0;
            this.i.fV();
        }

        @Override
        public void d() {
            this.j = null;
            super.d();
        }

        @Override
        public boolean b() {
            if (this.j != null) {
                if (!this.o.test(this.j)) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.w(this.c)) {
                    return false;
                }
                if (this.n.a(this.i, this.c)) {
                    return true;
                }
            }
            return super.b();
        }

        @Override
        public void e() {
            if (this.i.P_() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.c();
                }
            } else {
                if (this.c != null && !this.i.bL()) {
                    if (this.i.f((EntityHuman)this.c)) {
                        if (this.c.f((Entity)this.i) < 16.0 && this.i.tryEscape(EndermanEscapeEvent.Reason.STARE)) {
                            this.i.w();
                        }
                        this.l = 0;
                    } else if (this.c.f((Entity)this.i) > 256.0 && this.l++ >= this.a(30) && this.i.a((Entity)this.c)) {
                        this.l = 0;
                    }
                }
                super.e();
            }
        }
    }
}

