/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftMonster;

public abstract class EntityMonster
extends EntityCreature
implements IMonster {
    public CraftMonster getBukkitMonster() {
        return (CraftMonster)super.getBukkitEntity();
    }

    protected EntityMonster(EntityTypes<? extends EntityMonster> type, World world) {
        super((EntityTypes<? extends EntityCreature>)type, world);
        this.bI = 5;
    }

    @Override
    public SoundCategory cX() {
        return SoundCategory.f;
    }

    @Override
    public void b_() {
        this.eH();
        this.fX();
        super.b_();
    }

    protected void fX() {
        float f2 = this.bh();
        if (f2 > 0.5f) {
            this.ba += 2;
        }
    }

    @Override
    protected boolean R() {
        return true;
    }

    @Override
    protected SoundEffect aI() {
        return SoundEffects.ln;
    }

    @Override
    protected SoundEffect aJ() {
        return SoundEffects.lm;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.lk;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.lj;
    }

    @Override
    public EntityLiving.a ey() {
        return new EntityLiving.a(SoundEffects.ll, SoundEffects.li);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return -world.y(pos);
    }

    public static boolean a(WorldAccess world, BlockPosition pos, RandomSource random) {
        int i2;
        if (world.a(EnumSkyBlock.a, pos) > random.a(32)) {
            return false;
        }
        DimensionManager dimensionType = world.q_();
        int n2 = i2 = world.C().paperConfig().entities.spawning.monsterSpawnMaxLightLevel >= 0 ? world.C().paperConfig().entities.spawning.monsterSpawnMaxLightLevel : dimensionType.e();
        if (i2 < 15 && world.a(EnumSkyBlock.b, pos) > i2) {
            return false;
        }
        int j2 = world.C().X() ? world.c(pos, 10) : world.C(pos);
        return j2 <= dimensionType.d().a(random);
    }

    public static boolean b(EntityTypes<? extends EntityMonster> type, WorldAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.ah() != EnumDifficulty.a && EntityMonster.a(world, pos, random) && EntityMonster.a(type, world, spawnReason, pos, random);
    }

    public static boolean c(EntityTypes<? extends EntityMonster> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.ah() != EnumDifficulty.a && EntityMonster.a(type, world, spawnReason, pos, random);
    }

    public static AttributeProvider.Builder fY() {
        return EntityInsentient.y().a(GenericAttributes.f);
    }

    @Override
    public boolean dV() {
        return true;
    }

    @Override
    protected boolean dW() {
        return true;
    }

    public boolean e(EntityHuman player) {
        return true;
    }

    @Override
    public ItemStack g(ItemStack stack) {
        if (stack.c() instanceof ItemProjectileWeapon) {
            Predicate<ItemStack> predicate = ((ItemProjectileWeapon)stack.c()).e();
            ItemStack itemStack = ItemProjectileWeapon.a(this, predicate);
            return itemStack.b() ? new ItemStack(Items.nD) : itemStack;
        }
        return ItemStack.b;
    }
}

