/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> e = entity -> entity.bq() && !(entity instanceof EntityRavager);
    private static final double bS = 0.3;
    private static final double bT = 0.35;
    private static final int bU = 8356754;
    private static final double bV = 0.5725490196078431;
    private static final double bW = 0.5137254901960784;
    private static final double bX = 0.4980392156862745;
    private static final int bY = 10;
    public static final int b = 40;
    public int bZ;
    public int ca;
    public int cb;

    public EntityRavager(EntityTypes<? extends EntityRavager> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
        this.v(1.0f);
        this.bI = 20;
        this.a(PathType.v, 0.0f);
    }

    @Override
    protected void x() {
        super.x();
        this.bN.a(0, new PathfinderGoalFloat(this));
        this.bN.a(4, new a());
        this.bN.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.bN.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bN.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bO.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bO.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bO.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, entityliving -> !entityliving.y_()));
        this.bO.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void N() {
        boolean flag = !(this.cK() instanceof EntityInsentient) || this.cK().ae().a(TagsEntity.b);
        boolean flag1 = !(this.cV() instanceof EntityBoat);
        this.bN.a(PathfinderGoal.Type.a, flag);
        this.bN.a(PathfinderGoal.Type.c, flag && flag1);
        this.bN.a(PathfinderGoal.Type.b, flag);
        this.bN.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fY().a(GenericAttributes.a, 100.0).a(GenericAttributes.d, 0.3).a(GenericAttributes.c, 0.75).a(GenericAttributes.f, 12.0).a(GenericAttributes.g, 1.5).a(GenericAttributes.b, 32.0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AttackTick", this.bZ);
        nbt.a("StunTick", this.ca);
        nbt.a("RoarTick", this.cb);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.bZ = nbt.h("AttackTick");
        this.ca = nbt.h("StunTick");
        this.cb = nbt.h("RoarTick");
    }

    @Override
    public SoundEffect X_() {
        return SoundEffects.tc;
    }

    @Override
    public int W() {
        return 45;
    }

    @Override
    public double bv() {
        return 2.1;
    }

    @Override
    @Nullable
    public EntityLiving cK() {
        Entity entity;
        if (!this.fK() && (entity = this.cN()) instanceof EntityLiving) {
            EntityLiving entityliving1;
            EntityLiving entityliving = entityliving1 = (EntityLiving)entity;
            return entityliving;
        }
        EntityLiving entityliving = null;
        return entityliving;
    }

    @Override
    public void b_() {
        super.b_();
        if (this.bq()) {
            if (this.eP()) {
                this.a(GenericAttributes.d).a(0.0);
            } else {
                double d0 = this.P_() != null ? 0.35 : 0.3;
                double d1 = this.a(GenericAttributes.d).b();
                this.a(GenericAttributes.d).a(MathHelper.d(0.1, d1, d0));
            }
            if (this.O && this.H.W().b(GameRules.c)) {
                boolean flag = false;
                AxisAlignedBB axisalignedbb = this.cD().g(0.2);
                for (BlockPosition blockposition : BlockPosition.b(MathHelper.a(axisalignedbb.a), MathHelper.a(axisalignedbb.b), MathHelper.a(axisalignedbb.c), MathHelper.a(axisalignedbb.d), MathHelper.a(axisalignedbb.e), MathHelper.a(axisalignedbb.f))) {
                    IBlockData iblockdata = this.H.a_(blockposition);
                    Block block = iblockdata.b();
                    if (!(block instanceof BlockLeaves) || CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, iblockdata.r().g()).isCancelled()) continue;
                    flag = this.H.a(blockposition, true, this) || flag;
                }
                if (!flag && this.N) {
                    if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                        this.eS();
                    } else {
                        this.r(false);
                    }
                }
            }
            if (this.cb > 0) {
                --this.cb;
                if (this.cb == 10) {
                    this.ge();
                }
            }
            if (this.bZ > 0) {
                --this.bZ;
            }
            if (this.ca > 0) {
                --this.ca;
                this.gd();
                if (this.ca == 0) {
                    this.a(SoundEffects.th, 1.0f, 1.0f);
                    this.cb = 20;
                }
            }
        }
    }

    private void gd() {
        if (this.af.a(6) == 0) {
            double d0 = this.dl() - (double)this.dc() * Math.sin(this.aT * ((float)Math.PI / 180)) + (this.af.j() * 0.6 - 0.3);
            double d1 = this.dn() + (double)this.dd() - 0.3;
            double d2 = this.dr() + (double)this.dc() * Math.cos(this.aT * ((float)Math.PI / 180)) + (this.af.j() * 0.6 - 0.3);
            this.H.a(Particles.v, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    @Override
    protected boolean eP() {
        return super.eP() || this.bZ > 0 || this.ca > 0 || this.cb > 0;
    }

    @Override
    public boolean B(Entity entity) {
        return this.ca <= 0 && this.cb <= 0 ? super.B(entity) : false;
    }

    @Override
    protected void e(EntityLiving target) {
        if (this.cb == 0) {
            if (this.af.j() < 0.5) {
                this.ca = 40;
                this.a(SoundEffects.tg, 1.0f, 1.0f);
                this.H.a((Entity)this, (byte)39);
                target.g((Entity)this);
            } else {
                this.a((Entity)target);
            }
            target.S = true;
        }
    }

    private void ge() {
        if (this.bq()) {
            List<Entity> list = this.H.a(EntityLiving.class, this.cD().g(4.0), e);
            for (EntityLiving entityLiving : list) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.a(this.dG().b(this), 6.0f);
                }
                this.a((Entity)entityLiving);
            }
            Vec3D vec3d = this.cD().f();
            for (int i2 = 0; i2 < 40; ++i2) {
                double d0 = this.af.k() * 0.2;
                double d1 = this.af.k() * 0.2;
                double d2 = this.af.k() * 0.2;
                this.H.a(Particles.Y, vec3d.c, vec3d.d, vec3d.e, d0, d1, d2);
            }
            this.a(GameEvent.v);
        }
    }

    private void a(Entity entity) {
        double d0 = entity.dl() - this.dl();
        double d1 = entity.dr() - this.dr();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.push(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0, this);
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.bZ = 10;
            this.a(SoundEffects.tb, 1.0f, 1.0f);
        } else if (status == 39) {
            this.ca = 40;
        }
        super.b(status);
    }

    public int r() {
        return this.bZ;
    }

    public int fS() {
        return this.ca;
    }

    public int gc() {
        return this.cb;
    }

    @Override
    public boolean z(Entity target) {
        this.bZ = 10;
        this.H.a((Entity)this, (byte)4);
        this.a(SoundEffects.tb, 1.0f, 1.0f);
        return super.z(target);
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return SoundEffects.ta;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.te;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.td;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.tf, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader world) {
        return !world.d(this.cD());
    }

    @Override
    public void a(int wave, boolean unused) {
    }

    @Override
    public boolean fT() {
        return false;
    }

    private class a
    extends PathfinderGoalMeleeAttack {
        public a() {
            super(EntityRavager.this, 1.0, true);
        }

        @Override
        protected double a(EntityLiving entity) {
            float f2 = EntityRavager.this.dc() - 0.1f;
            return f2 * 2.0f * f2 * 2.0f + entity.dc();
        }
    }
}

