/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EntityShulker
extends EntityGolem
implements VariantHolder<Optional<EnumColor>>,
IMonster {
    private static final UUID e = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier bS = new AttributeModifier(e, "Covered armor bonus", 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.p);
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> d = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int bT = 6;
    private static final byte bU = 16;
    private static final byte bV = 16;
    private static final int bW = 8;
    private static final int bX = 8;
    private static final int bY = 5;
    private static final float bZ = 0.05f;
    static final Vector3f ca = SystemUtils.a(() -> {
        BaseBlockPosition baseblockposition = EnumDirection.d.q();
        return new Vector3f((float)baseblockposition.u(), (float)baseblockposition.v(), (float)baseblockposition.w());
    });
    private float cb;
    private float cc;
    @Nullable
    private BlockPosition cd;
    private int ce;
    private static final float cf = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
        this.bI = 5;
        this.bJ = new d(this);
    }

    @Override
    protected void x() {
        this.bN.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.bN.a(4, new a());
        this.bN.a(7, new f());
        this.bN.a(8, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.bO.a(2, new e(this));
        this.bO.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission aQ() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory cX() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.uI;
    }

    @Override
    public void L() {
        if (!this.fX()) {
            super.L();
        }
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.uO;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.fX() ? SoundEffects.uQ : SoundEffects.uP;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, EnumDirection.a);
        this.am.a(c, (byte)0);
        this.am.a(d, (byte)16);
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.a, 30.0);
    }

    @Override
    protected EntityAIBodyControl A() {
        return new b(this);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(EnumDirection.a(nbt.f("AttachFace")));
        this.am.b(c, nbt.f("Peek"));
        if (nbt.b("Color", 99)) {
            this.am.b(d, nbt.f("Color"));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AttachFace", (byte)this.w().d());
        nbt.a("Peek", this.am.a(c));
        nbt.a("Color", this.am.a(d));
    }

    @Override
    public void l() {
        super.l();
        if (!(this.H.B || this.bL() || this.a(this.dg(), this.w()))) {
            this.fU();
        }
        if (this.fV()) {
            this.fW();
        }
        if (this.H.B) {
            if (this.ce > 0) {
                --this.ce;
            } else {
                this.cd = null;
            }
        }
    }

    private void fU() {
        EnumDirection enumdirection = this.g(this.dg());
        if (enumdirection != null) {
            this.a(enumdirection);
        } else {
            this.r();
        }
    }

    @Override
    protected AxisAlignedBB am() {
        float f2 = EntityShulker.E(this.cc);
        EnumDirection enumdirection = this.w().g();
        float f1 = this.ae().k() / 2.0f;
        return EntityShulker.a(enumdirection, f2).d(this.dl() - (double)f1, this.dn(), this.dr() - (double)f1);
    }

    private static float E(float openProgress) {
        return 0.5f - MathHelper.a((0.5f + openProgress) * (float)Math.PI) * 0.5f;
    }

    private boolean fV() {
        this.cb = this.cc;
        float f2 = (float)this.fZ() * 0.01f;
        if (this.cc == f2) {
            return false;
        }
        this.cc = this.cc > f2 ? MathHelper.a(this.cc - 0.05f, f2, 1.0f) : MathHelper.a(this.cc + 0.05f, 0.0f, f2);
        return true;
    }

    private void fW() {
        this.an();
        float f2 = EntityShulker.E(this.cc);
        float f1 = EntityShulker.E(this.cb);
        EnumDirection enumdirection = this.w().g();
        float f22 = f2 - f1;
        if (f22 > 0.0f) {
            List<Entity> list = this.H.a((Entity)this, EntityShulker.a(enumdirection, f1, f2).d(this.dl() - 0.5, this.dn(), this.dr() - 0.5), IEntitySelector.f.and(entity -> !entity.v(this)));
            for (Entity entity2 : list) {
                if (entity2 instanceof EntityShulker || entity2.ae) continue;
                entity2.a(EnumMoveType.e, new Vec3D(f22 * (float)enumdirection.j(), f22 * (float)enumdirection.k(), f22 * (float)enumdirection.l()));
            }
        }
    }

    public static AxisAlignedBB a(EnumDirection direction, float extraLength) {
        return EntityShulker.a(direction, -1.0f, extraLength);
    }

    public static AxisAlignedBB a(EnumDirection direction, float prevExtraLength, float extraLength) {
        double d0 = Math.max(prevExtraLength, extraLength);
        double d1 = Math.min(prevExtraLength, extraLength);
        return new AxisAlignedBB(BlockPosition.b).b((double)direction.j() * d0, (double)direction.k() * d0, (double)direction.l() * d0).a((double)(-direction.j()) * (1.0 + d1), (double)(-direction.k()) * (1.0 + d1), (double)(-direction.l()) * (1.0 + d1));
    }

    @Override
    public double bu() {
        EntityTypes<?> entitytypes = this.cV().ae();
        return !(this.cV() instanceof EntityBoat) && entitytypes != EntityTypes.an ? super.bu() : 0.1875 - this.cV().bv();
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.H.k_()) {
            this.cd = null;
            this.ce = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, force);
    }

    @Override
    public void bz() {
        super.bz();
        if (this.H.B) {
            this.cd = this.dg();
        }
        this.aU = 0.0f;
        this.aT = 0.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.f(0.0f);
        this.aV = this.dw();
        this.bi();
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (movementType == EnumMoveType.d) {
            this.r();
        } else {
            super.a(movementType, movement);
        }
    }

    @Override
    public Vec3D dj() {
        return Vec3D.b;
    }

    @Override
    public void f(Vec3D velocity) {
    }

    @Override
    public void e(double x2, double y2, double z2) {
        BlockPosition blockposition1;
        BlockPosition blockposition = this.dg();
        if (this.bL()) {
            super.e(x2, y2, z2);
        } else {
            super.e((double)MathHelper.a(x2) + 0.5, MathHelper.a(y2 + 0.5), (double)MathHelper.a(z2) + 0.5);
        }
        if (this.ag != 0 && !(blockposition1 = this.dg()).equals(blockposition)) {
            this.am.b(c, (byte)0);
            this.at = true;
            if (this.H.B && !this.bL() && !blockposition1.equals(this.cd)) {
                this.cd = blockposition;
                this.ce = 6;
                this.ab = this.dl();
                this.ac = this.dn();
                this.ad = this.dr();
            }
        }
    }

    @Nullable
    protected EnumDirection g(BlockPosition pos) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.a(pos, enumdirection)) continue;
            return enumdirection;
        }
        return null;
    }

    boolean a(BlockPosition pos, EnumDirection direction) {
        if (this.h(pos)) {
            return false;
        }
        EnumDirection enumdirection1 = direction.g();
        if (!this.H.a(pos.a(direction), (Entity)this, enumdirection1)) {
            return false;
        }
        AxisAlignedBB axisalignedbb = EntityShulker.a(enumdirection1, 1.0f).a(pos).h(1.0E-6);
        return this.H.a((Entity)this, axisalignedbb);
    }

    private boolean h(BlockPosition pos) {
        IBlockData iblockdata = this.H.a_(pos);
        if (iblockdata.h()) {
            return false;
        }
        boolean flag = iblockdata.a(Blocks.bP) && pos.equals(this.dg());
        return !flag;
    }

    protected boolean r() {
        if (!this.fK() && this.bq()) {
            BlockPosition blockposition = this.dg();
            for (int i2 = 0; i2 < 5; ++i2) {
                EnumDirection enumdirection;
                BlockPosition blockposition1 = blockposition.b(MathHelper.b(this.af, -8, 8), MathHelper.b(this.af, -8, 8), MathHelper.b(this.af, -8, 8));
                if (blockposition1.v() <= this.H.v_() || !this.H.w(blockposition1) || !this.H.p_().a(blockposition1) || !this.H.a((Entity)this, new AxisAlignedBB(blockposition1).h(1.0E-6)) || (enumdirection = this.g(blockposition1)) == null) continue;
                EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), CraftLocation.toBukkit(blockposition1, (org.bukkit.World)this.H.getWorld()));
                this.H.getCraftServer().getPluginManager().callEvent((Event)teleport);
                if (teleport.isCancelled()) {
                    return false;
                }
                Location to = teleport.getTo();
                blockposition1 = BlockPosition.a(to.getX(), to.getY(), to.getZ());
                this.ac();
                this.a(enumdirection);
                this.a(SoundEffects.uT, 1.0f, 1.0f);
                this.e((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5);
                this.H.a(GameEvent.V, blockposition, GameEvent.a.a(this));
                this.am.b(c, (byte)0);
                this.i((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.bm = 0;
        this.e(x2, y2, z2);
        this.a(yaw, pitch);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        Entity entity;
        if (this.fX() && (entity = source.c()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(source, amount)) {
            return false;
        }
        if ((double)this.eo() < (double)this.eE() * 0.5 && this.af.a(4) == 0) {
            this.r();
        } else if (source.a(DamageTypeTags.j) && (entity = source.c()) != null && entity.ae() == EntityTypes.aH) {
            this.fY();
        }
        return true;
    }

    private boolean fX() {
        return this.fZ() == 0;
    }

    private void fY() {
        Vec3D vec3d = this.de();
        AxisAlignedBB axisalignedbb = this.cD();
        if (!this.fX() && this.r()) {
            EntityShulker entityshulker;
            int i2 = this.H.a(EntityTypes.aG, axisalignedbb.g(8.0), Entity::bq).size();
            float f2 = (float)(i2 - 1) / 5.0f;
            if (this.H.z.i() >= f2 && (entityshulker = EntityTypes.aG.a(this.H)) != null) {
                entityshulker.a(this.fS());
                entityshulker.d(vec3d);
                this.H.addFreshEntity(entityshulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean bs() {
        return this.bq();
    }

    public EnumDirection w() {
        return this.am.a(b);
    }

    @Override
    public void a(EnumDirection face) {
        this.am.b(b, face);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (b.equals(data)) {
            this.a(this.am());
        }
        super.a(data);
    }

    public int fZ() {
        return this.am.a(c).byteValue();
    }

    public void b(int peekAmount) {
        if (!this.H.B) {
            this.a(GenericAttributes.i).d(bS);
            if (peekAmount == 0) {
                this.a(GenericAttributes.i).c(bS);
                this.a(SoundEffects.uN, 1.0f, 1.0f);
                this.a(GameEvent.j);
            } else {
                this.a(SoundEffects.uR, 1.0f, 1.0f);
                this.a(GameEvent.k);
            }
        }
        this.am.b(c, (byte)peekAmount);
    }

    public float C(float delta) {
        return MathHelper.i(delta, this.cb, this.cc);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.5f;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.aT = 0.0f;
        this.aU = 0.0f;
    }

    @Override
    public int V() {
        return 180;
    }

    @Override
    public int W() {
        return 180;
    }

    @Override
    public void g(Entity entity) {
    }

    @Override
    public float bB() {
        return 0.0f;
    }

    public Optional<Vec3D> D(float tickDelta) {
        if (this.cd != null && this.ce > 0) {
            double d0 = (double)((float)this.ce - tickDelta) / 6.0;
            d0 *= d0;
            BlockPosition blockposition = this.dg();
            double d1 = (double)(blockposition.u() - this.cd.u()) * d0;
            double d2 = (double)(blockposition.v() - this.cd.v()) * d0;
            double d3 = (double)(blockposition.w() - this.cd.w()) * d0;
            return Optional.of(new Vec3D(-d1, -d2, -d3));
        }
        return Optional.empty();
    }

    @Override
    public void a(Optional<EnumColor> variant) {
        this.am.b(d, variant.map(enumcolor -> (byte)enumcolor.a()).orElse((byte)16));
    }

    public Optional<EnumColor> fS() {
        return Optional.ofNullable(this.fT());
    }

    @Nullable
    public EnumColor fT() {
        byte b0 = this.am.a(d);
        return b0 != 16 && b0 <= 15 ? EnumColor.a(b0) : null;
    }

    private class d
    extends ControllerLook {
        public d(EntityInsentient entity) {
            super(entity);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection enumdirection = EntityShulker.this.w().g();
            Vector3f vector3f = enumdirection.b().transform(new Vector3f((Vector3fc)ca));
            BaseBlockPosition baseblockposition = enumdirection.q();
            Vector3f vector3f1 = new Vector3f((float)baseblockposition.u(), (float)baseblockposition.v(), (float)baseblockposition.w());
            vector3f1.cross((Vector3fc)vector3f);
            double d0 = this.e - this.a.dl();
            double d1 = this.f - this.a.dp();
            double d2 = this.g - this.a.dr();
            Vector3f vector3f2 = new Vector3f((float)d0, (float)d1, (float)d2);
            float f2 = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return Math.abs(f2) <= 1.0E-5f && Math.abs(f1) <= 1.0E-5f ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 57.2957763671875)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    private class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = EntityShulker.this.P_();
            return entityliving != null && entityliving.bq() ? EntityShulker.this.H.ah() != EnumDifficulty.a : false;
        }

        @Override
        public void c() {
            this.b = 20;
            EntityShulker.this.b(100);
        }

        @Override
        public void d() {
            EntityShulker.this.b(0);
        }

        @Override
        public boolean J_() {
            return true;
        }

        @Override
        public void e() {
            if (EntityShulker.this.H.ah() != EnumDifficulty.a) {
                --this.b;
                EntityLiving entityliving = EntityShulker.this.P_();
                if (entityliving != null) {
                    EntityShulker.this.C().a(entityliving, 180.0f, 180.0f);
                    double d0 = EntityShulker.this.f((Entity)entityliving);
                    if (d0 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.af.a(10) * 20 / 2;
                            EntityShulker.this.H.b(new EntityShulkerBullet(EntityShulker.this.H, EntityShulker.this, entityliving, EntityShulker.this.w().o()));
                            EntityShulker.this.a(SoundEffects.uS, 2.0f, (EntityShulker.this.af.i() - EntityShulker.this.af.i()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.i((EntityLiving)null);
                    }
                    super.e();
                }
            }
        }
    }

    private class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean a() {
            return EntityShulker.this.P_() == null && EntityShulker.this.af.a(net.minecraft.world.entity.monster.EntityShulker$f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.dg(), EntityShulker.this.w());
        }

        @Override
        public boolean b() {
            return EntityShulker.this.P_() == null && this.b > 0;
        }

        @Override
        public void c() {
            this.b = this.a(20 * (1 + EntityShulker.this.af.a(3)));
            EntityShulker.this.b(30);
        }

        @Override
        public void d() {
            if (EntityShulker.this.P_() == null) {
                EntityShulker.this.b(0);
            }
        }

        @Override
        public void e() {
            --this.b;
        }
    }

    private class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker entityshulker) {
            super((EntityInsentient)entityshulker, EntityHuman.class, true);
        }

        @Override
        public boolean a() {
            return EntityShulker.this.H.ah() == EnumDifficulty.a ? false : super.a();
        }

        @Override
        protected AxisAlignedBB a(double distance) {
            EnumDirection enumdirection = ((EntityShulker)this.e).w();
            return enumdirection.o() == EnumDirection.EnumAxis.a ? this.e.cD().c(4.0, distance, distance) : (enumdirection.o() == EnumDirection.EnumAxis.c ? this.e.cD().c(distance, distance, 4.0) : this.e.cD().c(distance, 4.0, distance));
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker shulker) {
            super(shulker, EntityLiving.class, 10, true, false, entityliving -> entityliving instanceof IMonster);
        }

        @Override
        public boolean a() {
            return this.e.cb() == null ? false : super.a();
        }

        @Override
        protected AxisAlignedBB a(double distance) {
            EnumDirection enumdirection = ((EntityShulker)this.e).w();
            return enumdirection.o() == EnumDirection.EnumAxis.a ? this.e.cD().c(4.0, distance, distance) : (enumdirection.o() == EnumDirection.EnumAxis.c ? this.e.cD().c(distance, distance, 4.0) : this.e.cD().c(distance, 4.0, distance));
        }
    }

    private static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
        }
    }
}

