/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> bS = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int b = 1;
    public static final int c = 127;
    public float d;
    public float e;
    public float bR;
    private boolean bT;
    private boolean canWander = true;

    public EntitySlime(EntityTypes<? extends EntitySlime> type, World world) {
        super((EntityTypes<? extends EntityInsentient>)type, world);
        this.cz();
        this.bK = new ControllerMoveSlime(this);
    }

    @Override
    protected void x() {
        this.bN.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bN.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bN.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bN.a(5, new PathfinderGoalSlimeIdle(this));
        this.bO.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, entityliving -> Math.abs(entityliving.dn() - this.dn()) <= 4.0));
        this.bO.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bS, 1);
    }

    @VisibleForTesting
    public void a(int size, boolean heal) {
        int j2 = MathHelper.a(size, 1, 127);
        this.am.b(bS, j2);
        this.an();
        this.c_();
        this.a(GenericAttributes.a).a(j2 * j2);
        this.a(GenericAttributes.d).a(0.2f + 0.1f * (float)j2);
        this.a(GenericAttributes.f).a(j2);
        if (heal) {
            this.c(this.eE());
        }
        this.bI = j2;
    }

    public int fU() {
        return this.am.a(bS);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Paper.canWander", this.canWander);
        nbt.a("Size", this.fU() - 1);
        nbt.a("wasOnGround", this.bT);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.a(nbt.h("Size") + 1, false);
        super.a(nbt);
        if (nbt.e("Paper.canWander")) {
            this.canWander = nbt.q("Paper.canWander");
        }
        this.bT = nbt.q("wasOnGround");
    }

    public boolean fV() {
        return this.fU() <= 1;
    }

    protected ParticleParam r() {
        return Particles.S;
    }

    @Override
    protected boolean R() {
        return this.fU() > 0;
    }

    @Override
    public void l() {
        this.e += (this.d - this.e) * 0.5f;
        this.bR = this.e;
        super.l();
        if (this.N && !this.bT) {
            int i2 = this.fU();
            for (int j2 = 0; j2 < i2 * 8; ++j2) {
                float f2 = this.af.i() * ((float)Math.PI * 2);
                float f1 = this.af.i() * 0.5f + 0.5f;
                float f22 = MathHelper.a(f2) * (float)i2 * 0.5f * f1;
                float f3 = MathHelper.b(f2) * (float)i2 * 0.5f * f1;
                this.H.a(this.r(), this.dl() + (double)f22, this.dn(), this.dr() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.a(this.fS(), this.eN(), ((this.af.i() - this.af.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.N && this.bT) {
            this.d = 1.0f;
        }
        this.bT = this.N;
        this.fP();
    }

    protected void fP() {
        this.d *= 0.6f;
    }

    protected int w() {
        return this.af.a(20) + 10;
    }

    @Override
    public void c_() {
        double d0 = this.dl();
        double d1 = this.dn();
        double d2 = this.dr();
        super.c_();
        this.e(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bS.equals(data)) {
            this.c_();
            this.f(this.aV);
            this.aT = this.aV;
            if (this.aT() && this.af.a(20) == 0) {
                this.bb();
            }
        }
        super.a(data);
    }

    public EntityTypes<? extends EntitySlime> ae() {
        return super.ae();
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        int i2 = this.fU();
        if (!this.H.B && i2 > 1 && this.ep()) {
            IChatBaseComponent ichatbasecomponent = this.ab();
            boolean flag = this.fK();
            float f2 = (float)i2 / 4.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.af.a(3);
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.H.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.a(reason);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f1 = ((float)(l2 % 2) - 0.5f) * f2;
                float f22 = ((float)(l2 / 2) - 0.5f) * f2;
                EntitySlime entityslime = this.ae().a(this.H);
                if (entityslime == null) continue;
                if (this.fB()) {
                    entityslime.fz();
                }
                entityslime.aware = this.aware;
                entityslime.b(ichatbasecomponent);
                entityslime.t(flag);
                entityslime.m(this.cm());
                entityslime.a(j2, true);
                entityslime.b(this.dl() + (double)f1, this.dn() + 0.5, this.dr() + (double)f22, this.af.i() * 360.0f, 0.0f);
                slimes.add(entityslime);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.a(reason);
                return;
            }
            for (EntityLiving living : slimes) {
                this.H.addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.a(reason);
    }

    @Override
    public void g(Entity entity) {
        super.g(entity);
        if (entity instanceof EntityIronGolem && this.fQ()) {
            this.m((EntityLiving)entity);
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (this.fQ()) {
            this.m(player);
        }
    }

    protected void m(EntityLiving target) {
        if (this.bq()) {
            int i2 = this.fU();
            if (this.f((Entity)target) < 0.6 * (double)i2 * 0.6 * (double)i2 && this.B(target) && target.a(this.dG().b(this), this.fR())) {
                this.a(SoundEffects.vm, 1.0f, (this.af.i() - this.af.i()) * 0.2f + 1.0f);
                this.a((EntityLiving)this, (Entity)target);
            }
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.625f * dimensions.b;
    }

    protected boolean fQ() {
        return !this.fV() && this.cU();
    }

    protected float fR() {
        return (float)this.b(GenericAttributes.f);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.fV() ? SoundEffects.wd : SoundEffects.vo;
    }

    @Override
    public SoundEffect x_() {
        return this.fV() ? SoundEffects.wc : SoundEffects.vn;
    }

    protected SoundEffect fS() {
        return this.fV() ? SoundEffects.wf : SoundEffects.vq;
    }

    public static boolean c(EntityTypes<EntitySlime> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        if (world.ah() != EnumDifficulty.a) {
            if (spawnReason == EnumMobSpawn.c) {
                return random.a(10) == 0;
            }
            double maxHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.maximum;
            double minHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.minimum;
            if (world.v(pos).a(BiomeTags.ao) && (double)pos.v() > minHeightSwamp && (double)pos.v() < maxHeightSwamp && random.i() < 0.5f && random.i() < world.am() && world.C(pos) <= random.a(8)) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
            if (!(world instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(pos);
            boolean flag = world.getMinecraftWorld().paperConfig().entities.spawning.allChunksAreSlimeChunks || SeededRandom.a(chunkcoordintpair.e, chunkcoordintpair.f, ((GeneratorAccessSeed)world).A(), world.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            double maxHeightSlimeChunk = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.slimeChunk.maximum;
            if (random.a(10) == 0 && flag && (double)pos.v() < maxHeightSlimeChunk) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float eN() {
        return 0.4f * (float)this.fU();
    }

    @Override
    public int V() {
        return 0;
    }

    protected boolean fW() {
        return this.fU() > 0;
    }

    @Override
    protected void eS() {
        Vec3D vec3d = this.dj();
        this.o(vec3d.c, this.eQ(), vec3d.e);
        this.at = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.r_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficulty.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    float q() {
        float f2 = this.fV() ? 1.4f : 0.8f;
        return ((this.af.i() - this.af.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect fT() {
        return this.fV() ? SoundEffects.we : SoundEffects.vp;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return super.a(pose).a(0.255f * (float)this.fU());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime slime) {
            super(slime);
            this.n = slime;
            this.l = 180.0f * slime.dw() / (float)Math.PI;
        }

        public void a(float targetYaw, boolean jumpOften) {
            this.l = targetYaw;
            this.o = jumpOften;
        }

        public void a(double speed) {
            this.h = speed;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.f(this.a(this.d.dw(), this.l, 90.0f));
            this.d.aV = this.d.dw();
            this.d.aT = this.d.dw();
            if (this.k != ControllerMove.Operation.b) {
                this.d.y(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.ax()) {
                    this.d.h((float)(this.h * this.d.b(GenericAttributes.d)));
                    if (this.m-- <= 0) {
                        this.m = this.n.w();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.E().a();
                        if (this.n.fW()) {
                            this.n.a(this.n.fT(), this.n.eN(), this.n.q());
                        }
                    } else {
                        this.n.bj = 0.0f;
                        this.n.bl = 0.0f;
                        this.d.h(0.0f);
                    }
                } else {
                    this.d.h((float)(this.h * this.d.b(GenericAttributes.d)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            slime.G().a(true);
        }

        @Override
        public boolean a() {
            return (this.a.aT() || this.a.bg()) && this.a.D() instanceof ControllerMoveSlime && this.a.canWander && new SlimeSwimEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean J_() {
            return true;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            if (this.a.dZ().i() < 0.8f) {
                this.a.E().a();
            }
            if ((controllermove = this.a.D()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = this.a.P_();
            if (entityliving == null || !entityliving.bq()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return this.a.D() instanceof ControllerMoveSlime && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public void c() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.c();
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.P_();
            if (entityliving == null || !entityliving.bq()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return --this.b > 0 && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean J_() {
            return true;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.P_();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.D()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dw(), this.a.fQ());
            }
        }

        @Override
        public void d() {
            this.b = 0;
            this.a.i((EntityLiving)null);
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return this.a.P_() == null && (this.a.N || this.a.aT() || this.a.bg() || this.a.a(MobEffects.y)) && this.a.D() instanceof ControllerMoveSlime && this.a.canWander;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.dZ().a(60));
                this.b = this.a.dZ().a(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((Slime)this.a.getBukkitEntity(), this.b);
                if (!this.a.canWander || !event.callEvent()) {
                    return;
                }
                this.b = event.getNewYaw();
            }
            if ((controllermove = this.a.D()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return !this.a.bL() && this.a.canWander && new SlimeWanderEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void e() {
            ControllerMove controllermove = this.a.D();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

