/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntitySpider
extends EntityMonster {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntitySpider.class, DataWatcherRegistry.a);
    private static final float c = 0.1f;

    public EntitySpider(EntityTypes<? extends EntitySpider> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void x() {
        this.bN.a(1, new PathfinderGoalFloat(this));
        this.bN.a(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bN.a(4, new PathfinderGoalSpiderMeleeAttack(this));
        this.bN.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bN.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(6, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bO.a(2, new PathfinderGoalSpiderNearestAttackableTarget<EntityHuman>(this, EntityHuman.class));
        this.bO.a(3, new PathfinderGoalSpiderNearestAttackableTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    public double bv() {
        return this.dd() * 0.5f;
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new NavigationSpider(this, world);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, (byte)0);
    }

    @Override
    public void l() {
        super.l();
        if (!this.H.B) {
            this.w(this.O && (this.H.paperConfig().entities.behavior.allowSpiderWorldBorderClimbing || !this.collidingWithWorldBorder));
        }
    }

    public static AttributeProvider.Builder r() {
        return EntityMonster.fY().a(GenericAttributes.a, 16.0).a(GenericAttributes.d, 0.3f);
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.wF;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.wH;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.wG;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.wI, 0.15f, 1.0f);
    }

    @Override
    public boolean z_() {
        return this.w();
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!state.a(Blocks.br)) {
            super.a(state, multiplier);
        }
    }

    @Override
    public EnumMonsterType eJ() {
        return EnumMonsterType.c;
    }

    @Override
    public boolean c(MobEffect effect) {
        return effect.c() == MobEffects.s && this.H.paperConfig().entities.mobEffects.spidersImmuneToPoisonEffect ? false : super.c(effect);
    }

    public boolean w() {
        return (this.am.a(b) & 1) != 0;
    }

    public void w(boolean climbing) {
        byte b0 = this.am.a(b);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.am.b(b, b0);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        EntitySkeleton entityskeleton;
        GroupDataEntity object = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        RandomSource randomsource = world.r_();
        if (randomsource.a(100) == 0 && (entityskeleton = EntityTypes.aJ.a(this.H)) != null) {
            entityskeleton.b(this.dl(), this.dn(), this.dr(), this.dw(), 0.0f);
            entityskeleton.a(world, difficulty, spawnReason, (GroupDataEntity)null, null);
            entityskeleton.k((Entity)this);
        }
        if (object == null) {
            object = new GroupDataSpider();
            if (world.ah() == EnumDifficulty.d && randomsource.i() < 0.1f * difficulty.d()) {
                ((GroupDataSpider)object).a(randomsource);
            }
        }
        if (object instanceof GroupDataSpider) {
            GroupDataSpider entityspider_groupdataspider = (GroupDataSpider)object;
            MobEffectList mobeffectlist = entityspider_groupdataspider.a;
            if (mobeffectlist != null) {
                this.addEffect(new MobEffect(mobeffectlist, -1), EntityPotionEffectEvent.Cause.SPIDER_SPAWN);
            }
        }
        return object;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.65f;
    }

    private static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntitySpider spider) {
            super(spider, 1.0, true);
        }

        @Override
        public boolean a() {
            return super.a() && !this.a.bM();
        }

        @Override
        public boolean b() {
            float f2 = this.a.bh();
            if (f2 >= 0.5f && this.a.dZ().a(100) == 0) {
                this.a.i((EntityLiving)null);
                return false;
            }
            return super.b();
        }

        @Override
        protected double a(EntityLiving entity) {
            return 4.0f + entity.dc();
        }
    }

    private static class PathfinderGoalSpiderNearestAttackableTarget<T extends EntityLiving>
    extends PathfinderGoalNearestAttackableTarget<T> {
        public PathfinderGoalSpiderNearestAttackableTarget(EntitySpider spider, Class<T> targetEntityClass) {
            super((EntityInsentient)spider, targetEntityClass, true);
        }

        @Override
        public boolean a() {
            float f2 = this.e.bh();
            return f2 >= 0.5f ? false : super.a();
        }
    }

    public static class GroupDataSpider
    implements GroupDataEntity {
        @Nullable
        public MobEffectList a;

        public void a(RandomSource random) {
            int i2 = random.a(5);
            if (i2 <= 1) {
                this.a = MobEffects.a;
            } else if (i2 <= 2) {
                this.a = MobEffects.e;
            } else if (i2 <= 3) {
                this.a = MobEffects.j;
            } else if (i2 <= 4) {
                this.a = MobEffects.n;
            }
        }
    }
}

