/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final UUID bS = UUID.fromString("9e362924-01de-4ddd-a2b2-d0f7a405a174");
    private static final AttributeModifier bT = new AttributeModifier(bS, "Strider suffocating modifier", (double)-0.34f, AttributeModifier.Operation.b);
    private static final float bV = 0.35f;
    private static final float bW = 0.55f;
    private static final RecipeItemStack bX = RecipeItemStack.a(Items.df);
    private static final RecipeItemStack bY = RecipeItemStack.a(Items.df, Items.nc);
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage cc;
    @Nullable
    private PathfinderGoalTempt cd;
    @Nullable
    private PathfinderGoalPanic ce;

    public EntityStrider(EntityTypes<? extends EntityStrider> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.cc = new SaddleStorage(this.am, bZ, cb);
        this.F = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.j();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (world.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return world.a_(blockposition_mutableblockposition).h();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bZ.equals(data) && this.H.B) {
            this.cc.a();
        }
        super.a(data);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bZ, 0);
        this.am.a(ca, false);
        this.am.a(cb, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.cc.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.cc.b(nbt);
    }

    @Override
    public boolean i() {
        return this.cc.d();
    }

    @Override
    public boolean g() {
        return this.bq() && !this.y_();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.cc.a(true);
        if (sound != null) {
            this.H.a((EntityHuman)null, this, SoundEffects.wb, sound, 0.5f, 1.0f);
        }
    }

    @Override
    protected void x() {
        this.ce = new PathfinderGoalPanic(this, 1.65);
        this.bN.a(1, this.ce);
        this.bN.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cd = new PathfinderGoalTempt(this, 1.4, bY, false);
        this.bN.a(3, this.cd);
        this.bN.a(4, new a(this, 1.0));
        this.bN.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.bN.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.bN.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(8, new PathfinderGoalRandomLookaround(this));
        this.bN.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void w(boolean cold) {
        this.am.b(ca, cold);
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null) {
            attributemodifiable.b(bS);
            if (cold) {
                attributemodifiable.b(bT);
            }
        }
    }

    public boolean q() {
        return this.am.a(ca);
    }

    @Override
    public boolean a(Fluid state) {
        return state.a(TagsFluid.b);
    }

    @Override
    public double bv() {
        float f2 = Math.min(0.25f, this.aP.a());
        float f1 = this.aP.b();
        return (double)this.dd() - 0.19 + (double)(0.12f * MathHelper.b(f1 * 1.5f) * 2.0f * f2);
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    @Nullable
    public EntityLiving cK() {
        EntityHuman entityhuman;
        Entity entity = this.cN();
        if (entity instanceof EntityHuman && ((entityhuman = (EntityHuman)entity).eK().a(Items.nc) || entityhuman.eL().a(Items.nc))) {
            return entityhuman;
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.dc(), (double)passenger.dc(), passenger.dw()), EntityStrider.a(this.dc(), (double)passenger.dc(), passenger.dw() - 22.5f), EntityStrider.a(this.dc(), (double)passenger.dc(), passenger.dw() + 22.5f), EntityStrider.a(this.dc(), (double)passenger.dc(), passenger.dw() - 45.0f), EntityStrider.a(this.dc(), (double)passenger.dc(), passenger.dw() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.cD().e;
        double d1 = this.cD().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        Vec3D[] avec3d1 = avec3d;
        int i2 = avec3d.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = avec3d1[j2];
            blockposition_mutableblockposition.b(this.dl() + vec3d.c, d0, this.dr() + vec3d.e);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.i());
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.H.b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.H.i(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : passenger.fr()) {
                AxisAlignedBB axisalignedbb = passenger.g(entitypose);
                if (!DismountUtil.a(this.H, passenger, axisalignedbb.c(vec3d1))) continue;
                passenger.b(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dl(), this.cD().e, this.dr());
    }

    @Override
    protected void a(EntityLiving controllingPassenger, Vec3D movementInput) {
        this.a(controllingPassenger.dw(), controllingPassenger.dy() * 0.5f);
        this.aT = this.aV = this.dw();
        this.L = this.aV;
        this.cc.b();
        super.a(controllingPassenger, movementInput);
    }

    @Override
    protected Vec3D b(EntityLiving controllingPassenger, Vec3D movementInput) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float g(EntityLiving controllingPassenger) {
        return (float)(this.b(GenericAttributes.d) * (double)(this.q() ? 0.35f : 0.55f) * (double)this.cc.c());
    }

    @Override
    protected float aH() {
        return this.Y + 0.6f;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.bg() ? SoundEffects.vZ : SoundEffects.vY, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.cc.a(this.dZ());
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        this.aL();
        if (this.bg()) {
            this.n();
        } else {
            super.a(heightDifference, onGround, state, landedPosition);
        }
    }

    @Override
    public void l() {
        if (this.fS() && this.af.a(140) == 0) {
            this.a(SoundEffects.vU, 1.0f, this.eO());
        } else if (this.w() && this.af.a(60) == 0) {
            this.a(SoundEffects.vV, 1.0f, this.eO());
        }
        if (!this.fK()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.H.a_(this.dg());
            IBlockData iblockdata1 = this.bc();
            boolean flag = iblockdata.a(TagsBlock.aR) || iblockdata1.a(TagsBlock.aR) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.cV();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).q();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.q() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.w(suffocating);
            }
        }
        super.l();
        this.fY();
        this.aL();
    }

    private boolean w() {
        return this.ce != null && this.ce.k();
    }

    private boolean fS() {
        return this.cd != null && this.cd.i();
    }

    @Override
    protected boolean z() {
        return true;
    }

    private void fY() {
        if (this.bg()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.c, this.dg(), true) && !this.H.b_(this.dg().c()).a(TagsFluid.b)) {
                this.N = true;
            } else {
                this.f(this.dj().a(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder r() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.175f).a(GenericAttributes.b, 16.0);
    }

    @Override
    protected SoundEffect s() {
        return !this.w() && !this.fS() ? SoundEffects.vT : null;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.vX;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.vW;
    }

    @Override
    protected boolean o(Entity passenger) {
        return !this.bM() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean eX() {
        return true;
    }

    @Override
    public boolean bK() {
        return false;
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).r().a(TagsFluid.b) ? 10.0f : (this.bg() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Nullable
    public EntityStrider b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aV.a(world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return bX.a(stack);
    }

    @Override
    protected void er() {
        super.er();
        if (this.i()) {
            this.a((IMaterial)Items.mV);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.m(player.b(hand));
        if (!flag && this.i() && !this.bM() && !player.fz()) {
            if (!this.H.B) {
                player.k(this);
            }
            return EnumInteractionResult.a(this.H.B);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.mV) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.d;
        }
        if (flag && !this.aO()) {
            this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), SoundEffects.wa, this.cX(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D cF() {
        return new Vec3D(0.0, 0.6f * this.cE(), this.dc() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (this.y_()) {
            return super.a(world, difficulty, spawnReason, entityData, entityNbt);
        }
        RandomSource randomsource = world.r_();
        if (randomsource.a(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.bs.a(world.C());
            if (entityinsentient != null) {
                entityData = this.a(world, difficulty, entityinsentient, new EntityZombie.GroupDataZombie(EntityZombie.a(randomsource), false));
                entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.nc));
                this.a((SoundCategory)null);
            }
        } else if (randomsource.a(10) == 0) {
            EntityAgeable entityageable = EntityTypes.aV.a(world.C());
            if (entityageable != null) {
                entityageable.c_(-24000);
                entityData = this.a(world, difficulty, entityageable, (GroupDataEntity)null);
            }
        } else {
            entityData = new EntityAgeable.a(0.5f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntityInsentient rider, @Nullable GroupDataEntity entityData) {
        rider.b(this.dl(), this.dn(), this.dr(), this.dw(), 0.0f);
        rider.a(world, difficulty, EnumMobSpawn.g, entityData, null);
        rider.a((Entity)this, true);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider strider, double speed) {
            super(strider, speed, 8, 2);
            this.g = strider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean b() {
            return !this.g.bg() && this.a(this.g.H, this.e);
        }

        @Override
        public boolean a() {
            return !this.g.bg() && super.a();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.H) && world.a_(pos.c()).a((IBlockAccess)world, pos, PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entity, World world) {
            super(entity, world);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new PathfinderNormal();
            this.o.a(true);
            return new Pathfinder(this.o, range);
        }

        @Override
        protected boolean a(PathType pathType) {
            return pathType != PathType.i && pathType != PathType.o && pathType != PathType.n ? super.a(pathType) : true;
        }

        @Override
        public boolean a(BlockPosition pos) {
            return this.b.a_(pos).a(Blocks.H) || super.a(pos);
        }
    }
}

