/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchReadyPotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.ItemStack;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final UUID b = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier e = new AttributeModifier(b, "Drinking speed penalty", -0.25, AttributeModifier.Operation.a);
    private static final DataWatcherObject<Boolean> bS = DataWatcher.a(EntityWitch.class, DataWatcherRegistry.k);
    public int bT;
    private PathfinderGoalNearestHealableRaider<EntityRaider> bU;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> bV;

    public EntityWitch(EntityTypes<? extends EntityWitch> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
    }

    @Override
    protected void x() {
        super.x();
        this.bU = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, entityliving -> entityliving != null && this.gh() && entityliving.ae() != EntityTypes.bj);
        this.bV = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, (Predicate<EntityLiving>)null);
        this.bN.a(1, new PathfinderGoalFloat(this));
        this.bN.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.bN.a(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bN.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(3, new PathfinderGoalRandomLookaround(this));
        this.bO.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.bO.a(2, this.bU);
        this.bO.a(3, this.bV);
    }

    @Override
    protected void a_() {
        super.a_();
        this.aj().a(bS, false);
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.zy;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.zC;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.zA;
    }

    public void y(boolean drinking) {
        this.aj().b(bS, drinking);
    }

    public boolean q() {
        return this.aj().a(bS);
    }

    public static AttributeProvider.Builder r() {
        return EntityMonster.fY().a(GenericAttributes.a, 26.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    public void b_() {
        if (!this.H.B && this.bq()) {
            this.bU.k();
            if (this.bU.i() <= 0) {
                this.bV.a(true);
            } else {
                this.bV.a(false);
            }
            if (this.q()) {
                if (this.bT-- <= 0) {
                    this.y(false);
                    net.minecraft.world.item.ItemStack itemstack = this.eK();
                    this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.b);
                    if (itemstack.a(Items.rr)) {
                        List<MobEffect> list;
                        WitchConsumePotionEvent event = new WitchConsumePotionEvent((Witch)this.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemstack));
                        List<MobEffect> list2 = list = event.callEvent() ? PotionUtil.a(CraftItemStack.asNMSCopy(event.getPotion())) : null;
                        if (list != null) {
                            for (MobEffect mobeffect : list) {
                                this.addEffect(new MobEffect(mobeffect), EntityPotionEffectEvent.Cause.ATTACK);
                            }
                        }
                    }
                    this.a(GenericAttributes.d).d(e);
                }
            } else {
                PotionRegistry potionregistry = null;
                if (this.af.i() < 0.15f && ((Entity)this).a(TagsFluid.a) && !this.a(MobEffects.m)) {
                    potionregistry = Potions.y;
                } else if (this.af.i() < 0.15f && (this.bK() || this.eq() != null && this.eq().a(DamageTypeTags.i)) && !this.a(MobEffects.l)) {
                    potionregistry = Potions.n;
                } else if (this.af.i() < 0.05f && this.eo() < this.eE()) {
                    potionregistry = Potions.A;
                } else if (this.af.i() < 0.5f && this.P_() != null && !this.a(MobEffects.a) && this.P_().f((Entity)this) > 121.0) {
                    potionregistry = Potions.p;
                }
                if (potionregistry != null) {
                    net.minecraft.world.item.ItemStack potion = PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.rr), potionregistry);
                    this.setDrinkingPotion(potion);
                }
            }
            if (this.af.i() < 7.5E-4f) {
                this.H.a((Entity)this, (byte)15);
            }
        }
        super.b_();
    }

    public void setDrinkingPotion(net.minecraft.world.item.ItemStack potion) {
        ItemStack bukkitStack = WitchReadyPotionEvent.process((Witch)((Witch)this.getBukkitEntity()), (ItemStack)CraftItemStack.asCraftMirror(potion));
        this.a(EnumItemSlot.a, CraftItemStack.asNMSCopy(bukkitStack));
        this.bT = this.eK().q();
        this.y(true);
        if (!this.aO()) {
            this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), SoundEffects.zB, this.cX(), 1.0f, 0.8f + this.af.i() * 0.4f);
        }
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        attributemodifiable.d(e);
        attributemodifiable.b(e);
    }

    @Override
    public SoundEffect X_() {
        return SoundEffects.zz;
    }

    @Override
    public void b(byte status) {
        if (status == 15) {
            for (int i2 = 0; i2 < this.af.a(35) + 10; ++i2) {
                this.H.a(Particles.aj, this.dl() + this.af.k() * (double)0.13f, this.cD().e + 0.5 + this.af.k() * (double)0.13f, this.dr() + this.af.k() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.b(status);
        }
    }

    @Override
    protected float e(DamageSource source, float amount) {
        amount = super.e(source, amount);
        if (source.d() == this) {
            amount = 0.0f;
        }
        if (source.a(DamageTypeTags.k)) {
            amount *= 0.15f;
        }
        return amount;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        if (!this.q()) {
            Vec3D vec3d = target.dj();
            double d0 = target.dl() + vec3d.c - this.dl();
            double d1 = target.dp() - (double)1.1f - this.dn();
            double d2 = target.dr() + vec3d.e - this.dr();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            PotionRegistry potionregistry = Potions.C;
            if (target instanceof EntityRaider) {
                potionregistry = target.eo() <= 4.0f ? Potions.A : Potions.H;
                this.i((EntityLiving)null);
            } else if (d3 >= 8.0 && !target.a(MobEffects.b)) {
                potionregistry = Potions.s;
            } else if (target.eo() >= 8.0f && !target.a(MobEffects.s)) {
                potionregistry = Potions.E;
            } else if (d3 <= 3.0 && !target.a(MobEffects.r) && this.af.i() < 0.25f) {
                potionregistry = Potions.N;
            }
            net.minecraft.world.item.ItemStack potion = PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.up), potionregistry);
            WitchThrowPotionEvent event = new WitchThrowPotionEvent((Witch)this.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(potion));
            if (!event.callEvent()) {
                return;
            }
            potion = CraftItemStack.asNMSCopy(event.getPotion());
            EntityPotion entitypotion = new EntityPotion(this.H, this);
            entitypotion.a(potion);
            entitypotion.e(entitypotion.dy() - -20.0f);
            entitypotion.c(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
            if (!this.aO()) {
                this.H.a((EntityHuman)null, this.dl(), this.dn(), this.dr(), SoundEffects.zD, this.cX(), 1.0f, 0.8f + this.af.i() * 0.4f);
            }
            this.H.b(entitypotion);
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 1.62f;
    }

    @Override
    public void a(int wave, boolean unused) {
    }

    @Override
    public boolean fT() {
        return false;
    }
}

