/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.base.Predicates;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final UUID b = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier c = new AttributeModifier(b, "Baby speed boost", 0.5, AttributeModifier.Operation.b);
    private final AttributeModifier babyModifier;
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bW = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> bX = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float e = 0.05f;
    public static final int bS = 50;
    public static final int bT = 40;
    public static final int bU = 7;
    protected static final float bV = 0.81f;
    private static final float bY = 0.1f;
    public static final Predicate<EnumDifficulty> bZ = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private final PathfinderGoalBreakDoor ca;
    private boolean cb;
    private int cc;
    public int cd;
    private int lastTick;
    private boolean shouldBurnInDay;

    public EntityZombie(EntityTypes<? extends EntityZombie> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.babyModifier = new AttributeModifier(c.a(), c.b(), this.H.paperConfig().entities.behavior.babyZombieMovementModifier, c.c());
        this.lastTick = MinecraftServer.currentTick;
        this.shouldBurnInDay = true;
        this.ca = new PathfinderGoalBreakDoor(this, (Predicate<EnumDifficulty>)Predicates.in(world.paperConfig().entities.behavior.doorBreakingDifficulty.getOrDefault(type, world.paperConfig().entities.behavior.doorBreakingDifficulty.get(EntityTypes.bp))));
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bp, world);
    }

    @Override
    protected void x() {
        if (this.H.paperConfig().entities.behavior.zombiesTargetTurtleEggs) {
            this.bN.a(4, new a((EntityCreature)this, 1.0, 3));
        }
        this.bN.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bN.a(8, new PathfinderGoalRandomLookaround(this));
        this.q();
    }

    protected void q() {
        this.bN.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bN.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::ga));
        this.bN.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bO.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.H.spigotConfig.zombieAggressiveTowardsVillager) {
            this.bO.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.bO.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bO.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bT));
    }

    public static AttributeProvider.Builder fW() {
        return EntityMonster.fY().a(GenericAttributes.b, 35.0).a(GenericAttributes.d, 0.23f).a(GenericAttributes.f, 3.0).a(GenericAttributes.i, 2.0).a(GenericAttributes.l);
    }

    @Override
    protected void a_() {
        super.a_();
        this.aj().a(d, false);
        this.aj().a(bW, 0);
        this.aj().a(bX, false);
    }

    public boolean fZ() {
        return this.aj().a(bX);
    }

    public boolean ga() {
        return this.cb;
    }

    public void x(boolean canBreakDoors) {
        if (this.r() && PathfinderGoalUtil.a(this)) {
            if (this.cb != canBreakDoors) {
                this.cb = canBreakDoors;
                ((Navigation)this.G()).b(canBreakDoors);
                if (canBreakDoors) {
                    this.bN.a(1, this.ca);
                } else {
                    this.bN.a(this.ca);
                }
            }
        } else if (this.cb) {
            this.bN.a(this.ca);
            this.cb = false;
        }
    }

    public boolean r() {
        return true;
    }

    @Override
    public boolean y_() {
        return this.aj().a(d);
    }

    @Override
    public int dX() {
        int previousReward = this.bI;
        if (this.y_()) {
            this.bI = (int)((double)this.bI * 2.5);
        }
        int reward = super.dX();
        this.bI = previousReward;
        return reward;
    }

    @Override
    public void a(boolean baby) {
        this.aj().b(d, baby);
        if (this.H != null && !this.H.B) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            attributemodifiable.d(this.babyModifier);
            if (baby) {
                attributemodifiable.b(this.babyModifier);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (d.equals(data)) {
            this.c_();
        }
        super.a(data);
    }

    protected boolean fT() {
        return true;
    }

    @Override
    public void l() {
        if (!this.H.B && this.bq() && !this.fK()) {
            if (this.fZ()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.cd -= elapsedTicks;
                if (this.cd < 0) {
                    this.fV();
                }
            } else if (this.fT()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cc;
                    if (this.cc >= 600) {
                        this.b(300);
                    }
                } else {
                    this.cc = -1;
                }
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void b_() {
        if (this.bq()) {
            boolean flag;
            boolean bl = flag = this.W_() && this.fN();
            if (flag) {
                ItemStack itemstack = this.c(EnumItemSlot.f);
                if (!itemstack.b()) {
                    if (itemstack.h()) {
                        itemstack.b(itemstack.j() + this.af.a(2));
                        if (itemstack.j() >= itemstack.k()) {
                            this.d(EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.b);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.f(8);
                }
            }
        }
        super.b_();
    }

    public void stopDrowning() {
        this.cd = -1;
        this.aj().b(bX, false);
    }

    public void b(int ticksUntilWaterConversion) {
        this.lastTick = MinecraftServer.currentTick;
        this.cd = ticksUntilWaterConversion;
        this.aj().b(bX, true);
    }

    protected void fV() {
        this.b(EntityTypes.y);
        if (!this.aO()) {
            this.H.a((EntityHuman)null, 1040, this.dg(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entityType) {
        EntityZombie entityzombie = this.convertTo(entityType, true, EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (entityzombie != null) {
            entityzombie.C(entityzombie.H.d_(entityzombie.dg()).d());
            entityzombie.x(entityzombie.r() && this.ga());
        } else {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    public boolean W_() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!super.a(source, amount)) {
            return false;
        }
        if (!(this.H instanceof WorldServer)) {
            return false;
        }
        WorldServer worldserver = (WorldServer)this.H;
        EntityLiving entityliving = this.P_();
        if (entityliving == null && source.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)source.d();
        }
        if (entityliving != null && this.H.ah() == EnumDifficulty.d && (double)this.af.i() < this.b(GenericAttributes.l) && this.H.W().b(GameRules.e)) {
            int i2 = MathHelper.a(this.dl());
            int j2 = MathHelper.a(this.dn());
            int k2 = MathHelper.a(this.dr());
            EntityZombie entityzombie = new EntityZombie(this.H);
            for (int l2 = 0; l2 < 50; ++l2) {
                int i1 = i2 + MathHelper.a(this.af, 7, 40) * MathHelper.a(this.af, -1, 1);
                int j1 = j2 + MathHelper.a(this.af, 7, 40) * MathHelper.a(this.af, -1, 1);
                int k1 = k2 + MathHelper.a(this.af, 7, 40) * MathHelper.a(this.af, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1, k1);
                EntityTypes<?> entitytypes = entityzombie.ae();
                EntityPositionTypes.Surface entitypositiontypes_surface = EntityPositionTypes.a(entitytypes);
                if (!SpawnerCreature.a(entitypositiontypes_surface, this.H, blockposition, entitytypes) || !EntityPositionTypes.a(entitytypes, worldserver, EnumMobSpawn.j, blockposition, this.H.z)) continue;
                entityzombie.e(i1, j1, k1);
                if (this.H.hasNearbyAlivePlayerThatAffectsSpawning(i1, j1, k1, 7.0) || !this.H.f(entityzombie) || !this.H.g(entityzombie) || this.H.d(entityzombie.cD())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a(worldserver, this.H.d_(entityzombie.dg()), EnumMobSpawn.j, (GroupDataEntity)null, null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                this.a(GenericAttributes.l).c(new AttributeModifier("Zombie reinforcement caller charge", -0.05f, AttributeModifier.Operation.a));
                entityzombie.a(GenericAttributes.l).c(new AttributeModifier("Zombie reinforcement callee charge", -0.05f, AttributeModifier.Operation.a));
                break;
            }
        }
        return true;
    }

    @Override
    public boolean z(Entity target) {
        boolean flag = super.z(target);
        if (flag) {
            float f2 = this.H.d_(this.dg()).b();
            if (this.eK().b() && this.bK() && this.af.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), 2 * (int)f2);
                this.H.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    target.setSecondsOnFire(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.Av;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.AF;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.AA;
    }

    protected SoundEffect w() {
        return SoundEffects.AL;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.w(), 0.15f, 1.0f);
    }

    @Override
    public EnumMonsterType eJ() {
        return EnumMonsterType.b;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        super.a(random, localDifficulty);
        float f2 = random.i();
        float f3 = this.H.ah() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = random.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.oi));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.oj));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsBaby", this.y_());
        nbt.a("CanBreakDoors", this.ga());
        nbt.a("InWaterTime", this.aT() ? this.cc : -1);
        nbt.a("DrownedConversionTime", this.fZ() ? this.cd : -1);
        nbt.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.x(nbt.q("CanBreakDoors"));
        this.cc = nbt.h("InWaterTime");
        if (nbt.b("DrownedConversionTime", 99) && nbt.h("DrownedConversionTime") > -1) {
            this.b(nbt.h("DrownedConversionTime"));
        }
        if (nbt.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = nbt.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        boolean flag = super.a(world, other);
        if (this.H.paperConfig().entities.behavior.zombieVillagerInfectionChance != 0.0 && (this.H.paperConfig().entities.behavior.zombieVillagerInfectionChance != -1.0 || world.ah() == EnumDifficulty.c || world.ah() == EnumDifficulty.d) && other instanceof EntityVillager) {
            if (this.H.paperConfig().entities.behavior.zombieVillagerInfectionChance == -1.0 && world.ah() != EnumDifficulty.d && this.af.h()) {
                return flag;
            }
            if (this.H.paperConfig().entities.behavior.zombieVillagerInfectionChance != -1.0 && this.af.j() * 100.0 > this.H.paperConfig().entities.behavior.zombieVillagerInfectionChance) {
                return flag;
            }
            EntityVillager entityvillager = (EntityVillager)other;
            flag = EntityZombie.zombifyVillager(world, entityvillager, this.dg(), this.aO(), CreatureSpawnEvent.SpawnReason.INFECTION) == null;
        }
        return flag;
    }

    public static EntityZombieVillager zombifyVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.br, false, EntityTransformEvent.TransformReason.INFECTION, spawnReason);
        if (entityzombievillager != null) {
            entityzombievillager.a(worldserver, worldserver.d_(entityzombievillager.dg()), EnumMobSpawn.i, new GroupDataZombie(false, true), null);
            entityzombievillager.a(entityvillager.gd());
            entityzombievillager.a(entityvillager.gn().a(DynamicOpsNBT.a));
            entityzombievillager.c(entityvillager.fU().a());
            entityzombievillager.b(entityvillager.r());
            if (!silent) {
                worldserver.a((EntityHuman)null, 1026, blockPosition, 0);
            }
        }
        return entityzombievillager;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? 0.93f : 1.74f;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(Items.pZ) && this.y_() && this.bL() ? false : super.j(stack);
    }

    @Override
    public boolean k(ItemStack stack) {
        return stack.a(Items.qo) ? false : super.k(stack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.r_();
        GroupDataEntity object = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        float f2 = difficulty.d();
        this.s(this.H.paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.zombies || randomsource.i() < 0.55f * f2);
        if (object == null) {
            object = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (object instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)object;
            if (entityzombie_groupdatazombie.a) {
                this.a(true);
                if (entityzombie_groupdatazombie.b) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = world.a(EntityChicken.class, this.cD().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.w(true);
                            this.k((Entity)entitychicken);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.q.a(this.H)) != null) {
                        entitychicken1.b(this.dl(), this.dn(), this.dr(), this.dw(), 0.0f);
                        entitychicken1.a(world, difficulty, EnumMobSpawn.g, (GroupDataEntity)null, null);
                        entitychicken1.w(true);
                        this.k((Entity)entitychicken1);
                        world.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.x(this.r() && randomsource.i() < f2 * 0.1f);
            this.a(randomsource, difficulty);
            this.b(randomsource, difficulty);
        }
        if (this.c(EnumItemSlot.f).b()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.ef : Blocks.ee));
                this.bQ[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        this.C(f2);
        return object;
    }

    public static boolean a(RandomSource random) {
        return random.i() < 0.05f;
    }

    protected void C(float chanceMultiplier) {
        this.gb();
        this.a(GenericAttributes.c).c(new AttributeModifier("Random spawn bonus", this.af.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.af.j() * 1.5 * (double)chanceMultiplier;
        if (d0 > 1.0) {
            this.a(GenericAttributes.b).c(new AttributeModifier("Random zombie-spawn bonus", d0, AttributeModifier.Operation.c));
        }
        if (this.af.i() < chanceMultiplier * 0.05f) {
            this.a(GenericAttributes.l).c(new AttributeModifier("Leader zombie bonus", this.af.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.a(GenericAttributes.a).c(new AttributeModifier("Leader zombie bonus", this.af.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.x(this.r());
        }
    }

    protected void gb() {
        this.a(GenericAttributes.l).a(this.af.j() * (double)0.1f);
    }

    @Override
    public double bu() {
        return this.y_() ? 0.0 : -0.45;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.a(source, lootingMultiplier, allowDrops);
        Entity entity = source.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).fT() && !(itemstack = this.fS()).b()) {
            entitycreeper.fU();
            this.b(itemstack);
        }
    }

    protected ItemStack fS() {
        return new ItemStack(Items.tq);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature mob, double speed, int range) {
            super(Blocks.mc, mob, speed, range);
        }

        @Override
        public void a(GeneratorAccess world, BlockPosition pos) {
            world.a((EntityHuman)null, pos, SoundEffects.AB, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.af.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition pos) {
            world.a((EntityHuman)null, pos, SoundEffects.xM, SoundCategory.e, 0.7f, 0.9f + world.z.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean baby, boolean tryChickenJockey) {
            this.a = baby;
            this.b = tryChickenJockey;
        }
    }
}

